/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.session;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.common.ProcessingThread;
import de.sciss.fscape.Application;
import de.sciss.fscape.gui.EnvIcon;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.MarginBorderLayout;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.ProcessPanel;
import de.sciss.fscape.gui.ProgressPanel;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.proc.Processor;
import de.sciss.fscape.proc.ProcessorAdapter;
import de.sciss.fscape.proc.ProcessorEvent;
import de.sciss.fscape.proc.ProcessorListener;
import de.sciss.fscape.prop.BasicProperties;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.Session;
import de.sciss.fscape.util.Constants;
import de.sciss.gui.GUIUtil;
import de.sciss.gui.MenuAction;
import de.sciss.gui.MenuItem;
import de.sciss.gui.ProgressComponent;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.util.Flag;
import de.sciss.util.Param;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public abstract class ModulePanel
extends JPanel
implements Processor,
EventManager.Processor,
ProgressComponent {
    public static final String PACKAGE = "de.sciss.fscape.gui";
    public static final String PROP_CLASS = "Class";
    protected static final int FLAGS_TOOLBAR = 1;
    protected static final int FLAGS_PRESETS = 2;
    protected static final int FLAGS_PROGBAR = 4;
    protected static final int FLAGS_NORESIZE = 8;
    protected static final int FLAGS_NOPRESETLOAD = 16;
    protected static final int FLAGS_PROGBARASYNC = 36;
    protected static final int GGTYPE_GAIN = 0;
    protected static final int GAIN_UNITY = 0;
    protected static final int GAIN_ABSOLUTE = 1;
    protected static final String PRN_GAINTYPE = "GainType";
    protected static final String PRN_GAIN = "Gain";
    protected static final int GG_OFF_CHECKBOX = 0;
    protected static final int GG_OFF_CHOICE = 256;
    protected static final int GG_OFF_PARAMFIELD = 512;
    protected static final int GG_OFF_TEXTFIELD = 768;
    protected static final int GG_OFF_PATHFIELD = 1024;
    protected static final int GG_OFF_FONTFIELD = 1280;
    protected static final int GG_OFF_COLORCHOICE = 1536;
    protected static final int GG_OFF_ENVICON = 1792;
    protected static final int GG_OFF_OTHER = 2048;
    private ProcessPanel pp = null;
    private ProgressPanel pProgress = null;
    protected GUISupport gui;
    private MenuAction actionDeletePreset = null;
    protected PropertyArray pr;
    protected Presets presets;
    public static final String ERR_CORRUPTED = "Internal data corrupted. Please report bug!";
    protected static final String ERR_MEMORY = "FScape ran out of memory";
    protected static final String ERR_NOPROPERTIES = "There are no properties...";
    protected static final String TXT_OBSCURE = "> Obscure?! ";
    protected static final String ERR_CLASS = "This chosen file was created\nby a different module:\n";
    protected static final String TXT_SIGH = ">-Sigh-";
    protected static final String ERR_MISSINGPROP = "Bug! Missing property!";
    protected static final String ERR_EMPTY = "File is empty";
    protected static final String ERR_FRAMESYNC = "Bug! Frame sync lost!";
    protected static final String ERR_COMPLEX = "Real and imaginary file must\nhave same # of channels";
    protected boolean threadRunning = false;
    protected boolean threadPausing = false;
    private float progress = 0.0f;
    private final EventManager elm = new EventManager((EventManager.Processor)this);
    private int listenerCount = 0;
    private Exception threadError = null;
    private boolean clipping;
    private float maxAmp;
    private ParamField ggGain = null;
    private JComboBox ggGainType = null;
    private static final Color COLOR_NORM = new Color(255, 255, 0, 47);
    private final ModulePanel enc_this = this;
    private final List<AudioFile> collTempFiles = new ArrayList<AudioFile>();
    private final Session doc;
    private final JLabel lbWriteProtected;
    private boolean writeProtected = false;
    private boolean wpHaveWarned = false;
    private final ProcessingThread.Listener closeAfterSaveListener;
    private final String procTitle;
    private boolean disposed = false;

    public ModulePanel(String string) {
        super(new MarginBorderLayout(0, 6, new Insets(0, 4, 4, 4)));
        this.procTitle = string;
        this.doc = new Session();
        this.doc.setFrame(this);
        this.closeAfterSaveListener = new ProcessingThread.Listener(){

            public void processStarted(ProcessingThread.Event event) {
            }

            public void processStopped(ProcessingThread.Event event) {
                if (event.isDone()) {
                    ModulePanel.this.documentClosed();
                }
            }
        };
        this.lbWriteProtected = new JLabel();
    }

    public String getModuleName() {
        return this.procTitle;
    }

    protected void init2() {
        this.buildGUI();
    }

    protected void buildGUI() {
    }

    protected boolean restoreVisibility() {
        return false;
    }

    protected boolean alwaysPackSize() {
        return false;
    }

    protected boolean autoUpdatePrefs() {
        return true;
    }

    protected void fillDefaultAudioDescr(int[] nArray, int n) {
        this.fillDefaultAudioDescr(nArray, n, -1, -1);
    }

    protected void fillDefaultAudioDescr(int[] nArray, int n, int n2) {
        this.fillDefaultAudioDescr(nArray, n, n2, -1);
    }

    protected void fillDefaultAudioDescr(int[] nArray, int n, int n2, int n3) {
        int n4;
        Preferences preferences = Application.userPrefs;
        if (n >= 0) {
            n4 = GenericFile.getType(preferences.get("audioFileType", ""));
            for (int i = 0; i < GenericFile.TYPES_SOUND.length; ++i) {
                if (GenericFile.TYPES_SOUND[i] != n4) continue;
                nArray[n] = i;
                break;
            }
        }
        if (n2 >= 0 && (n4 = PathField.getSoundResIdx(preferences.get("audioFileRes", ""))) >= 0) {
            nArray[n2] = n4;
        }
        if (n3 >= 0 && (n4 = PathField.getSoundRateIdx(preferences.get("audioFileRate", ""))) >= 0) {
            nArray[n3] = n4;
        }
    }

    protected void fillDefaultGain(de.sciss.fscape.util.Param[] paramArray, int n) {
        paramArray[n] = this.getDefaultGain();
    }

    protected de.sciss.fscape.util.Param getDefaultGain() {
        Preferences preferences = Application.userPrefs;
        Param param = Param.fromPrefs((Preferences)preferences, (String)"headroom", null);
        if (param != null) {
            return new de.sciss.fscape.util.Param(param.val, 785);
        }
        return null;
    }

    public Session getDocument() {
        return this.doc;
    }

    private String createPresetMenuID(String string) {
        return "preset_" + string;
    }

    private MenuItem createPresetMenuItem(String string) {
        return new MenuItem(this.createPresetMenuID(string), (Action)((Object)new ActionRecallPreset(string, null)));
    }

    protected void initGUI(ModulePanel modulePanel, int n, Component component) {
        ModulePanel modulePanel2 = this;
        if ((n & 1) != 0) {
            JPanel jPanel = new JPanel(new FlowLayout(0, 2, 2));
            modulePanel2.add((Component)jPanel, "North");
        }
        modulePanel2.add(component, "Center");
        if ((n & 0x10) == 0) {
            this.loadPreset("(default)");
        }
        if ((n & 4) != 0) {
            this.pProgress = new ProgressPanel();
            this.pp = new ProcessPanel((n & 0x24) == 36 ? 4 : 0, this.pProgress, this);
            this.pp.addProcessorListener(new ProcessorAdapter(){

                @Override
                public void processorStopped(ProcessorEvent processorEvent) {
                    if (ModulePanel.this.isVisible()) {
                        Exception exception = ModulePanel.this.getError();
                        if (exception != null) {
                            ModulePanel.this.displayError(exception, ModulePanel.this.getTitle());
                        }
                        if (ModulePanel.this.clipping) {
                            ModulePanel.this.clippingDlg();
                        }
                    }
                }
            });
            modulePanel2.add((Component)this.pp, "South");
        }
    }

    public ProcessingThread closeDocument(boolean bl, Flag flag) {
        ProcessingThread processingThread;
        if (!bl && (processingThread = this.confirmUnsaved(this.getResourceString("menuClose"), flag)) != null) {
            processingThread.addListener(this.closeAfterSaveListener);
            return processingThread;
        }
        if (flag.isSet()) {
            this.documentClosed();
        }
        return null;
    }

    protected void documentClosed() {
        if (!this.disposed) {
            this.disposed = true;
            Application.documentHandler.close(this.getDocument());
        }
    }

    public void dispose() {
    }

    protected String getResourceString(String string) {
        return string;
    }

    private ProcessingThread confirmUnsaved(String string, Flag flag) {
        if (!this.confirmAbortProc(string)) {
            return null;
        }
        if (!this.doc.isDirty()) {
            flag.set(true);
            return null;
        }
        Object[] objectArray = new String[]{this.getResourceString("buttonSave"), this.getResourceString("buttonCancel"), this.getResourceString("buttonDontSave")};
        File file = this.doc.getFile();
        String string2 = this.doc.getName();
        int n = JOptionPane.showOptionDialog(this.getComponent(), this.procTitle + " (" + string2 + ") :\n" + this.getResourceString("optionDlgUnsaved"), string, 1, 2, null, objectArray, objectArray[1]);
        switch (n) {
            case -1: 
            case 1: {
                flag.set(false);
                return null;
            }
            case 2: {
                flag.set(true);
                return null;
            }
            case 0: {
                flag.set(false);
                return null;
            }
        }
        assert (false) : n;
        return null;
    }

    public boolean isRunning() {
        return this.pp.getState() != 0;
    }

    private boolean confirmAbortProc(String string) {
        if (this.pp.getState() == 0) {
            return true;
        }
        String string2 = this.doc.getName();
        int n = JOptionPane.showOptionDialog(this.getComponent(), string2 + " :\n" + this.getResourceString("optionDlgAbortProc"), string, 0, 2, null, null, null);
        switch (n) {
            case -1: 
            case 1: {
                return false;
            }
            case 0: {
                for (int i = 0; i < 20; ++i) {
                    this.pp.stop();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.pp.getState() != 0) continue;
                    return true;
                }
                return false;
            }
        }
        assert (false) : n;
        return false;
    }

    public PropertyArray getPropertyArray() {
        return this.pr;
    }

    protected Presets getPresets() {
        return this.presets;
    }

    protected boolean loadPreset(String string) {
        boolean bl;
        block3: {
            boolean bl2 = this.isVisible();
            bl = false;
            try {
                PropertyArray propertyArray = this.getPropertyArray();
                Properties properties = this.getPresets().getPreset(string);
                propertyArray.fromProperties(false, properties);
                this.fillGUI();
                bl = true;
            }
            catch (Exception exception) {
                if (!bl2) break block3;
                this.displayError(exception, this.getTitle());
            }
        }
        if (bl) {
            this.presetsChanged();
        }
        return bl;
    }

    protected boolean addPreset(String string) {
        return false;
    }

    protected boolean deletePreset(String string) {
        return false;
    }

    private boolean storePresetFile() {
        return false;
    }

    public boolean loadFile(File file) {
        boolean bl;
        block9: {
            boolean bl2 = this.isVisible();
            bl = false;
            try {
                PropertyArray propertyArray = this.getPropertyArray();
                BasicProperties basicProperties = new BasicProperties(null, file);
                try {
                    basicProperties.load();
                    String string = basicProperties.getProperty(PROP_CLASS);
                    if (string != null && this.getClass().getName().endsWith(string)) {
                        propertyArray.fromProperties(false, basicProperties);
                        this.fillGUI();
                        bl = true;
                    } else if (bl2) {
                        JOptionPane.showMessageDialog(this.getComponent(), ERR_CLASS + string);
                    }
                }
                catch (IOException iOException) {
                    if (bl2) {
                        this.displayError(iOException, this.getTitle());
                    }
                }
            }
            catch (Exception exception) {
                if (!bl2) break block9;
                this.displayError(exception, this.getTitle());
            }
        }
        if (bl) {
            this.fileChanged(file);
        }
        return bl;
    }

    public boolean saveFile(File file) {
        boolean bl;
        block9: {
            boolean bl2 = this.isVisible();
            bl = false;
            try {
                this.fillPropertyArray();
                PropertyArray propertyArray = this.getPropertyArray();
                BasicProperties basicProperties = new BasicProperties(null, file);
                propertyArray.toProperties(false, basicProperties);
                if (!basicProperties.isEmpty()) {
                    basicProperties.setProperty(PROP_CLASS, this.getClass().getName());
                    try {
                        basicProperties.store(true);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        if (bl2) {
                            this.displayError(iOException, this.getTitle());
                        }
                    }
                } else if (bl2) {
                    JOptionPane.showMessageDialog(this.getComponent(), ERR_NOPROPERTIES);
                }
            }
            catch (Exception exception) {
                if (!bl2) break block9;
                this.displayError(exception, this.getTitle());
            }
        }
        if (bl) {
            this.fileChanged(file);
        }
        return bl;
    }

    private void fileChanged(File file) {
        this.doc.setFile(file);
    }

    private void presetsChanged() {
    }

    public void fillGUI() {
    }

    public boolean isThreadRunning() {
        return this.threadRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckBoxQuiet(JCheckBox jCheckBox, boolean bl) {
        int n;
        ActionListener[] actionListenerArray = jCheckBox.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            jCheckBox.removeActionListener(actionListenerArray[n]);
        }
        try {
            jCheckBox.setSelected(bl);
        }
        finally {
            for (n = 0; n < actionListenerArray.length; ++n) {
                jCheckBox.addActionListener(actionListenerArray[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setComboBoxQuiet(JComboBox jComboBox, int n) {
        int n2;
        ActionListener[] actionListenerArray = jComboBox.getActionListeners();
        for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
            jComboBox.removeActionListener(actionListenerArray[n2]);
        }
        try {
            jComboBox.setSelectedIndex(n);
        }
        finally {
            for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                jComboBox.addActionListener(actionListenerArray[n2]);
            }
        }
    }

    public void fillGUI(GUISupport gUISupport) {
        PropertyArray propertyArray = this.getPropertyArray();
        try {
            Component component;
            int n;
            for (n = 0; n < propertyArray.bool.length; ++n) {
                component = gUISupport.getItemObj(n + 0);
                if (component == null) continue;
                this.setCheckBoxQuiet((JCheckBox)component, propertyArray.bool[n]);
            }
            for (n = 0; n < propertyArray.intg.length; ++n) {
                component = gUISupport.getItemObj(n + 256);
                if (component == null || ((JComboBox)component).getItemCount() <= propertyArray.intg[n]) continue;
                this.setComboBoxQuiet((JComboBox)component, propertyArray.intg[n]);
            }
            for (n = 0; n < propertyArray.para.length; ++n) {
                component = gUISupport.getItemObj(n + 512);
                if (component == null) continue;
                ((ParamField)component).setParam(propertyArray.para[n]);
            }
            for (n = 0; n < propertyArray.text.length; ++n) {
                component = gUISupport.getItemObj(n + 768);
                if (component != null) {
                    ((JTextField)component).setText(propertyArray.text[n]);
                    continue;
                }
                component = gUISupport.getItemObj(n + 1024);
                if (component == null) continue;
                ((PathField)component).setPath(new File(propertyArray.text[n]));
            }
            for (n = 0; n < propertyArray.envl.length; ++n) {
                component = gUISupport.getItemObj(n + 1792);
                if (component == null) continue;
                ((EnvIcon)component).setEnv(propertyArray.envl[n]);
            }
        }
        catch (ClassCastException classCastException) {
            this.displayError(classCastException, this.getTitle());
        }
        this.reflectPropertyChanges();
    }

    public void fillPropertyArray() {
    }

    protected void fillPropertyArray(GUISupport gUISupport) {
        PropertyArray propertyArray = this.getPropertyArray();
        try {
            Component component;
            int n;
            for (n = 0; n < propertyArray.bool.length; ++n) {
                component = gUISupport.getItemObj(n + 0);
                if (component == null) continue;
                propertyArray.bool[n] = ((JCheckBox)component).isSelected();
            }
            for (n = 0; n < propertyArray.intg.length; ++n) {
                component = gUISupport.getItemObj(n + 256);
                if (component == null) continue;
                propertyArray.intg[n] = ((JComboBox)component).getSelectedIndex();
            }
            for (n = 0; n < propertyArray.para.length; ++n) {
                component = gUISupport.getItemObj(n + 512);
                if (component == null) continue;
                propertyArray.para[n] = ((ParamField)component).getParam();
            }
            for (n = 0; n < propertyArray.text.length; ++n) {
                component = gUISupport.getItemObj(n + 768);
                if (component != null) {
                    propertyArray.text[n] = ((JTextField)component).getText();
                    continue;
                }
                component = gUISupport.getItemObj(n + 1024);
                if (component == null) continue;
                propertyArray.text[n] = ((PathField)component).getPath().getPath();
            }
            for (n = 0; n < propertyArray.envl.length; ++n) {
                component = gUISupport.getItemObj(n + 1792);
                if (component == null) continue;
                propertyArray.envl[n] = ((EnvIcon)component).getEnv();
            }
        }
        catch (ClassCastException classCastException) {
            this.displayError(classCastException, this.getTitle());
        }
    }

    protected String getTitle() {
        return this.procTitle;
    }

    protected Component[] createGadgets(int n) {
        Component[] componentArray;
        switch (n) {
            case 0: {
                final ParamField paramField = new ParamField(Constants.spaces[7]);
                final JComboBox<String> jComboBox = new JComboBox<String>();
                jComboBox.addItem("normalized");
                jComboBox.addItem("immediate");
                this.ggGain = paramField;
                this.ggGainType = jComboBox;
                componentArray = new Component[]{paramField, jComboBox};
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        switch (jComboBox.getSelectedIndex()) {
                            case 1: {
                                paramField.setParam(new de.sciss.fscape.util.Param(0.0, 785));
                                break;
                            }
                            case 0: {
                                paramField.setParam(ModulePanel.this.getDefaultGain());
                                break;
                            }
                        }
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        return componentArray;
    }

    protected void handleClipping(float f) {
        boolean bl = this.clipping = f < 0.707f || f > 1.0f;
        if (!this.clipping) {
            return;
        }
        int n = this.ggGainType == null ? 1 : this.ggGainType.getSelectedIndex();
        this.clipping = this.clipping && n != 0;
        this.maxAmp = f;
    }

    protected void clippingDlg() {
        double d = 1.0 / ((double)this.maxAmp * 1.0115794543);
        Double d2 = new Double(20.0 * Math.log(d) / 2.302585092994046);
        Object[] objectArray = new Object[]{d2};
        String string = "The output {0,choice,-1#is clipped|0#volume is suboptimal}!\nShall the gain be adjusted by {0,number,#,##0.0} dB?";
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.setLocale(Locale.US);
        messageFormat.applyPattern(string);
        if (this.ggGain != null) {
            int n = JOptionPane.showConfirmDialog(this.getComponent(), messageFormat.format(objectArray), "Confirm", 0);
            if (n == 0) {
                de.sciss.fscape.util.Param param = this.ggGain.getParam();
                de.sciss.fscape.util.Param param2 = new de.sciss.fscape.util.Param(1.0, 1);
                de.sciss.fscape.util.Param param3 = de.sciss.fscape.util.Param.transform(param, 1, param2, null);
                param = de.sciss.fscape.util.Param.transform(new de.sciss.fscape.util.Param(param3.value * d, param3.unit), param.unit, param2, null);
                this.ggGain.setParam(param);
            }
        } else {
            JOptionPane.showMessageDialog(this.getComponent(), messageFormat.format(objectArray));
        }
    }

    protected void indicateOutputWrite() {
        this.pp.setPaint(COLOR_NORM);
    }

    protected boolean normalizeAudioFile(FloatFile[] floatFileArray, AudioFile audioFile, float[][] fArray, float f, float f2) throws IOException {
        int n;
        AudioFileDescr audioFileDescr = audioFile.getDescr();
        int n2 = audioFileDescr.channels;
        int n3 = fArray[0].length;
        float f3 = this.getProgression();
        float f4 = f2 - f3;
        this.indicateOutputWrite();
        for (n = 0; n < floatFileArray.length; ++n) {
            floatFileArray[n].seekFloat(0);
        }
        int n4 = 0;
        if (floatFileArray.length == n2) {
            int n5 = (int)floatFileArray[0].getSize();
            while (n4 < n5 && this.threadRunning) {
                int n6 = Math.min(n3, n5 - n4);
                for (n = 0; n < n2; ++n) {
                    float[] fArray2 = fArray[n];
                    floatFileArray[n].readFloats(fArray2, 0, n6);
                    int n7 = 0;
                    while (n7 < n6) {
                        int n8 = n7++;
                        fArray2[n8] = fArray2[n8] * f;
                    }
                }
                audioFile.writeFrames(fArray, 0, n6);
                this.setProgression((float)(n4 += n6) / (float)n5 * f4 + f3);
            }
        } else if (floatFileArray.length == 1) {
            int n9 = (int)(floatFileArray[0].getSize() / (long)n2);
            n4 = 0;
            float[] fArray3 = new float[n3 * n2];
            while (n4 < n9 && this.threadRunning) {
                int n10 = Math.min(n3, n9 - n4);
                floatFileArray[0].readFloats(fArray3, 0, n10 * n2);
                for (n = 0; n < n2; ++n) {
                    float[] fArray4 = fArray[n];
                    int n11 = 0;
                    int n12 = n;
                    while (n11 < n10) {
                        fArray4[n11] = fArray3[n12] * f;
                        ++n11;
                        n12 += n2;
                    }
                }
                audioFile.writeFrames(fArray, 0, n10);
                this.setProgression((float)(n4 += n10) / (float)n9 * f4 + f3);
            }
        } else {
            System.err.println("DocumentFrame.normalizeAudioFile : illegal floatfile channel #");
        }
        return this.threadRunning;
    }

    protected boolean normalizeAudioFile(AudioFile audioFile, AudioFile audioFile2, float[][] fArray, float f, float f2) throws IOException {
        int n = audioFile2.getDescr().channels;
        long l = audioFile.getFrameNum();
        int n2 = fArray[0].length;
        float f3 = this.getProgression();
        float f4 = f2 - f3;
        this.indicateOutputWrite();
        audioFile.seekFrame(0L);
        long l2 = 0L;
        while (l2 < l && this.threadRunning) {
            int n3 = (int)Math.min((long)n2, l - l2);
            audioFile.readFrames(fArray, 0, n3);
            for (int i = 0; i < n; ++i) {
                float[] fArray2 = fArray[i];
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = n4++;
                    fArray2[n5] = fArray2[n5] * f;
                }
            }
            audioFile2.writeFrames(fArray, 0, n3);
            this.setProgression((float)(l2 += (long)n3) / (float)l * f4 + f3);
        }
        return this.threadRunning;
    }

    protected AudioFile createTempFile(AudioFileDescr audioFileDescr) throws IOException {
        return this.createTempFile(audioFileDescr.channels, audioFileDescr.rate);
    }

    protected AudioFile createTempFile(int n, double d) throws IOException {
        AudioFileDescr audioFileDescr = new AudioFileDescr();
        audioFileDescr.type = 0;
        audioFileDescr.channels = n;
        audioFileDescr.rate = d;
        audioFileDescr.bitsPerSample = 32;
        audioFileDescr.sampleFormat = 1;
        audioFileDescr.file = IOUtil.createTempFile((String)"fsc", (String)".aif");
        AudioFile audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
        this.collTempFiles.add(audioFile);
        return audioFile;
    }

    protected void deleteTempFile(AudioFile audioFile) {
        this.collTempFiles.remove(audioFile);
        audioFile.cleanUp();
        audioFile.getDescr().file.delete();
    }

    private void deleteAllTempFiles() {
        while (!this.collTempFiles.isEmpty()) {
            this.deleteTempFile(this.collTempFiles.get(0));
        }
    }

    @Override
    public void run() {
        this.fillPropertyArray();
        this.setProgression(0.0f);
        this.deleteAllTempFiles();
        this.setError(null);
        this.clipping = false;
        this.resume();
        this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(this, 0, System.currentTimeMillis(), this));
        try {
            this.process();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(new Exception(ERR_MEMORY));
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        finally {
            this.deleteAllTempFiles();
            this.stop();
            this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(this, 1, System.currentTimeMillis(), this));
        }
    }

    protected abstract void process();

    @Override
    public void start() {
        this.pp.start();
    }

    @Override
    public void pause() {
        this.threadRunning = true;
        this.threadPausing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        ModulePanel modulePanel = this;
        synchronized (modulePanel) {
            this.threadRunning = true;
            this.threadPausing = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ModulePanel modulePanel = this;
        synchronized (modulePanel) {
            this.threadRunning = false;
            this.threadPausing = false;
            this.notify();
        }
    }

    @Override
    public void addProcessorListener(ProcessorListener processorListener) {
        this.elm.addListener((Object)processorListener);
        ++this.listenerCount;
    }

    @Override
    public void removeProcessorListener(ProcessorListener processorListener) {
        this.elm.removeListener((Object)processorListener);
        --this.listenerCount;
    }

    @Override
    public float getProgression() {
        return this.progress;
    }

    @Override
    public Exception getError() {
        return this.threadError;
    }

    @Override
    public void setError(Exception exception) {
        this.threadError = exception;
    }

    public void processEvent(BasicEvent basicEvent) {
        block7: for (int i = 0; i < this.elm.countListeners(); ++i) {
            ProcessorListener processorListener = (ProcessorListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 4: {
                    processorListener.processorProgress((ProcessorEvent)basicEvent);
                    continue block7;
                }
                case 0: {
                    processorListener.processorStarted((ProcessorEvent)basicEvent);
                    continue block7;
                }
                case 1: {
                    processorListener.processorStopped((ProcessorEvent)basicEvent);
                    continue block7;
                }
                case 2: {
                    processorListener.processorPaused((ProcessorEvent)basicEvent);
                    continue block7;
                }
                case 3: {
                    processorListener.processorResumed((ProcessorEvent)basicEvent);
                    continue block7;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block7;
                }
            }
        }
    }

    protected ProcessPanel getProcessPanel() {
        return this.pp;
    }

    protected void reflectPropertyChanges() {
    }

    public void addCancelListener(ActionListener actionListener) {
        this.pProgress.addCancelListener(actionListener);
    }

    public void removeCancelListener(ActionListener actionListener) {
        this.pProgress.removeCancelListener(actionListener);
    }

    public Component getComponent() {
        return this;
    }

    public void resetProgression() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgression(float f) {
        this.progress = f;
        if (this.listenerCount > 0) {
            this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(this, 4, System.currentTimeMillis(), this));
        }
        if (this.threadPausing) {
            try {
                ModulePanel modulePanel = this;
                synchronized (modulePanel) {
                    this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(this, 2, System.currentTimeMillis(), this));
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(this, 3, System.currentTimeMillis(), this));
        }
    }

    public void finishProgression(int n) {
    }

    public void setProgressionText(String string) {
    }

    public void showMessage(int n, String string) {
    }

    public void displayError(Exception exception, String string) {
        GUIUtil.displayError((Component)this.getComponent(), (Exception)exception, (String)string);
    }

    private class ActionRecallPreset
    extends MenuAction {
        protected ActionRecallPreset(String string, KeyStroke keyStroke) {
            super(string, keyStroke);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ModulePanel.this.threadRunning) {
                return;
            }
            ModulePanel.this.loadPreset(this.getValue("Name").toString());
        }
    }
}

