/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.render;

import de.sciss.fscape.render.AbstractRenderPlugIn;
import de.sciss.fscape.render.RenderContext;
import de.sciss.fscape.render.RenderSource;
import de.sciss.gui.PrefCheckBox;
import de.sciss.gui.PrefComboBox;
import de.sciss.gui.PrefNumberField;
import de.sciss.gui.SpringPanel;
import de.sciss.gui.StringItem;
import de.sciss.util.NumberSpace;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Needlehole
extends AbstractRenderPlugIn {
    private Preferences prefs;
    private static final String KEY_GAINTYPE = "gaintype";
    private static final String KEY_GAIN = "gain";
    private static final String KEY_FILTER = "filter";
    private static final String KEY_LENGTH = "length";
    private static final String KEY_THRESH = "thresh";
    private static final String KEY_SUBDRY = "subdry";
    private static final String GAIN_ABSOLUTE = "abs";
    private static final String GAIN_NORMALIZED = "norm";
    private static final String FILTER_MEDIAN = "median";
    private static final String FILTER_STDDEV = "stddev";
    private static final String FILTER_MINIMUM = "minimum";
    private static final String FILTER_CENTER = "center";
    private RunningWindowFilter prFilter;
    private boolean prSubDry;
    private boolean prNormalize;
    private float prGain;
    private float[][] prInBuf;
    private int prInBufSize;
    private int prOffStart;
    private long prFramesWritten;
    private long prRenderLength;
    private int prWinSize;

    @Override
    public boolean hasUserParameters() {
        return true;
    }

    @Override
    public boolean shouldDisplayParameters() {
        return true;
    }

    @Override
    public void init(Preferences preferences) {
        super.init(preferences);
        this.prefs = preferences;
    }

    @Override
    public JComponent getSettingsView(RenderContext renderContext) {
        SpringPanel springPanel = new SpringPanel();
        PrefNumberField prefNumberField = new PrefNumberField();
        PrefComboBox prefComboBox = new PrefComboBox();
        PrefNumberField prefNumberField2 = new PrefNumberField();
        PrefComboBox prefComboBox2 = new PrefComboBox();
        PrefNumberField prefNumberField3 = new PrefNumberField();
        PrefCheckBox prefCheckBox = new PrefCheckBox();
        prefNumberField.setSpace(NumberSpace.genericDoubleSpace);
        prefComboBox.addItem((Object)new StringItem(GAIN_NORMALIZED, (Object)"normalized"));
        prefComboBox.addItem((Object)new StringItem(GAIN_ABSOLUTE, (Object)"immediate"));
        prefNumberField2.setSpace(NumberSpace.genericDoubleSpace);
        prefNumberField3.setSpace(NumberSpace.genericDoubleSpace);
        prefComboBox2.addItem((Object)new StringItem(FILTER_MEDIAN, (Object)"Median"));
        prefComboBox2.addItem((Object)new StringItem(FILTER_STDDEV, (Object)"Standard Deviation"));
        prefComboBox2.addItem((Object)new StringItem(FILTER_MINIMUM, (Object)"Minimum"));
        prefComboBox2.addItem((Object)new StringItem(FILTER_CENTER, (Object)"Center Clipping"));
        springPanel.gridAdd((JComponent)new JLabel("Gain", 4), 0, 0);
        springPanel.gridAdd((JComponent)prefNumberField, 1, 0);
        springPanel.gridAdd((JComponent)prefComboBox, 1, 0);
        springPanel.gridAdd((JComponent)new JLabel("Window length", 4), 0, 1);
        springPanel.gridAdd((JComponent)prefNumberField2, 1, 1);
        springPanel.gridAdd((JComponent)new JLabel("Filter", 4), 0, 2);
        springPanel.gridAdd((JComponent)prefComboBox2, 1, 2);
        springPanel.gridAdd((JComponent)new JLabel("Clip thresh", 4), 0, 3);
        springPanel.gridAdd((JComponent)prefNumberField3, 1, 3);
        springPanel.gridAdd((JComponent)new JLabel("Subtract dry signal", 4), 0, 4);
        springPanel.gridAdd((JComponent)prefCheckBox, 1, 4);
        prefNumberField.setPreferences(this.prefs, KEY_GAIN);
        prefComboBox.setPreferences(this.prefs, KEY_GAINTYPE);
        prefNumberField2.setPreferences(this.prefs, KEY_LENGTH);
        prefComboBox2.setPreferences(this.prefs, KEY_FILTER);
        prefNumberField3.setPreferences(this.prefs, KEY_THRESH);
        prefCheckBox.setPreferences(this.prefs, KEY_SUBDRY);
        springPanel.makeCompactGrid();
        return springPanel;
    }

    @Override
    public String getName() {
        return "Needlehole Cherry Blossom";
    }

    @Override
    public boolean producerBegin(RenderContext renderContext, RenderSource renderSource) throws IOException {
        double d = this.prefs.getDouble(KEY_LENGTH, 1.0);
        String string = this.prefs.get(KEY_FILTER, FILTER_MEDIAN);
        double d2 = Math.exp(this.prefs.getDouble(KEY_THRESH, -3.0) / 20.0 * Math.log(10.0));
        this.prSubDry = this.prefs.getBoolean(KEY_SUBDRY, false);
        this.prNormalize = this.prefs.get(KEY_GAINTYPE, "").equals(GAIN_NORMALIZED);
        this.prWinSize = Math.max(1, (int)(d * (double)renderContext.getSourceRate() + 0.5) & 0xFFFFFFFE);
        int n = Math.max(8192, this.prWinSize);
        Integer n2 = new Integer(n);
        this.prInBufSize = n + this.prWinSize;
        this.prOffStart = this.prWinSize >> 1;
        this.prInBuf = new float[renderSource.numChannels][this.prInBufSize];
        renderContext.setOption(RenderContext.KEY_MINBLOCKSIZE, n2);
        renderContext.setOption(RenderContext.KEY_PREFBLOCKSIZE, n2);
        renderContext.setOption(RenderContext.KEY_MAXBLOCKSIZE, n2);
        if (string.equals(FILTER_MEDIAN)) {
            this.prFilter = new MedianFilter(this.prWinSize, renderSource.numChannels);
        } else if (string.equals(FILTER_STDDEV)) {
            this.prFilter = new StdDevFilter(this.prWinSize, renderSource.numChannels);
        } else if (string.equals(FILTER_MINIMUM)) {
            this.prFilter = new MinimumFilter(this.prWinSize, renderSource.numChannels);
        } else if (string.equals(FILTER_CENTER)) {
            this.prFilter = new CenterClippingFilter(this.prWinSize, renderSource.numChannels, d2);
        } else {
            throw new IOException("Unknown filter type : " + string);
        }
        this.prGain = this.prNormalize ? 1.0f : (float)Math.exp(this.prefs.getDouble(KEY_GAIN, 0.0) / 20.0 * Math.log(10.0));
        this.prRenderLength = renderContext.getTimeSpan().getLength();
        this.prFramesWritten = 0L;
        return renderContext.getConsumer().consumerBegin(renderContext, renderSource);
    }

    @Override
    public boolean producerRender(RenderContext renderContext, RenderSource renderSource) throws IOException {
        int n;
        int n2 = (int)Math.min((long)(this.prInBufSize - this.prWinSize), this.prRenderLength - this.prFramesWritten);
        for (n = 0; n < renderSource.numChannels; ++n) {
            System.arraycopy(renderSource.blockBuf[n], renderSource.blockBufOff, this.prInBuf, this.prOffStart, renderSource.blockBufLen);
        }
        if (this.prOffStart + renderSource.blockBufLen < this.prInBufSize) {
            Needlehole.fill(this.prInBuf, this.prOffStart + renderSource.blockBufLen, this.prInBufSize - this.prOffStart - renderSource.blockBufLen, 0.0f);
        }
        this.prFilter.process(this.prInBuf, renderSource.blockBuf, 0, renderSource.blockBufOff, n2);
        if (this.prSubDry) {
            Needlehole.subtract(renderSource.blockBuf, renderSource.blockBufOff, this.prInBuf, this.prWinSize >> 1, n2);
        }
        for (n = 0; n < renderSource.numChannels; ++n) {
            System.arraycopy(this.prInBuf[n], this.prInBufSize - this.prWinSize, this.prInBuf[n], 0, this.prWinSize);
        }
        this.prOffStart = this.prWinSize;
        this.prFramesWritten += (long)n2;
        if (this.prGain != 1.0f) {
            Needlehole.multiply(renderSource.blockBuf, renderSource.blockBufOff, n2, this.prGain);
        }
        return renderContext.getConsumer().consumerRender(renderContext, renderSource);
    }

    private static void fill(float[][] fArray, int n, int n2, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                fArray2[n3++] = f;
            }
        }
    }

    private static void multiply(float[][] fArray, int n, int n2, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = n3++;
                fArray2[n5] = fArray2[n5] * f;
            }
        }
    }

    private static void subtract(float[][] fArray, int n, float[][] fArray2, int n2, int n3) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n4 = n;
            int n5 = n2;
            int n6 = n + n3;
            while (n4 < n6) {
                int n7 = n4++;
                fArray3[n7] = fArray3[n7] - fArray4[n5++];
            }
        }
    }

    private static class CenterClippingFilter
    implements RunningWindowFilter {
        final int channels;
        final int winSizeM1;
        final int[][] histogram;
        final int threshSum;
        boolean init = false;

        public CenterClippingFilter(int n, int n2, double d) {
            this.channels = n2;
            this.winSizeM1 = n - 1;
            this.histogram = new int[n2][16384];
            this.threshSum = (int)(d * (double)n + 0.5);
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                int n4;
                float f;
                int n5;
                int n6;
                int[] nArray = this.histogram[i];
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                if (!this.init) {
                    n6 = 0;
                    n5 = n;
                    while (n6 < this.winSizeM1) {
                        f = fArray3[n5];
                        int n7 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                        nArray[n7] = nArray[n7] + 1;
                        ++n6;
                        ++n5;
                    }
                }
                n6 = 0;
                n5 = n;
                int n8 = n2;
                while (n6 < n3) {
                    f = fArray3[n5 + this.winSizeM1];
                    int n9 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                    nArray[n9] = nArray[n9] + 1;
                    n4 = 0;
                    for (int j = 0; n4 < 8192 && j < this.threshSum; j += nArray[n4], ++n4) {
                    }
                    float f2 = (float)n4 / 16383.0f;
                    f2 = f2 * f2 * 4.0f;
                    f = fArray3[n5];
                    fArray4[n8] = f >= 0.0f ? Math.max(0.0f, f - f2) : Math.min(0.0f, f + f2);
                    f = fArray3[n5];
                    int n10 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                    nArray[n10] = nArray[n10] - 1;
                    ++n6;
                    ++n5;
                    ++n8;
                }
            }
            this.init = true;
        }
    }

    private static class MedianFilter
    implements RunningWindowFilter {
        final int winSize;
        final int medianOff;
        final int winSizeM;
        final int channels;
        final float[][] buf;
        final int[][] idxBuf;

        protected MedianFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.buf = new float[n2][n];
            this.idxBuf = new int[n2][n];
            this.medianOff = n >> 1;
            this.winSizeM = n - 1;
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                int n4;
                int n5;
                float f;
                int n6;
                float[] fArray3 = this.buf[i];
                float[] fArray4 = fArray[i];
                float[] fArray5 = fArray2[i];
                int[] nArray = this.idxBuf[i];
                int n7 = n;
                int n8 = n2;
                fArray3[0] = fArray4[n7++];
                nArray[0] = 0;
                for (n6 = 1; n6 < this.winSize; ++n6) {
                    f = fArray4[n7++];
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (!(f < fArray3[n5])) continue;
                        System.arraycopy(fArray3, n5, fArray3, n5 + 1, n6 - n5);
                        for (n4 = 0; n4 < n6; ++n4) {
                            if (nArray[n4] < n5) continue;
                            int n9 = n4;
                            nArray[n9] = nArray[n9] + 1;
                        }
                        break;
                    }
                    fArray3[n5] = f;
                    nArray[n6] = n5;
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    fArray5[n8++] = fArray3[this.medianOff];
                    n5 = nArray[n6 % this.winSize];
                    System.arraycopy(fArray3, n5 + 1, fArray3, n5, this.winSizeM - n5);
                    for (n4 = 0; n4 < this.winSize; ++n4) {
                        if (nArray[n4] <= n5) continue;
                        int n10 = n4;
                        nArray[n10] = nArray[n10] - 1;
                    }
                    f = fArray4[n7++];
                    for (n5 = 0; n5 < this.winSizeM; ++n5) {
                        if (!(f < fArray3[n5])) continue;
                        System.arraycopy(fArray3, n5, fArray3, n5 + 1, this.winSizeM - n5);
                        for (n4 = 0; n4 < this.winSize; ++n4) {
                            if (nArray[n4] < n5) continue;
                            int n11 = n4;
                            nArray[n11] = nArray[n11] + 1;
                        }
                        break;
                    }
                    fArray3[n5] = f;
                    nArray[n6 % this.winSize] = n5;
                }
            }
        }
    }

    private static class MinimumFilter
    implements RunningWindowFilter {
        final int winSize;
        final int channels;
        final int winSizeM1;

        public MinimumFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.winSizeM1 = n - 1;
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                int n4 = -1;
                float f = 0.0f;
                int n5 = 0;
                int n6 = n;
                int n7 = n2;
                while (n5 < n3) {
                    float f2;
                    if (n4 < n6) {
                        f2 = Math.abs(fArray3[n6]);
                        n4 = n6;
                        int n8 = 1;
                        int n9 = n6 + 1;
                        while (n8 < this.winSize) {
                            float f3 = Math.abs(fArray3[n9]);
                            if (f3 < f2) {
                                f2 = f3;
                                n4 = n9;
                            }
                            ++n8;
                            ++n9;
                        }
                        f = fArray3[n4];
                    } else {
                        f2 = fArray3[n6 + this.winSizeM1];
                        if (Math.abs(f2) < Math.abs(f)) {
                            f = f2;
                            n4 = n6 + this.winSizeM1;
                        }
                    }
                    fArray4[n7] = f;
                    --n4;
                    ++n5;
                    ++n6;
                    ++n7;
                }
            }
        }
    }

    private static class StdDevFilter
    implements RunningWindowFilter {
        final int winSize;
        final int channels;
        final double[][] dcMem;
        final int winSizeM1;

        public StdDevFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.winSizeM1 = n - 1;
            this.dcMem = new double[n2][2];
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                double[] dArray = this.dcMem[i];
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                double d = 0.0;
                int n4 = 0;
                int n5 = n;
                while (n4 < this.winSizeM1) {
                    d += (double)fArray3[n5];
                    ++n4;
                    ++n5;
                }
                double d2 = 0.0;
                int n6 = 0;
                n5 = n;
                int n7 = n2;
                while (n6 < n3) {
                    double d3;
                    d = d - d2 + (double)fArray3[n5 + this.winSizeM1];
                    double d4 = d / (double)this.winSize;
                    double d5 = 0.0;
                    n4 = 0;
                    int n8 = n5;
                    while (n4 < this.winSize) {
                        d3 = (double)fArray3[n8] - d4;
                        d5 += d3 * d3;
                        ++n4;
                        ++n8;
                    }
                    d3 = Math.sqrt(d5);
                    double d6 = d3 - dArray[0] + 0.99 * dArray[1];
                    fArray4[n7] = (float)d6;
                    dArray[0] = d3;
                    dArray[1] = d6;
                    d2 = fArray3[n5];
                    ++n6;
                    ++n5;
                    ++n7;
                }
            }
        }
    }

    private static interface RunningWindowFilter {
        public void process(float[][] var1, float[][] var2, int var3, int var4, int var5) throws IOException;
    }
}

