/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.prop;

import de.sciss.fscape.Application;
import de.sciss.io.AudioFile;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class BasicProperties
extends Properties {
    private File f;
    protected static final String header = "Created by FScape; do not edit manually!";
    protected boolean modified = false;

    public BasicProperties(Class clazz, Properties properties, String string) {
        super(properties);
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46) + 1;
        String string3 = string2.substring(n);
        try {
            this.f = new File(System.getProperty("user.home") + File.separator + "FScape" + File.separator + string + File.separator + string3 + '.' + string);
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BasicProperties(Properties properties, File file) {
        super(properties);
        this.f = file;
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        BasicProperties basicProperties = this;
        synchronized (basicProperties) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.f)));
            String string = "";
            do {
                if ((string = bufferedReader.readLine()).startsWith("#")) continue;
                String string2 = AudioFile.retrieveType((File)this.f) == -1 ? "Unknown file format" : "This is an audio file.\nYou don't open audio files via the File menu!";
                throw new IOException("This file is not an FScape document.\n" + string2);
            } while (!string.contains(header));
            this.load(bufferedReader);
            this.modified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(boolean bl) throws IOException {
        BasicProperties basicProperties = this;
        synchronized (basicProperties) {
            if (bl || this.modified) {
                if (this.f.exists() && Application.userPrefs.getBoolean("makebackups", false)) {
                    File file = new File(Application.userPrefs.get("backupdir", ""), this.f.getName());
                    BasicProperties.copyFile(this.f, file);
                }
                try {
                    this.store(new FileOutputStream(this.f), header);
                    this.modified = false;
                }
                catch (IOException iOException) {
                    File file = this.f.getParentFile();
                    file.mkdirs();
                    this.store(new FileOutputStream(this.f), header);
                    this.modified = false;
                }
            }
        }
    }

    public void store() throws IOException {
        this.store(false);
    }

    private static void copyFile(File file, File file2) throws IOException {
        int n;
        if (file2.exists()) {
            file2.delete();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
        byte[] byArray = new byte[16768];
        long l = randomAccessFile.length();
        for (long i = 0L; i < l; i += (long)n) {
            n = (int)Math.min(16768L, l - i);
            randomAccessFile.readFully(byArray, 0, n);
            randomAccessFile2.write(byArray, 0, n);
        }
        randomAccessFile.close();
        randomAccessFile2.close();
    }

    @Override
    public Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object object, Object object2) {
        BasicProperties basicProperties = this;
        synchronized (basicProperties) {
            this.modified = true;
            return super.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String string, String string2) {
        BasicProperties basicProperties = this;
        synchronized (basicProperties) {
            this.modified = true;
            return super.put(string, string2);
        }
    }

    public static Object setPointProperty(Properties properties, String string, Point point) {
        return properties.put(string, "" + point.x + "," + point.y);
    }

    public static Object setDimensionProperty(Properties properties, String string, Dimension dimension) {
        return properties.put(string, "" + dimension.width + "," + dimension.height);
    }

    public static Object setRectangleProperty(Properties properties, String string, Rectangle rectangle) {
        return properties.put(string, "" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public static Point getPointProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 == null) {
                throw new NoSuchElementException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new Point(n, n2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Dimension getDimensionProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 == null) {
                throw new NoSuchElementException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new Dimension(n, n2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Rectangle getRectangleProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 == null) {
                throw new NoSuchElementException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            return new Rectangle(n, n2, n3, n4);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

