/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import java.io.EOFException;
import java.io.IOException;

public class TarnishOp
extends Operator {
    protected static final String defaultName = "Tarnish";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_LOFREQ = 0;
    private static final int PR_HIFREQ = 1;
    private static final int PR_WINDOW = 0;
    private static final int PR_OVERSMP = 1;
    private static final int PR_MODE = 2;
    private static final int PR_RESIDUAL = 0;
    private static final int PR_MINPHASE = 1;
    protected static final int MODE_OVERTONES = 0;
    protected static final int MODE_ALL = 1;
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_OVERSMP = "OverSmp";
    private static final String PRN_WINDOW = "Window";
    private static final String PRN_RESIDUAL = "Residual";
    private static final String PRN_MINPHASE = "MinPhase";
    private static final String PRN_MODE = "Mode";
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"LoFreq", "HiFreq"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OverSmp", "Window", "Mode"};
    private static final boolean[] prBool = new boolean[]{false, true};
    private static final String[] prBoolName = new String[]{"Residual", "MinPhase"};

    public TarnishOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), TarnishOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            TarnishOp.static_pr.para = prPara;
            TarnishOp.static_pr.para[0] = new Param(100.0, 3);
            TarnishOp.static_pr.para[1] = new Param(3000.0, 3);
            TarnishOp.static_pr.paraName = prParaName;
            TarnishOp.static_pr.intg = prIntg;
            TarnishOp.static_pr.intgName = prIntgName;
            TarnishOp.static_pr.bool = prBool;
            TarnishOp.static_pr.boolName = prBoolName;
            TarnishOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "TarnishOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block48: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            int n = this.pr.intg[1];
            try {
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block48;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                int n2 = spectStream.bands;
                int n3 = n2 - 1 << 1 >> n;
                int n4 = n3 >> 1;
                float[] fArray = Filter.createFullWindow(n3, this.pr.intg[0]);
                int n5 = n2 - 1;
                int n6 = n5 << 1;
                int n7 = n6 << 1;
                float[] fArray2 = new float[n7];
                float f = (spectStream.hiFreq - spectStream.loFreq) / (float)spectStream.bands;
                System.arraycopy(fArray, n4, fArray2, 0, n4);
                System.arraycopy(fArray, 0, fArray2, n6 - n4, n4);
                fArray = new float[n5 + 1];
                Fourier.realTransform(fArray2, n6, 1);
                float f2 = 1.0f / fArray2[0];
                int n8 = 0;
                int n9 = 0;
                while (n8 <= n6) {
                    fArray[n9] = fArray2[n8] * f2;
                    n8 += 2;
                    ++n9;
                }
                for (n9 = 0; n9 <= n5 && !(fArray[n9] < 0.125f); ++n9) {
                }
                n3 = n9;
                int n10 = Math.max(n3, Math.min(n2 - 1, (int)((this.pr.para[0].value - (double)spectStream.loFreq) / (double)f + 0.5)));
                int n11 = Math.min(n2 - n3, Math.max(n10, (int)((this.pr.para[1].value - (double)spectStream.loFreq) / (double)f + 0.5)));
                float[] fArray3 = new float[n2];
                float[] fArray4 = new float[n2];
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n2];
                float f3 = 0.001f;
                this.runSlotsReady();
                block17: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block17;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        int n12;
                        float f4;
                        float[] fArray5 = spectFrame.data[i];
                        float[] fArray6 = spectFrame2.data[i];
                        Util.clear(fArray4);
                        f2 = 0.0f;
                        n8 = 0;
                        for (n9 = 0; n9 < n2; ++n9) {
                            f4 = f2;
                            f2 = fArray5[n8];
                            fArray3[n9] = f2 - f4;
                            n8 += 2;
                        }
                        f2 = fArray3[0];
                        n8 = n10;
                        int n13 = n8 << 1;
                        while (n8 < n2 - n3) {
                            block49: {
                                f4 = f2;
                                f2 = fArray3[n8];
                                float f5 = fArray5[n13];
                                if (f4 >= 0.0f && f2 <= 0.0f && f5 > f3) {
                                    int n14 = n8 - n3;
                                    n9 = n8;
                                    while (n9 > n14) {
                                        if (!(fArray3[--n9] <= 0.0f)) continue;
                                        break block49;
                                    }
                                    while (n9 > 0 && !(fArray3[--n9] <= 0.0f)) {
                                    }
                                    ++n9;
                                    n14 = n8 + n3;
                                    n12 = n8;
                                    while (n12 < n14) {
                                        if (!(fArray3[++n12] >= 0.0f)) continue;
                                        break block49;
                                    }
                                    while (n12 < n5 && !(fArray3[++n12] >= 0.0f)) {
                                    }
                                    fArray4[n8] = f5;
                                    nArray[n8] = n9;
                                    nArray2[n8] = --n12;
                                }
                            }
                            ++n8;
                            n13 += 2;
                        }
                        n8 = 0;
                        while (n8 <= n5) {
                            fArray2[n8++] = 1.0f;
                        }
                        int n15 = 0;
                        block27: for (n8 = n10; n8 <= n11; ++n8) {
                            if (fArray4[n8] == 0.0f) continue;
                            switch (this.pr.intg[2]) {
                                case 0: {
                                    int n16;
                                    n9 = n8 << 1;
                                    int n17 = 2;
                                    while (n9 < n2) {
                                        for (n13 = Math.max(n8 + 1, n9 - n3 - n17); n13 < Math.min(n2, n9 + n3 + n17); ++n13) {
                                            if (fArray4[n13] == 0.0f) continue;
                                            n16 = nArray[n13];
                                            n12 = nArray2[n13];
                                            n16 = n13 - 1;
                                            for (n12 = 0; n12 < n13 - 1; ++n12) {
                                                int n18 = n16--;
                                                fArray2[n18] = fArray2[n18] * (1.0f - fArray[n12]);
                                            }
                                            fArray2[n13] = 0.0f;
                                            n16 = n13 + 1;
                                            for (n12 = 0; n12 < n5 - n13; ++n12) {
                                                int n19 = n16++;
                                                fArray2[n19] = fArray2[n19] * (1.0f - fArray[n12]);
                                            }
                                            fArray4[n13] = 0.0f;
                                            ++n15;
                                        }
                                        n9 += n8;
                                        ++n17;
                                    }
                                    continue block27;
                                }
                                case 1: {
                                    n13 = n8;
                                    int n16 = nArray[n13];
                                    n12 = nArray2[n13];
                                    n16 = n13 - 1;
                                    for (n12 = 0; n12 < n13 - 1; ++n12) {
                                        int n20 = n16--;
                                        fArray2[n20] = fArray2[n20] * (1.0f - fArray[n12]);
                                    }
                                    fArray2[n13] = 0.0f;
                                    n16 = n13 + 1;
                                    for (n12 = 0; n12 < n5 - n13; ++n12) {
                                        int n21 = n16++;
                                        fArray2[n21] = fArray2[n21] * (1.0f - fArray[n12]);
                                    }
                                    fArray4[n13] = 0.0f;
                                    ++n15;
                                }
                            }
                        }
                        if (this.pr.bool[0]) {
                            n8 = n5 + 1;
                            n9 = n6 + 2;
                            while (n8 > 0) {
                                fArray2[--n9] = 0.0f;
                                fArray2[--n9] = 1.0f - fArray2[--n8];
                            }
                        } else {
                            n8 = n5 + 1;
                            n9 = n6 + 2;
                            while (n8 > 0) {
                                fArray2[--n9] = 0.0f;
                                fArray2[--n9] = fArray2[--n8];
                            }
                        }
                        if (this.pr.bool[1] && n15 > 0) {
                            for (n8 = 0; n8 <= n6; n8 += 2) {
                                fArray2[n8] = (float)Math.log(Math.max(1.0E-24, (double)fArray2[n8]));
                            }
                            n8 = n6 + 2;
                            n9 = n6 - 2;
                            while (n8 < n7) {
                                fArray2[n8++] = fArray2[n9];
                                fArray2[n8++] = 0.0f;
                                n9 -= 2;
                            }
                            Fourier.complexTransform(fArray2, n6, -1);
                            n8 = 2;
                            n9 = n7 - 2;
                            while (n8 < n6) {
                                int n22 = n8;
                                fArray2[n22] = fArray2[n22] + fArray2[n9];
                                int n23 = n8 + 1;
                                fArray2[n23] = fArray2[n23] - fArray2[n9 + 1];
                                n8 += 2;
                                n9 -= 2;
                            }
                            fArray2[++n8] = -fArray2[n8];
                            ++n8;
                            while (n8 < n7) {
                                fArray2[n8++] = 0.0f;
                            }
                            Fourier.complexTransform(fArray2, n6, 1);
                            for (n8 = 0; n8 <= n6; n8 += 2) {
                                fArray2[n8] = (float)Math.exp(fArray2[n8]);
                            }
                        }
                        for (n8 = 0; n8 <= n6; ++n8) {
                            fArray6[n8] = fArray5[n8] * fArray2[n8];
                            fArray6[++n8] = fArray5[n8] + fArray2[n8];
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        String[] stringArray = Filter.getWindowNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(",it");
            stringBuffer.append(stringArray[i]);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbLow frequency;pf15,prLoFreq\nlbHigh frequency;pf15,prHiFreq\nlbTarnish;ch,prMode,itOvertones,itAll Harmonics\nlbWindow;ch,prWindow" + stringBuffer.toString() + "\nlbOversampling;ch,pr" + PRN_OVERSMP + ",it1x (none),it2x,it4x,it8x\ncbMinimum phase,pr" + PRN_MINPHASE + "\ncbResidual,pr" + PRN_RESIDUAL + "\n");
        return propertyGUI;
    }
}

