/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.spect.SpectralFile;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.EOFException;
import java.io.IOException;

public class OutputOp
extends Operator {
    protected static final String defaultName = "Output file";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    private static final int PR_FILENAME = 0;
    private static final int PR_CHANNELS = 0;
    private static final int PR_OMITDATA = 1;
    private static final int PR_REMOVEDC = 0;
    private static final String PRN_FILENAME = "Filename";
    private static final String PRN_CHANNELS = "Channels";
    private static final String PRN_OMITDATA = "OmitData";
    private static final String PRN_REMOVEDC = "RemoveDC";
    private static final int PR_CHANNELS_UNTOUCHED = 0;
    private static final int PR_OMITDATA_UNTOUCHED = 0;
    private static final int PR_OMITDATA_PHASE = 1;
    private static final int PR_OMITDATA_AMPLITUDE = 2;
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Filename"};
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"Channels", "OmitData"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"RemoveDC"};
    protected static final String ERR_NOOUTPUT = "No output file";

    public OutputOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), OutputOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            OutputOp.static_pr.text = prText;
            OutputOp.static_pr.textName = prTextName;
            OutputOp.static_pr.intg = prIntg;
            OutputOp.static_pr.intgName = prIntgName;
            OutputOp.static_pr.bool = prBool;
            OutputOp.static_pr.boolName = prBoolName;
            OutputOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "OutputOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.icon = new OpIcon(this, 9, defaultName);
    }

    @Override
    public void run() {
        block22: {
            String string;
            this.runInit();
            GenericFile genericFile = null;
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            if (this.pr.text[0] == null || this.pr.text[0].length() == 0) {
                Component component = this.owner.getModule().getComponent();
                boolean bl = !(component instanceof Frame);
                Frame frame = bl ? new Frame() : (Frame)component;
                FileDialog fileDialog = new FileDialog(frame, ((OpIcon)this.getIcon()).getName() + ": Select outputfile", 1);
                fileDialog.setVisible(true);
                if (bl) {
                    frame.dispose();
                }
                String string2 = fileDialog.getFile();
                String string3 = fileDialog.getDirectory();
                fileDialog.dispose();
                if (string3 == null) {
                    string3 = "";
                }
                if (string2 == null) {
                    this.runQuit(new IOException(ERR_NOOUTPUT));
                    return;
                }
                string = string3 + string2;
            } else {
                string = this.pr.text[0];
            }
            try {
                int n;
                genericFile = new SpectralFile(string, 1 | (this.pr.bool[0] ? 65536 : 0));
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block22;
                SpectStream spectStream2 = new SpectStream(spectStream);
                if (this.pr.intg[0] != 0) {
                    spectStream2.setChannels(1);
                }
                switch (this.pr.intg[1]) {
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 1: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = 3;
                    }
                }
                ((SpectralFile)genericFile).initWriter(spectStream2, n);
                this.runSlotsReady();
                block12: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            SpectFrame spectFrame2 = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame = new SpectFrame(spectFrame2, this.pr.intg[0]);
                            this.runFrameDone(spectStreamSlot, spectFrame2);
                            spectStreamSlot.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block12;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    ((SpectralFile)genericFile).writeFrame(spectFrame);
                    ((SpectralFile)genericFile).freeFrame(spectFrame);
                }
                spectStream.closeReader();
                ((SpectralFile)genericFile).close();
            }
            catch (IOException iOException) {
                if (genericFile != null) {
                    genericFile.cleanUp();
                }
                this.runQuit(iOException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbFilename;io1|Select output file,prFilename\nlbChannel mode;ch,prChannels,itLeave untouched,itLeft channel only,itRight channel only,itSum left + right\ncbRemove DC offset,prRemoveDC\nlbSelect data;ch,prOmitData,itLeave untouched,itOmit phase data,itOmit amplitude data");
        return propertyGUI;
    }
}

