/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;

public class Mono2StereoOp
extends Operator {
    protected static final String defaultName = "Mono\u2192Stereo";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_PHASEMOD = 0;
    private static final int PR_HIDEPTH = 0;
    private static final int PR_LODEPTH = 1;
    private static final int PR_BANDWIDTH = 2;
    private static final int PR_PHASEMODFREQ = 3;
    private static final int PR_GAIN = 4;
    private static final String PRN_PHASEMOD = "PhaseMod";
    private static final String PRN_HIDEPTH = "HiDepth";
    private static final String PRN_LODEPTH = "LoDepth";
    private static final String PRN_BANDWIDTH = "Bandwidth";
    private static final String PRN_PHASEMODFREQ = "PhaseModFreq";
    private static final String PRN_GAIN = "Gain";
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"PhaseMod"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"HiDepth", "LoDepth", "Bandwidth", "PhaseModFreq", "Gain"};
    protected static final float hiFreq = 16000.0f;

    public Mono2StereoOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), Mono2StereoOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            Mono2StereoOp.static_pr.bool = prBool;
            Mono2StereoOp.static_pr.boolName = prBoolName;
            Mono2StereoOp.static_pr.para = prPara;
            Mono2StereoOp.static_pr.para[0] = new Param(7.5, 785);
            Mono2StereoOp.static_pr.para[1] = new Param(3.0, 785);
            Mono2StereoOp.static_pr.para[2] = new Param(92.0, 35);
            Mono2StereoOp.static_pr.para[3] = new Param(0.66, 3);
            Mono2StereoOp.static_pr.para[4] = new Param(0.0, 785);
            Mono2StereoOp.static_pr.paraName = prParaName;
            Mono2StereoOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "Mono2StereoOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 16, defaultName);
    }

    @Override
    public void run() {
        block20: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            Param param = new Param(1.0, 1);
            boolean bl = true;
            float f = 0.0f;
            try {
                int n;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                int n2 = 0;
                while (n2 == 0 && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        n2 = 1;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block20;
                float[] fArray = new float[spectStream.bands];
                float[] fArray2 = new float[spectStream.bands];
                float[] fArray3 = new float[spectStream.bands];
                int n3 = 1 % spectStream.chanNum;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStream2.setChannels(2);
                spectStreamSlot2.initWriter(spectStream2);
                double d = (float)Param.transform((Param)this.pr.para[4], (int)1, (Param)param, (SpectStream)spectStream).value;
                Param param2 = new Param(0.0, 3);
                Param param3 = this.pr.para[2];
                Param param4 = new Param(-param3.value, param3.unit);
                for (n2 = n = 1; n2 < spectStream.bands; ++n2) {
                    param2.value = (float)n2 * spectStream.hiFreq / (float)(spectStream.bands - 1);
                    Param param5 = Param.transform(param3, 3, param2, spectStream);
                    Param param6 = Param.transform(param4, 3, param2, spectStream);
                    fArray3[n2] = (float)(param2.value / (param5.value - param6.value) % 1.0);
                    fArray[n2] = (float)(this.pr.para[1].value + (this.pr.para[0].value - this.pr.para[1].value) * param2.value / 16000.0);
                }
                this.runSlotsReady();
                block12: while (!this.threadDead) {
                    float f2;
                    if (this.pr.bool[0] && (double)Math.abs((f2 = (float)(this.pr.para[3].value * (spectStream.getTime() / 1000.0 % (1.0 / this.pr.para[3].value)))) - f) >= 0.01) {
                        f = f2;
                        bl = true;
                    }
                    n2 = 0;
                    while (n2 == 0 && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            n2 = 1;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block12;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    if (bl) {
                        for (n2 = n; n2 < spectStream.bands; ++n2) {
                            double d2 = Math.sin(Math.PI * (double)(fArray3[n2] + f));
                            d2 = (d2 * d2 - 0.5) * (double)fArray[n2];
                            fArray2[n2] = (float)Math.exp(d2 / 20.0 * 2.302585092994046);
                        }
                        bl = false;
                    }
                    System.arraycopy(spectFrame.data[0], 0, spectFrame2.data[0], 0, spectFrame.data[0].length);
                    System.arraycopy(spectFrame.data[n3], 0, spectFrame2.data[1], 0, spectFrame.data[n3].length);
                    for (n2 = n; n2 < spectStream2.bands; ++n2) {
                        float[] fArray4 = spectFrame2.data[0];
                        int n4 = (n2 << 1) + 0;
                        fArray4[n4] = (float)((double)fArray4[n4] * (d * (double)fArray2[n2]));
                        float[] fArray5 = spectFrame2.data[1];
                        int n5 = (n2 << 1) + 0;
                        fArray5[n5] = (float)((double)fArray5[n5] * (d / (double)fArray2[n2]));
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    n2 = 0;
                    while (n2 == 0 && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            n2 = 1;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbHigh freq stereo depth;pf7,prHiDepth\nlbLow freq stereo depth;pf7,prLoDepth\nlbBandwidth;pf20|18|19,prBandwidth\nlbTotal gain;pf7,prGain\nglModulation\ncbPhase motion,actrue|1|en,acfalse|1|di,prPhaseMod;pf21,id1,prPhaseModFreq");
        return propertyGUI;
    }
}

