/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.Util;
import java.io.EOFException;
import java.io.IOException;

public class MindmachineOp
extends Operator {
    protected static final String defaultName = "Mindmachine";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    private static final int PR_ANGLE = 0;
    private static final String PRN_ANGLE = "Angle";
    protected static final int SLOT_INPUT1 = 0;
    protected static final int SLOT_INPUT2 = 1;
    protected static final int SLOT_OUTPUT = 2;
    private static final Param[] prPara = new Param[]{null};
    private static final String[] prParaName = new String[]{"Angle"};

    public MindmachineOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), MindmachineOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            MindmachineOp.static_pr.para = prPara;
            MindmachineOp.static_pr.para[0] = new Param(25.0, 0);
            MindmachineOp.static_pr.paraName = prParaName;
            MindmachineOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "MindmachineOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16, "in1"));
        this.slots.addElement(new SpectStreamSlot(this, 16, "in2"));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block27: {
            this.runInit();
            SpectStreamSlot[] spectStreamSlotArray = new SpectStreamSlot[2];
            SpectStream[] spectStreamArray = new SpectStream[2];
            SpectFrame[] spectFrameArray = new SpectFrame[2];
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            try {
                boolean bl;
                int n;
                for (n = 0; n < 2; ++n) {
                    spectStreamSlotArray[n] = (SpectStreamSlot)this.slots.elementAt(0 + n);
                    if (spectStreamSlotArray[n].getLinked() == null) {
                        this.runStop();
                    }
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamArray[n] = spectStreamSlotArray[n].getDescr();
                            bl = true;
                            nArray[n] = spectStreamArray[n].bands;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                if (this.threadDead) break block27;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(2);
                SpectStream spectStream = new SpectStream(spectStreamArray[0]);
                spectStreamSlot.initWriter(spectStream);
                int n2 = nArray[0] - 1;
                int n3 = n2 << 1;
                int n4 = n3 << 1;
                float[][] fArray = new float[2][n4];
                float[] fArray2 = new float[n3];
                double d = 1.0 / (double)n3 * Math.PI;
                for (n = 0; n < n3; ++n) {
                    double d2 = Math.cos((double)n * d);
                    fArray2[n] = (float)(d2 * d2);
                }
                nArray2[0] = (int)(this.pr.para[0].value / 100.0 * (double)n3 + 0.5) % n3;
                nArray2[1] = (nArray2[0] + n2) % n3;
                this.runSlotsReady();
                block15: while (!this.threadDead) {
                    int n5 = 0;
                    while (n5 < 2 && !this.threadDead) {
                        int n6 = n5;
                        for (n = 0; n < 2; ++n) {
                            block28: {
                                try {
                                    if (spectStreamArray[n].framesReadable() <= 0) break block28;
                                    spectFrameArray[n] = spectStreamSlotArray[n].readFrame();
                                    ++n5;
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (EOFException eOFException) {
                                    break block15;
                                }
                            }
                            this.runCheckPause();
                        }
                        if (n6 != n5) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    SpectFrame spectFrame = spectStream.allocFrame();
                    for (int i = 0; i < spectStream.chanNum; ++i) {
                        float[] fArray3;
                        float[] fArray4;
                        for (int j = 0; j < 2; ++j) {
                            fArray4 = spectFrameArray[j].data[i];
                            fArray3 = fArray[j];
                            for (n = 0; n <= n3; ++n) {
                                fArray3[n] = (float)Math.log(Math.max(1.0E-24, (double)fArray4[n]));
                                fArray3[++n] = fArray4[n];
                            }
                            n = n3 + 2;
                            int n7 = n3 - 2;
                            while (n < n4) {
                                fArray3[n++] = fArray3[n7];
                                fArray3[n++] = -fArray3[n7 + 1];
                                n7 -= 2;
                            }
                            Fourier.complexTransform(fArray3, n3, -1);
                            int n8 = nArray2[j];
                            n = 0;
                            while (n8 < n3) {
                                int n9 = n++;
                                fArray3[n9] = fArray3[n9] * fArray2[n8];
                                int n10 = n++;
                                fArray3[n10] = fArray3[n10] * fArray2[n8++];
                            }
                            n8 = 0;
                            while (n < n4) {
                                int n11 = n++;
                                fArray3[n11] = fArray3[n11] * fArray2[n8];
                                int n12 = n++;
                                fArray3[n12] = fArray3[n12] * fArray2[n8++];
                            }
                        }
                        fArray4 = fArray[0];
                        fArray3 = spectFrame.data[i];
                        Util.add(fArray[1], 0, fArray4, 0, n4);
                        Fourier.complexTransform(fArray4, n3, 1);
                        for (n = 0; n <= n3; ++n) {
                            fArray3[n] = (float)Math.exp(fArray4[n]);
                            fArray3[++n] = fArray4[n];
                        }
                    }
                    spectStreamSlotArray[0].freeFrame(spectFrameArray[0]);
                    spectStreamSlotArray[1].freeFrame(spectFrameArray[1]);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot.writeFrame(spectFrame);
                            bl = true;
                            this.runFrameDone(spectStreamSlot, spectFrame);
                            spectStream.freeFrame(spectFrame);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStreamArray[0].closeReader();
                spectStreamArray[1].closeReader();
                spectStream.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        if (n != 0) {
            return null;
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbShift;pf2,prAngle\n");
        return propertyGUI;
    }
}

