/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.spect.SpectralFile;
import de.sciss.fscape.util.Param;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.IOException;

public class InputOp
extends Operator {
    protected static final String defaultName = "Input file";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_OUTPUT = 0;
    private static final int PR_FILENAME = 0;
    private static final int PR_CHANNELS = 0;
    private static final int PR_ADJUSTSTART = 0;
    private static final int PR_ADJUSTLENGTH = 1;
    private static final int PR_REMOVEDC = 2;
    private static final int PR_STARTSHIFT = 0;
    private static final int PR_LENGTH = 1;
    private static final String PRN_FILENAME = "Filename";
    private static final String PRN_CHANNELS = "Channels";
    private static final String PRN_ADJUSTSTART = "AdjustStart";
    private static final String PRN_ADJUSTLENGTH = "AdjustLength";
    private static final String PRN_REMOVEDC = "RemoveDC";
    private static final String PRN_STARTSHIFT = "StartShift";
    private static final String PRN_LENGTH = "Length";
    private static final int PR_CHANNELS_UNTOUCHED = 0;
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Filename"};
    private static final int[] prIntg = new int[]{0};
    private static final String[] prIntgName = new String[]{"Channels"};
    private static final boolean[] prBool = new boolean[]{false, false, false};
    private static final String[] prBoolName = new String[]{"AdjustStart", "AdjustLength", "RemoveDC"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"StartShift", "Length"};
    protected static final String ERR_NOINPUT = "No input file";

    public InputOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), InputOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            InputOp.static_pr.text = prText;
            InputOp.static_pr.textName = prTextName;
            InputOp.static_pr.intg = prIntg;
            InputOp.static_pr.intgName = prIntgName;
            InputOp.static_pr.bool = prBool;
            InputOp.static_pr.boolName = prBoolName;
            InputOp.static_pr.para = prPara;
            InputOp.static_pr.para[0] = new Param(0.0, 2);
            InputOp.static_pr.para[1] = new Param(5000.0, 2);
            InputOp.static_pr.paraName = prParaName;
            InputOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "InputOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 8, defaultName);
    }

    @Override
    public void run() {
        String string;
        this.runInit();
        GenericFile genericFile = null;
        long l = 0L;
        if (this.pr.text[0] == null || this.pr.text[0].length() == 0) {
            Component component = this.owner.getModule().getComponent();
            boolean bl = !(component instanceof Frame);
            Frame frame = bl ? new Frame() : (Frame)component;
            FileDialog fileDialog = new FileDialog(frame, ((OpIcon)this.getIcon()).getName() + ": Select inputfile");
            fileDialog.setVisible(true);
            if (bl) {
                frame.dispose();
            }
            String string2 = fileDialog.getFile();
            String string3 = fileDialog.getDirectory();
            fileDialog.dispose();
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null) {
                this.runQuit(new IOException(ERR_NOINPUT));
                return;
            }
            string = string3 + string2;
        } else {
            string = this.pr.text[0];
        }
        try {
            long l2;
            long l3;
            genericFile = new SpectralFile(string, 0 | (this.pr.bool[2] ? 65536 : 0));
            SpectStream spectStream = ((SpectralFile)genericFile).getDescr();
            Param param = new Param(SpectStream.framesToMillis(spectStream, spectStream.frames), 2);
            double d = Param.transform((Param)this.pr.para[0], (int)2, (Param)param, (SpectStream)spectStream).value;
            double d2 = Param.transform((Param)this.pr.para[1], (int)2, (Param)param, (SpectStream)spectStream).value;
            if (this.pr.bool[0]) {
                l3 = (long)SpectStream.millisToFrames(spectStream, d);
                if (l3 >= spectStream.frames) {
                    l3 = spectStream.frames;
                }
            } else {
                l3 = 0L;
            }
            ((SpectralFile)genericFile).seekFrame(l3);
            if (this.pr.bool[1]) {
                l2 = (long)SpectStream.millisToFrames(spectStream, d2);
                if (l3 + l2 > spectStream.frames) {
                    l2 = spectStream.frames - l3;
                }
            } else {
                l2 = spectStream.frames - l3;
            }
            spectStream.setEstimatedLength(l2);
            SpectStream spectStream2 = new SpectStream(spectStream);
            if (this.pr.intg[0] != 0) {
                spectStream2.setChannels(1);
            }
            SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
            spectStreamSlot.initWriter(spectStream2);
            this.runSlotsReady();
            while (l < l2 && !this.threadDead) {
                SpectFrame spectFrame = ((SpectralFile)genericFile).readFrame();
                ++l;
                SpectFrame spectFrame2 = new SpectFrame(spectFrame, this.pr.intg[0]);
                ((SpectralFile)genericFile).freeFrame(spectFrame);
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStreamSlot.writeFrame(spectFrame2);
                        bl = true;
                        this.runFrameDone(spectStreamSlot, spectFrame2);
                        spectStream2.freeFrame(spectFrame2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
            }
            ((SpectralFile)genericFile).close();
            spectStream2.closeWriter();
        }
        catch (IOException iOException) {
            if (genericFile != null) {
                genericFile.cleanUp();
            }
            this.runQuit(iOException);
            return;
        }
        catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
            if (genericFile != null) {
                genericFile.cleanUp();
            }
            this.runQuit(slotAlreadyConnectedException);
            return;
        }
        this.runQuit(null);
    }

    @Override
    public PropertyGUI createGUI(int n) {
        String string;
        block4: {
            GenericFile genericFile = null;
            string = "";
            if (n != 0) {
                return null;
            }
            if (this.pr.text[0] != null && this.pr.text[0].length() != 0) {
                try {
                    genericFile = new SpectralFile(this.pr.text[0], 0);
                    SpectStream spectStream = ((SpectralFile)genericFile).getDescr();
                    double d = (double)(spectStream.frames * (long)spectStream.smpPerFrame) / ((double)spectStream.smpRate / 1000.0);
                    ((SpectralFile)genericFile).close();
                    string = ",re" + d + "|" + 2;
                }
                catch (IOException iOException) {
                    if (genericFile == null) break block4;
                    genericFile.cleanUp();
                }
            }
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbFile name;io0|Select input file,prFilename\nlbChannel mode;ch,prChannels,itLeave untouched,itLeft channel only,itRight channel only,itSum left + right\ncbRemove DC offset,prRemoveDC\nglTruncation\ncbStart shift,actrue|1|en,acfalse|1|di,prAdjustStart;pf8|9|11" + string + ",id1,pr" + PRN_STARTSHIFT + "\ncbLength,actrue|2|en,acfalse|2|di,pr" + PRN_ADJUSTLENGTH + ";pf" + 8 + "|" + 9 + "|" + 11 + string + ",id2,pr" + PRN_LENGTH);
        return propertyGUI;
    }
}

