/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.op;

import de.sciss.fscape.gui.FIRDesignerDlg;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.PropertyGUI;
import de.sciss.fscape.op.Operator;
import de.sciss.fscape.op.SlotAlreadyConnectedException;
import de.sciss.fscape.prop.OpPrefs;
import de.sciss.fscape.prop.Prefs;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.spect.SpectFrame;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.spect.SpectStreamSlot;
import de.sciss.fscape.util.Param;
import java.io.EOFException;
import java.io.IOException;

public class ExtrapolateOp
extends Operator {
    protected static final String defaultName = "Extrapolate";
    protected static Presets static_presets = null;
    protected static Prefs static_prefs = null;
    protected static PropertyArray static_pr = null;
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    private static final int PR_LOFREQ = 0;
    private static final int PR_HIFREQ = 1;
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_QUALITY = "Quality";
    private static final int[] prIntg = new int[]{1};
    private static final String[] prIntgName = new String[]{"Quality"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"LoFreq", "HiFreq"};
    protected static final String ERR_BANDS = "Band# not power of 2";
    protected static final float EXPECTEDERROR2 = 4.0E-6f;
    protected static final float EXPECTEDERROR = 1.0E-7f;
    protected static final int MR = 8;
    protected static final int MT = 10;
    protected static final int MAXITER = 80;
    protected static final float[] frac = new float[]{0.0f, 0.5f, 0.25f, 0.75f, 0.13f, 0.38f, 0.62f, 0.88f, 1.0f};

    public ExtrapolateOp() {
        if (static_prefs == null) {
            static_prefs = new OpPrefs(this.getClass(), ExtrapolateOp.getDefaultPrefs());
        }
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ExtrapolateOp.static_pr.intg = prIntg;
            ExtrapolateOp.static_pr.intgName = prIntgName;
            ExtrapolateOp.static_pr.para = prPara;
            ExtrapolateOp.static_pr.para[1] = new Param(440.0, 3);
            ExtrapolateOp.static_pr.para[0] = new Param(0.0, 3);
            ExtrapolateOp.static_pr.paraName = prParaName;
            ExtrapolateOp.static_pr.superPr = Operator.op_static_pr;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.opName = "ExtrapolateOp";
        this.prefs = static_prefs;
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.slots.addElement(new SpectStreamSlot(this, 16));
        this.slots.addElement(new SpectStreamSlot(this, 32));
        this.icon = new OpIcon(this, 12, defaultName);
    }

    @Override
    public void run() {
        block20: {
            this.runInit();
            SpectStream spectStream = null;
            SpectFrame spectFrame = null;
            SpectFrame spectFrame2 = null;
            try {
                float f;
                SpectStreamSlot spectStreamSlot = (SpectStreamSlot)this.slots.elementAt(0);
                if (spectStreamSlot.getLinked() == null) {
                    this.runStop();
                }
                boolean bl = false;
                while (!bl && !this.threadDead) {
                    try {
                        spectStream = spectStreamSlot.getDescr();
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.runCheckPause();
                }
                if (this.threadDead) break block20;
                SpectStreamSlot spectStreamSlot2 = (SpectStreamSlot)this.slots.elementAt(1);
                SpectStream spectStream2 = new SpectStream(spectStream);
                spectStreamSlot2.initWriter(spectStream2);
                float f2 = (spectStream.hiFreq - spectStream.loFreq) / (float)spectStream.bands;
                int n = spectStream.bands;
                float[][] fArray = new float[2][n];
                float f3 = Math.min(spectStream.smpRate / 2.0f, (float)this.pr.para[0].value);
                float f4 = Math.max(0.5f, Math.min(spectStream.smpRate / 2.0f, (float)this.pr.para[1].value));
                if (f3 > f4) {
                    f = f3;
                    f3 = f4;
                    f4 = f;
                }
                int n2 = (int)((f3 - spectStream.loFreq) / f2 + 0.5f);
                int n3 = (int)((f4 - spectStream.loFreq) / f2 + 0.5f);
                int n4 = Math.min(64, n3 - n2);
                float[] fArray2 = new float[n4];
                this.runSlotsReady();
                block11: while (!this.threadDead) {
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectFrame = spectStreamSlot.readFrame();
                            bl = true;
                            spectFrame2 = spectStream2.allocFrame();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (EOFException eOFException) {
                            break block11;
                        }
                        this.runCheckPause();
                    }
                    if (this.threadDead) break;
                    for (int i = 0; i < spectStream2.chanNum; ++i) {
                        float f5;
                        float[] fArray3 = spectFrame.data[i];
                        float[] fArray4 = fArray[0];
                        float[] fArray5 = fArray[1];
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < n) {
                            f5 = fArray3[n5++];
                            f = fArray3[n5++];
                            fArray4[n6] = f5 * (float)Math.cos(f);
                            fArray5[n6++] = f5 * (float)Math.sin(f);
                        }
                        for (n5 = 0; n5 < 2; ++n5) {
                            fArray3 = fArray[n5];
                            ExtrapolateOp.lpCoeffs(fArray3, n2, n3 - n2, fArray2, n4);
                            ExtrapolateOp.linearPrediction2(fArray3, n2, n3 - n2, fArray2, n4, fArray3, n3, n - n3);
                        }
                        fArray3 = spectFrame2.data[i];
                        fArray4 = fArray[0];
                        fArray5 = fArray[1];
                        n5 = 0;
                        n6 = 0;
                        while (n6 < n) {
                            f = fArray4[n6];
                            f5 = fArray5[n6++];
                            fArray3[n5++] = ExtrapolateOp.complexAbs(f, f5);
                            fArray3[n5++] = (float)Math.atan2(f5, f);
                        }
                    }
                    spectStreamSlot.freeFrame(spectFrame);
                    bl = false;
                    while (!bl && !this.threadDead) {
                        try {
                            spectStreamSlot2.writeFrame(spectFrame2);
                            bl = true;
                            this.runFrameDone(spectStreamSlot2, spectFrame2);
                            spectStream2.freeFrame(spectFrame2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runCheckPause();
                    }
                }
                spectStream.closeReader();
                spectStream2.closeWriter();
            }
            catch (IOException iOException) {
                this.runQuit(iOException);
                return;
            }
            catch (SlotAlreadyConnectedException slotAlreadyConnectedException) {
                this.runQuit(slotAlreadyConnectedException);
                return;
            }
        }
        this.runQuit(null);
    }

    public static void linearPrediction(float[] fArray, int n, int n2, float[] fArray2, int n3, float[] fArray3, int n4, int n5) {
        float[] fArray4 = new float[n3];
        int n6 = 0;
        int n7 = n + n2;
        while (n6 < n3) {
            fArray4[n6++] = fArray[--n7];
        }
        int n8 = n4 + n5;
        for (n6 = n4; n6 < n8; ++n6) {
            float f = 0.0f;
            for (n7 = 0; n7 < n3; ++n7) {
                f += fArray2[n7] * fArray4[n7];
            }
            System.arraycopy(fArray4, 0, fArray4, 1, n3 - 1);
            fArray4[0] = f;
            fArray3[n6] = f;
        }
    }

    public static void linearPrediction2(float[] fArray, int n, int n2, float[] fArray2, int n3, float[] fArray3, int n4, int n5) {
        float[] fArray4 = new float[n3];
        float f = 1.0f;
        int n6 = 0;
        int n7 = n + n2;
        while (n6 < n3) {
            fArray4[n6++] = fArray[--n7];
        }
        int n8 = n4 + n5;
        for (n6 = n4; n6 < n8; ++n6) {
            float f2 = 0.0f;
            for (n7 = 0; n7 < n3; ++n7) {
                f2 += fArray2[n7] * fArray4[n7];
            }
            System.arraycopy(fArray4, 0, fArray4, 1, n3 - 1);
            f = Math.min(16.0f, f * 0.99f + 0.01f * Math.abs(fArray3[n6]) / Math.max(1.0E-6f, Math.abs(f2)));
            fArray3[n6] = f * f2;
            fArray4[0] = f * f2;
        }
    }

    protected static float lpCoeffs(float[] fArray, int n, int n2, float[] fArray2, int n3) {
        int n4;
        float[] fArray3 = new float[n2 - 1];
        float[] fArray4 = new float[n2 - 1];
        float[] fArray5 = new float[n3 - 1];
        int n5 = n2 + n;
        float f = 0.0f;
        for (n4 = n2; n4 < n5; ++n4) {
            f += fArray[n4] * fArray[n4];
        }
        float f2 = f / (float)n2;
        fArray3[0] = fArray[0];
        fArray4[n2 - 2] = fArray[n2 - 1];
        System.arraycopy(fArray, n, fArray3, 0, n2 - 1);
        System.arraycopy(fArray, n + 1, fArray4, 0, n2 - 1);
        int n6 = 0;
        block1: while (true) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            n5 = n2 - n6 - 1;
            for (n4 = 0; n4 < n5; ++n4) {
                f3 += fArray3[n4] * fArray4[n4];
                f4 += fArray3[n4] * fArray3[n4] + fArray4[n4] * fArray4[n4];
            }
            f = f4 > 0.0f ? 2.0f * f3 / f4 : 1.0f;
            fArray2[n6] = f;
            f2 *= 1.0f - f * f;
            for (n5 = 0; n5 < n6; ++n5) {
                fArray2[n5] = fArray5[n5] - f * fArray5[n6 - n5 - 1];
            }
            if (++n6 == n3) {
                return f2;
            }
            System.arraycopy(fArray2, 0, fArray5, 0, n6);
            n4 = 0;
            n5 = n2 - n6 - 1;
            while (true) {
                if (n4 >= n5) continue block1;
                int n7 = n4;
                fArray3[n7] = fArray3[n7] - f * fArray4[n4];
                fArray4[n4] = fArray4[n4 + 1] - f * fArray3[n4 + 1];
                ++n4;
            }
            break;
        }
    }

    protected static void fixRoots(float[] fArray, int n) {
        int n2 = n << 1;
        float[] fArray2 = new float[n2 + 2];
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[2];
        fArray2[n2] = 1.0f;
        fArray2[n2 + 1] = 0.0f;
        int n3 = 0;
        int n4 = n2;
        while (n4 > 0) {
            fArray2[--n4] = 0.0f;
            fArray2[--n4] = -fArray[n3++];
        }
        ExtrapolateOp.zRoots(fArray2, n, fArray3, true);
        for (n4 = 0; n4 < n2; n4 += 2) {
            float f = ExtrapolateOp.complexAbs(fArray3[n4], fArray3[n4 + 1]);
            if (!(f > 1.0f)) continue;
            ExtrapolateOp.complexDiv(1.0f, 0.0f, fArray3[n4], -fArray3[n4 + 1], fArray4);
            fArray3[n4] = fArray4[0];
            fArray3[n4 + 1] = fArray4[1];
        }
        fArray2[0] = -fArray3[0];
        fArray2[1] = -fArray3[1];
        fArray2[2] = 1.0f;
        fArray2[3] = 0.0f;
        for (n4 = 2; n4 < n2; n4 += 2) {
            fArray2[n4 + 2] = 1.0f;
            fArray2[n4 + 3] = 0.0f;
            float f = fArray3[n4];
            float f2 = fArray3[n4 + 1];
            for (n3 = n4; n3 >= 2; n3 -= 2) {
                fArray2[n3] = fArray2[n3 - 2] - (f * fArray2[n3] - f2 * fArray2[n3 + 1]);
                fArray2[n3 + 1] = fArray2[n3 - 1] - (f2 * fArray2[n3] + f * fArray2[n3 + 1]);
            }
            fArray2[0] = -f * fArray2[0] + f2 * fArray2[1];
            fArray2[1] = -f2 * fArray2[0] - f * fArray2[1];
        }
        n3 = n;
        for (n4 = 0; n4 < n2; n4 += 2) {
            fArray[--n3] = -fArray2[n4];
        }
    }

    protected static void zRoots(float[] fArray, int n, float[] fArray2, boolean bl) {
        int n2;
        int n3 = n << 1;
        float[] fArray3 = new float[n3 + 2];
        float[] fArray4 = new float[2];
        System.arraycopy(fArray, 0, fArray3, 0, n3 + 2);
        for (n2 = n3; n2 >= 2; n2 -= 2) {
            int n4 = n2 - 2;
            fArray4[0] = 0.0f;
            fArray4[1] = 0.0f;
            ExtrapolateOp.laguerre(fArray3, n2 >> 1, fArray4);
            if (Math.abs(fArray4[1]) <= 4.0E-6f * Math.abs(fArray4[0])) {
                fArray4[1] = 0.0f;
            }
            fArray2[n4] = fArray4[0];
            fArray2[n4 + 1] = fArray4[1];
            float f = fArray3[n2];
            float f2 = fArray3[n2 + 1];
            while (n4 >= 0) {
                float f3 = fArray3[n4];
                float f4 = fArray3[n4 + 1];
                fArray3[n4] = f;
                fArray3[n4 + 1] = f2;
                f = fArray4[0] * f - fArray4[1] * f2 + f3;
                f2 = fArray4[1] * f + fArray4[0] * f2 + f4;
                n4 -= 2;
            }
        }
        if (bl) {
            n2 = 0;
            while (n2 < n3) {
                fArray4[0] = fArray2[n2];
                fArray4[1] = fArray2[n2 + 1];
                ExtrapolateOp.laguerre(fArray, n, fArray4);
                fArray2[n2++] = fArray4[0];
                fArray2[n2++] = fArray4[1];
            }
        }
        for (n2 = 2; n2 < n3; n2 += 2) {
            fArray4[0] = fArray2[n2];
            fArray4[1] = fArray2[n2 + 1];
            for (int i = n2 - 2; i >= 2 && !(fArray2[i] <= fArray4[0]); i -= 2) {
                fArray2[i + 2] = fArray2[i];
                fArray2[i + 3] = fArray2[i + 1];
            }
            fArray2[i + 2] = fArray4[0];
            fArray2[i + 3] = fArray4[1];
        }
    }

    protected static int laguerre(float[] fArray, int n, float[] fArray2) {
        float[] fArray3 = new float[2];
        int n2 = n << 1;
        for (int i = 1; i <= 80; ++i) {
            float f;
            float f2;
            float f3;
            float f4 = fArray[n2];
            float f5 = fArray[n2 + 1];
            float f6 = f3 = ExtrapolateOp.complexAbs(f4, f5);
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = ExtrapolateOp.complexAbs(fArray2[0], fArray2[1]);
            int n3 = n2;
            while (n3 > 0) {
                f9 = fArray2[0] * f9 - fArray2[1] * f10 + f4;
                f10 = fArray2[1] * f9 + fArray2[0] * f10 + f5;
                f5 = fArray2[1] * f4 + fArray2[0] * f5 + fArray[--n3];
                f4 = fArray2[0] * f4 - fArray2[1] * f5 + fArray[--n3];
                f3 = ExtrapolateOp.complexAbs(f4, f5);
                f6 = f3 + f11 * f6;
            }
            if (f3 <= (f6 *= 1.0E-7f)) {
                return i;
            }
            ExtrapolateOp.complexDiv(f9, f10, f4, f5, fArray3);
            float f12 = fArray3[0];
            float f13 = fArray3[1];
            float f14 = f12 * f12 - f13 * f13;
            float f15 = f13 * f12 * 2.0f;
            ExtrapolateOp.complexDiv(f7, f8, f4, f5, fArray3);
            float f16 = f14 - 2.0f * fArray3[0];
            float f17 = f15 - 2.0f * fArray3[1];
            float f18 = (float)(n - 1) * ((float)n * f16 - f14);
            float f19 = (float)(n - 1) * ((float)n * f17 - f15);
            ExtrapolateOp.complexSqrt(f18, f19, fArray3);
            f18 = fArray3[0];
            f19 = fArray3[1];
            float f20 = f12 + f18;
            float f21 = f13 + f19;
            float f22 = f12 - f18;
            float f23 = f13 - f19;
            float f24 = ExtrapolateOp.complexAbs(f20, f21);
            float f25 = ExtrapolateOp.complexAbs(f22, f23);
            if (f24 < f25) {
                f20 = f22;
                f21 = f23;
            }
            if (f24 > 0.0f || f25 > 0.0f) {
                ExtrapolateOp.complexDiv(n, 0.0f, f20, f21, fArray3);
                f2 = fArray3[0];
                f = fArray3[1];
            } else {
                float f26 = 1.0f + f11;
                f2 = f26 * (float)Math.cos(i);
                f = f26 * (float)Math.sin(i);
            }
            float f27 = fArray2[0] - f2;
            float f28 = fArray2[1] - f;
            if (f2 == 0.0f && f == 0.0f) {
                return i;
            }
            if (i % 10 != 0) {
                fArray2[0] = f27;
                fArray2[1] = f28;
                continue;
            }
            int n4 = i / 10;
            fArray2[0] = fArray2[0] - frac[n4] * f2;
            fArray2[1] = fArray2[1] - frac[n4] * f;
        }
        return 0;
    }

    protected static float complexAbs(float f, float f2) {
        if (f == 0.0f) {
            return Math.abs(f2);
        }
        if (f2 == 0.0f) {
            return Math.abs(f);
        }
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    protected static void complexDiv(float f, float f2, float f3, float f4, float[] fArray) {
        if (Math.abs(f3) >= Math.abs(f4)) {
            float f5 = f4 / f3;
            float f6 = f3 + f5 * f4;
            fArray[0] = (f + f5 * f2) / f6;
            fArray[1] = (f2 - f5 * f) / f6;
        } else {
            float f7 = f3 / f4;
            float f8 = f4 + f7 * f3;
            fArray[0] = (f * f7 + f2) / f8;
            fArray[1] = (f2 * f7 - f) / f8;
        }
    }

    protected static void complexSqrt(float f, float f2, float[] fArray) {
        if (f == 0.0f && f2 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            float f3;
            float f4;
            float f5 = Math.abs(f);
            if (f5 >= (f4 = Math.abs(f2))) {
                float f6 = f4 / f5;
                f3 = (float)(Math.sqrt(f5) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0f + f6 * f6))));
            } else {
                float f7 = f5 / f4;
                f3 = (float)(Math.sqrt(f4) * Math.sqrt(0.5 * ((double)f7 + Math.sqrt(1.0f + f7 * f7))));
            }
            if ((double)f >= 0.0) {
                fArray[0] = f3;
                fArray[1] = f2 / (2.0f * f3);
            } else {
                fArray[1] = f2 >= 0.0f ? f3 : -f3;
                fArray[0] = f2 / (2.0f * fArray[1]);
            }
        }
    }

    @Override
    public PropertyGUI createGUI(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            return null;
        }
        for (int i = 0; i < FIRDesignerDlg.QUAL_NAMES.length; ++i) {
            stringBuffer.append(",it");
            stringBuffer.append(FIRDesignerDlg.QUAL_NAMES[i]);
        }
        PropertyGUI propertyGUI = new PropertyGUI("glGeneral\nlbHigh frequency;pf15,prHiFreq\nlbLow frequency;pf15,prLoFreq\nlbQuality;ch,prQuality" + stringBuffer.toString() + "\n");
        return propertyGUI;
    }
}

