/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.net;

import de.sciss.fscape.net.OSCRoot;
import de.sciss.fscape.net.OSCRouter;
import de.sciss.fscape.net.RoutedOSCMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class OSCRouterWrapper
implements OSCRouter {
    private final OSCRouter r;
    private final OSCRouter superRouter;
    private final Map<String, OSCRouter> mapSubRouters = new HashMap<String, OSCRouter>();
    private static final Class[] oscCmdMethodTypes = new Class[]{RoutedOSCMessage.class};
    private static final Class[] oscGetMethodTypes = new Class[]{RoutedOSCMessage.class};

    public OSCRouterWrapper(OSCRouter oSCRouter, OSCRouter oSCRouter2) {
        this.r = oSCRouter2;
        this.superRouter = oSCRouter;
        if (oSCRouter != null) {
            oSCRouter.oscAddRouter(this.r);
        }
    }

    public void remove() {
        if (this.superRouter != null) {
            this.superRouter.oscRemoveRouter(this.r);
        }
    }

    @Override
    public void oscRoute(RoutedOSCMessage routedOSCMessage) {
        block24: {
            int n = routedOSCMessage.msg.getArgCount();
            if (routedOSCMessage.hasNext()) {
                OSCRouter oSCRouter = this.mapSubRouters.get((routedOSCMessage = routedOSCMessage.next()).getPathComponent());
                if (oSCRouter != null) {
                    oSCRouter.oscRoute(routedOSCMessage);
                } else {
                    OSCRoot.failedUnknownPath(routedOSCMessage);
                }
            } else {
                if (n == 0) {
                    OSCRoot.failedArgCount(routedOSCMessage);
                    return;
                }
                try {
                    String string = routedOSCMessage.msg.getArg(0).toString();
                    if (string.equals("query")) {
                        int n2;
                        if (n < 2) {
                            OSCRoot.failedArgCount(routedOSCMessage);
                            return;
                        }
                        Object[] objectArray = new Object[n - 1];
                        objectArray[0] = routedOSCMessage.msg.getArg(1);
                        try {
                            for (n2 = 2; n2 < n; ++n2) {
                                Method method = this.r.getClass().getMethod("oscQuery_" + routedOSCMessage.msg.getArg(n2).toString(), null);
                                objectArray[n2 - 1] = method.invoke((Object)this.r, (Object[])null);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            OSCRoot.failedArgValue(routedOSCMessage, n2);
                            return;
                        }
                        routedOSCMessage.reply("/query.reply", objectArray);
                        break block24;
                    }
                    if (string.equals("get")) {
                        if (n < 3) {
                            OSCRoot.failedArgCount(routedOSCMessage);
                            return;
                        }
                        try {
                            Method method = this.r.getClass().getMethod("oscGet_" + routedOSCMessage.msg.getArg(2), oscGetMethodTypes);
                            Object[] objectArray = (Object[])method.invoke((Object)this.r, routedOSCMessage);
                            if (objectArray != null) {
                                Object[] objectArray2 = new Object[objectArray.length + 1];
                                objectArray2[0] = routedOSCMessage.msg.getArg(1);
                                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                                routedOSCMessage.reply("/get.reply", objectArray2);
                            }
                            break block24;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            OSCRoot.failedArgValue(routedOSCMessage, 2);
                        }
                        break block24;
                    }
                    try {
                        Method method = this.r.getClass().getMethod("oscCmd_" + string, oscCmdMethodTypes);
                        method.invoke((Object)this.r, routedOSCMessage);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        OSCRoot.failedUnknownCmd(routedOSCMessage);
                    }
                }
                catch (SecurityException securityException) {
                    OSCRoot.failed(routedOSCMessage, securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    OSCRoot.failed(routedOSCMessage, illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    OSCRoot.failed(routedOSCMessage, illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    OSCRoot.failed(routedOSCMessage, invocationTargetException);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    OSCRoot.failed(routedOSCMessage, exceptionInInitializerError);
                }
                catch (IOException iOException) {
                    OSCRoot.failed(routedOSCMessage, iOException);
                }
            }
        }
    }

    @Override
    public void oscAddRouter(OSCRouter oSCRouter) {
        if (this.mapSubRouters.put(oSCRouter.oscGetPathComponent(), oSCRouter) != null) {
            throw new IllegalArgumentException("Tried to overwrite existing router for sub path " + oSCRouter.oscGetPathComponent());
        }
    }

    @Override
    public void oscRemoveRouter(OSCRouter oSCRouter) {
        if (this.mapSubRouters.remove(oSCRouter.oscGetPathComponent()) == null) {
            throw new IllegalArgumentException("Tried to remove unknown router for sub path " + oSCRouter.oscGetPathComponent());
        }
    }

    @Override
    public String oscGetPathComponent() {
        return this.r.oscGetPathComponent();
    }
}

