/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MemoryStreamReader
extends BufferedReader {
    protected char[] buf = new char[this.bufSize];
    protected int bufSize = 1024;
    protected int bufOff = 0;
    protected static final String ERR_NOMARKS = "Requested marks not found";

    public MemoryStreamReader(InputStream inputStream) throws IOException {
        super(new InputStreamReader(inputStream));
    }

    public int skipTo(String[] stringArray) throws IOException {
        return this.readTo(stringArray, null, 0L);
    }

    public int skipTo(String[] stringArray, long l) throws IOException {
        return this.readTo(stringArray, null, l);
    }

    public int readTo(String[] stringArray, StringBuffer stringBuffer) throws IOException {
        return this.readTo(stringArray, stringBuffer, 0L);
    }

    public int readTo(String[] stringArray, StringBuffer stringBuffer, long l) throws IOException {
        int n;
        boolean bl = l > 0L;
        long l2 = l;
        boolean bl2 = stringBuffer != null;
        int n2 = this.checkBufSize(stringArray);
        if (bl) {
            l2 += System.currentTimeMillis();
        }
        do {
            int n3;
            n = this.read(this.buf, this.bufOff, this.bufSize - this.bufOff);
            int n4 = Math.max(0, n);
            this.bufOff += n4;
            for (int i = 0; i < stringArray.length; ++i) {
                int n5;
                String string = stringArray[i];
                block2: for (int j = n5 = string.length(); j < this.bufOff; ++j) {
                    n3 = j;
                    int n6 = n5;
                    while (n6 > 0) {
                        if (string.charAt(--n6) == this.buf[--n3]) continue;
                        continue block2;
                    }
                    this.bufOff -= n3;
                    if (bl2) {
                        stringBuffer.append(this.buf, 0, n3);
                    }
                    System.arraycopy(this.buf, n3, this.buf, 0, this.bufOff);
                    return i;
                }
            }
            n3 = Math.max(0, this.bufOff - n2);
            this.bufOff -= n3;
            if (bl2) {
                stringBuffer.append(this.buf, 0, n3);
            }
            System.arraycopy(this.buf, n3, this.buf, 0, this.bufOff);
            if (!bl || System.currentTimeMillis() <= l2) continue;
            return -1;
        } while (n > 0);
        throw new EOFException(ERR_NOMARKS);
    }

    protected int checkBufSize(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = stringArray[i].length();
            if (n2 <= n) continue;
            n = n2;
        }
        if (n > this.bufSize) {
            this.bufSize = n + (n >> 1);
            this.buf = new char[this.bufSize];
        }
        return n;
    }
}

