/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.io;

import de.sciss.fscape.io.GenericFile;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class FloatFile
extends GenericFile {
    private byte[] buf = new byte[this.bufSize];
    private int bufSize = 131072;
    private int bufOffset = 0;
    private int bufLength = 0;
    private boolean flushed = true;
    private long bufPhysical = 0L;

    public FloatFile(File file, int n) throws IOException {
        super(file, n & 0xFFFF000F | 0x50);
        if ((n & 0xF) == 0) {
            if ((this.mode & 0xFFF0) != 80) {
                throw new UnsupportedEncodingException("Unsupported file format");
            }
        } else {
            this.writeInt(1179870022);
        }
        this.seekFloat(0);
    }

    public FloatFile(String string, int n) throws IOException {
        this(new File(string), n);
    }

    public void seekFloat(int n) throws IOException {
        long l = n + 1 << 2;
        if (!this.flushed) {
            this.flush();
        } else if (this.bufPhysical <= l && this.bufPhysical + (long)this.bufLength > l) {
            this.bufOffset = (int)(l - this.bufPhysical);
            l = this.bufPhysical + (long)this.bufLength;
        } else {
            this.bufOffset = 0;
            this.bufLength = 0;
        }
        this.seek(l);
    }

    public void flush() throws IOException {
        if (!this.flushed) {
            this.write(this.buf, 0, this.bufLength);
            this.flushed = true;
            this.bufOffset = 0;
            this.bufLength = 0;
            this.bufPhysical = this.getFilePointer();
        }
    }

    public long getSize() throws IOException {
        this.flush();
        return (this.length() >> 2) - 1L;
    }

    public int readFloats(float[] fArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n + n2;
        this.flush();
        while (n < n4) {
            if (this.bufOffset >= this.bufLength) {
                this.bufPhysical = this.getFilePointer();
                n3 = (int)Math.min((long)this.bufSize, this.length() - this.bufPhysical) & 0xFFFFFFFC;
                this.readFully(this.buf, 0, n3);
                this.bufOffset = 0;
                this.bufLength = n3;
            }
            if ((n3 = Math.min(n4 - n, this.bufLength - this.bufOffset >> 2)) <= 0) break;
            for (int i = 0; i < n3; ++i) {
                fArray[n++] = Float.intBitsToFloat(this.buf[this.bufOffset++] << 24 | (this.buf[this.bufOffset++] & 0xFF) << 16 | (this.buf[this.bufOffset++] & 0xFF) << 8 | this.buf[this.bufOffset++] & 0xFF);
            }
        }
        if ((n3 = n2 - n4 + n) == 0 && n2 > 0) {
            throw new EOFException();
        }
        while (n < n4) {
            fArray[n++] = 0.0f;
        }
        return n3;
    }

    public int readFloats(float[] fArray) throws IOException {
        return this.readFloats(fArray, 0, fArray.length);
    }

    public int readInts(int[] nArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n + n2;
        this.flush();
        while (n < n4) {
            if (this.bufOffset >= this.bufLength) {
                this.bufPhysical = this.getFilePointer();
                n3 = (int)Math.min((long)this.bufSize, this.length() - this.bufPhysical) & 0xFFFFFFFC;
                this.readFully(this.buf, 0, n3);
                this.bufOffset = 0;
                this.bufLength = n3;
            }
            if ((n3 = Math.min(n4 - n, this.bufLength - this.bufOffset >> 2)) <= 0) break;
            for (int i = 0; i < n3; ++i) {
                nArray[n++] = this.buf[this.bufOffset++] << 24 | (this.buf[this.bufOffset++] & 0xFF) << 16 | (this.buf[this.bufOffset++] & 0xFF) << 8 | this.buf[this.bufOffset++] & 0xFF;
            }
        }
        if ((n3 = n2 - n4 + n) == 0 && n2 > 0) {
            throw new EOFException();
        }
        while (n < n4) {
            nArray[n++] = 0;
        }
        return n3;
    }

    public int readInts(int[] nArray) throws IOException {
        return this.readInts(nArray, 0, nArray.length);
    }

    public float readUnbufferedFloat() throws IOException {
        return this.readFloat();
    }

    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if (this.flushed) {
            if (this.bufOffset != this.bufLength) {
                this.seek(this.bufPhysical + (long)this.bufOffset);
            }
            this.bufOffset = 0;
            this.bufLength = 0;
            this.bufPhysical = this.getFilePointer();
        }
        while (n < n3) {
            if (this.bufLength >= this.bufSize) {
                this.flush();
            }
            this.flushed = false;
            int n4 = Math.min(n3 - n, this.bufSize - this.bufLength >> 2);
            for (int i = 0; i < n4; ++i) {
                int n5 = Float.floatToIntBits(fArray[n++]);
                this.buf[this.bufLength++] = (byte)(n5 >> 24);
                this.buf[this.bufLength++] = (byte)(n5 >> 16);
                this.buf[this.bufLength++] = (byte)(n5 >> 8);
                this.buf[this.bufLength++] = (byte)n5;
            }
        }
        this.bufOffset = this.bufLength;
    }

    public void writeFloats(float[] fArray) throws IOException {
        this.writeFloats(fArray, 0, fArray.length);
    }

    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if (this.flushed) {
            if (this.bufOffset != this.bufLength) {
                this.seek(this.bufPhysical + (long)this.bufOffset);
            }
            this.bufOffset = 0;
            this.bufLength = 0;
            this.bufPhysical = this.getFilePointer();
        }
        while (n < n3) {
            if (this.bufLength >= this.bufSize) {
                this.flush();
            }
            this.flushed = false;
            int n4 = Math.min(n3 - n, this.bufSize - this.bufLength >> 2);
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray[n++];
                this.buf[this.bufLength++] = (byte)(n5 >> 24);
                this.buf[this.bufLength++] = (byte)(n5 >> 16);
                this.buf[this.bufLength++] = (byte)(n5 >> 8);
                this.buf[this.bufLength++] = (byte)n5;
            }
        }
        this.bufOffset = this.bufLength;
    }

    public void writeInts(int[] nArray) throws IOException {
        this.writeInts(nArray, 0, nArray.length);
    }

    @Override
    public void close() throws IOException {
        int n = this.bufLength;
        this.bufLength = 0;
        byte[] byArray = this.buf;
        this.buf = null;
        if (!this.flushed) {
            this.flushed = true;
            if (byArray != null && n > 0) {
                this.write(byArray, 0, n);
            }
        }
        super.close();
    }

    @Override
    public String getFormat() throws IOException {
        return "temporary file; " + this.getSize() + " 16-bit floating point numbers";
    }
}

