/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;

public class VirtualChoice
extends JComboBox {
    protected int virtualIndex = super.getSelectedIndex();
    protected Vector<ItemListener> listeners = new Vector();

    public void addItem(String string) {
        super.addItem(string);
        if (this.getItemCount() - 1 == this.virtualIndex) {
            try {
                super.setSelectedIndex(this.virtualIndex);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void insertItemAt(String string, int n) throws IllegalArgumentException {
        super.insertItemAt(string, n);
        if (this.getItemCount() - 1 == this.virtualIndex) {
            super.setSelectedIndex(this.virtualIndex);
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.virtualIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedIndex(int n) throws IllegalArgumentException {
        if (n >= 0) {
            this.virtualIndex = n;
            if (this.getItemCount() > this.virtualIndex) {
                super.setSelectedIndex(n);
            }
        }
        Vector<ItemListener> vector = this.listeners;
        synchronized (vector) {
            int n2 = this.listeners.size();
            if (n2 > 0) {
                Object[] objectArray = this.getSelectedObjects();
                ItemEvent itemEvent = new ItemEvent(this, 701, objectArray != null && objectArray.length > 0 ? objectArray : null, 1);
                for (int i = 0; i < n2; ++i) {
                    this.listeners.elementAt(i).itemStateChanged(itemEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpecialItemListener(ItemListener itemListener) {
        Vector<ItemListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(itemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpecialItemListener(ItemListener itemListener) {
        Vector<ItemListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(itemListener);
        }
    }
}

