/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.TopPainter;
import de.sciss.fscape.gui.VectorDisplay;
import de.sciss.gui.Axis;
import de.sciss.gui.VectorSpace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class VectorPanel
extends JPanel
implements TopPainter {
    public static final int FLAG_HLOG_GADGET = 1;
    public static final int FLAG_VLOG_GADGET = 2;
    public static final int FLAG_UPDATE_GADGET = 4;
    private static final int GADGET_MASK = 7;
    private final Client client;
    private VectorSpace space = null;
    private final VectorDisplay ggVectorDisplay;
    private final Axis hAxis;
    private final Axis vAxis;
    private JCheckBox ggHLog = null;
    private JCheckBox ggVLog = null;
    private FontMetrics fntMetrics;
    private static final Color colrCross = new Color(0, 0, 0, 127);
    private static final Color colrTextBg = new Color(255, 255, 255, 160);
    private final Cursor csrCrossHair = new Cursor(1);
    private String lastTxt;
    private boolean paintCrossHair = false;
    private Point lastPt = null;

    public VectorPanel(Client client, int n) {
        super(new BorderLayout());
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        boolean bl = UIManager.getBoolean("dark-skin");
        this.client = client;
        this.ggVectorDisplay = new VectorDisplay(bl);
        this.ggVectorDisplay.addTopPainter(this);
        this.ggVectorDisplay.setCursor(this.csrCrossHair);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                VectorPanel.this.ggVectorDisplay.requestFocus();
                VectorPanel.this.redrawCrossHair(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                VectorPanel.this.redrawCrossHair(mouseEvent);
            }
        };
        this.ggVectorDisplay.addMouseListener(mouseInputAdapter);
        this.ggVectorDisplay.addMouseMotionListener(mouseInputAdapter);
        this.add((Component)this.ggVectorDisplay, "Center");
        if ((n & 7) != 0) {
            JPanel jPanel = new JPanel(new FlowLayout(3, 4, 1));
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VectorPanel.this.requestUpdate();
                }
            };
            if ((n & 4) != 0) {
                JButton jButton = new JButton("Update");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
            }
            if ((n & 1) != 0) {
                this.ggHLog = new JCheckBox("Horiz.log.");
                this.ggHLog.addActionListener(actionListener);
                jPanel.add(this.ggHLog);
            }
            if ((n & 2) != 0) {
                this.ggVLog = new JCheckBox("Vert.log.");
                this.ggVLog.addActionListener(actionListener);
                jPanel.add(this.ggVLog);
            }
            this.add((Component)jPanel, "South");
        }
        this.hAxis = new Axis(0);
        this.vAxis = new Axis(1);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(this.vAxis.getPreferredSize().width));
        box.add((Component)this.hAxis);
        this.add((Component)box, "North");
        this.add((Component)this.vAxis, "West");
        this.fntMetrics = this.getFontMetrics(this.getFont());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("font")) {
                    VectorPanel.this.fntMetrics = VectorPanel.this.getFontMetrics((Font)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected void redrawCrossHair(MouseEvent mouseEvent) {
        Dimension dimension = this.ggVectorDisplay.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = this.ggHLog != null && this.ggHLog.isSelected();
        boolean bl2 = this.ggVLog != null && this.ggVLog.isSelected();
        this.paintCrossHair = false;
        if (this.space != null && !mouseEvent.isAltDown()) {
            float[] fArray = this.ggVectorDisplay.getVector();
            int n3 = fArray.length;
            if (n3 < 1) {
                return;
            }
            if (n >= 0 && n2 >= 0 && n < dimension.width && n2 < dimension.height) {
                double d;
                double d2;
                if (mouseEvent.isShiftDown()) {
                    d2 = this.space.vUnityToSpace(1.0 - (double)n2 / (double)(dimension.height - 1));
                    d = this.space.hUnityToSpace((double)n / (double)(dimension.width - 1));
                } else {
                    n = (int)((double)n / (double)(dimension.width - 1) * (double)(n3 - 1) + 0.5);
                    d2 = fArray[n];
                    d = this.space.hUnityToSpace((double)n / (double)(n3 - 1));
                    n2 = (int)((1.0 - this.space.vSpaceToUnity(d2)) * (double)(dimension.height - 1) + 0.5);
                    n = mouseEvent.getX();
                }
                this.lastPt = new Point(n, n2);
                String string = this.client.formatVText(d2, bl2);
                String string2 = this.client.formatHText(d, bl);
                this.lastTxt = string + " @ " + string2;
                this.paintCrossHair = true;
            }
        }
        this.ggVectorDisplay.repaint();
    }

    protected void requestUpdate() {
        boolean bl = this.ggHLog != null && this.ggHLog.isSelected();
        boolean bl2 = this.ggVLog != null && this.ggVLog.isSelected();
        this.client.requestUpdate(bl, bl2);
    }

    public void setVector(float[] fArray) {
        this.ggVectorDisplay.setVector(this, fArray);
    }

    public void setSpace(VectorSpace vectorSpace) {
        this.space = vectorSpace;
        this.ggVectorDisplay.setMinMax((float)vectorSpace.vmin, (float)vectorSpace.vmax);
        this.hAxis.setSpace(vectorSpace);
        this.vAxis.setSpace(vectorSpace);
    }

    @Override
    public void paintOnTop(Graphics2D graphics2D) {
        Dimension dimension = this.ggVectorDisplay.getSize();
        if (this.paintCrossHair) {
            graphics2D.setColor(colrCross);
            graphics2D.drawLine(0, this.lastPt.y, dimension.width - 1, this.lastPt.y);
            graphics2D.drawLine(this.lastPt.x, 0, this.lastPt.x, dimension.height - 1);
            graphics2D.setColor(colrTextBg);
            graphics2D.fillRect(1, 1, this.fntMetrics.stringWidth(this.lastTxt) + 6, this.fntMetrics.getHeight() + 4);
            graphics2D.setColor(Color.blue);
            graphics2D.drawString(this.lastTxt, 4, this.fntMetrics.getHeight() + 1);
        }
    }

    public static interface Client {
        public void requestUpdate(boolean var1, boolean var2);

        public String formatVText(double var1, boolean var3);

        public String formatHText(double var1, boolean var3);
    }
}

