/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class TransientExtrDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_MODFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_LPMODE = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_LPORDER1 = 1;
    private static final int PR_LPORDER2 = 2;
    private static final int PR_CMORDER = 3;
    private static final int PR_LPADAPT1 = 4;
    private static final int PR_LPADAPT2 = 5;
    private static final int PR_CMADAPT = 6;
    private static final int PR_CROSSSYNTH = 0;
    private static final int PR_CONSTANTMODULUS = 1;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_MODFILE = "ModFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_LPMODE = "LPMode";
    private static final String PRN_LPORDER1 = "LPOrder1";
    private static final String PRN_LPORDER2 = "LPOrder2";
    private static final String PRN_CMORDER = "CMOrder";
    private static final String PRN_LPADAPT1 = "LPAdapt1";
    private static final String PRN_LPADAPT2 = "LPAdapt2";
    private static final String PRN_CMADAPT = "CMAdapt";
    private static final String PRN_CROSSSYNTH = "CrossSynth";
    private static final String PRN_CONSTANTMODULUS = "ConstMod";
    private static final int LPMODE_BYPASS = 0;
    private static final int LPMODE_FILTER = 1;
    private static final int LPMODE_RESIDUAL = 2;
    private static final String[] LPMODE_NAMES = new String[]{"Bypass", "Filter", "Residual"};
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile", "ModFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "LPMode"};
    private static final boolean[] prBool = new boolean[]{true, false};
    private static final String[] prBoolName = new String[]{"CrossSynth", "ConstMod"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "LPOrder1", "LPOrder2", "CMOrder", "LPAdapt1", "LPAdapt2", "CMAdapt"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_MODFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_LPMODE = 259;
    private static final int GG_LPORDER1 = 513;
    private static final int GG_LPORDER2 = 514;
    private static final int GG_CMORDER = 515;
    private static final int GG_LPADAPT1 = 516;
    private static final int GG_LPADAPT2 = 517;
    private static final int GG_CMADAPT = 518;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_CROSSSYNTH = 0;
    private static final int GG_CONSTANTMODULUS = 1;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public TransientExtrDlg() {
        super("Adaptive LP Filter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            TransientExtrDlg.static_pr.text = prText;
            TransientExtrDlg.static_pr.textName = prTextName;
            TransientExtrDlg.static_pr.intg = prIntg;
            TransientExtrDlg.static_pr.intgName = prIntgName;
            TransientExtrDlg.static_pr.bool = prBool;
            TransientExtrDlg.static_pr.boolName = prBoolName;
            TransientExtrDlg.static_pr.para = prPara;
            TransientExtrDlg.static_pr.para[1] = new Param(18.0, 0);
            TransientExtrDlg.static_pr.para[2] = new Param(12.0, 0);
            TransientExtrDlg.static_pr.para[3] = new Param(24.0, 0);
            TransientExtrDlg.static_pr.para[4] = new Param(2.0, 17);
            TransientExtrDlg.static_pr.para[5] = new Param(0.5, 17);
            TransientExtrDlg.static_pr.para[6] = new Param(0.1, 17);
            TransientExtrDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(TransientExtrDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(TransientExtrDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = TransientExtrDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 259: {
                        ((TransientExtrDlg)TransientExtrDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        TransientExtrDlg.this.reflectPropertyChanges();
                        break;
                    }
                    case 0: 
                    case 1: {
                        ((TransientExtrDlg)TransientExtrDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        TransientExtrDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select (excitation) input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("(Excitation) input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select (filter) input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Filter input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1026, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0LP$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1025, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Filter Settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < LPMODE_NAMES.length; ++i) {
            jComboBox.addItem(LPMODE_NAMES[i]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Source LP output", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, itemListener);
        ParamField paramField = new ParamField(new ParamSpace(1.0, 4096.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Source LP order", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamField paramField2 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Adaptiveness", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 516, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Cross synthesis", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        ParamField paramField3 = new ParamField(new ParamSpace(1.0, 4096.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Target LP order", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 514, null);
        ParamField paramField4 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Adaptiveness", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 517, null);
        JCheckBox jCheckBox2 = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Constant Modulus Flt.", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox2, 1, itemListener);
        ParamField paramField5 = new ParamField(new ParamSpace(1.0, 4096.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("CM order", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 515, null);
        ParamField paramField6 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Adaptiveness", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField6, 518, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block71: {
            float[] fArray;
            float[] fArray2;
            float[] fArray3;
            float[] fArray4;
            float[][] fArray5;
            float[][] fArray6;
            audioFile2 = null;
            AudioFile audioFile3 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            AudioFileDescr audioFileDescr3 = null;
            floatFileArray = null;
            fileArray = null;
            float[][] fArray7 = null;
            float[][] fArray8 = null;
            float[][] fArray9 = null;
            float[][] fArray10 = null;
            float[][] fArray11 = null;
            float[][] fArray12 = null;
            float[][] fArray13 = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            boolean bl = this.pr.bool[0];
            boolean bl2 = this.pr.bool[1];
            boolean bl3 = this.pr.intg[3] != 0;
            float f2 = 0.0f;
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n7 = audioFileDescr.channels;
                int n8 = (int)audioFileDescr.length;
                if (n8 * n7 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block71;
                long l = 0L;
                long l2 = 0L;
                if (bl) {
                    audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[2]));
                    audioFileDescr2 = audioFile3.getDescr();
                    n6 = (int)audioFileDescr2.length;
                    n5 = audioFileDescr2.channels;
                    if (n6 * n5 < 1) {
                        throw new EOFException("File is empty");
                    }
                    if (!this.threadRunning) break block71;
                    n4 = Math.min(n8, n6);
                    n3 = Math.max(n7, n5);
                    l2 += (long)n4;
                } else {
                    n6 = n8;
                    n5 = n7;
                    n4 = n8;
                    n3 = n7;
                }
                l2 += (long)n4 * 2L;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr3);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                if (!this.threadRunning) break block71;
                int n9 = (int)(this.pr.para[1].value + 0.5);
                int n10 = (int)(this.pr.para[2].value + 0.5);
                int n11 = (int)(this.pr.para[3].value + 0.5);
                double d = this.pr.para[4].value / 100.0;
                double d2 = this.pr.para[5].value / 100.0;
                double d3 = this.pr.para[6].value / 100.0;
                double d4 = 1.0;
                int n12 = Math.max(bl2 ? n11 : 0, Math.max(bl ? n10 : 0, bl3 ? n9 : 0));
                fArray6 = new float[n7][8192 + n12];
                Util.clear(fArray6);
                fArray5 = fArray6;
                if (bl3) {
                    fArray11 = new float[n7][n9];
                    Util.clear(fArray11);
                    for (n = 0; n < n7; ++n) {
                        fArray11[n][n9 >> 1] = 1.0f;
                    }
                    fArray9 = new float[n7][8192 + n12];
                    Util.clear(fArray9);
                    fArray5 = fArray9;
                } else {
                    fArray9 = fArray6;
                }
                if (bl) {
                    fArray12 = new float[n5][n10];
                    Util.clear(fArray12);
                    for (n = 0; n < n5; ++n) {
                        fArray12[n][n10 >> 1] = 1.0f;
                    }
                    fArray8 = new float[n5][8192 + n12];
                    Util.clear(fArray8);
                    fArray10 = new float[n3][8192 + n12];
                    Util.clear(fArray10);
                    fArray5 = fArray10;
                }
                if (bl2) {
                    fArray13 = new float[n3][n11];
                    Util.clear(fArray13);
                    for (n = 0; n < n3; ++n) {
                        fArray13[n][n11 >> 1] = 1.0f;
                    }
                    fArray7 = fArray5;
                    fArray5 = new float[n3][8192 + n12];
                    Util.clear(fArray5);
                }
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n7];
                    floatFileArray = new FloatFile[n7];
                    for (n = 0; n < n7; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n7; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n4;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block71;
                int n13 = 0;
                int n14 = 0;
                for (int i = 0; this.threadRunning && i < n4; i += n2) {
                    float f3;
                    int n15;
                    int n16;
                    double d5;
                    double d6;
                    int n17;
                    int n18;
                    n2 = Math.min(8192, Math.min(n8 - n13, n6 - n14));
                    audioFile2.readFrames(fArray6, n12, n2);
                    n13 += n2;
                    l += (long)n2;
                    if (bl) {
                        audioFile3.readFrames(fArray8, n12, n2);
                        n14 += n2;
                        l += (long)n2;
                    }
                    this.setProgression((float)l / (float)l2);
                    if (!this.threadRunning) break block71;
                    switch (this.pr.intg[3]) {
                        case 1: {
                            for (n = 0; n < n7; ++n) {
                                fArray4 = fArray11[n];
                                fArray3 = fArray6[n];
                                fArray2 = fArray9[n];
                                n18 = 0;
                                n17 = n12;
                                while (n18 < n2) {
                                    d6 = 0.0;
                                    d5 = 0.0;
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n9) {
                                        f3 = fArray3[--n15];
                                        d6 += (double)(fArray4[n16++] * f3);
                                        d5 += (double)(f3 * f3);
                                    }
                                    fArray2[n17] = (float)d6;
                                    d6 = (double)fArray3[n17] - d6;
                                    f3 = (float)(d6 * d);
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n9) {
                                        int n19 = n16++;
                                        fArray4[n19] = fArray4[n19] - f3 * fArray3[--n15];
                                    }
                                    ++n18;
                                    ++n17;
                                }
                            }
                            for (n = 0; n < n7; ++n) {
                                System.arraycopy(fArray6[n], n2, fArray6[n], 0, n12);
                            }
                            break;
                        }
                        case 2: {
                            for (n = 0; n < n7; ++n) {
                                fArray4 = fArray11[n];
                                fArray3 = fArray6[n];
                                fArray2 = fArray9[n];
                                n18 = 0;
                                n17 = n12;
                                while (n18 < n2) {
                                    d6 = 0.0;
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n9) {
                                        d6 += (double)(fArray4[n16++] * fArray3[--n15]);
                                    }
                                    d6 = (double)fArray3[n17] - d6;
                                    fArray2[n17] = (float)d6;
                                    f3 = (float)(d6 * d);
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n9) {
                                        int n20 = n16++;
                                        fArray4[n20] = fArray4[n20] - f3 * fArray3[--n15];
                                    }
                                    ++n18;
                                    ++n17;
                                }
                            }
                            for (n = 0; n < n7; ++n) {
                                System.arraycopy(fArray6[n], n2, fArray6[n], 0, n12);
                            }
                            break;
                        }
                    }
                    if (bl) {
                        if (n7 <= n5) {
                            for (n = 0; n < n5; ++n) {
                                fArray4 = fArray12[n];
                                fArray3 = fArray8[n];
                                fArray2 = fArray9[n % n7];
                                fArray = fArray10[n];
                                n18 = 0;
                                n17 = n12;
                                while (n18 < n2) {
                                    d6 = 0.0;
                                    d5 = 0.0;
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n10) {
                                        d6 += (double)(fArray4[n16] * fArray3[--n15]);
                                        d5 += (double)(fArray4[n16++] * fArray2[n15]);
                                    }
                                    fArray[n17] = (float)d5;
                                    d6 = (double)fArray3[n17] - d6;
                                    f3 = (float)(d6 * d2);
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n10) {
                                        int n21 = n16++;
                                        fArray4[n21] = fArray4[n21] - f3 * fArray3[--n15];
                                    }
                                    ++n18;
                                    ++n17;
                                }
                            }
                        } else {
                            for (n = 0; n < n5; ++n) {
                                fArray4 = fArray12[n];
                                fArray3 = fArray8[n];
                                n18 = 0;
                                n17 = n12;
                                while (n18 < n2) {
                                    d6 = 0.0;
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n10) {
                                        d6 += (double)(fArray4[n16] * fArray3[--n15]);
                                    }
                                    for (int j = n; j < n7; j += n5) {
                                        fArray2 = fArray9[j];
                                        fArray = fArray10[j];
                                        d5 = 0.0;
                                        n16 = 0;
                                        n15 = n17;
                                        while (n16 < n10) {
                                            d5 += (double)(fArray4[n16++] * fArray2[n15]);
                                        }
                                        fArray[n17] = (float)d5;
                                    }
                                    d6 = (double)fArray3[n17] - d6;
                                    f3 = (float)(d6 * d2);
                                    n16 = 0;
                                    n15 = n17;
                                    while (n16 < n10) {
                                        int n22 = n16++;
                                        fArray4[n22] = fArray4[n22] - f3 * fArray3[--n15];
                                    }
                                    ++n18;
                                    ++n17;
                                }
                            }
                        }
                        for (n = 0; n < n5; ++n) {
                            System.arraycopy(fArray8[n], n2, fArray8[n], 0, n12);
                        }
                        for (n = 0; n < n7; ++n) {
                            System.arraycopy(fArray9[n], n2, fArray9[n], 0, n12);
                        }
                    }
                    if (bl2) {
                        for (n = 0; n < n3; ++n) {
                            fArray4 = fArray13[n];
                            fArray3 = fArray7[n];
                            fArray2 = fArray5[n];
                            n18 = 0;
                            n17 = n12;
                            while (n18 < n2) {
                                d6 = 0.0;
                                n16 = 0;
                                n15 = n17;
                                while (n16 < n11) {
                                    d6 += (double)(fArray4[n16++] * fArray3[n15--]);
                                }
                                fArray2[n17] = (float)d6;
                                f3 = (float)(d3 * (d6 * d6 - d4) * d6);
                                n16 = 0;
                                n15 = n17;
                                while (n16 < n11) {
                                    int n23 = n16++;
                                    fArray4[n23] = fArray4[n23] - f3 * fArray3[n15--];
                                }
                                ++n18;
                                ++n17;
                            }
                        }
                        for (n = 0; n < n3; ++n) {
                            System.arraycopy(fArray7[n], n2, fArray7[n], 0, n12);
                        }
                    }
                    for (n = 0; n < n3; ++n) {
                        fArray4 = fArray5[n];
                        for (n18 = 0; n18 < n2; ++n18) {
                            f3 = Math.abs(fArray4[n18]);
                            if (!(f3 > f2)) continue;
                            f2 = f3;
                        }
                    }
                    if (floatFileArray != null) {
                        for (n = 0; n < n3; ++n) {
                            floatFileArray[n].writeFloats(fArray5[n], n12, n2);
                        }
                    } else {
                        for (n = 0; n < n3; ++n) {
                            Util.mult(fArray5[n], n12, n2, f);
                        }
                        audioFile.writeFrames(fArray5, n12, n2);
                    }
                    this.setProgression((float)(l += (long)n2) / (float)l2);
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    audioFileDescr = null;
                    if (audioFile3 != null) {
                        audioFile3.close();
                        audioFile3 = null;
                        audioFileDescr2 = null;
                    }
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray5, f, 1.0f);
                        for (n = 0; n < n7; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    audioFile.close();
                    audioFile = null;
                    this.handleClipping(f2 *= f);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr3 = null;
                audioFileDescr2 = null;
                fArray6 = null;
                fArray5 = null;
                fArray8 = null;
                fArray9 = null;
                fArray10 = null;
                fArray7 = null;
                fArray4 = null;
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected void adjustEnergy(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < n2; ++j) {
                float f = Math.abs(fArray2[j]);
                if (!(f > 1.0f)) continue;
                int n3 = j;
                fArray2[n3] = fArray2[n3] / f;
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(1026);
        if (component != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(513)) != null) {
            component.setEnabled(this.pr.intg[3] != 0);
        }
        if ((component = this.gui.getItemObj(516)) != null) {
            component.setEnabled(this.pr.intg[3] != 0);
        }
        if ((component = this.gui.getItemObj(514)) != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(517)) != null) {
            component.setEnabled(this.pr.bool[0]);
        }
        if ((component = this.gui.getItemObj(515)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
        if ((component = this.gui.getItemObj(518)) != null) {
            component.setEnabled(this.pr.bool[1]);
        }
    }
}

