/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class TrajectoryDlg
extends ModulePanel {
    private static final int PR_INPUTFILE1 = 0;
    private static final int PR_INPUTFILE2 = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_ZOOM = 3;
    private static final int PR_DECAY = 4;
    private static final int PR_GAIN = 0;
    private static final int PR_LIMITTHRESH = 1;
    private static final int PR_IMGWIDTH = 2;
    private static final int PR_IMGHEIGHT = 3;
    private static final int PR_LENGTH = 4;
    private static final int PR_OFFSET = 5;
    private static final String PRN_INPUTFILE1 = "InputFile1";
    private static final String PRN_INPUTFILE2 = "InputFile2";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_LIMITTHRESH = "LimitTresh";
    private static final String PRN_IMGWIDTH = "ImgWidth";
    private static final String PRN_IMGHEIGHT = "ImgHeight";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_OFFSET = "Offset";
    private static final String PRN_ZOOM = "Zoom";
    private static final String PRN_DECAY = "Decay";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InputFile1", "InputFile2", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 2, 3};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Zoom", "Decay"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "LimitTresh", "ImgWidth", "ImgHeight", "Length", "Offset"};
    private static final int GG_INPUTFILE1 = 1024;
    private static final int GG_INPUTFILE2 = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_ZOOM = 259;
    private static final int GG_DECAY = 260;
    private static final int GG_GAIN = 512;
    private static final int GG_LIMITTHRESH = 513;
    private static final int GG_IMGWIDTH = 514;
    private static final int GG_IMGHEIGHT = 515;
    private static final int GG_LENGTH = 516;
    private static final int GG_OFFSET = 517;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public TrajectoryDlg() {
        super("Trajectory Image Generator");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        int n;
        if (static_pr == null) {
            static_pr = new PropertyArray();
            TrajectoryDlg.static_pr.text = prText;
            TrajectoryDlg.static_pr.textName = prTextName;
            TrajectoryDlg.static_pr.intg = prIntg;
            TrajectoryDlg.static_pr.intgName = prIntgName;
            TrajectoryDlg.static_pr.para = prPara;
            TrajectoryDlg.static_pr.para[1] = new Param(0.0, 785);
            TrajectoryDlg.static_pr.para[2] = new Param(360.0, 0);
            TrajectoryDlg.static_pr.para[3] = new Param(284.0, 0);
            TrajectoryDlg.static_pr.para[4] = new Param(100.0, 18);
            TrajectoryDlg.static_pr.para[5] = new Param(0.0, 34);
            TrajectoryDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(TrajectoryDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(TrajectoryDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file 1", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file 2", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_IMAGE);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Trj$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        ParamSpace paramSpace = new ParamSpace(-144.0, 0.0, 0.1, 785);
        ParamField paramField = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Limit.thresh.", 4));
        gridBagConstraints.weightx = 0.233;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 513, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Trajectory Settings", 1, 0));
        ParamSpace paramSpace2 = new ParamSpace(1.0, 32768.0, 1.0, 0);
        ParamField paramField2 = new ParamField(paramSpace2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Width [pixels]", 4));
        gridBagConstraints.weightx = 0.233;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(paramSpace2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Height [pixels]", 4));
        gridBagConstraints.weightx = 0.233;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField3, 515, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[12], Constants.spaces[13], Constants.spaces[14]};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], Constants.spaces[14], Constants.spaces[10]};
        ParamField paramField4 = new ParamField(paramSpaceArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Traj. Offset", 4));
        gridBagConstraints.weightx = 0.233;
        this.gui.addParamField(paramField4, 517, null);
        ParamField paramField5 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Traj. Length", 4));
        gridBagConstraints.weightx = 0.233;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 516, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < 4; ++n) {
            jComboBox.addItem((1 << n) + "x");
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Zoom factor", 4));
        gridBagConstraints.weightx = 0.233;
        this.gui.addChoice(jComboBox, 259, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = -3; n <= 3; ++n) {
            jComboBox2.addItem(String.valueOf(Math.pow(2.0, n)));
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_DECAY, 4));
        gridBagConstraints.weightx = 0.233;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        GenericFile genericFile;
        AudioFile audioFile;
        AudioFile audioFile2;
        block31: {
            audioFile2 = null;
            audioFile = null;
            genericFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            ImageStream imageStream = null;
            byte[] byArray = null;
            float[][] fArray = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            int n = 8;
            int n2 = 1;
            float f2 = 0.0f;
            int n3 = 1 << this.pr.intg[3];
            float f3 = (float)Math.pow(2.0, this.pr.intg[4] - 3);
            try {
                int n4;
                int n5;
                float f4;
                int n6;
                float f5;
                float f6;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n7 = audioFileDescr.channels;
                int n8 = (int)audioFileDescr.length;
                if (n8 * n7 < 1) {
                    throw new EOFException("File is empty");
                }
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                audioFileDescr2 = audioFile.getDescr();
                int n9 = audioFileDescr2.channels;
                if ((n8 = (int)Math.min((long)n8, audioFileDescr2.length)) * n9 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block31;
                int n10 = (int)this.pr.para[2].value;
                int n11 = (int)this.pr.para[3].value;
                int n12 = n10 * n11;
                float f7 = (float)(n10 - 1) / 2.0f;
                float f8 = (float)(n11 - 1) / 2.0f;
                float f9 = f7;
                float f10 = f8;
                f7 *= (float)n3 / 0.6931472f;
                f8 *= (float)n3 / 0.6931472f;
                int n13 = Math.max(0, Math.min(n8 - 1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[5], (int)2, (Param)new Param((double)0.0, (int)2), null).value) + 0.5)));
                audioFile2.seekFrame((long)n13);
                audioFile.seekFrame((long)n13);
                int n14 = Math.min(n8 - n13, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[4], (int)2, (Param)new Param((double)AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)((long)n8)), (int)2), null).value) + 0.5));
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                genericFile = new ImageFile(this.pr.text[2], 1 | pathField.getType());
                imageStream = new ImageStream();
                imageStream.bitsPerSmp = 8;
                pathField.fillStream(imageStream);
                imageStream.width = n10;
                imageStream.height = n11;
                imageStream.smpPerPixel = n2;
                n = imageStream.bitsPerSmp;
                ((ImageFile)genericFile).initWriter(imageStream);
                byArray = ((ImageFile)genericFile).allocRow();
                fArray = new float[n2][n12 + 1];
                float[][] fArray2 = new float[n7][8192];
                float[][] fArray3 = new float[n9][8192];
                if (!this.threadRunning) break block31;
                long l = 0L;
                long l2 = (long)n14 * 2L + (long)n11;
                if (this.pr.intg[2] != 0) {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if ((f6 = (float)Param.transform((Param)this.pr.para[1], (int)1, (Param)param, null).value) < 1.0f) {
                    f5 = Math.min(1.0f, (1.0f - f6) / (1.0f / f6 - f6));
                    f /= f6;
                } else {
                    f5 = 0.0f;
                }
                int n15 = 0;
                float[] fArray4 = fArray2[0];
                float[] fArray5 = fArray3[0];
                int n16 = 0;
                while (this.threadRunning && n15 < n14) {
                    int n17 = Math.min(8192, n14 - n15);
                    audioFile2.readFrames(fArray2, 0, n17);
                    audioFile.readFrames(fArray3, 0, n17);
                    n15 += n17;
                    this.setProgression((float)(l += (long)n17) / (float)l2);
                    if (this.threadRunning) {
                        n6 = 0;
                        while (n6 < n17) {
                            f4 = Math.min(1.0f, Math.max(-1.0f, fArray4[n6]));
                            n13 = f4 < 0.0f ? -1 : 1;
                            float f11 = (float)n13 * (float)Math.log(Math.abs(f4) + 1.0f) * f7 + f9;
                            f4 = Math.min(1.0f, Math.max(-1.0f, fArray5[n6]));
                            n13 = f4 < 0.0f ? -1 : 1;
                            float f12 = (float)n13 * (float)Math.log(Math.abs(f4) + 1.0f) * f8 + f10;
                            float f13 = f11 % 1.0f;
                            float f14 = f12 % 1.0f;
                            float f15 = 1.0f - f13;
                            float f16 = 1.0f - f14;
                            int n18 = (int)f11;
                            int n19 = (int)f12;
                            if (!(f11 < 0.0f) && n18 <= n10 - 2 && !(f12 < 0.0f) && n19 <= n11 - 2) {
                                f4 = (float)Math.pow((float)n16 / (float)n14, f3);
                                f13 *= f4;
                                float[] fArray6 = fArray[0];
                                int n20 = n18 + (n19 *= n10);
                                fArray6[n20] = fArray6[n20] + (f15 *= f4) * f16;
                                float[] fArray7 = fArray[0];
                                int n21 = n18 + 1 + n19;
                                fArray7[n21] = fArray7[n21] + f13 * f16;
                                float[] fArray8 = fArray[0];
                                int n22 = n18 + n19 + n10;
                                fArray8[n22] = fArray8[n22] + f15 * f14;
                                float[] fArray9 = fArray[0];
                                int n23 = n18 + 1 + n19 + n10;
                                fArray9[n23] = fArray9[n23] + f13 * f14;
                            }
                            ++n6;
                            ++n16;
                        }
                        this.setProgression((float)(l += (long)n17) / (float)l2);
                        if (this.threadRunning) continue;
                    }
                    break block31;
                }
                audioFile2.close();
                audioFile2 = null;
                audioFile.close();
                audioFile = null;
                for (n5 = 0; n5 < n2; ++n5) {
                    for (n6 = 0; n6 < n12; ++n6) {
                        f4 = fArray[n5][n6];
                        if (!(f4 > f2)) continue;
                        f2 = f4;
                    }
                }
                if (this.pr.intg[2] == 0) {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)((double)(1.0f / f2)), (int)1), null).value;
                    if (f6 < 1.0f) {
                        f /= f6;
                    }
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    fArray4 = fArray[n5];
                    if (f != 1.0f) {
                        Util.mult(fArray[n5], 0, n12, f);
                    }
                    n6 = 0;
                    n4 = 0;
                    while (n6 < n11) {
                        n13 = 0;
                        n16 = n4;
                        while (n13 < n10) {
                            f4 = fArray4[n16];
                            float f17 = f4 - f6;
                            if (f17 > 0.0f) {
                                f4 = f6 + f17 * f5;
                            }
                            fArray4[n16] = f4;
                            ++n13;
                            ++n16;
                        }
                        ++n6;
                        n4 += n10;
                    }
                }
                if (!this.threadRunning) break block31;
                n6 = 0;
                n4 = 0;
                while (this.threadRunning && n6 < n11) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        int n24;
                        fArray4 = fArray[n5];
                        if (n == 8) {
                            n13 = 0;
                            n24 = n4;
                            n16 = n5;
                            while (n13 < n10) {
                                byArray[n16] = (byte)(fArray4[n24] * 255.0f);
                                ++n13;
                                ++n24;
                                n16 += n2;
                            }
                            continue;
                        }
                        n13 = 0;
                        n24 = n4;
                        n16 = n5;
                        while (n13 < n10) {
                            int n25 = n16 << 1;
                            int n26 = (int)(fArray4[n24] * 65535.0f);
                            byArray[n25++] = (byte)(n26 >> 8);
                            byArray[n25] = (byte)n26;
                            ++n13;
                            ++n24;
                            n16 += n2;
                        }
                    }
                    ((ImageFile)genericFile).writeRow(byArray);
                    this.setProgression((float)(++l) / (float)l2);
                    ++n6;
                    n4 += n10;
                }
                if (this.threadRunning) {
                    ((ImageFile)genericFile).close();
                    genericFile = null;
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                imageStream = null;
                float[][] fArray10 = null;
                float[][] fArray11 = null;
                fArray = null;
                Object var23_39 = null;
                Object var24_41 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (genericFile != null) {
            genericFile.cleanUp();
        }
    }
}

