/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.gui.TopPainter;
import de.sciss.fscape.gui.VectorDisplay;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Util;
import de.sciss.gui.Axis;
import de.sciss.gui.VectorSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class StatisticsDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_PROPERTY = 0;
    private static final int PR_CHANNEL = 1;
    private static final int PR_DATALEN = 2;
    private static final int PR_ANALYSISWIN = 3;
    private static final int PR_SUM = 0;
    private static final int PR_HLOG = 1;
    private static final int PR_VLOG = 2;
    private static final int PROP_ASPECT = 0;
    private static final int PROP_PSPECT = 1;
    private static final int PROP_PHSPECT = 2;
    private static final int PROP_ELONG = 3;
    private static final int NUMPROP = 4;
    private static final int CHANNEL_SUM = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_PROPERTY = "Property";
    private static final String PRN_CHANNEL = "Channel";
    private static final String PRN_DATALEN = "DataLen";
    private static final String PRN_ANALYSISWIN = "AnalysisWin";
    private static final String PRN_SUM = "Histo";
    private static final String PRN_HLOG = "HLog";
    private static final String PRN_VLOG = "VLog";
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"InputFile"};
    private static final int[] prIntg = new int[]{0, 2, 3, 0};
    private static final String[] prIntgName = new String[]{"Property", "Channel", "DataLen", "AnalysisWin"};
    private static final boolean[] prBool = new boolean[]{false, false, false};
    private static final String[] prBoolName = new String[]{"Histo", "HLog", "VLog"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_PROPERTY = 256;
    private static final int GG_CHANNEL = 257;
    private static final int GG_DATALEN = 258;
    private static final int GG_ANALYSISWIN = 259;
    private static final int GG_SUM = 0;
    private static final int GG_HLOG = 1;
    private static final int GG_VLOG = 2;
    private static final int GG_DATASET = 2048;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private VectorDisplay ggVectorDisplay;
    private DataRecord[] properties;
    private Point lastPt = null;
    private String lastTxt;
    private boolean paintCrossHair = false;
    private final Cursor xhairCursor = new Cursor(1);
    private Axis haxis;
    private Axis vaxis;
    private FontMetrics fntMetr;
    private static final Color colrCross = new Color(0, 0, 0, 127);
    private static final Color colrTextBg = new Color(255, 255, 255, 160);
    private final MessageFormat msgHertz = new MessageFormat("{0,number,0.0} Hz", Locale.US);
    private final MessageFormat msgDecibel = new MessageFormat("{0,number,0.0} dB", Locale.US);
    private final MessageFormat msgPlain = new MessageFormat("{0,number,0.000}", Locale.US);
    private final MessageFormat msgDegree = new MessageFormat("{0,number,0.000} rad", Locale.US);

    public StatisticsDlg() {
        super("Statistics");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            StatisticsDlg.static_pr.text = prText;
            StatisticsDlg.static_pr.textName = prTextName;
            StatisticsDlg.static_pr.intg = prIntg;
            StatisticsDlg.static_pr.intgName = prIntgName;
            StatisticsDlg.static_pr.bool = prBool;
            StatisticsDlg.static_pr.boolName = prBoolName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.properties = new DataRecord[4];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = null;
        }
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StatisticsDlg.this.redrawCrosshair(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                StatisticsDlg.this.ggVectorDisplay.setCursor(StatisticsDlg.this.xhairCursor);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                StatisticsDlg.this.ggVectorDisplay.setCursor(null);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                StatisticsDlg.this.redrawCrosshair(mouseEvent);
            }
        };
        TopPainter topPainter = new TopPainter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintOnTop(Graphics2D graphics2D) {
                Dimension dimension = StatisticsDlg.this.ggVectorDisplay.getSize();
                DataRecord[] dataRecordArray = StatisticsDlg.this.properties;
                synchronized (dataRecordArray) {
                    if (StatisticsDlg.this.paintCrossHair) {
                        graphics2D.setColor(colrCross);
                        graphics2D.drawLine(0, ((StatisticsDlg)StatisticsDlg.this).lastPt.y, dimension.width - 1, ((StatisticsDlg)StatisticsDlg.this).lastPt.y);
                        graphics2D.drawLine(((StatisticsDlg)StatisticsDlg.this).lastPt.x, 0, ((StatisticsDlg)StatisticsDlg.this).lastPt.x, dimension.height - 1);
                        graphics2D.setColor(colrTextBg);
                        graphics2D.fillRect(1, 1, StatisticsDlg.this.fntMetr.stringWidth(StatisticsDlg.this.lastTxt) + 6, StatisticsDlg.this.fntMetr.getHeight() + 4);
                        graphics2D.setColor(Color.blue);
                        graphics2D.drawString(StatisticsDlg.this.lastTxt, 4, StatisticsDlg.this.fntMetr.getHeight() + 1);
                    }
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = StatisticsDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 256: {
                        DataRecord[] dataRecordArray = StatisticsDlg.this.properties;
                        synchronized (dataRecordArray) {
                            DataRecord dataRecord = StatisticsDlg.this.properties[((StatisticsDlg)StatisticsDlg.this).pr.intg[0]];
                            if (dataRecord != null) {
                                DataRecord.access$1102(dataRecord, null);
                            }
                        }
                    }
                    case 257: {
                        ((StatisticsDlg)StatisticsDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        StatisticsDlg.this.redrawDataset();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        ((StatisticsDlg)StatisticsDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        StatisticsDlg.this.redrawDataset();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Sound Source", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("File name", 4));
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        this.gui.addLabel(new GroupLabel("Description", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Amp. spectrum");
        jComboBox.addItem("Power spectrum");
        jComboBox.addItem("Diff'ed phase spect");
        jComboBox.addItem("Sample histogram");
        gridBagConstraints.weightx = 0.133;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_PROPERTY, 4));
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 2;
        this.gui.addChoice(jComboBox, 256, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (int i = 32; i <= 65536; i <<= 1) {
            jComboBox2.addItem(String.valueOf(i));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.2;
        this.gui.addLabel(new JLabel("Record size", 4));
        gridBagConstraints.weightx = 0.133;
        this.gui.addChoice(jComboBox2, 258, itemListener);
        JComboBox jComboBox3 = new JComboBox();
        GUISupport.addItemsToChoice(Filter.getWindowNames(), jComboBox3);
        gridBagConstraints.weightx = 0.133;
        this.gui.addLabel(new JLabel("Analysis win", 4));
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox3, 259, itemListener);
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        this.ggVectorDisplay = new VectorDisplay();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.gui.registerGadget(this.ggVectorDisplay, 2048);
        this.ggVectorDisplay.addMouseListener(mouseInputAdapter);
        this.ggVectorDisplay.addMouseMotionListener(mouseInputAdapter);
        this.ggVectorDisplay.addTopPainter(topPainter);
        this.ggVectorDisplay.setPreferredSize(new Dimension(256, 256));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.ggVectorDisplay, "Center");
        this.haxis = new Axis(0);
        this.vaxis = new Axis(1);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(this.vaxis.getPreferredSize().width));
        box.add((Component)this.haxis);
        jPanel.add((Component)box, "North");
        jPanel.add((Component)this.vaxis, "West");
        this.gui.addGadget(jPanel, -1);
        JComboBox<String> jComboBox4 = new JComboBox<String>();
        jComboBox4.addItem("Left");
        jComboBox4.addItem("Right");
        jComboBox4.addItem("Sum");
        jComboBox4.addItem("Difference");
        gridBagConstraints.weightx = 0.15;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        this.gui.addLabel(new JLabel("View channel(s)", 4));
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addChoice(jComboBox4, 257, itemListener);
        JCheckBox jCheckBox = new JCheckBox("Integ.");
        gridBagConstraints.weightx = 0.25;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        JCheckBox jCheckBox2 = new JCheckBox("Log h.scale");
        gridBagConstraints.weightx = 0.25;
        this.gui.addCheckbox(jCheckBox2, 1, itemListener);
        JCheckBox jCheckBox3 = new JCheckBox("Log v.scale");
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox3, 2, itemListener);
        this.initGUI(this, 6, this.gui);
        Font font = this.getFont();
        this.fntMetr = this.getComponent().getFontMetrics(font);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void process() {
        GenericFile genericFile;
        File file;
        AudioFile audioFile;
        block42: {
            audioFile = null;
            file = null;
            genericFile = null;
            float[] fArray = null;
            float[] fArray2 = null;
            float[] fArray3 = null;
            try {
                int n;
                int n2;
                DataRecord[] dataRecordArray = this.properties;
                // MONITORENTER : this.properties
                int n3 = this.pr.intg[0];
                DataRecord dataRecord = this.properties[n3];
                this.properties[n3] = null;
                if (dataRecord != null) {
                    dataRecord.tempFile.delete();
                    DataRecord.access$1102(dataRecord, null);
                    dataRecord.tempFile = null;
                }
                // MONITOREXIT : dataRecordArray
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                AudioFileDescr audioFileDescr = audioFile.getDescr();
                int n4 = audioFileDescr.channels;
                int n5 = (int)audioFileDescr.length;
                int n6 = n5 * n4;
                if (n6 <= 0) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block42;
                file = IOUtil.createTempFile();
                genericFile = new FloatFile(file, 1);
                int n7 = 1 << this.pr.intg[2] + 5;
                float[] fArray4 = new float[n7];
                float[] fArray5 = new float[n7];
                int n8 = n2 = n7;
                int n9 = 0;
                dataRecord = new DataRecord();
                dataRecord.tempFile = file;
                dataRecord.afd = audioFileDescr;
                switch (this.pr.intg[0]) {
                    case 2: {
                        List list = (List)audioFileDescr.getProperty((Object)"markers");
                        if (list != null && (n = Marker.find((List)list, (String)"Support", (int)0)) >= 0) {
                            n9 = (int)((Marker)list.get((int)n)).pos;
                        }
                        fArray2 = new float[n2 << 1];
                    }
                    case 0: 
                    case 1: {
                        fArray3 = Filter.createWindow(n7, this.pr.intg[3]);
                        fArray = new float[(n2 <<= 1) + 2];
                        break;
                    }
                }
                float[][] fArray6 = new float[n4][n2 + 2];
                Util.clear(fArray4);
                Util.clear(fArray6);
                long l = 0L;
                long l2 = ((long)n5 << 1) + (long)n7;
                long l3 = 10000L;
                long l4 = System.currentTimeMillis() + l3;
                int n10 = 0;
                int n11 = Math.min(n2, n5);
                audioFile.readFrames(fArray6, 0, n11);
                int n12 = n11;
                this.setProgression((float)(l += (long)n11) / (float)l2);
                if (!this.threadRunning) break block42;
                do {
                    float[] fArray7;
                    int n13;
                    int n14;
                    switch (this.pr.intg[0]) {
                        case 0: 
                        case 1: 
                        case 2: {
                            block21: for (n14 = 0; n14 < 1; ++n14) {
                                System.arraycopy(fArray6[n14], n10, fArray, 0, n2 - n10);
                                System.arraycopy(fArray6[n14], 0, fArray, n2 - n10, n10);
                                n = 1;
                                n13 = n7;
                                while (n13 < n2 - 1) {
                                    int n15 = n13++;
                                    fArray[n15] = fArray[n15] * fArray3[n];
                                    ++n;
                                }
                                fArray[n13] = 0.0f;
                                n = 0;
                                n13 = n7 - 1;
                                while (n13 >= 0) {
                                    int n16 = n13--;
                                    fArray[n16] = fArray[n16] * fArray3[n];
                                    ++n;
                                }
                                if (this.pr.intg[0] == 2) {
                                    Util.rotate(fArray, n2, fArray2, -((n9 - n10) % n2));
                                }
                                Fourier.realTransform(fArray, n2, 1);
                                switch (this.pr.intg[0]) {
                                    case 0: {
                                        Fourier.rect2Polar(fArray, 0, fArray, 0, n2 + 2);
                                        n = 0;
                                        n13 = 0;
                                        while (n < n7) {
                                            int n17 = n++;
                                            fArray4[n17] = fArray4[n17] + fArray[n13];
                                            n13 += 2;
                                        }
                                        continue block21;
                                    }
                                    case 1: {
                                        n = 0;
                                        n13 = 0;
                                        while (n < n7) {
                                            int n18 = n++;
                                            fArray4[n18] = fArray4[n18] + (float)Math.abs((double)fArray[n13++] * (double)fArray[n13++]);
                                        }
                                        continue block21;
                                    }
                                    case 2: {
                                        Fourier.rect2Polar(fArray, 0, fArray, 0, n2 + 2);
                                        Fourier.unwrapPhases(fArray, 0, fArray, 0, n2 + 2);
                                        n = 0;
                                        n13 = 1;
                                        while (n < n7) {
                                            int n19 = n13 + 2;
                                            int n20 = n++;
                                            fArray4[n20] = fArray4[n20] + (fArray[n19] - fArray[n13]);
                                            n13 = n19;
                                        }
                                        continue block21;
                                    }
                                }
                            }
                            break;
                        }
                        case 3: {
                            for (n14 = 0; n14 < 1; ++n14) {
                                fArray7 = fArray6[n14];
                                for (n = 0; n < n11; ++n) {
                                    n13 = (int)(Math.abs(fArray7[n]) * (float)(n7 - 1) + 0.5f);
                                    int n21 = Math.min(n7 - 1, n13);
                                    fArray4[n21] = fArray4[n21] + 1.0f;
                                }
                            }
                            break;
                        }
                    }
                    this.setProgression((float)(l += (long)n11) / (float)l2);
                    n11 = Math.min(n8, n5 - n12);
                    audioFile.readFrames(fArray6, n10, n11);
                    n12 += n11;
                    this.setProgression((float)(l += (long)n11) / (float)l2);
                    if (!this.threadRunning) break block42;
                    if (n11 < n8) {
                        for (n14 = 0; n14 < n4; ++n14) {
                            fArray7 = fArray6[n14];
                            n13 = n + n10;
                            for (n = n11; n < n8; ++n, ++n13) {
                                fArray7[n13] = 0.0f;
                            }
                        }
                    }
                    n10 = (n10 + n8) % n2;
                    if (System.currentTimeMillis() <= l4 && n11 != 0) continue;
                    System.arraycopy(fArray4, 0, fArray5, 0, n7);
                    float f = 0.0f;
                    for (n = 0; n < n7; ++n) {
                        if (!(fArray5[n] > f)) continue;
                        f = fArray5[n];
                    }
                    if (f > 0.0f) {
                        n = 0;
                        while (n < n7) {
                            int n22 = n++;
                            fArray5[n22] = fArray5[n22] / f;
                        }
                    }
                    ((FloatFile)genericFile).seekFloat(0);
                    ((FloatFile)genericFile).writeFloats(fArray5, 0, n7);
                    ((FloatFile)genericFile).flush();
                    dataRecordArray = this.properties;
                    // MONITORENTER : this.properties
                    this.properties[n3] = dataRecord;
                    DataRecord.access$1102(dataRecord, null);
                    this.redrawDataset();
                    // MONITOREXIT : dataRecordArray
                    l4 += (l3 <<= 1);
                } while (this.threadRunning && n11 > 0);
                if (this.threadRunning) {
                    ((FloatFile)genericFile).close();
                    genericFile = null;
                    audioFile.close();
                    audioFile = null;
                    audioFileDescr = null;
                    this.setProgression((float)(l += (long)n7) / (float)l2);
                    if (this.threadRunning) {
                        // empty if block
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                float[][] fArray8 = null;
                fArray = null;
                fArray2 = null;
                Object var23_41 = null;
                Object var11_13 = null;
                Object var25_19 = null;
                Object var26_21 = null;
                fArray3 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (genericFile == null) return;
        genericFile.cleanUp();
        if (this.getError() == null) return;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redrawDataset() {
        DataRecord dataRecord = this.properties[this.pr.intg[0]];
        FloatFile floatFile = null;
        int n = 0;
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        double d = 1.0;
        double d2 = 8.685889638065035;
        DataRecord[] dataRecordArray = this.properties;
        synchronized (this.properties) {
            if (dataRecord != null) {
                block32: {
                    boolean bl;
                    boolean bl2 = bl = dataRecord.sum && !this.pr.bool[0] || dataRecord.hlog && !this.pr.bool[1] || dataRecord.vlog && !this.pr.bool[2] || this.pr.bool[0] && (dataRecord.hlog != this.pr.bool[1] || dataRecord.vlog != this.pr.bool[2]) || dataRecord.hlog != this.pr.bool[1] && this.pr.bool[2];
                    if (bl || dataRecord.data == null) {
                        try {
                            floatFile = new FloatFile(dataRecord.tempFile, 0);
                            dataRecord.sum = false;
                            dataRecord.hlog = false;
                            dataRecord.vlog = false;
                            DataRecord.access$1102(dataRecord, new float[(int)floatFile.getSize()]);
                            floatFile.seekFloat(0);
                            floatFile.readFloats(dataRecord.data, 0, dataRecord.data.length);
                            floatFile.close();
                        }
                        catch (Exception exception) {
                            System.err.println(exception.getLocalizedMessage());
                            DataRecord.access$1102(dataRecord, null);
                            if (floatFile == null) break block32;
                            floatFile.cleanUp();
                            floatFile = null;
                        }
                    }
                }
                if (dataRecord.data != null) {
                    float f3;
                    int n2;
                    double d3;
                    double d4;
                    float[] fArray;
                    int n3;
                    int n4;
                    double d5;
                    float[] fArray2 = dataRecord.data;
                    int n5 = fArray2.length;
                    if (this.pr.bool[0] && !dataRecord.sum) {
                        d5 = 0.0;
                        for (n4 = 0; n4 < n5; ++n4) {
                            fArray2[n4] = (float)(d5 += (double)fArray2[n4]);
                        }
                        dataRecord.sum = true;
                    }
                    if (this.pr.bool[1] && !dataRecord.hlog) {
                        n3 = 2049;
                        fArray = new float[n3];
                        switch (this.pr.intg[0]) {
                            case 3: {
                                d = Math.sqrt(0.5);
                                d4 = 1.0E-4;
                                d3 = 1.0;
                                break;
                            }
                            default: {
                                d = 1000.0;
                                d4 = 16.0;
                                d3 = ((DataRecord)dataRecord).afd.rate / 2.0;
                            }
                        }
                        double d6 = d * d / d3;
                        double d7 = Math.log(d3 / d6);
                        double d8 = Math.log(d4 / d6) / d7;
                        double d9 = (1.0 - d8) / (double)(n3 - 1);
                        double d10 = d6 / d3 * (double)(n5 - 1);
                        for (n2 = 0; n2 < n3; ++n2) {
                            d5 = Math.exp(((double)n2 * d9 + d8) * d7);
                            double d11 = d5 * d10;
                            n4 = (int)d11;
                            d5 = d11 % 1.0;
                            f3 = fArray2[n4];
                            d11 = (double)f3 * (1.0 - d5);
                            if (n4 + 1 < n5) {
                                f3 = fArray2[n4 + 1];
                                f3 = (float)(d11 + (double)f3 * d5);
                            } else {
                                f3 = (float)d11;
                            }
                            fArray[n2] = f3;
                            if (f3 > f) {
                                f = f3;
                            }
                            if (!(f3 < f2)) continue;
                            f2 = f3;
                        }
                    } else {
                        n4 = 4096;
                        while (n4 < n5) {
                            n4 <<= 1;
                            ++n;
                        }
                        n3 = (n5 >> n) + 1;
                        fArray = new float[n3];
                        n4 = 0;
                        n2 = 0;
                        n = 1 << n;
                        while (n4 < n5) {
                            fArray[n2] = f3 = fArray2[n4];
                            if (f3 > f) {
                                f = f3;
                            }
                            if (f3 < f2) {
                                f2 = f3;
                            }
                            n4 += n;
                            ++n2;
                        }
                        d4 = 0.0;
                        d3 = ((DataRecord)dataRecord).afd.rate / 2.0;
                    }
                    if (this.pr.bool[2] && !dataRecord.vlog) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            fArray[n2] = (float)(d2 * Math.log(Math.max(1.0E-8, (double)fArray[n2])));
                        }
                        f2 = (float)(d2 * Math.log(Math.max(1.0E-8, (double)f2)));
                        if ((double)((f = (float)(d2 * Math.log(Math.max(1.0E-8, (double)f)))) - f2) >= 40.0) {
                            f = (float)(Math.ceil((double)f / 6.0) * 6.0);
                            f2 = (float)(Math.floor((double)f2 / 6.0) * 6.0);
                        } else if ((double)(f - f2) >= 20.0) {
                            f = (float)(Math.ceil((double)f / 3.0) * 3.0);
                            f2 = (float)(Math.floor((double)f2 / 3.0) * 3.0);
                        } else {
                            f = (float)(Math.ceil((double)f / 1.0) * 1.0);
                            f2 = (float)(Math.floor((double)f2 / 1.0) * 1.0);
                        }
                    } else {
                        f = (float)(Math.ceil((double)f * 10.0) / 10.0);
                        f2 = (float)(Math.floor((double)f2 * 10.0) / 10.0);
                    }
                    if (this.pr.bool[1]) {
                        dataRecord.space = VectorSpace.createLogLinSpace((double)d4, (double)d3, (double)d, (double)f2, (double)f, null, null, null, null);
                    } else {
                        dataRecord.space = VectorSpace.createLinSpace((double)d4, (double)d3, (double)f2, (double)f, null, null, null, null);
                    }
                    this.ggVectorDisplay.setMinMax(f2, f);
                    this.ggVectorDisplay.setVector(this, fArray);
                    this.haxis.setSpace(dataRecord.space);
                    this.vaxis.setSpace(dataRecord.space);
                }
            }
            // ** MonitorExit[var36_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redrawCrosshair(MouseEvent mouseEvent) {
        Dimension dimension = this.ggVectorDisplay.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        DataRecord[] dataRecordArray = this.properties;
        synchronized (this.properties) {
            int n3 = this.pr.intg[0];
            DataRecord dataRecord = this.properties[n3];
            this.paintCrossHair = false;
            if (dataRecord != null && dataRecord.data != null && !mouseEvent.isAltDown()) {
                float[] fArray = this.ggVectorDisplay.getVector();
                int n4 = fArray.length;
                if (n >= 0 && n2 >= 0 && n < dimension.width && n2 < dimension.height) {
                    String string;
                    double d;
                    double d2;
                    if (mouseEvent.isShiftDown()) {
                        d2 = dataRecord.space.vUnityToSpace(1.0 - (double)n2 / (double)(dimension.height - 1));
                        d = dataRecord.space.hUnityToSpace((double)n / (double)(dimension.width - 1));
                    } else {
                        n = (int)((double)n / (double)(dimension.width - 1) * (double)(n4 - 1) + 0.5);
                        d2 = fArray[n];
                        d = dataRecord.space.hUnityToSpace((double)n / (double)(n4 - 1));
                        n2 = (int)((1.0 - dataRecord.space.vSpaceToUnity(d2)) * (double)(dimension.height - 1) + 0.5);
                        n = mouseEvent.getX();
                    }
                    this.lastPt = new Point(n, n2);
                    String string2 = this.pr.bool[2] ? this.msgDecibel.format(new Object[]{new Double(d2)}) : (!this.pr.bool[0] && n3 == 2 ? this.msgDegree.format(new Object[]{new Double(d2)}) : this.msgPlain.format(new Object[]{new Double(d2)}));
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            string = this.msgHertz.format(new Object[]{new Double(d)});
                            break;
                        }
                        default: {
                            string = this.msgPlain.format(new Object[]{new Double(d)});
                        }
                    }
                    this.lastTxt = string2 + " @ " + string;
                    this.paintCrossHair = true;
                }
            }
            // ** MonitorExit[var15_5] (shouldn't be in output)
            this.ggVectorDisplay.repaint();
            return;
        }
    }

    protected static class DataRecord {
        private File tempFile = null;
        private float[] data = null;
        private boolean sum = false;
        private boolean hlog = false;
        private boolean vlog = false;
        private AudioFileDescr afd = null;
        private VectorSpace space;

        protected DataRecord() {
        }

        static /* synthetic */ float[] access$1102(DataRecord dataRecord, float[] fArray) {
            dataRecord.data = fArray;
            return fArray;
        }
    }
}

