/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class SpectSlider
extends JPanel
implements ComponentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private int bands = -1;
    private float[] value = null;
    private Color[] sliderColor = null;
    private Color[] borderColor = null;
    private Dimension currentSize;
    private Cursor lastCursor = null;
    private Cursor drawCursor;
    private int currentSlider;
    private boolean focused = false;
    private static final Color colrBorder = new Color(128, 128, 128);
    private static final Color colrFocus = new Color(100, 115, 162);
    private Button actionComponent = new Button();
    private static float[] clipboard = null;

    public SpectSlider(float[] fArray, int n, int n2) {
        this.setBands(fArray);
        this.drawCursor = new Cursor(12);
        Dimension dimension = new Dimension(n, n2);
        this.setPreferredSize(dimension);
        this.setMinimumSize(new Dimension(n >> 1, n2 >> 1));
        this.currentSize = dimension;
        this.setForeground(Color.black);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public SpectSlider(int n, int n2, int n3) {
        this(new float[n], n2, n3);
    }

    public SpectSlider(int n) {
        this(new float[n], n * 11 + 3, n * 11 + 3);
    }

    public void setBand(int n, float f) {
        this.value[n] = f;
        this.repaint();
    }

    public float getBand(int n) {
        return this.value[n];
    }

    public void setBands(float[] fArray) {
        int n = this.bands;
        this.bands = fArray.length;
        if (n != this.bands || this.value == null) {
            this.value = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.value, 0, this.bands);
        if (n != this.bands || this.sliderColor == null) {
            this.sliderColor = new Color[this.bands];
            this.borderColor = new Color[this.bands];
        }
        float f = 0.75f / (float)(this.bands - 1);
        for (int i = 0; i < this.bands; ++i) {
            float f2 = (float)i * f;
            this.sliderColor[i] = new Color(Color.HSBtoRGB(f2, 0.5f, 1.0f));
            this.borderColor[i] = new Color(Color.HSBtoRGB(f2, 0.5f, 0.5f));
        }
        this.repaint();
    }

    public float[] getBands() {
        float[] fArray = new float[this.value.length];
        System.arraycopy(this.value, 0, fArray, 0, this.value.length);
        return fArray;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionComponent.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionComponent.removeActionListener(actionListener);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(colrBorder);
        graphics.draw3DRect(0, 0, this.currentSize.width - 1, this.currentSize.height - 1, false);
        if (this.focused) {
            graphics.setColor(colrFocus);
            graphics.drawRect(1, 1, this.currentSize.width - 3, this.currentSize.height - 3);
        }
        float f = (float)(this.currentSize.width - 3) / (float)this.bands;
        int n = this.currentSize.height - 2;
        int n2 = 0;
        for (int i = 0; i < this.bands; ++i) {
            int n3 = (int)(this.value[i] * (float)(this.currentSize.height - 4) + 0.5f);
            int n4 = n2 + 2;
            n2 = (int)((float)(i + 1) * f + 0.5f);
            if (n3 <= 0) continue;
            graphics.setColor(this.sliderColor[i]);
            graphics.fillRect(n4, n - n3, n2 - n4, n3 - 1);
            graphics.setColor(this.borderColor[i]);
            graphics.drawRect(n4, n - n3, n2 - n4, n3 - 1);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bands; ++i) {
            stringBuffer.append(this.value[i]);
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static float[] valueOf(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        }
        return fArray;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.currentSize = this.getSize();
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focused = true;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.focused = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case 'c': {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    clipboard = this.getBands();
                    break;
                }
            }
            case 'v': {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    this.setBands(clipboard);
                    break;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.lastCursor = this.getCursor();
        this.setCursor(this.drawCursor);
        this.processMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentSlider >= 0) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "");
            this.actionComponent.dispatchEvent(actionEvent);
        }
        this.currentSlider = -1;
        this.setCursor(this.lastCursor);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void processMouse(int n, int n2) {
        float f = (float)(this.currentSize.width - 3) / (float)this.bands;
        int n3 = (int)((float)(n - 2) / f);
        if (n3 < 0 || n3 >= this.bands) {
            if (this.currentSlider == -1) {
                return;
            }
        } else {
            this.currentSlider = n3;
        }
        f = (float)(this.currentSize.height - 2 - n2) / (float)(this.currentSize.height - 4);
        this.value[this.currentSlider] = Math.max(0.0f, Math.min(1.0f, f));
        this.repaint();
    }
}

