/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.ConstQ;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.MathUtil;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SonagramExportDlg
extends ModulePanel {
    private static final int PR_OUTPUTFILE = 0;
    private static final int PR_INPUTFILE = 1;
    private static final int PR_MAXFFTSIZE = 0;
    private static final int PR_MINFREQ = 0;
    private static final int PR_MAXFREQ = 1;
    private static final int PR_BANDSPEROCT = 2;
    private static final int PR_TIMERES = 3;
    private static final int PR_SIGNALCEIL = 4;
    private static final int PR_NOISEFLOOR = 5;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_MAXFFTSIZE = "MaxFFTSize";
    private static final String PRN_MINFREQ = "MinFreq";
    private static final String PRN_MAXFREQ = "MaxFreq";
    private static final String PRN_BANDSPEROCT = "BandsPerOct";
    private static final String PRN_TIMERES = "TimeReso";
    private static final String PRN_SIGNALCEIL = "SignalCeil";
    private static final String PRN_NOISEFLOOR = "NoiseFloor";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{5};
    private static final String[] prIntgName = new String[]{"MaxFFTSize"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"MinFreq", "MaxFreq", "BandsPerOct", "TimeReso", "SignalCeil", "NoiseFloor"};
    private static final int GG_INPUTFILE = 1025;
    private static final int GG_OUTPUTFILE = 1024;
    private static final int GG_MAXFFTSIZE = 256;
    private static final int GG_MINFREQ = 512;
    private static final int GG_MAXFREQ = 513;
    private static final int GG_BANDSPEROCT = 514;
    private static final int GG_TIMERES = 515;
    private static final int GG_SIGNALCEIL = 516;
    private static final int GG_NOISEFLOOR = 517;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_MONO = "Audio file must be monophonic";

    public SonagramExportDlg() {
        super("Sonogram Export");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SonagramExportDlg.static_pr.text = prText;
            SonagramExportDlg.static_pr.textName = prTextName;
            SonagramExportDlg.static_pr.intg = prIntg;
            SonagramExportDlg.static_pr.intgName = prIntgName;
            SonagramExportDlg.static_pr.para = prPara;
            SonagramExportDlg.static_pr.para[0] = new Param(32.0, 3);
            SonagramExportDlg.static_pr.para[1] = new Param(18000.0, 3);
            SonagramExportDlg.static_pr.para[2] = new Param(12.0, 0);
            SonagramExportDlg.static_pr.para[3] = new Param(20.0, 2);
            SonagramExportDlg.static_pr.para[4] = new Param(0.0, 785);
            SonagramExportDlg.static_pr.para[5] = new Param(-96.0, 785);
            SonagramExportDlg.static_pr.paraName = prParaName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input sound file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Audio input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1025, null);
        PathField pathField2 = new PathField(49, "Select output image file");
        pathField2.handleTypes(GenericFile.TYPES_IMAGE);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Sono$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Image output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1024, null);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Lowest Frequency:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        ParamField paramField2 = new ParamField(new ParamSpace(1.0, 32768.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Bands Per Octave:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        ParamField paramField3 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Highest Frequency:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 513, null);
        ParamField paramField4 = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Max. Time Resolution:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 515, null);
        ParamField paramField5 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Signal Ceiling:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 516, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 256; i <= 32768; i <<= 1) {
            jComboBox.addItem(String.valueOf(i));
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Max. FFT Size:", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 256, null);
        ParamField paramField6 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Noise Floor:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField6, 517, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        GenericFile genericFile;
        AudioFile audioFile;
        block18: {
            audioFile = null;
            double d = this.pr.para[0].value;
            double d2 = this.pr.para[1].value;
            double d3 = this.pr.para[3].value;
            int n = (int)this.pr.para[2].value;
            int n2 = 256 << this.pr.intg[0];
            genericFile = null;
            double d4 = this.pr.para[4].value;
            double d5 = this.pr.para[5].value;
            double d6 = d4 - d5;
            try {
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                AudioFileDescr audioFileDescr = audioFile.getDescr();
                int n3 = audioFileDescr.channels;
                long l = audioFileDescr.length;
                if (l < 1L || n3 < 1) {
                    throw new EOFException("File is empty");
                }
                if (n3 != 1) {
                    throw new EOFException(ERR_MONO);
                }
                if (!this.threadRunning) break block18;
                ConstQ constQ = new ConstQ();
                constQ.setSampleRate(audioFileDescr.rate);
                constQ.setMinFreq((float)d);
                constQ.setMaxFreq((float)d2);
                constQ.setBandsPerOct(n);
                constQ.setMaxFFTSize(n2);
                constQ.setMaxTimeRes((float)d3);
                constQ.createKernels();
                int n4 = constQ.getFFTSize();
                int n5 = constQ.getNumKernels();
                int n6 = n4;
                int n7 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d3) + 0.5);
                int n8 = n4 - n7;
                int n9 = (int)((l + (long)n7 - 1L) / (long)n7);
                int n10 = n5;
                PathField pathField = (PathField)this.gui.getItemObj(1024);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                genericFile = new ImageFile(this.pr.text[0], 1 | pathField.getType());
                ImageStream imageStream = new ImageStream();
                imageStream.bitsPerSmp = 8;
                pathField.fillStream(imageStream);
                imageStream.width = n10;
                imageStream.height = n9;
                imageStream.smpPerPixel = 1;
                int n11 = imageStream.bitsPerSmp;
                ((ImageFile)genericFile).initWriter(imageStream);
                byte[] byArray = ((ImageFile)genericFile).allocRow();
                int n12 = Math.max(8192, n4);
                float[][] fArray = new float[n3][n12];
                float[] fArray2 = new float[n5];
                long l2 = n9;
                long l3 = 0L;
                long l4 = 0L;
                int n13 = 0;
                for (int i = 0; i < n9; ++i) {
                    int n14;
                    if (n13 < 0) {
                        audioFile.seekFrame(Math.min(audioFile.getFrameNum(), audioFile.getFramePosition() - (long)n13));
                        n13 = 0;
                    }
                    int n15 = (int)Math.min(l - l4, (long)(n6 - n13));
                    audioFile.readFrames(fArray, n13, n15);
                    if (n13 + n15 < n6) {
                        Util.clear(fArray, n13 + n15, n6 - (n13 + n15));
                    }
                    constQ.transform(fArray[0], 0, n6, fArray2, 0);
                    for (n14 = 0; n14 < n10; ++n14) {
                        fArray2[n14] = (float)((Math.min(d4, Math.max(d5, MathUtil.linearToDB(fArray2[n14] * 1.0f))) - d5) / d6);
                    }
                    if (n11 == 8) {
                        for (n14 = 0; n14 < n10; ++n14) {
                            byArray[n14] = (byte)(fArray2[n14] * 255.0f + 0.5f);
                        }
                    } else {
                        int n16 = 0;
                        for (n14 = 0; n14 < n10; ++n14) {
                            int n17 = (int)(fArray2[n14] * 65535.0f + 0.5f);
                            byArray[n16++] = (byte)(n17 >> 8);
                            byArray[n16++] = (byte)n17;
                        }
                    }
                    ((ImageFile)genericFile).writeRow(byArray);
                    if (n8 > 0) {
                        Util.copy(fArray, n7, fArray, 0, n8);
                    }
                    n13 = n8;
                    l4 += (long)n15;
                    this.setProgression((float)(++l3) / (float)l2);
                    if (this.threadRunning) {
                        continue;
                    }
                    break block18;
                }
                audioFile.close();
                audioFile = null;
                ((ImageFile)genericFile).close();
                genericFile = null;
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (genericFile != null) {
            genericFile.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }
}

