/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.JLabel;

public class SachensucherDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_OUTPUTRATE = 2;
    private static final int PR_GAIN = 0;
    private static final int PR_LENGTH = 1;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String PRN_LENGTH = "Length";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "OutputRate"};
    private static final Param[] prPara = new Param[]{null, null};
    private static final String[] prParaName = new String[]{"Gain", "Length"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_OUTPUTRATE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_LENGTH = 513;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public SachensucherDlg() {
        super("Sachensucher");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            SachensucherDlg.static_pr.text = prText;
            SachensucherDlg.static_pr.textName = prTextName;
            SachensucherDlg.static_pr.intg = prIntg;
            SachensucherDlg.static_pr.intgName = prIntgName;
            SachensucherDlg.static_pr.para = prPara;
            SachensucherDlg.static_pr.para[1] = new Param(768.0, 0);
            SachensucherDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(SachensucherDlg.static_pr.intg, 0, 1, 2);
            this.fillDefaultGain(SachensucherDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("File I/O", 1, 0));
        PathField pathField = new PathField(0, "Select input file");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Any input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(113, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Sonif$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.registerGadget(pathField2.getRateGadget(), 258);
        ParamField paramField = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Headroom", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 512, null);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamSpace paramSpace = new ParamSpace(12.0, 98304.0, 3.0, 0);
        ParamField paramField2 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Window length [bytes]", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 513, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        RandomAccessFile randomAccessFile;
        block30: {
            randomAccessFile = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            Param param = new Param(1.0, 1);
            int[] nArray = new int[5];
            float[] fArray = new float[4];
            float[] fArray2 = new float[4];
            try {
                int n;
                randomAccessFile = new RandomAccessFile(this.pr.text[0], "r");
                long l = randomAccessFile.length();
                FileChannel fileChannel = randomAccessFile.getChannel();
                long l2 = 0L;
                long l3 = l * 2L;
                int n2 = (int)this.pr.para[1].value / 3 * 3;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr();
                pathField.fillStream(audioFileDescr);
                audioFileDescr.channels = 1;
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block30;
                float f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                if (!this.threadRunning) break block30;
                int n3 = 0;
                float f2 = 0.0f;
                long l4 = 0L;
                int n4 = 0;
                int n5 = 0;
                Info info = new Info();
                ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
                info.bb = byteBuffer;
                float[][] fArray3 = new float[1][byteBuffer.capacity()];
                Info.access$102(info, fArray3[0]);
                for (long i = 0L; this.threadRunning && i < l; i += (long)n) {
                    int n6;
                    byteBuffer.clear();
                    n = (int)Math.min(l - i, (long)n2);
                    fileChannel.read(byteBuffer);
                    int n7 = 0;
                    float f3 = this.idByte(info, 0);
                    int n8 = 0;
                    float f4 = info.maxAmp;
                    float f5 = Float.POSITIVE_INFINITY;
                    int n9 = 0;
                    for (n6 = 0; n6 < 2; ++n6) {
                        fArray2[n6] = this.idShort(info, n6);
                        fArray[n6] = info.maxAmp;
                        if (!(info.diff < f5)) continue;
                        n9 = n6;
                        f5 = info.diff;
                    }
                    if (fArray2[n9] < f3) {
                        f3 = fArray2[n9];
                        n7 = 1;
                        f4 = fArray[n9];
                        n8 = n9;
                    }
                    f5 = Float.POSITIVE_INFINITY;
                    n9 = 0;
                    for (n6 = 0; n6 < 3; ++n6) {
                        fArray2[n6] = this.idTri(info, n6);
                        fArray[n6] = info.maxAmp;
                        if (!(info.diff < f5)) continue;
                        n9 = n6;
                        f5 = info.diff;
                    }
                    if (fArray2[n9] < f3) {
                        f3 = fArray2[n9];
                        n7 = 2;
                        f4 = fArray[n9];
                        n8 = n9;
                    }
                    f5 = Float.POSITIVE_INFINITY;
                    n9 = 0;
                    for (n6 = 0; n6 < 4; ++n6) {
                        fArray2[n6] = this.idInt(info, n6);
                        fArray[n6] = info.maxAmp;
                        if (!(info.diff < f5)) continue;
                        n9 = n6;
                        f5 = info.diff;
                    }
                    if (fArray2[n9] < f3) {
                        f3 = fArray2[n9];
                        n7 = 3;
                        f4 = fArray[n9];
                        n8 = n9;
                    }
                    f5 = Float.POSITIVE_INFINITY;
                    n9 = 0;
                    for (n6 = 0; n6 < 4; ++n6) {
                        fArray2[n6] = this.idFloat(info, n6);
                        fArray[n6] = info.maxAmp;
                        if (!(info.diff < f5)) continue;
                        n9 = n6;
                        f5 = info.diff;
                    }
                    if (fArray2[n9] < f3) {
                        f3 = fArray2[n9];
                        n7 = 3;
                        f4 = fArray[n9];
                        n8 = n9;
                    }
                    if (n7 != n3 || n8 != 0 || n < n2) {
                        long l5 = fileChannel.position();
                        fileChannel.position(l4);
                        float f6 = f2 > 0.0f ? f / f2 : 0.0f;
                        int n10 = n3;
                        nArray[n10] = nArray[n10] + 1;
                        for (n6 = 0; n6 < n4; ++n6) {
                            byteBuffer.clear();
                            fileChannel.read(byteBuffer);
                            n9 = info.fb.length;
                            switch (n3) {
                                case 0: {
                                    this.copyBytes(info, n5);
                                    break;
                                }
                                case 1: {
                                    this.copyShorts(info, n5);
                                    n9 = (n9 - n5) / 2;
                                    break;
                                }
                                case 2: {
                                    this.copyTris(info, n5);
                                    n9 = (n9 - n5) / 3;
                                    break;
                                }
                                case 3: {
                                    this.copyInts(info, n5);
                                    n9 = (n9 - n5) / 4;
                                    break;
                                }
                                case 4: {
                                    this.copyFloats(info, n5);
                                    n9 = (n9 - n5) / 4;
                                }
                            }
                            int n11 = 0;
                            while (n11 < n9) {
                                float[] fArray4 = info.fb;
                                int n12 = n11++;
                                fArray4[n12] = fArray4[n12] * f6;
                            }
                            audioFile.writeFrames(fArray3, 0, n9);
                            this.setProgression((float)(l2 += (long)n2) / (float)l3);
                            if (this.threadRunning) {
                                continue;
                            }
                            break block30;
                        }
                        n3 = n7;
                        l4 = l5;
                        n5 = n8;
                        fileChannel.position(l5 + (long)n8);
                        f2 = f4;
                        n4 = 1;
                    } else {
                        f2 = Math.max(f4, f2);
                        ++n4;
                    }
                    this.setProgression((float)(l2 += (long)n) / (float)l3);
                }
                if (this.threadRunning) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                    audioFile.close();
                    audioFile = null;
                    this.setProgression(1.0f);
                    System.out.println("# of chunks: " + nArray[0] + " bytes, " + nArray[1] + " shorts, " + nArray[2] + " tris, " + nArray[3] + " ints, " + nArray[4] + " floats.");
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    private float idByte(Info info, int n) {
        int n2 = info.bb.capacity() - n;
        float f = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 255;
        info.maxAmp = 0.0f;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            float f2 = f;
            f = (float)info.bb.get() / (float)n3;
            float f3 = Math.abs(f);
            if (f3 > info.maxAmp) {
                info.maxAmp = f3;
            }
            f *= f;
            d += (double)f;
            d2 += (double)Math.abs(f2 - f);
        }
        info.diff = (float)d2;
        return (float)(d2 / d);
    }

    private float idShort(Info info, int n) {
        int n2 = info.bb.capacity() - n >> 1;
        float f = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 65535;
        info.maxAmp = 0.0f;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            float f2 = f;
            f = (float)info.bb.getShort() / (float)n3;
            float f3 = Math.abs(f);
            if (f3 > info.maxAmp) {
                info.maxAmp = f3;
            }
            f *= f;
            d += (double)f;
            d2 += (double)Math.abs(f2 - f);
        }
        info.diff = (float)d2;
        return (float)(d2 / d);
    }

    private float idTri(Info info, int n) {
        int n2 = (info.bb.capacity() - n) / 3;
        float f = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0xFFFFFF;
        info.maxAmp = 0.0f;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            float f2 = f;
            f = (float)(info.bb.get() << 16 | (info.bb.get() & 0xFF) << 8 | info.bb.get() & 0xFF) / (float)n3;
            float f3 = Math.abs(f);
            if (f3 > info.maxAmp) {
                info.maxAmp = f3;
            }
            f *= f;
            d += (double)f;
            d2 += (double)Math.abs(f2 - f);
        }
        info.diff = (float)d2;
        return (float)(d2 / d);
    }

    private float idInt(Info info, int n) {
        int n2 = info.bb.capacity() - n >> 2;
        float f = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        long l = -1L;
        info.maxAmp = 0.0f;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            float f2 = f;
            f = (float)info.bb.getInt() / (float)l;
            float f3 = Math.abs(f);
            if (f3 > info.maxAmp) {
                info.maxAmp = f3;
            }
            f *= f;
            d += (double)f;
            d2 += (double)Math.abs(f2 - f);
        }
        info.diff = (float)d2;
        return (float)(d2 / d);
    }

    private float idFloat(Info info, int n) {
        int n2 = info.bb.capacity() - n >> 2;
        float f = 0.0f;
        float f2 = 0.0f;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        info.maxAmp = 0.0f;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            f = info.bb.getFloat();
            float f3 = Math.abs(f);
            if (!((f *= f) > -1000000.0f & f < 1000000.0f)) continue;
            if (f3 > info.maxAmp) {
                info.maxAmp = f3;
            }
            f2 = f;
            d += (double)f;
            d2 += (double)Math.abs(f2 - f);
            ++n3;
        }
        info.diff = (float)d2;
        if ((float)n3 / (float)n2 < 0.8f) {
            return Float.POSITIVE_INFINITY;
        }
        if (d != 0.0) {
            return (float)(d2 / d);
        }
        return 1.0f;
    }

    private void copyBytes(Info info, int n) throws IOException {
        int n2 = info.bb.capacity() - n;
        int n3 = 255;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            ((Info)info).fb[i] = (float)info.bb.get() / (float)n3;
        }
    }

    private void copyShorts(Info info, int n) throws IOException {
        int n2 = info.bb.capacity() - n >> 1;
        int n3 = 65535;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            ((Info)info).fb[i] = (float)info.bb.getShort() / (float)n3;
        }
    }

    private void copyTris(Info info, int n) throws IOException {
        int n2 = (info.bb.capacity() - n) / 3;
        int n3 = 0xFFFFFF;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            ((Info)info).fb[i] = (float)(info.bb.get() << 16 | (info.bb.get() & 0xFF) << 8 | info.bb.get() & 0xFF) / (float)n3;
        }
    }

    private void copyInts(Info info, int n) throws IOException {
        int n2 = info.bb.capacity() - n >> 2;
        long l = -1L;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            ((Info)info).fb[i] = (float)info.bb.getInt() / (float)l;
        }
    }

    private void copyFloats(Info info, int n) throws IOException {
        int n2 = info.bb.capacity() - n >> 2;
        info.bb.clear();
        info.bb.position(n);
        for (int i = 0; i < n2; ++i) {
            ((Info)info).fb[i] = info.bb.getFloat();
        }
    }

    protected class Info {
        private ByteBuffer bb;
        private float maxAmp;
        private float[] fb;
        private float diff;

        protected Info() {
        }

        static /* synthetic */ float[] access$102(Info info, float[] fArray) {
            info.fb = fArray;
            return fArray;
        }
    }
}

