/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.TimeFormat;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RecycleDlg
extends ModulePanel {
    private static final int PR_ORIGINFILE = 0;
    private static final int PR_COMPACTFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_MARKERS = 0;
    private static final int PR_MINMATCH = 0;
    private static final int PR_MINRECYCLE = 1;
    private static final int PR_PADDING = 2;
    private static final int PR_CMPSPACING = 3;
    private static final int PR_CROSSFADE = 4;
    private static final String PRN_ORIGINFILE = "OriginFile";
    private static final String PRN_COMPACTFILE = "CompactFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_MARKERS = "Markers";
    private static final String PRN_MINMATCH = "MinMatch";
    private static final String PRN_MINRECYCLE = "MinRecycle";
    private static final String PRN_PADDING = "Padding";
    private static final String PRN_CMPSPACING = "CmpSpacing";
    private static final String PRN_CROSSFADE = "CrossFade";
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"OriginFile", "CompactFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Markers"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"MinMatch", "MinRecycle", "Padding", "CmpSpacing", "CrossFade"};
    private static final int GG_ORIGINFILE = 1024;
    private static final int GG_COMPACTFILE = 1025;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_MARKERS = 0;
    private static final int GG_MINMATCH = 512;
    private static final int GG_MINRECYCLE = 513;
    private static final int GG_PADDING = 514;
    private static final int GG_CMPSPACING = 515;
    private static final int GG_CROSSFADE = 516;
    private static final int GG_INFOFIELD = 2048;
    private static final int GG_ANALYZE = 2049;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHANNUM = "Input files must have same # of channels";
    private static final String MARK_CUT = "Cut";
    private boolean regionsKnown = false;
    private boolean threadJustAnalyze = false;
    private final List<Region> regionList = new ArrayList<Region>();
    private final MessageFormat msgInfoField = new MessageFormat("{0,choice,-1#[\u2026|0#}{1,choice,0#No regions|1#One region|1<{1,number,integer} regions}{1,choice,0#|1# with total duration of {2}} to recycle{0,choice,-1#\u2026]|0#}", Locale.US);

    public RecycleDlg() {
        super("Recycle Or Die");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            RecycleDlg.static_pr.text = prText;
            RecycleDlg.static_pr.textName = prTextName;
            RecycleDlg.static_pr.intg = prIntg;
            RecycleDlg.static_pr.intgName = prIntgName;
            RecycleDlg.static_pr.bool = prBool;
            RecycleDlg.static_pr.boolName = prBoolName;
            RecycleDlg.static_pr.para = prPara;
            RecycleDlg.static_pr.para[0] = new Param(100.0, 2);
            RecycleDlg.static_pr.para[1] = new Param(100.0, 2);
            RecycleDlg.static_pr.para[2] = new Param(1000.0, 2);
            RecycleDlg.static_pr.para[3] = new Param(6.0, 2);
            RecycleDlg.static_pr.para[4] = new Param(0.0, 2);
            RecycleDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(RecycleDlg.static_pr.intg, 0, 1);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = RecycleDlg.this.gui.getItemID(actionEvent);
                switch (n) {
                    case 1024: 
                    case 1025: {
                        RecycleDlg.this.clearInput();
                        break;
                    }
                    case 2049: {
                        RecycleDlg.this.threadJustAnalyze = true;
                        RecycleDlg.this.clearInput();
                        RecycleDlg.this.start();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select original input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Original Input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select compacted input file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Compacted Input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField3.deriveFrom(pathFieldArray, "$D0$F0Rcyc$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Recycled Output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        JButton jButton = new JButton("Analyze");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addButton(jButton, 2049, actionListener);
        gridBagConstraints.fill = 2;
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setBackground(null);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addTextField(jTextField, 2048, actionListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Recycling Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min. Matching", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Write Markers", 4));
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        ParamField paramField2 = new ParamField(paramSpaceArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Compact Spacing", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 515, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        ParamField paramField3 = new ParamField(paramSpaceArray);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Min. Recycling", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 513, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        ParamField paramField4 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Pre/Post Padding", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField4, 514, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        ParamField paramField5 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Crossfade", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField5, 516, null);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new JLabel());
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        this.clearInput();
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        AudioFile audioFile3;
        block57: {
            audioFile3 = null;
            audioFile2 = null;
            audioFile = null;
            try {
                int n;
                int n2;
                float[] fArray;
                float[] fArray2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                long l;
                boolean bl = this.threadJustAnalyze;
                this.threadJustAnalyze = false;
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                AudioFileDescr audioFileDescr = audioFile3.getDescr();
                int n8 = audioFileDescr.channels;
                int n9 = (int)audioFileDescr.length;
                if (n9 < 1 || n8 < 1) {
                    throw new EOFException("File is empty");
                }
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                ArrayList<Marker> arrayList = (ArrayList<Marker>)audioFileDescr2.getProperty((Object)"markers");
                if (arrayList == null && this.pr.bool[0]) {
                    arrayList = new ArrayList<Marker>();
                }
                if (!bl) {
                    if (!this.pr.bool[0]) {
                        audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                    } else {
                        IOUtil.createEmptyFile((File)new File(this.pr.text[2]));
                    }
                }
                if (!this.threadRunning) break block57;
                double d = Param.transform((Param)this.pr.para[0], (int)2, null, null).value;
                int n10 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5));
                d = Param.transform((Param)this.pr.para[1], (int)2, null, null).value;
                int n11 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5));
                d = Param.transform((Param)this.pr.para[2], (int)2, null, null).value;
                int n12 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5);
                d = Param.transform((Param)this.pr.para[3], (int)2, null, null).value;
                int n13 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5);
                d = Param.transform((Param)this.pr.para[4], (int)2, null, null).value;
                int n14 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5));
                int n15 = n10 << 1;
                float[][] fArray3 = new float[n8][Math.max(8192, n15)];
                float[][] fArray4 = new float[n8][n14];
                Region region = null;
                long l2 = 0L;
                if (!this.regionsKnown) {
                    audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                    AudioFileDescr audioFileDescr3 = audioFile2.getDescr();
                    int n16 = (int)audioFileDescr3.length;
                    if (n8 != audioFileDescr3.channels) {
                        throw new IOException(ERR_CHANNUM);
                    }
                    if (n16 < 1) {
                        throw new EOFException("File is empty");
                    }
                    int n17 = n10;
                    float[][] fArray5 = new float[n8][n17];
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    this.regionList.clear();
                    l = (long)n9 + (long)n16 << (bl ? 0 : 1);
                    long l3 = 10000L;
                    long l4 = System.currentTimeMillis() + l3;
                    boolean bl2 = true;
                    block3: while (this.threadRunning) {
                        int n24;
                        if (n13 > 0) {
                            n7 = n18 - n13;
                            if (n7 > 0) {
                                n18 = n7;
                                for (n6 = 0; n6 < n8; ++n6) {
                                    System.arraycopy(fArray5[n6], n13, fArray5[n6], 0, n18);
                                }
                            } else {
                                n18 = 0;
                                audioFile2.seekFrame((long)(n20 -= n7));
                            }
                        }
                        n5 = Math.min(n16 - n20, n17 - n18);
                        for (n3 = 0; n3 < n5; n3 += n4) {
                            n4 = Math.min(8192, n5 - n3);
                            audioFile2.readFrames(fArray5, n18, n4);
                            n20 += n4;
                            n18 += n4;
                            this.setProgression((float)(l2 += (long)n4) / (float)l);
                            if (this.threadRunning) continue;
                            break block57;
                        }
                        if (n18 < n10) break;
                        block6: while (true) {
                            n5 = Math.min(n9 - n21, n15 - n19);
                            for (n3 = 0; n3 < n5; n3 += n4) {
                                n4 = Math.min(8192, n5 - n3);
                                audioFile3.readFrames(fArray3, n19, n4);
                                n21 += n4;
                                n19 += n4;
                                this.setProgression((float)(l2 += (long)n4) / (float)l);
                                if (this.threadRunning) continue;
                                break block57;
                            }
                            if (n5 == 0 || n19 < n10) break block3;
                            if (System.currentTimeMillis() > l4 && bl2) {
                                this.showRegions(audioFileDescr.rate, false);
                                l3 = l3 * 3L / 2L;
                                l4 += l3;
                                bl2 = false;
                            }
                            block8: for (n7 = n10; n7 <= n19; ++n7) {
                                for (n6 = 0; n6 < n8; ++n6) {
                                    fArray2 = fArray3[n6];
                                    fArray = fArray5[n6];
                                    n2 = n10;
                                    n = n7;
                                    while (n2 > 0) {
                                        if (fArray2[--n] == fArray[--n2]) continue;
                                        continue block8;
                                    }
                                }
                                n24 = n22 + n7 - n10;
                                n19 -= n7;
                                n22 += n7;
                                n18 = 0;
                                for (n6 = 0; n6 < n8; ++n6) {
                                    System.arraycopy(fArray3[n6], n7, fArray3[n6], 0, n19);
                                }
                                break block6;
                            }
                            n7 = n19 - n10;
                            n19 -= n7;
                            n22 += n7;
                            n6 = 0;
                            while (true) {
                                if (n6 >= n8) continue block6;
                                System.arraycopy(fArray3[n6], n7, fArray3[n6], 0, n19);
                                ++n6;
                            }
                            break;
                        }
                        if (n24 - n23 >= n11) {
                            n7 = Math.max(0, n23 - n12);
                            n2 = Math.min(n9, n24 + n12);
                            if (region != null && region.span.getStop() >= (long)n7) {
                                region = new Region(new Span(Math.min(region.span.getStart(), (long)n7), Math.max(region.span.getStop(), (long)n2)), region.name);
                                this.regionList.set(this.regionList.size() - 1, region);
                                bl2 = true;
                            } else {
                                region = new Region(new Span((long)n7, (long)n2), null);
                                this.regionList.add(region);
                                bl2 = true;
                            }
                        }
                        if (System.currentTimeMillis() > l4 && bl2) {
                            this.showRegions(audioFileDescr.rate, false);
                            l3 = l3 * 3L / 2L;
                            l4 += l3;
                            bl2 = false;
                        }
                        do {
                            if ((n5 = Math.min(Math.min(n16 - n20, n17 - n18), Math.min(n9 - n21, n15 - n19))) == 0) {
                                n23 = n22;
                                break block3;
                            }
                            for (n3 = 0; n3 < n5; n3 += n4) {
                                n4 = Math.min(8192, n5 - n3);
                                audioFile2.readFrames(fArray5, n18, n4);
                                n20 += n4;
                                n18 += n4;
                                l2 += (long)n4;
                                audioFile3.readFrames(fArray3, n19, n4);
                                n21 += n4;
                                n19 += n4;
                                this.setProgression((float)(l2 += (long)n4) / (float)l);
                                if (this.threadRunning) continue;
                                break block57;
                            }
                            n2 = n5;
                            block15: for (n6 = 0; n6 < n8; ++n6) {
                                fArray2 = fArray3[n6];
                                fArray = fArray5[n6];
                                for (n7 = 0; n7 < n5; ++n7) {
                                    if (fArray2[n7] == fArray[n7]) continue;
                                    n23 = n22 + n7;
                                    n2 = n7;
                                    break block15;
                                }
                            }
                            n19 -= n2;
                            n22 += n2;
                            n18 -= n2;
                            for (n6 = 0; n6 < n8; ++n6) {
                                System.arraycopy(fArray3[n6], n2, fArray3[n6], 0, n19);
                                System.arraycopy(fArray5[n6], n2, fArray5[n6], 0, n18);
                            }
                        } while (n2 == n5);
                    }
                    if (!this.threadRunning) break block57;
                    if (n9 - n23 >= n11) {
                        n7 = Math.max(0, n23 - n12);
                        n2 = n9;
                        if (region != null && region.span.getStop() >= (long)n7) {
                            region = new Region(new Span(Math.min(region.span.getStart(), (long)n7), Math.max(region.span.getStop(), (long)n2)), region.name);
                            this.regionList.set(this.regionList.size() - 1, region);
                        } else {
                            region = new Region(new Span((long)n7, (long)n2), null);
                            this.regionList.add(region);
                        }
                    }
                    audioFile2.close();
                    audioFile2 = null;
                    this.regionsKnown = true;
                    if (!bl) {
                        this.indicateOutputWrite();
                    }
                }
                this.showRegions(audioFileDescr.rate, true);
                int n25 = 0;
                for (n7 = 0; n7 < this.regionList.size(); ++n7) {
                    region = this.regionList.get(n7);
                    n2 = (int)region.span.getLength();
                    if (this.pr.bool[0]) {
                        arrayList.add(new Marker((long)n25, MARK_CUT));
                    }
                    n25 += n2;
                }
                if (!bl) {
                    if (this.pr.bool[0]) {
                        audioFileDescr2.setProperty("markers", arrayList);
                        audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                    }
                    l2 = l2 == 0L ? 0L : (long)n25;
                    l = l2 + (long)n25;
                    int n26 = 0;
                    for (n7 = 0; n7 < this.regionList.size(); ++n7) {
                        region = this.regionList.get(n7);
                        n5 = (int)region.span.getLength();
                        int n27 = n26;
                        audioFile3.seekFrame(region.span.getStart() - (long)n27);
                        for (n3 = 0; n3 < n27; n3 += n4) {
                            n4 = Math.min(8192, n27 - n3);
                            audioFile3.readFrames(fArray3, 0, n4);
                            for (n6 = 0; n6 < n8; ++n6) {
                                fArray2 = fArray4[n6];
                                fArray = fArray3[n6];
                                n2 = 0;
                                n = n3;
                                while (n2 < n4) {
                                    int n28 = n;
                                    fArray2[n28] = fArray2[n28] + fArray[n2] * (float)Math.sqrt((double)n / (double)n27);
                                    ++n2;
                                    ++n;
                                }
                            }
                            audioFile.writeFrames(fArray4, n3, n4);
                            this.setProgression((float)(l2 += (long)n4) / (float)l);
                            if (this.threadRunning) continue;
                            break block57;
                        }
                        if (n7 + 1 < this.regionList.size()) {
                            n26 = (int)Math.min((long)n14, Math.min((long)n9 - region.span.getStop(), this.regionList.get((int)(n7 + 1)).span.getStart()));
                            n5 -= n26;
                        } else {
                            n26 = 0;
                        }
                        for (n3 = 0; n3 < n5; n3 += n4) {
                            n4 = Math.min(8192, n5 - n3);
                            audioFile3.readFrames(fArray3, 0, n4);
                            audioFile.writeFrames(fArray3, 0, n4);
                            this.setProgression((float)(l2 += (long)n4) / (float)l);
                            if (this.threadRunning) continue;
                            break block57;
                        }
                        if (n26 <= 0) continue;
                        audioFile3.readFrames(fArray4, 0, n26);
                        for (n6 = 0; n6 < n8; ++n6) {
                            fArray2 = fArray4[n6];
                            for (n2 = 0; n2 < n26; ++n2) {
                                int n29 = n2;
                                fArray2[n29] = fArray2[n29] * (float)Math.sqrt(1.0 - (double)n2 / (double)n26);
                            }
                        }
                    }
                    if (!this.threadRunning) break block57;
                    audioFile.close();
                    audioFile = null;
                }
                audioFile3.close();
                audioFile3 = null;
                this.setProgression(1.0f);
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Object var17_6 = null;
                Object var18_27 = null;
                Object var19_11 = null;
                float[][] fArray = null;
                float[][] fArray6 = null;
                float[][] fArray7 = null;
                Object var24_50 = null;
                Object var25_52 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }

    private void showRegions(double d, boolean bl) {
        String string;
        int n = this.regionList.size();
        if (n > 0) {
            long l = 0L;
            for (int i = 0; i < this.regionList.size(); ++i) {
                l += this.regionList.get((int)i).span.getLength();
            }
            string = new TimeFormat(0, null, null, 3, Locale.US).formatTime(new Double((double)l / d));
        } else {
            string = null;
        }
        Integer n2 = new Integer(bl ? 1 : -1);
        Object[] objectArray = new Object[]{n2, new Integer(this.regionList.size()), string};
        this.gui.stringToJTextField(this.msgInfoField.format(objectArray), 2048);
    }

    protected void clearInput() {
        this.regionsKnown = false;
        this.regionList.clear();
        this.gui.stringToJTextField("", 2048);
    }
}

