/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.fscape.gui.ProgressPanel;
import de.sciss.fscape.proc.Processor;
import de.sciss.fscape.proc.ProcessorEvent;
import de.sciss.fscape.proc.ProcessorListener;
import de.sciss.gui.GUIUtil;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ProcessPanel
extends JPanel
implements EventManager.Processor {
    public static final int TYPE_ASYNC = 4;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_PAUSING = 2;
    public static final int STATE_WARMUP = 3;
    private final ProgressPanel pProgress;
    private final Action actionClose;
    private final ActionProcess actionProcess;
    private final JButton ggProcess;
    private final EventManager elm = new EventManager((EventManager.Processor)this);
    private final ProcessorListener pl;
    private Window win;
    private int state = 0;
    private Processor proc;
    private Thread procThread;
    private static final String[] txt = new String[]{" Render ", "Stop", "Resume", "???"};

    public ProcessPanel(final int n, final ProgressPanel progressPanel, Processor processor) {
        this.setLayout(new BoxLayout(this, 0));
        this.pProgress = progressPanel;
        this.actionClose = new ActionClose("Close");
        this.actionProcess = new ActionProcess();
        this.pl = new ProcessorListener(){

            @Override
            public void processorProgress(ProcessorEvent processorEvent) {
                progressPanel.setProgression(processorEvent.getProcessor().getProgression());
            }

            @Override
            public void processorStarted(ProcessorEvent processorEvent) {
                ProcessPanel.this.actionClose.setEnabled(false);
                ProcessPanel.this.state = 1;
                if ((n & 4) != 0) {
                    progressPanel.setProgression(-1.0f);
                }
                this.updateSchnucki(processorEvent);
            }

            @Override
            public void processorStopped(ProcessorEvent processorEvent) {
                ProcessPanel.this.actionClose.setEnabled(true);
                if (processorEvent.getProcessor().getError() != null) {
                    progressPanel.finishProgression(1);
                } else if (processorEvent.getProcessor().getProgression() == 1.0f) {
                    progressPanel.finishProgression(0);
                } else if ((n & 4) != 0) {
                    progressPanel.resetProgression();
                }
                ProcessPanel.this.state = 0;
                this.updateSchnucki(processorEvent);
            }

            @Override
            public void processorPaused(ProcessorEvent processorEvent) {
                ProcessPanel.this.state = 2;
                progressPanel.pause();
                this.updateSchnucki(processorEvent);
            }

            @Override
            public void processorResumed(ProcessorEvent processorEvent) {
                ProcessPanel.this.state = 1;
                progressPanel.resume();
                this.updateSchnucki(processorEvent);
            }

            private void updateSchnucki(ProcessorEvent processorEvent) {
                ProcessPanel.this.actionProcess.updateState();
                if (ProcessPanel.this.state != 1) {
                    ProcessPanel.this.setEnabled(true);
                }
                ProcessPanel.this.elm.dispatchEvent((BasicEvent)new ProcessorEvent(processorEvent.getSource(), processorEvent.getID(), System.currentTimeMillis(), processorEvent.getProcessor()));
            }
        };
        this.ggProcess = new JButton(this.actionProcess);
        InputMap inputMap = this.ggProcess.getInputMap(2);
        ActionMap actionMap = this.ggProcess.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(46, 4), "stop");
        actionMap.put("stop", new ActionStop());
        this.add(progressPanel);
        this.add(this.ggProcess);
        this.add(Box.createHorizontalStrut(16));
        this.ggProcess.setFocusable(false);
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Dimension dimension = ProcessPanel.this.ggProcess.getPreferredSize();
                GUIUtil.constrainSize((JComponent)ProcessPanel.this.ggProcess, (int)dimension.width, (int)dimension.height);
            }
        });
        progressPanel.addCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProcessPanel.this.stop();
            }
        });
        this.setProcessor(processor);
    }

    public void setProcessor(Processor processor) {
        if (this.proc != null) {
            this.proc.removeProcessorListener(this.pl);
        }
        this.proc = processor;
        if (processor != null) {
            this.actionProcess.setEnabled(true);
            processor.addProcessorListener(this.pl);
        } else {
            this.actionProcess.setEnabled(false);
        }
    }

    public int getState() {
        return this.state;
    }

    public void start() {
        if (this.proc != null && this.state == 0) {
            this.setEnabled(false);
            this.pProgress.resetProgression();
            this.procThread = new Thread((Runnable)this.proc, this.proc.toString());
            this.procThread.start();
            this.state = 3;
        }
    }

    public void stop() {
        if (this.proc != null && (this.state == 1 || this.state == 2)) {
            this.setEnabled(false);
            this.proc.stop();
            if (this.procThread != null && !this.procThread.isAlive()) {
                this.pl.processorStopped(new ProcessorEvent(this.proc, 1, 0L, this.proc));
            }
        }
    }

    public void pause() {
        if (this.proc != null && this.state == 1) {
            this.setEnabled(false);
            this.proc.pause();
            if (this.procThread != null && !this.procThread.isAlive()) {
                this.pl.processorStopped(new ProcessorEvent(this.proc, 1, 0L, this.proc));
            }
        }
    }

    public void resume() {
        if (this.proc != null && this.state == 2) {
            this.setEnabled(false);
            this.proc.resume();
        }
    }

    public void addProcessorListener(ProcessorListener processorListener) {
        this.elm.addListener((Object)processorListener);
    }

    public void removeProcessorListener(ProcessorListener processorListener) {
        this.elm.removeListener((Object)processorListener);
    }

    public void processEvent(BasicEvent basicEvent) {
        block6: for (int i = 0; i < this.elm.countListeners(); ++i) {
            ProcessorListener processorListener = (ProcessorListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    processorListener.processorStarted((ProcessorEvent)basicEvent);
                    continue block6;
                }
                case 1: {
                    processorListener.processorStopped((ProcessorEvent)basicEvent);
                    continue block6;
                }
                case 2: {
                    processorListener.processorPaused((ProcessorEvent)basicEvent);
                    continue block6;
                }
                case 3: {
                    processorListener.processorResumed((ProcessorEvent)basicEvent);
                    continue block6;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block6;
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.actionProcess.setEnabled(bl);
    }

    public void setPaint(Paint paint) {
        this.pProgress.setPaint(paint);
    }

    public void setText(String string) {
        this.pProgress.setProgressionText(string);
    }

    private class ActionClose
    extends AbstractAction {
        protected ActionClose(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProcessPanel.this.state == 0 && ProcessPanel.this.win != null) {
                ProcessPanel.this.win.dispatchEvent(new WindowEvent(ProcessPanel.this.win, 201));
            }
        }
    }

    private class ActionStop
    extends AbstractAction {
        protected ActionStop() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProcessPanel.this.state == 1 || ProcessPanel.this.state == 2) {
                ProcessPanel.this.stop();
            }
        }
    }

    private class ActionProcess
    extends AbstractAction {
        protected ActionProcess() {
            super(txt[ProcessPanel.this.state]);
        }

        protected void updateState() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProcessPanel.this.state == 0) {
                ProcessPanel.this.start();
            }
        }
    }
}

