/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupStrip
extends JPopupMenu {
    protected Hashtable<String, JMenuItem> h = new Hashtable();
    protected ActionListener listener;

    public PopupStrip(String[][] stringArray, ActionListener actionListener) {
        this.listener = actionListener;
        PopupStrip.createStrip(this, this.h, stringArray, actionListener);
    }

    public boolean setItemEnabled(String string, boolean bl) {
        JMenuItem jMenuItem = this.h.get(string);
        if (jMenuItem != null) {
            jMenuItem.setEnabled(bl);
        }
        return jMenuItem != null;
    }

    public boolean setItemJLabel(String string, String string2) {
        JMenuItem jMenuItem = this.h.get(string);
        if (jMenuItem != null) {
            this.h.remove(string);
            PopupStrip.setItemLabelAndCut(jMenuItem, string2);
            this.h.put(string, jMenuItem);
        }
        return jMenuItem != null;
    }

    public JMenuItem getItem(String string) {
        return this.h.get(string);
    }

    public boolean addItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem();
        PopupStrip.setItemLabelAndCut(jMenuItem, string2);
        if (string != null) {
            JMenuItem jMenuItem2 = this.getItem(string);
            if (jMenuItem2 == null || !(jMenuItem2 instanceof JMenu)) {
                return false;
            }
            JMenu jMenu = (JMenu)jMenuItem2;
            jMenu.add(jMenuItem);
        } else {
            this.add(jMenuItem);
        }
        jMenuItem.addActionListener(this.listener);
        this.h.put(string2, jMenuItem);
        return true;
    }

    public boolean removeItem(String string) {
        JMenuItem jMenuItem = this.getItem(string);
        if (jMenuItem != null) {
            this.h.remove(string);
            jMenuItem.removeActionListener(this.listener);
            jMenuItem.getParent().remove(jMenuItem);
        }
        return jMenuItem != null;
    }

    public static void createStrip(JPopupMenu jPopupMenu, Hashtable<String, JMenuItem> hashtable, String[][] stringArray, ActionListener actionListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = stringArray[i].length > 1;
            JComponent jComponent = jPopupMenu;
            for (int j = 0; j < stringArray[i].length; ++j) {
                JMenuItem jMenuItem;
                String string = stringArray[i][j];
                if (string == null) {
                    if (jComponent instanceof JPopupMenu) {
                        ((JPopupMenu)jComponent).addSeparator();
                        continue;
                    }
                    if (!(jComponent instanceof JMenu)) continue;
                    ((JMenu)jComponent).addSeparator();
                    continue;
                }
                if (j == 0 && bl) {
                    jComponent = new JMenu();
                    jMenuItem = (JMenu)jComponent;
                    jPopupMenu.add(jMenuItem);
                } else {
                    jMenuItem = string.endsWith("#") ? new JCheckBoxMenuItem() : new JMenuItem();
                    if (jComponent instanceof JPopupMenu) {
                        ((JPopupMenu)jComponent).add(jMenuItem);
                    } else if (jComponent instanceof JMenu) {
                        ((JMenu)jComponent).add(jMenuItem);
                    }
                }
                PopupStrip.setItemLabelAndCut(jMenuItem, string);
                jMenuItem.addActionListener(actionListener);
                hashtable.put(string, jMenuItem);
            }
        }
    }

    public static void setItemLabelAndCut(JMenuItem jMenuItem, String string) {
        jMenuItem.setActionCommand(string);
        if (string.endsWith("#")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("&")) {
            string = string.substring(2);
        }
        jMenuItem.setText(string);
    }
}

