/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.fscape.Application;
import de.sciss.fscape.gui.SelectPathButton;
import de.sciss.fscape.gui.VirtualChoice;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.io.ImageStream;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.util.Util;
import de.sciss.gui.ColouredTextField;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFileDescr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class PathField
extends JPanel
implements ActionListener,
ComponentListener,
ItemListener,
PathListener,
EventManager.Processor {
    public static final int TYPE_BASICMASK = 15;
    public static final int TYPE_INPUTFILE = 0;
    public static final int TYPE_FORMATFIELD = 16;
    public static final int TYPE_RESFIELD = 32;
    public static final int TYPE_RATEFIELD = 64;
    public static final int TYPE_OUTPUTFILE = 1;
    public static final int TYPE_FOLDER = 2;
    public static final int SNDRES_16 = 0;
    public static final int SNDRES_24 = 1;
    public static final int SNDRES_32F = 2;
    public static final int SNDRES_32 = 3;
    public static final int SNDRES_NUM = 4;
    public static final int SNDRATE_96 = 0;
    public static final int SNDRATE_48 = 1;
    public static final int SNDRATE_44 = 2;
    public static final int SNDRATE_32 = 3;
    public static final int SNDRATE_NUM = 4;
    public static final int IMGRES_8 = 0;
    public static final int IMGRES_16 = 1;
    private static final float[] sndRate = new float[]{96000.0f, 48000.0f, 44100.0f, 32000.0f};
    private static final float[] spectRate = sndRate;
    private static final String[] sndResID = new String[]{"int16", "int24", "int32", "float32"};
    private static final String[] sndResTxt = new String[]{"16-bit int", "24-bit int", "32-bit float", "32-bit int"};
    private static final String[] sndRateTxt = new String[]{"96 kHz", "48 kHz", "44.1 kHz", "32 kHz"};
    private static final String[] spectRateTxt = sndRateTxt;
    private static final String[] imgResTxt = new String[]{"8-bit", "16-bit"};
    private static final String[] movRateTxt = new String[]{"8 fps", "10 fps", "12 fps", "15 fps", "24 fps", "25 fps", "29.97 fps", "30 fps"};
    private IOTextField ggPath;
    private SelectPathButton ggChoose;
    private ColouredTextField ggFormat = null;
    private VirtualChoice ggType = null;
    private VirtualChoice ggRes = null;
    private VirtualChoice ggRate = null;
    private static final Color COLOR_ERR = new Color(255, 0, 0, 47);
    private static final Color COLOR_EXISTS = new Color(0, 0, 255, 47);
    private static final Color COLOR_PROPSET = new Color(0, 255, 0, 47);
    protected final Vector<PathField> collChildren = new Vector();
    private int type;
    private int[] handledTypes = null;
    private String scheme;
    private String protoScheme;
    private PathField[] superPaths;
    private boolean init = true;
    private boolean enabled = true;
    protected static final int ABBR_LENGTH = 12;
    private final EventManager elm = new EventManager((EventManager.Processor)this);

    public PathField(int n, String string) {
        this.type = n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.ggPath = new IOTextField();
        this.ggChoose = new SelectPathButton(n, string);
        this.ggChoose.addPathListener(this);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints((Component)((Object)this.ggPath), gridBagConstraints);
        this.ggPath.addActionListener(this);
        this.add((Component)((Object)this.ggPath));
        if ((n & 0x10) != 0) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            if ((n & 0xF) == 0) {
                this.ggFormat = new ColouredTextField();
                this.ggFormat.setEditable(false);
                this.ggFormat.setFocusable(false);
                gridBagLayout.setConstraints((Component)this.ggFormat, gridBagConstraints);
                this.add((Component)this.ggFormat);
            } else {
                this.ggType = new VirtualChoice();
                gridBagConstraints.weightx = 0.3;
                gridBagLayout.setConstraints(this.ggType, gridBagConstraints);
                this.add(this.ggType);
                this.ggType.addSpecialItemListener(this);
                if ((n & 0x20) != 0) {
                    this.ggRes = new VirtualChoice();
                    ++gridBagConstraints.gridx;
                    gridBagLayout.setConstraints(this.ggRes, gridBagConstraints);
                    this.add(this.ggRes);
                }
                if ((n & 0x40) != 0) {
                    this.ggRate = new VirtualChoice();
                    ++gridBagConstraints.gridx;
                    gridBagLayout.setConstraints(this.ggRate, gridBagConstraints);
                    this.add(this.ggRate);
                }
            }
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.anchor = 18;
        } else {
            gridBagConstraints.gridheight = 2;
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.ggChoose, gridBagConstraints);
        this.add(this.ggChoose);
        this.deriveFrom(new PathField[]{}, this.ggType != null ? "$E" : "");
        this.addComponentListener(this);
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Font font = ((PathField)propertyChangeEvent.getSource()).getFont();
                PathField.this.ggPath.setFont(font);
                if (PathField.this.ggFormat != null) {
                    PathField.this.ggFormat.setFont(font);
                }
            }
        });
    }

    public static String getSoundResID(int n) {
        return sndResID[n];
    }

    public static int getSoundResIdx(String string) {
        for (int i = 0; i < sndResID.length; ++i) {
            if (!sndResID[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getSoundResDescr(int n) {
        return sndResTxt[n];
    }

    public static String getSoundRateID(int n) {
        return String.valueOf(sndRate[n]);
    }

    public static int getSoundRateIdx(String string) {
        for (int i = 0; i < sndRate.length; ++i) {
            if (!String.valueOf(sndRate[i]).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getSoundRateDescr(int n) {
        return sndRateTxt[n];
    }

    public void setPath(File file) {
        this.setPathIgnoreScheme(file);
        this.scheme = this.createScheme(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPathIgnoreScheme(File file) {
        this.ggPath.setText(file.getPath());
        this.ggChoose.setPath(file);
        Vector<PathField> vector = this.collChildren;
        synchronized (vector) {
            for (int i = 0; i < this.collChildren.size(); ++i) {
                this.collChildren.get(i).motherSpeaks(file);
            }
        }
        this.feedback();
    }

    protected void setPathAndDispatchEvent(File file) {
        this.setPathIgnoreScheme(file);
        this.elm.dispatchEvent((BasicEvent)new PathEvent((Object)this, 0, System.currentTimeMillis(), file));
    }

    public File getPath() {
        return new File(this.ggPath.getText());
    }

    public void setFormat(String string) {
        if (this.ggFormat != null) {
            this.ggFormat.setText(string);
        }
    }

    public String getFormat() {
        if (this.ggFormat != null) {
            return this.ggFormat.getText();
        }
        return null;
    }

    public void fillStream(AudioFileDescr audioFileDescr) {
        int n;
        audioFileDescr.file = this.getPath();
        if (this.ggType != null) {
            audioFileDescr.type = GenericFile.getAudioFileType(this.getType());
        }
        if (this.ggRes != null) {
            n = this.ggRes.getSelectedIndex();
            switch (n) {
                case 0: {
                    audioFileDescr.bitsPerSample = 16;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 1: {
                    audioFileDescr.bitsPerSample = 24;
                    audioFileDescr.sampleFormat = 0;
                    break;
                }
                case 2: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 1;
                    break;
                }
                case 3: {
                    audioFileDescr.bitsPerSample = 32;
                    audioFileDescr.sampleFormat = 0;
                }
            }
        }
        if (this.ggRate != null && (n = this.ggRate.getSelectedIndex()) >= 0 && n < sndRate.length) {
            audioFileDescr.rate = sndRate[n];
        }
    }

    public void fillStream(SpectStream spectStream) {
        int n;
        if (this.ggRate != null && (n = this.ggRate.getSelectedIndex()) >= 0 && n < spectRate.length) {
            spectStream.smpRate = spectRate[n];
        }
    }

    public void fillStream(ImageStream imageStream) {
        if (this.ggRes != null) {
            int n = this.ggRes.getSelectedIndex();
            switch (n) {
                case 0: {
                    imageStream.bitsPerSmp = 8;
                    break;
                }
                case 1: {
                    imageStream.bitsPerSmp = 16;
                }
            }
        }
    }

    public int getType() {
        if (this.ggType != null) {
            return GenericFile.getType(this.ggType.getSelectedItem().toString());
        }
        return 0;
    }

    public JComboBox getTypeGadget() {
        return this.ggType;
    }

    public JComboBox getResGadget() {
        return this.ggRes;
    }

    public JComboBox getRateGadget() {
        return this.ggRate;
    }

    public void deriveFrom(PathField[] pathFieldArray, String string) {
        this.superPaths = pathFieldArray;
        this.scheme = string;
        this.protoScheme = string;
        for (int i = 0; i < pathFieldArray.length; ++i) {
            pathFieldArray[i].addChildPathField(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildPathField(PathField pathField) {
        Vector<PathField> vector = this.collChildren;
        synchronized (vector) {
            if (!this.collChildren.contains(pathField)) {
                this.collChildren.add(pathField);
            }
        }
    }

    protected void motherSpeaks(File file) {
        this.setPathAndDispatchEvent(new File(this.evalScheme(this.scheme)));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        if (!bl) {
            this.ggChoose.requestFocus();
        }
        this.ggPath.setEnabled(bl);
        this.ggChoose.setEnabled(bl);
        if (this.ggType != null) {
            this.ggType.setEnabled(bl);
        }
        if (this.ggRes != null) {
            this.ggRes.setEnabled(bl);
        }
        if (this.ggRate != null) {
            this.ggRate.setEnabled(bl);
        }
        this.feedback();
        if (bl) {
            this.ggPath.requestFocus();
        }
    }

    public void addPathListener(PathListener pathListener) {
        this.elm.addListener((Object)pathListener);
    }

    public void removePathListener(PathListener pathListener) {
        this.elm.removeListener((Object)pathListener);
    }

    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            PathListener pathListener = (PathListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    pathListener.pathChanged((PathEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    public void handleTypes(int[] nArray) {
        this.handledTypes = nArray;
        if ((this.type & 0xF) == 1) {
            this.ggType.removeAllItems();
            for (int i = 0; i < nArray.length; ++i) {
                this.ggType.addItem(GenericFile.getTypeDescr(nArray[i]));
            }
        }
    }

    public void handleTypes(int[][] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n].length;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 0; n2 < nArray[n].length; ++n2) {
                nArray2[n3++] = nArray[n][n2];
            }
        }
        this.handleTypes(nArray2);
    }

    protected void calcFormat() {
        String string = this.getPath().getPath();
        String string2 = null;
        boolean bl = false;
        if (string.length() > 0 && this.enabled) {
            try {
                GenericFile genericFile = new GenericFile(string, 0);
                int n = genericFile.mode & 0xFFF0;
                string2 = genericFile.getTypeDescr();
                for (int i = 0; i < this.handledTypes.length; ++i) {
                    if (n != this.handledTypes[i]) continue;
                    this.setFormat(genericFile.getFormat());
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.setFormat("Wrong format - " + string2);
                }
                genericFile.cleanUp();
            }
            catch (IOException iOException) {
                this.setFormat((string2 == null ? "" : string2 + "; ") + "I/O Error: " + iOException.getMessage());
            }
        } else {
            this.setFormat("");
            bl = true;
        }
        this.ggFormat.setPaint((Paint)(bl ? null : COLOR_ERR));
    }

    protected void checkExist() {
        Color color;
        String string = this.getPath().getPath();
        boolean bl = false;
        if (string.length() > 0) {
            try {
                bl = new File(string).isFile();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Color color2 = color = bl && this.enabled ? COLOR_EXISTS : null;
        if (color != this.ggPath.getPaint()) {
            this.ggPath.setPaint(color);
        }
    }

    protected String evalScheme(String string) {
        int n;
        String string2;
        int n2;
        int n3 = string.indexOf("$D");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string = string.substring(0, n3) + string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1) + string.substring(n3 + 3);
            n3 = string.indexOf("$D", n3);
        }
        n3 = string.indexOf("$F");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string = string.substring(0, n3) + (n > 0 ? string2.substring(0, n) : string2) + string.substring(n3 + 3);
            n3 = string.indexOf("$F", n3);
        }
        n3 = string.indexOf("$X");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string = string.substring(0, n3) + (n > 0 ? string2.substring(n) : "") + string.substring(n3 + 3);
            n3 = string.indexOf("$X", n3);
        }
        n3 = string.indexOf("$B");
        while (n3 >= 0 && n3 < string.length() - 2) {
            n2 = string.charAt(n3 + 2) - 48;
            try {
                string2 = this.superPaths[n2].getPath().getPath();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = "";
            }
            string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            n = string2.lastIndexOf(46);
            string2 = PathField.abbreviate(n > 0 ? string2.substring(0, n) : string2);
            string = string.substring(0, n3) + string2 + string.substring(n3 + 3);
            n3 = string.indexOf("$B", n3);
        }
        n3 = string.indexOf("$E");
        while (n3 >= 0) {
            n2 = this.getType();
            string = string.substring(0, n3) + GenericFile.getExtStr(n2) + string.substring(n3 + 2);
            n3 = string.indexOf("$E", n3);
        }
        return string;
    }

    protected static String abbreviate(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (n = 0; n < n2 && stringBuffer.length() + n2 - n > 12; ++n) {
            c = string.charAt(n);
            if (!Character.isLetterOrDigit(c)) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append(string.substring(n));
        string = stringBuffer.toString();
        n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string.charAt(0));
        for (n = 1; n < n2 - 1 && stringBuffer.length() + n2 - n > 12; ++n) {
            c = string.charAt(n);
            if ("aeiou\u00e4\u00f6\u00fc".indexOf(c) >= 0) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append(string.substring(n));
        string = stringBuffer.toString();
        n2 = string.length();
        if (n2 <= 12) {
            return string;
        }
        n = 5;
        return string.substring(0, n) + '\'' + string.substring(string.length() - n);
    }

    protected String createScheme(String string) {
        String string2;
        int n;
        int n2 = 0;
        if (string.length() == 0) {
            return this.protoScheme;
        }
        for (n = 0; n < this.superPaths.length; ++n) {
            string2 = this.superPaths[n].getPath().getPath();
            if (!string.startsWith(string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1))) continue;
            string = "$D" + (char)(n + 48) + string.substring(string2.length());
            n2 = 3;
            break;
        }
        n2 = Math.max(n2, string.lastIndexOf(File.separatorChar) + 1);
        int n3 = -1;
        for (n = 0; n < this.superPaths.length; ++n) {
            boolean bl;
            string2 = this.superPaths[n].getPath().getPath();
            int n4 = (string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1)).lastIndexOf(46);
            String string3 = string2 = n4 > 0 ? string2.substring(0, n4) : string2;
            if (!this.protoScheme.contains("$B" + (char)(n + 48)) || n3 == n) {
                n4 = string.indexOf(string2, n2);
                if (n4 >= 0) {
                    string = string.substring(0, n4) + "$F" + (char)(n + 48) + string.substring(n4 + string2.length());
                    n2 = n4 + 3;
                    continue;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (n3 == n) continue;
            n4 = string.indexOf(string2 = PathField.abbreviate(string2), n2);
            if (n4 >= 0) {
                string = string.substring(0, n4) + "$B" + (char)(n + 48) + string.substring(n4 + string2.length());
                n2 = n4 + 3;
                continue;
            }
            if (bl) continue;
            n3 = n--;
        }
        string2 = GenericFile.getExtStr(this.getType());
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length()) + "$E";
        }
        return string;
    }

    protected String abbrScheme(String string) {
        int n = string.lastIndexOf("$F");
        if (n >= 0) {
            return string.substring(0, n) + "$B" + string.substring(n + 2);
        }
        return string;
    }

    protected String expandScheme(String string) {
        int n = string.indexOf("$B");
        if (n >= 0) {
            return string.substring(0, n) + "$F" + string.substring(n + 2);
        }
        return string;
    }

    protected String udirScheme(String string, String string2) {
        String string3 = Application.userPrefs.get(string2, null);
        if (string3 == null) {
            return string;
        }
        int n = string.startsWith("$D") ? 3 : string.lastIndexOf(File.separatorChar) + 1;
        return new File(string3, string.substring(n)).getPath();
    }

    protected void feedback() {
        if (this.handledTypes != null && (this.type & 0xF) == 0) {
            this.calcFormat();
        } else if ((this.type & 0xF) == 1) {
            this.checkExist();
        }
    }

    public void pathChanged(PathEvent pathEvent) {
        File file = pathEvent.getPath();
        this.scheme = this.createScheme(file.getPath());
        this.setPathAndDispatchEvent(file);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.ggPath.getText();
        if (string.length() == 0) {
            this.scheme = this.protoScheme;
            string = this.evalScheme(this.scheme);
        } else {
            this.scheme = this.createScheme(string);
        }
        this.setPathAndDispatchEvent(new File(string));
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.ggType != null && this.init) {
            this.init = false;
            this.itemStateChanged(new ItemEvent(this.ggType, 701, this.ggType.getSelectedItem(), 1));
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.ggType) {
            if (this.ggRes != null || this.ggRate != null) {
                int n;
                int n2;
                int n3 = this.getType();
                if (this.ggRes != null) {
                    n2 = this.ggRes.getSelectedIndex();
                    this.ggRes.removeAllItems();
                    if (Util.isValueInArray(n3, GenericFile.TYPES_SOUND)) {
                        for (n = 0; n < sndResTxt.length; ++n) {
                            this.ggRes.addItem(sndResTxt[n]);
                        }
                    } else if (Util.isValueInArray(n3, GenericFile.TYPES_IMAGE)) {
                        for (n = 0; n < imgResTxt.length; ++n) {
                            this.ggRes.addItem(imgResTxt[n]);
                        }
                    }
                    this.ggRes.setSelectedIndex(n2);
                }
                if (this.ggRate != null) {
                    n2 = this.ggRate.getSelectedIndex();
                    this.ggRate.removeAllItems();
                    if (Util.isValueInArray(n3, GenericFile.TYPES_SOUND)) {
                        for (n = 0; n < sndRateTxt.length; ++n) {
                            this.ggRate.addItem(sndRateTxt[n]);
                        }
                    } else if (Util.isValueInArray(n3, GenericFile.TYPES_SPECT)) {
                        for (n = 0; n < spectRateTxt.length; ++n) {
                            this.ggRate.addItem(spectRateTxt[n]);
                        }
                    } else if (Util.isValueInArray(n3, GenericFile.TYPES_MOVIE)) {
                        for (n = 0; n < movRateTxt.length; ++n) {
                            this.ggRate.addItem(movRateTxt[n]);
                        }
                    }
                    this.ggRate.setSelectedIndex(n2);
                }
            }
            this.setPathAndDispatchEvent(new File(this.evalScheme(this.scheme)));
        }
    }

    class IOTextField
    extends ColouredTextField {
        public IOTextField() {
            super(32);
            InputMap inputMap = this.getInputMap();
            ActionMap actionMap = this.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(37, 4), "abbr");
            actionMap.put("abbr", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.abbrScheme(PathField.this.scheme);
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(39, 4), "expd");
            actionMap.put("expd", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.expandScheme(PathField.this.scheme);
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(27, 4), "auto");
            actionMap.put("auto", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PathField.this.scheme = PathField.this.protoScheme;
                    PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
                }
            });
            for (int i = 1; i <= 9; ++i) {
                String string = "sudir" + i;
                inputMap.put(KeyStroke.getKeyStroke(96 + i, 5), string);
                actionMap.put(string, new SetUserDirAction(i));
                string = "rudir" + i;
                inputMap.put(KeyStroke.getKeyStroke(96 + i, 4), string);
                actionMap.put(string, new RecallUserDirAction(i));
            }
        }

        class RecallUserDirAction
        extends AbstractAction {
            private int idx;

            public RecallUserDirAction(int n) {
                this.idx = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PathField.this.scheme = PathField.this.udirScheme(PathField.this.scheme, "UserDir" + this.idx);
                PathField.this.setPathAndDispatchEvent(new File(PathField.this.evalScheme(PathField.this.scheme)));
            }
        }

        class SetUserDirAction
        extends AbstractAction {
            private int idx;
            private Timer visualFeedback;
            private Paint oldPaint = null;

            public SetUserDirAction(int n) {
                this.idx = n;
                this.visualFeedback = new Timer(250, this);
                this.visualFeedback.setRepeats(false);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.visualFeedback) {
                    PathField.this.ggPath.setPaint(this.oldPaint);
                } else {
                    String string = PathField.this.getPath().getParent();
                    if (string != null) {
                        Application.userPrefs.put("UserDir" + this.idx, string);
                        if (this.visualFeedback.isRunning()) {
                            this.visualFeedback.restart();
                        } else {
                            this.oldPaint = PathField.this.ggPath.getPaint();
                            PathField.this.ggPath.setPaint(COLOR_PROPSET);
                            this.visualFeedback.start();
                        }
                    }
                }
            }
        }
    }
}

