/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.app.BasicEvent;
import de.sciss.app.EventManager;
import de.sciss.fscape.gui.ParamEvent;
import de.sciss.fscape.gui.ParamListener;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.gui.Jog;
import de.sciss.gui.NumberEvent;
import de.sciss.gui.NumberField;
import de.sciss.gui.NumberListener;
import de.sciss.util.NumberSpace;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ParamField
extends JPanel
implements EventManager.Processor {
    private static final String[] dimTxt = new String[]{"", "", "ms", "Hz", "\u00b0"};
    private static final String[] specialTxt = new String[]{"", "beats", "semi", "dB"};
    private static final String percentTxt = "%";
    private static final String relTxt = "\u00b1";
    private GridBagLayout lay;
    private GridBagConstraints con;
    private NumberField ggNumber;
    private final Jog ggJog;
    private JComboBox ggUnits;
    private JLabel lbUnits;
    private final EventManager elm = new EventManager((EventManager.Processor)this);
    private Param reference = null;
    private ParamField refField = null;
    protected ParamSpace[] spaces;
    private int currentSpaceIdx;
    private ParamSpace currentSpace;

    public ParamField() {
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        this.spaces = new ParamSpace[1];
        this.spaces[0] = Constants.spaces[0];
        this.currentSpaceIdx = 0;
        this.currentSpace = this.spaces[this.currentSpaceIdx];
        this.lay = new GridBagLayout();
        this.con = new GridBagConstraints();
        this.ggNumber = new NumberField();
        this.ggNumber.setSpace((NumberSpace)this.currentSpace);
        this.ggJog = new Jog();
        this.ggUnits = new JComboBox();
        this.lbUnits = new JLabel();
        this.ggJog.addListener(new NumberListener(){

            public void numberChanged(NumberEvent numberEvent) {
                if (ParamField.this.currentSpace != null) {
                    boolean bl;
                    double d = numberEvent.getNumber().doubleValue() * ((ParamField)ParamField.this).currentSpace.inc;
                    Number number = ParamField.this.ggNumber.getNumber();
                    Number number2 = ParamField.this.currentSpace.isInteger() ? (Number)new Long((long)ParamField.this.currentSpace.fitValue((double)number.longValue() + d)) : (Number)new Double(ParamField.this.currentSpace.fitValue(number.doubleValue() + d));
                    boolean bl2 = bl = !((Object)number2).equals(number);
                    if (bl) {
                        ParamField.this.ggNumber.setNumber(number2);
                    }
                    if (bl || !numberEvent.isAdjusting()) {
                        ParamField.this.fireValueChanged(numberEvent.isAdjusting());
                    }
                }
            }
        });
        this.setLayout(this.lay);
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridwidth = 1;
        this.con.gridheight = 2;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.weighty = 1.0;
        this.lay.setConstraints((Component)this.ggJog, this.con);
        this.ggJog.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add((Component)this.ggJog);
        this.con.gridheight = 1;
        ++this.con.gridx;
        this.con.gridy = 1;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.lay.setConstraints((Component)this.ggNumber, this.con);
        this.ggNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParamField.this.dispatchChange();
            }
        });
        this.add((Component)this.ggNumber);
        ++this.con.gridx;
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        this.lay.setConstraints(this.ggUnits, this.con);
        this.lay.setConstraints(this.lbUnits, this.con);
        this.add(this.ggUnits);
        this.ggUnits.setVisible(false);
        this.ggUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ParamField.this.ggUnits.getSelectedIndex();
                if (n != ParamField.this.currentSpaceIdx) {
                    Param param = ParamField.this.getParam();
                    Param param2 = Param.transform(param, ParamField.this.spaces[n].unit, ParamField.this.refField == null ? ParamField.this.reference : ParamField.this.refField.makeReference(), null);
                    Param param3 = new Param(ParamField.this.spaces[n].fitValue(param2 == null ? param.value : param2.value), ParamField.this.spaces[n].unit);
                    ParamField.this.currentSpaceIdx = n;
                    ParamField.this.currentSpace = ParamField.this.spaces[ParamField.this.currentSpaceIdx];
                    ParamField.this.ggNumber.setSpace((NumberSpace)ParamField.this.currentSpace);
                    ParamField.this.ggNumber.setNumber(ParamField.this.paraToNumber(param3));
                    ParamField.this.dispatchChange();
                }
            }
        });
        this.add(this.lbUnits);
    }

    public ParamField(ParamSpace paramSpace) {
        this();
        ParamSpace[] paramSpaceArray = new ParamSpace[]{paramSpace};
        this.setSpaces(paramSpaceArray);
    }

    public ParamField(ParamSpace[] paramSpaceArray) {
        this();
        this.setSpaces(paramSpaceArray);
    }

    protected Number paraToNumber(Param param) {
        Number number = this.currentSpace.isInteger() ? (Number)new Long((long)param.value) : (Number)new Double(param.value);
        return number;
    }

    public void setSpaces(ParamSpace[] paramSpaceArray) {
        int n = this.spaces.length;
        this.spaces = paramSpaceArray;
        this.currentSpaceIdx = Math.min(paramSpaceArray.length - 1, this.currentSpaceIdx);
        this.currentSpace = paramSpaceArray[this.currentSpaceIdx];
        this.ggUnits.removeAllItems();
        if (paramSpaceArray.length > 1) {
            for (int i = 0; i < paramSpaceArray.length; ++i) {
                this.ggUnits.addItem(this.getUnitText(paramSpaceArray[i].unit));
            }
            if (n == 1) {
                this.lbUnits.setVisible(false);
                this.ggUnits.setVisible(true);
            }
        } else {
            this.lbUnits.setText(this.getUnitText(this.currentSpace.unit));
            if (n != 1) {
                this.ggUnits.setVisible(false);
                this.lbUnits.setVisible(true);
            }
        }
        this.ggNumber.setSpace((NumberSpace)this.currentSpace);
    }

    public ParamSpace getSpace() {
        return this.currentSpace;
    }

    public void setParam(Param param) {
        boolean bl;
        Number number = this.ggNumber.getNumber();
        int n = 0;
        int n2 = -99;
        for (int i = 0; i < this.spaces.length; ++i) {
            int n3 = Param.getPriority(param.unit, this.spaces[i].unit);
            if (n3 <= n2) continue;
            n2 = n3;
            n = i;
        }
        boolean bl2 = bl = this.currentSpaceIdx != n;
        if (bl) {
            this.currentSpaceIdx = n;
            this.currentSpace = this.spaces[this.currentSpaceIdx];
            this.ggNumber.setSpace((NumberSpace)this.currentSpace);
        }
        Number number2 = this.currentSpace.isInteger() ? (Number)new Long((long)param.value) : (Number)new Double(param.value);
        if (this.spaces.length > 1) {
            this.ggUnits.setSelectedIndex(this.currentSpaceIdx);
        }
        if (bl || !number2.equals(number)) {
            this.ggNumber.setNumber(number2);
        }
    }

    public void setReference(Param param) {
        this.reference = param;
    }

    public void setReference(ParamField paramField) {
        this.refField = paramField;
    }

    public Param makeReference() {
        int n = this.currentSpace.unit & 0xFFFFFF0F | 0;
        Param param = this.getParam();
        Param param2 = Param.transform(param, n, this.refField == null ? this.reference : this.refField.makeReference(), null);
        if (param2 == param) {
            return (Param)param2.clone();
        }
        return param2;
    }

    public Param getParam() {
        return new Param(this.ggNumber.getNumber().doubleValue(), this.currentSpace == null ? 0 : this.currentSpace.unit);
    }

    public void addParamListener(ParamListener paramListener) {
        this.elm.addListener((Object)paramListener);
    }

    public void removeParamListener(ParamListener paramListener) {
        this.elm.removeListener((Object)paramListener);
    }

    protected void fireValueChanged(boolean bl) {
        this.dispatchChange();
    }

    public void processEvent(BasicEvent basicEvent) {
        block3: for (int i = 0; i < this.elm.countListeners(); ++i) {
            ParamListener paramListener = (ParamListener)this.elm.getListener(i);
            switch (basicEvent.getID()) {
                case 0: {
                    paramListener.paramChanged((ParamEvent)basicEvent);
                    continue block3;
                }
                default: {
                    assert (false) : basicEvent.getID();
                    continue block3;
                }
            }
        }
    }

    protected void dispatchChange() {
        this.elm.dispatchEvent((BasicEvent)new ParamEvent(this, 0, System.currentTimeMillis(), this.getParam(), this.getSpace()));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl) {
            this.ggJog.requestFocus();
        }
        this.ggNumber.setEnabled(bl);
        this.ggJog.setEnabled(bl);
        if (this.ggUnits.isVisible()) {
            this.ggUnits.setEnabled(bl);
        }
        if (bl) {
            this.ggNumber.requestFocus();
        }
    }

    private String getUnitText(int n) {
        String string = specialTxt[(n & 0xF00) >> 8];
        switch (n & 0xF0) {
            case 0: {
                if (string.length() != 0) break;
                string = dimTxt[n & 0xF];
                break;
            }
            case 16: {
                string = string.length() == 0 ? percentTxt : string;
                break;
            }
            case 32: {
                string = "\u00b1 " + (string.length() == 0 ? dimTxt[n & 0xF] : string);
                break;
            }
            case 48: {
                string = "\u00b1 " + (string.length() == 0 ? percentTxt : string);
                break;
            }
        }
        return string;
    }
}

