/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class NeedleholeDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTER = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_LENGTH = 1;
    private static final int PR_THRESH = 2;
    private static final int PR_SUBDRY = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTER = "Filter";
    private static final String PRN_LENGTH = "Length";
    private static final String PRN_THRESH = "Thresh";
    private static final String PRN_SUBDRY = "SubDry";
    private static final int FILTER_MEDIAN = 0;
    private static final int FILTER_STDDEV = 1;
    private static final int FILTER_MINIMUM = 2;
    private static final int FILTER_CENTER = 3;
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Filter"};
    private static final Param[] prPara = new Param[]{null, new Param(50.0, 2), new Param(-18.0, 785)};
    private static final String[] prParaName = new String[]{"Gain", "Length", "Thresh"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"SubDry"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_FILTER = 259;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_LENGTH = 513;
    private static final int GG_THRESH = 514;
    private static final int GG_SUBDRY = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public NeedleholeDlg() {
        super("Needlehole Cherry Blossom");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            NeedleholeDlg.static_pr.text = prText;
            NeedleholeDlg.static_pr.textName = prTextName;
            NeedleholeDlg.static_pr.intg = prIntg;
            NeedleholeDlg.static_pr.intgName = prIntgName;
            NeedleholeDlg.static_pr.bool = prBool;
            NeedleholeDlg.static_pr.boolName = prBoolName;
            NeedleholeDlg.static_pr.para = prPara;
            NeedleholeDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(NeedleholeDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(NeedleholeDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = NeedleholeDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 259: {
                        ((NeedleholeDlg)NeedleholeDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        NeedleholeDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Bloss$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Peer-to-Peer Needle Sharing", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Window length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Median");
        jComboBox.addItem("Standard Deviation");
        jComboBox.addItem("Minimum");
        jComboBox.addItem("Center Clipping");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_FILTER, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 259, itemListener);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[5], Constants.spaces[7]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Clip thresh", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 514, null);
        JCheckBox jCheckBox = new JCheckBox("Subtract dry signal");
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block39: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[][] fArray4;
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            floatFileArray = null;
            fileArray = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                RunningWindowFilter runningWindowFilter;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n2 = audioFileDescr.channels;
                int n3 = (int)audioFileDescr.length;
                if (n3 * n2 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block39;
                long l = 0L;
                long l2 = (long)n3 * 3L;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block39;
                int n4 = Math.max(1, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)this.pr.para[1].value) + 0.5));
                int n5 = n4 >> 1;
                int n6 = Math.max(8192, n4);
                int n7 = n6 + n4;
                fArray4 = new float[n2][n7];
                fArray3 = new float[n2][n6];
                switch (this.pr.intg[3]) {
                    case 0: {
                        runningWindowFilter = new MedianFilter(n4, n2);
                        break;
                    }
                    case 1: {
                        runningWindowFilter = new StdDevFilter(n4, n2);
                        break;
                    }
                    case 2: {
                        runningWindowFilter = new MinimumFilter(n4, n2);
                        break;
                    }
                    case 3: {
                        runningWindowFilter = new CenterClippingFilter(n4, n2);
                        break;
                    }
                    default: {
                        assert (false) : this.pr.intg[3];
                        runningWindowFilter = null;
                    }
                }
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n2];
                    floatFileArray = new FloatFile[n2];
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n2; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n3;
                }
                if (this.pr.intg[2] == 1) {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block39;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (this.threadRunning && n8 < n3) {
                    int n11 = Math.min(n3 - n9, n7 - n10);
                    audioFile2.readFrames(fArray4, n10, n11);
                    n9 += n11;
                    this.setProgression((float)(l += (long)n11) / (float)l2);
                    if (this.threadRunning) {
                        float f3;
                        int n12;
                        int n13;
                        if (n10 + n11 < n7) {
                            for (n = 0; n < n2; ++n) {
                                fArray2 = fArray4[n];
                                for (n13 = n10 + n11; n13 < n7; ++n13) {
                                    fArray2[n13] = 0.0f;
                                }
                            }
                        }
                        int n14 = Math.min(n7 - n4, n3 - n8);
                        runningWindowFilter.process(fArray4, fArray3, 0, 0, n14);
                        if (this.pr.bool[0]) {
                            for (n = 0; n < n2; ++n) {
                                fArray2 = fArray3[n];
                                fArray = fArray4[n];
                                n13 = n5;
                                n12 = 0;
                                while (n12 < n14) {
                                    int n15 = n12++;
                                    fArray2[n15] = fArray2[n15] - fArray[n13];
                                    ++n13;
                                }
                            }
                        }
                        this.setProgression((float)(l += (long)n14) / (float)l2);
                        if (floatFileArray != null) {
                            for (n = 0; n < n2; ++n) {
                                fArray2 = fArray3[n];
                                floatFileArray[n].writeFloats(fArray2, 0, n14);
                                for (n13 = 0; n13 < n14; ++n13) {
                                    f3 = Math.abs(fArray2[n13]);
                                    if (!(f3 > f2)) continue;
                                    f2 = f3;
                                }
                            }
                        } else {
                            for (n = 0; n < n2; ++n) {
                                fArray2 = fArray3[n];
                                for (n12 = 0; n12 < n14; ++n12) {
                                    int n16 = n12;
                                    fArray2[n16] = fArray2[n16] * f;
                                    f3 = Math.abs(fArray2[n12]);
                                    if (!(f3 > f2)) continue;
                                    f2 = f3;
                                }
                            }
                            audioFile.writeFrames(fArray3, 0, n14);
                        }
                        n8 += n14;
                        for (n = 0; n < n2; ++n) {
                            System.arraycopy(fArray4[n], n7 - n4, fArray4[n], 0, n4);
                        }
                        n10 = n4;
                        this.setProgression((float)(l += (long)n14) / (float)l2);
                        continue;
                    }
                    break block39;
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    audioFileDescr = null;
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray3, f, 1.0f);
                        for (n = 0; n < n2; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                        f2 *= f;
                    }
                    audioFile.close();
                    audioFile = null;
                    this.handleClipping(f2);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                fArray4 = null;
                fArray3 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(514);
        if (component != null) {
            component.setEnabled(this.pr.intg[3] == 3);
        }
    }

    private class CenterClippingFilter
    extends RunningWindowFilter {
        final int channels;
        final int winSizeM1;
        final int[][] histogram;
        final int threshSum;
        boolean init;

        public CenterClippingFilter(int n, int n2) {
            this.init = false;
            this.channels = n2;
            this.winSizeM1 = n - 1;
            this.histogram = new int[n2][16384];
            this.threshSum = (int)(Param.transform((Param)((NeedleholeDlg)NeedleholeDlg.this).pr.para[2], (int)1, (Param)new Param((double)1.0, (int)1), null).value * (double)n + 0.5);
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                int n4;
                float f;
                int n5;
                int n6;
                int[] nArray = this.histogram[i];
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                if (!this.init) {
                    n6 = 0;
                    n5 = n;
                    while (n6 < this.winSizeM1) {
                        f = fArray3[n5];
                        int n7 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                        nArray[n7] = nArray[n7] + 1;
                        ++n6;
                        ++n5;
                    }
                }
                n6 = 0;
                n5 = n;
                int n8 = n2;
                while (n6 < n3) {
                    f = fArray3[n5 + this.winSizeM1];
                    int n9 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                    nArray[n9] = nArray[n9] + 1;
                    n4 = 0;
                    for (int j = 0; n4 < 8192 && j < this.threshSum; j += nArray[n4], ++n4) {
                    }
                    float f2 = (float)n4 / 16383.0f;
                    f2 = f2 * f2 * 4.0f;
                    f = fArray3[n5];
                    fArray4[n8] = f >= 0.0f ? Math.max(0.0f, f - f2) : Math.min(0.0f, f + f2);
                    f = fArray3[n5];
                    int n10 = n4 = (int)(Math.sqrt(Math.min(1.0f, Math.abs(f / 4.0f))) * 16383.5);
                    nArray[n10] = nArray[n10] - 1;
                    ++n6;
                    ++n5;
                    ++n8;
                }
            }
            this.init = true;
        }
    }

    private class MedianFilter
    extends RunningWindowFilter {
        final int winSize;
        final int medianOff;
        final int winSizeM;
        final int channels;
        final float[][] buf;
        final int[][] idxBuf;

        protected MedianFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.buf = new float[n2][n];
            this.idxBuf = new int[n2][n];
            this.medianOff = n >> 1;
            this.winSizeM = n - 1;
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                int n4;
                int n5;
                float f;
                int n6;
                float[] fArray3 = this.buf[i];
                float[] fArray4 = fArray[i];
                float[] fArray5 = fArray2[i];
                int[] nArray = this.idxBuf[i];
                int n7 = n;
                int n8 = n2;
                fArray3[0] = fArray4[n7++];
                nArray[0] = 0;
                for (n6 = 1; n6 < this.winSize; ++n6) {
                    f = fArray4[n7++];
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (!(f < fArray3[n5])) continue;
                        System.arraycopy(fArray3, n5, fArray3, n5 + 1, n6 - n5);
                        for (n4 = 0; n4 < n6; ++n4) {
                            if (nArray[n4] < n5) continue;
                            int n9 = n4;
                            nArray[n9] = nArray[n9] + 1;
                        }
                        break;
                    }
                    fArray3[n5] = f;
                    nArray[n6] = n5;
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    fArray5[n8++] = fArray3[this.medianOff];
                    n5 = nArray[n6 % this.winSize];
                    System.arraycopy(fArray3, n5 + 1, fArray3, n5, this.winSizeM - n5);
                    for (n4 = 0; n4 < this.winSize; ++n4) {
                        if (nArray[n4] <= n5) continue;
                        int n10 = n4;
                        nArray[n10] = nArray[n10] - 1;
                    }
                    f = fArray4[n7++];
                    for (n5 = 0; n5 < this.winSizeM; ++n5) {
                        if (!(f < fArray3[n5])) continue;
                        System.arraycopy(fArray3, n5, fArray3, n5 + 1, this.winSizeM - n5);
                        for (n4 = 0; n4 < this.winSize; ++n4) {
                            if (nArray[n4] < n5) continue;
                            int n11 = n4;
                            nArray[n11] = nArray[n11] + 1;
                        }
                        break;
                    }
                    fArray3[n5] = f;
                    nArray[n6 % this.winSize] = n5;
                }
            }
        }
    }

    private class MinimumFilter
    extends RunningWindowFilter {
        final int winSize;
        final int channels;
        final int winSizeM1;

        public MinimumFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.winSizeM1 = n - 1;
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                int n4 = -1;
                float f = 0.0f;
                int n5 = 0;
                int n6 = n;
                int n7 = n2;
                while (n5 < n3) {
                    float f2;
                    if (n4 < n6) {
                        f2 = Math.abs(fArray3[n6]);
                        n4 = n6;
                        int n8 = 1;
                        int n9 = n6 + 1;
                        while (n8 < this.winSize) {
                            float f3 = Math.abs(fArray3[n9]);
                            if (f3 < f2) {
                                f2 = f3;
                                n4 = n9;
                            }
                            ++n8;
                            ++n9;
                        }
                        f = fArray3[n4];
                    } else {
                        f2 = fArray3[n6 + this.winSizeM1];
                        if (Math.abs(f2) < Math.abs(f)) {
                            f = f2;
                            n4 = n6 + this.winSizeM1;
                        }
                    }
                    fArray4[n7] = f;
                    --n4;
                    ++n5;
                    ++n6;
                    ++n7;
                }
            }
        }
    }

    private class StdDevFilter
    extends RunningWindowFilter {
        final int winSize;
        final int channels;
        final double[][] dcMem;
        final int winSizeM1;

        public StdDevFilter(int n, int n2) {
            this.winSize = n;
            this.channels = n2;
            this.winSizeM1 = n - 1;
            this.dcMem = new double[n2][2];
        }

        @Override
        public void process(float[][] fArray, float[][] fArray2, int n, int n2, int n3) throws IOException {
            for (int i = 0; i < this.channels; ++i) {
                double[] dArray = this.dcMem[i];
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray2[i];
                double d = 0.0;
                int n4 = 0;
                int n5 = n;
                while (n4 < this.winSizeM1) {
                    d += (double)fArray3[n5];
                    ++n4;
                    ++n5;
                }
                double d2 = 0.0;
                int n6 = 0;
                n5 = n;
                int n7 = n2;
                while (n6 < n3) {
                    double d3;
                    d = d - d2 + (double)fArray3[n5 + this.winSizeM1];
                    double d4 = d / (double)this.winSize;
                    double d5 = 0.0;
                    n4 = 0;
                    int n8 = n5;
                    while (n4 < this.winSize) {
                        d3 = (double)fArray3[n8] - d4;
                        d5 += d3 * d3;
                        ++n4;
                        ++n8;
                    }
                    d3 = Math.sqrt(d5);
                    double d6 = d3 - dArray[0] + 0.99 * dArray[1];
                    fArray4[n7] = (float)d6;
                    dArray[0] = d3;
                    dArray[1] = d6;
                    d2 = fArray3[n5];
                    ++n6;
                    ++n5;
                    ++n7;
                }
            }
        }
    }

    abstract class RunningWindowFilter {
        RunningWindowFilter() {
        }

        public abstract void process(float[][] var1, float[][] var2, int var3, int var4, int var5) throws IOException;
    }
}

