/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.FilterBox;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.ConstQ;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.Marker;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class MosaicDlg
extends ModulePanel {
    private static final int PR_INIMGFILE = 0;
    private static final int PR_INMATFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTERTYPE = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_MINFREQ = 1;
    private static final int PR_MAXFREQ = 2;
    private static final int PR_DURATION = 3;
    private static final int PR_TIMEOVERLAP = 4;
    private static final int PR_TIMEJITTER = 5;
    private static final int PR_FREQOVERLAP = 6;
    private static final int PR_FREQJITTER = 7;
    private static final int PR_NOISEFLOOR = 8;
    private static final int PR_MAXBOOST = 9;
    private static final int PR_ATTACK = 10;
    private static final int PR_RELEASE = 11;
    private static final int PR_READMARKERS = 0;
    private static final String PRN_INIMGFILE = "InImgFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_INMATFILE = "InMatFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTERTYPE = "FilterType";
    private static final String PRN_MINFREQ = "MinFreq";
    private static final String PRN_MAXFREQ = "MaxFreq";
    private static final String PRN_DURATION = "Duration";
    private static final String PRN_TIMEOVERLAP = "TimeOverlap";
    private static final String PRN_TIMEJITTER = "TimeJitter";
    private static final String PRN_FREQOVERLAP = "FreqOverlap";
    private static final String PRN_FREQJITTER = "FreqJitter";
    private static final String PRN_NOISEFLOOR = "NoiseFloor";
    private static final String PRN_MAXBOOST = "MaxBoost";
    private static final String PRN_ATTACK = "Attack";
    private static final String PRN_RELEASE = "Release";
    private static final String PRN_READMARKERS = "ReadMarkers";
    private static final int FILTER_NONE = 0;
    private static final int FILTER_HIGHPASS = 1;
    private static final int FILTER_LOWPASS = 2;
    private static final int FILTER_BANDPASS = 3;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InImgFile", "InMatFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 3};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FilterType"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "MinFreq", "MaxFreq", "Duration", "TimeOverlap", "TimeJitter", "FreqOverlap", "FreqJitter", "NoiseFloor", "MaxBoost", "Attack", "Release"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"ReadMarkers"};
    private static final int GG_INIMGFILE = 1024;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_INMATFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FILTERTYPE = 259;
    private static final int GG_GAIN = 512;
    private static final int GG_MINFREQ = 513;
    private static final int GG_MAXFREQ = 514;
    private static final int GG_DURATION = 515;
    private static final int GG_TIMEOVERLAP = 516;
    private static final int GG_TIMEJITTER = 517;
    private static final int GG_FREQOVERLAP = 518;
    private static final int GG_FREQJITTER = 519;
    private static final int GG_NOISEFLOOR = 520;
    private static final int GG_MAXBOOST = 521;
    private static final int GG_ATTACK = 522;
    private static final int GG_RELEASE = 523;
    private static final int GG_READMARKERS = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public MosaicDlg() {
        super("Mosaic");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            MosaicDlg.static_pr.text = prText;
            MosaicDlg.static_pr.textName = prTextName;
            MosaicDlg.static_pr.intg = prIntg;
            MosaicDlg.static_pr.intgName = prIntgName;
            MosaicDlg.static_pr.bool = prBool;
            MosaicDlg.static_pr.boolName = prBoolName;
            MosaicDlg.static_pr.para = prPara;
            MosaicDlg.static_pr.para[1] = new Param(32.0, 3);
            MosaicDlg.static_pr.para[2] = new Param(18000.0, 3);
            MosaicDlg.static_pr.para[3] = new Param(60000.0, 2);
            MosaicDlg.static_pr.para[4] = new Param(100.0, 18);
            MosaicDlg.static_pr.para[5] = new Param(50.0, 18);
            MosaicDlg.static_pr.para[6] = new Param(100.0, 19);
            MosaicDlg.static_pr.para[7] = new Param(50.0, 19);
            MosaicDlg.static_pr.para[8] = new Param(-96.0, 785);
            MosaicDlg.static_pr.para[9] = new Param(96.0, 785);
            MosaicDlg.static_pr.para[10] = new Param(2.0, 2);
            MosaicDlg.static_pr.para[11] = new Param(100.0, 2);
            MosaicDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(MosaicDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(MosaicDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = MosaicDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 0: {
                        ((MosaicDlg)MosaicDlg.this).pr.bool[n - 0] = ((JCheckBox)itemEvent.getSource()).isSelected();
                        MosaicDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(0, "Select input image file");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Image input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select input audio file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Audio input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Mos$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Mosaic output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[8]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Nominal Duration", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 515, null);
        ParamField paramField2 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Min Freq.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 513, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("None");
        jComboBox.addItem("Highpass");
        jComboBox.addItem("Lowpass");
        jComboBox.addItem("Bandpass");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Filter Type", 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox, 259, itemListener);
        ParamField paramField3 = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max Freq.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField3, 514, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Read Markers", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        ParamField paramField4 = new ParamField(Constants.spaces[10]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Time Spacing", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField4, 516, null);
        ParamField paramField5 = new ParamField(new ParamSpace(100.0, 1000000.0, 0.01, 19));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Freq Spacing", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 518, null);
        ParamField paramField6 = new ParamField(Constants.spaces[10]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Time Jitter", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField6, 517, null);
        ParamField paramField7 = new ParamField(Constants.spaces[16]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Freq Jitter", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField7, 519, null);
        ParamField paramField8 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max Boost", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField8, 521, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[10]};
        ParamField paramField9 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_ATTACK, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField9, 522, null);
        ParamField paramField10 = new ParamField(Constants.spaces[7]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Noise Floor", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField10, 520, null);
        ParamField paramField11 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_RELEASE, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField11, 523, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        AudioFile audioFile2;
        block64: {
            BufferedImage bufferedImage = null;
            audioFile2 = null;
            audioFile = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            Random random = new Random();
            double d = this.pr.para[1].value;
            double d2 = this.pr.para[2].value;
            double d3 = this.pr.para[3].value;
            double d4 = this.pr.para[4].value / 100.0;
            double d5 = this.pr.para[6].value / 100.0;
            int n = this.pr.intg[3];
            boolean bl = this.pr.bool[0];
            float[] fArray = new float[3];
            double d6 = this.pr.para[5].value / 100.0;
            double d7 = this.pr.para[7].value / 100.0;
            double d8 = Param.transform((Param)this.pr.para[9], (int)1, (Param)param, null).value;
            double d9 = Param.transform((Param)this.pr.para[8], (int)1, (Param)param, null).value;
            int n2 = -1;
            int n3 = -1;
            float[] fArray2 = null;
            float[] fArray3 = null;
            try {
                int n4;
                int n5;
                int n6;
                long l;
                int n7;
                List list;
                bufferedImage = ImageIO.read(new File(this.pr.text[0]));
                if (bufferedImage == null) {
                    throw new IOException("No matching image decoder found");
                }
                if (!this.threadRunning) break block64;
                audioFile = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                AudioFileDescr audioFileDescr = audioFile.getDescr();
                int n8 = audioFileDescr.channels;
                long l2 = audioFileDescr.length;
                if (l2 < 1L || n8 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block64;
                PathField pathField = (PathField)this.gui.getItemObj(1026);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block64;
                ConstQ constQ = new ConstQ();
                constQ.setSampleRate(audioFileDescr.rate);
                constQ.setMinFreq((float)d);
                constQ.setMaxFreq((float)d2);
                constQ.setMaxFFTSize(8192);
                constQ.setMaxTimeRes(20.0f);
                constQ.createKernels();
                int n9 = constQ.getFFTSize();
                int n10 = constQ.getNumKernels();
                if (this.pr.intg[2] == 1) {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                AudioFile audioFile3 = this.createTempFile(audioFileDescr2);
                int n11 = bufferedImage.getWidth();
                int n12 = bufferedImage.getHeight();
                double d10 = AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d3) / (double)n11;
                if (bl) {
                    audioFile.readMarkers();
                    list = (List)audioFileDescr.getProperty((Object)"markers");
                    if (list == null || list.isEmpty()) {
                        throw new IOException("Soundfile does not contain markers");
                    }
                    Collections.sort(list);
                    Marker marker = (Marker)list.get(0);
                    if (marker.pos == 0L) {
                        list.remove(0);
                    }
                    marker = (Marker)list.get(list.size() - 1);
                    if (marker.pos < l2) {
                        list.add(new Marker(l2, "End"));
                    }
                    n7 = 0;
                    l = 0L;
                    for (n6 = 0; n6 < list.size(); ++n6) {
                        long l3 = ((Marker)list.get((int)n6)).pos;
                        n7 = Math.max(n7, (int)(l3 - l));
                        l = l3;
                    }
                    n5 = n7;
                } else {
                    n5 = (int)(d10 * d4 + 0.5);
                    list = null;
                }
                int n13 = Math.max(8192, n5);
                int n14 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)20.0) + 0.5);
                int n15 = Math.max(0, n5 - n9) / n14 + 1;
                float[][] fArray4 = new float[n8][n13];
                float[][] fArray5 = new float[n8][n13];
                float[][] fArray6 = new float[n15][n10];
                float[] fArray7 = new float[n10];
                int n16 = (int)((double)n10 / (double)n12 + 0.5);
                int n17 = Math.max(0, n10 - n16) + 1;
                int n18 = (int)((double)n17 * 0.9 + 0.5);
                int n19 = n17 - n18;
                double[] dArray = new double[n17];
                double[] dArray2 = new double[n17];
                Integer[] integerArray = new Integer[n17];
                for (n6 = 0; n6 < n17; ++n6) {
                    integerArray[n6] = new Integer(n6);
                }
                Object[] objectArray = new Integer[n17];
                double d11 = audioFileDescr.rate / 2.0;
                double d12 = Math.PI / d11;
                double d13 = 0.4052847345693511;
                long l4 = (n11 + 1) * n12 * n13;
                long l5 = 0L;
                l = 0L;
                int n20 = 0;
                int n21 = n5;
                for (n6 = 0; n6 < n11; ++n6) {
                    for (int i = 0; this.threadRunning && i < n12; ++i) {
                        int n22;
                        int n23;
                        double d14;
                        double d15;
                        double d16;
                        int n24;
                        int n25;
                        int n26;
                        int n27 = bufferedImage.getRGB(n6, i);
                        Color.RGBtoHSB(n27 >> 16 & 0xFF, n27 >> 8 & 0xFF, n27 & 0xFF, fArray);
                        float f3 = fArray[2];
                        if (f3 == 0.0f) {
                            l5 += (long)n13;
                            continue;
                        }
                        long l6 = audioFile.getFramePosition();
                        if (bl) {
                            if (n20 == list.size()) {
                                n20 = 0;
                                l = 0L;
                                audioFile.seekFrame(0L);
                            }
                            long l7 = ((Marker)list.get((int)n20++)).pos;
                            n21 = (int)(l7 - l);
                            l = l7;
                        } else if (l6 == l2) {
                            audioFile.seekFrame(0L);
                        }
                        n4 = (int)Math.min(l2 - l6, (long)n21);
                        audioFile.readFrames(fArray4, 0, n4);
                        for (n26 = 0; n26 < n17; ++n26) {
                            dArray[n26] = 0.0;
                            dArray2[n26] = 0.0;
                        }
                        int n28 = Math.max(0, n21 - n9) / n14 + 1;
                        n26 = 0;
                        int n29 = 0;
                        while (n26 < n28) {
                            float f4;
                            float f5;
                            n25 = Math.max(0, Math.min(n9, n4 - n29));
                            constQ.transform(fArray4[0], n29, n25, fArray6[n26], 0);
                            for (n24 = 1; n24 < n8; ++n24) {
                                constQ.transform(fArray4[n24], n29, n25, fArray7, 0);
                                Util.add(fArray7, 0, fArray6[n26], 0, n10);
                            }
                            d16 = 0.0;
                            d15 = 0.0;
                            float f6 = Util.mean(fArray6[n26], 0, n10);
                            for (n24 = 0; n24 < n16; ++n24) {
                                f5 = fArray6[n26][n24];
                                f4 = f5 - f6;
                                d16 += (double)(f5 * f5);
                                d15 += (double)(f4 * f4);
                            }
                            dArray[0] = dArray[0] + d16;
                            dArray2[0] = dArray2[0] + d15;
                            n24 = 1;
                            int n30 = n16;
                            while (n24 < n17) {
                                f5 = fArray6[n26][n30 - n16];
                                f4 = f5 - f6;
                                d16 -= (double)(f5 * f5);
                                d15 -= (double)(f4 * f4);
                                f5 = fArray6[n26][n30];
                                f4 = f5 - f6;
                                int n31 = n24;
                                dArray[n31] = dArray[n31] + (d16 += (double)(f5 * f5));
                                int n32 = n24++;
                                dArray2[n32] = dArray2[n32] + (d15 += (double)(f4 * f4));
                                ++n30;
                            }
                            ++n26;
                            n29 += n14;
                        }
                        System.arraycopy(integerArray, 0, objectArray, 0, n17);
                        Util.sort(dArray, objectArray, 0, n17);
                        int n33 = (int)(f3 * (float)n18 + (float)n19 + 0.5f);
                        int n34 = -1;
                        double d17 = Double.POSITIVE_INFINITY;
                        double d18 = 0.0;
                        for (n26 = n17 - n33; n26 < n17; ++n26) {
                            int n35 = (Integer)objectArray[n26];
                            if (!(dArray2[n35] < d17)) continue;
                            d17 = dArray2[n35];
                            d18 = dArray[n35];
                            n34 = n35;
                        }
                        double d19 = Util.linexp(n34, 0.0, n17 - 1, d, d2);
                        double d20 = Util.linexp(i, n12 - 1, 0.0, d, d2);
                        double d21 = d20 - d19;
                        long l8 = n4;
                        double d22 = d14 = audioFileDescr.rate * 0.245;
                        d22 *= Math.PI * 2 / audioFileDescr.rate;
                        d21 *= Math.PI * 2 / audioFileDescr.rate;
                        FilterBox filterBox = new FilterBox();
                        filterBox.filterType = 1;
                        filterBox.cutOff = new Param(d14, 3);
                        Point point = filterBox.calcLength(audioFileDescr, 3);
                        int n36 = point.x * 2;
                        n7 = (point.x + point.y) * 2 - 1;
                        int n37 = n7 + n7 - 1;
                        for (n23 = 2; n23 < n37; n23 <<= 1) {
                        }
                        int n38 = n23 - n7 - 1;
                        float[] fArray8 = new float[n23 << 1];
                        float[] fArray9 = new float[n23 << 1];
                        int n39 = n23 - n38;
                        float[][] fArray10 = new float[n8][n39];
                        filterBox.calcIR(audioFileDescr, 3, 1, fArray8, point);
                        Fourier.realTransform(fArray8, n23, 1);
                        for (n26 = 0; n26 <= n23; n26 += 2) {
                            d16 = fArray8[n26];
                            d15 = fArray8[n26 + 1];
                            fArray8[n26] = (float)(d16 * d16 - d15 * d15);
                            fArray8[n26 + 1] = (float)(2.0 * d16 * d15);
                        }
                        Fourier.realTransform(fArray8, n23, -1);
                        n26 = n23 - 1;
                        n29 = n26 - point.x;
                        n24 = fArray8.length - 1;
                        while (n26 >= 0) {
                            d16 = -d22 * (double)n29;
                            fArray8[n24--] = (float)((double)fArray8[n26] * Math.sin(d16));
                            fArray8[n24--] = (float)((double)fArray8[n26] * Math.cos(d16));
                            --n26;
                            --n29;
                        }
                        Fourier.complexTransform(fArray8, n23, 1);
                        long l9 = 0L;
                        for (long j = 0L; this.threadRunning && j < l8; j += (long)Math.max(0, n22 - n36)) {
                            int n40 = (int)Math.min((long)n38, l8 - l9);
                            n22 = (int)Math.min((long)n38, l8 - j);
                            for (n26 = 0; n26 < n8; ++n26) {
                                if (n40 > 0) {
                                    System.arraycopy(fArray4[n26], (int)l9, fArray9, 0, n40);
                                    for (n29 = n40; n29 < n23; ++n29) {
                                        fArray9[n29] = 0.0f;
                                    }
                                    Fourier.realTransform(fArray9, n23, 1);
                                    n29 = n23;
                                    n24 = n23;
                                    while (n29 > 0) {
                                        fArray9[n24] = fArray9[n29];
                                        fArray9[n24 + 1] = -fArray9[n29 + 1];
                                        n29 -= 2;
                                        n24 += 2;
                                    }
                                    Fourier.complexMult(fArray8, 0, fArray9, 0, fArray9, 0, n23 << 1);
                                    Fourier.complexTransform(fArray9, n23, -1);
                                    long l10 = l9;
                                    n24 = 0;
                                    for (n29 = 0; n29 < n23; ++n29) {
                                        d16 = d21 * (double)l10++;
                                        fArray9[n29] = (float)((double)fArray9[n24++] * Math.cos(d16) + (double)fArray9[n24++] * Math.sin(d16));
                                    }
                                } else {
                                    Util.clear(fArray9);
                                }
                                Util.add(fArray10[n26], 0, fArray9, 0, n39);
                                System.arraycopy(fArray9, n22, fArray10[n26], 0, n39);
                                System.arraycopy(fArray9, n36, fArray4[n26], (int)j, Math.max(0, n22 - n36));
                            }
                            l9 += (long)n40;
                            if (n36 <= 0) continue;
                            n36 = Math.max(0, n36 - n22);
                        }
                        long l11 = n4;
                        if (n != 0) {
                            int n41;
                            int n42;
                            double d23;
                            double d24;
                            double d25;
                            double d26;
                            double d27 = (random.nextDouble() * 2.0 - 1.0) * d7;
                            if (n == 2) {
                                d26 = 0.0;
                                d25 = 0.0;
                            } else {
                                d26 = Math.max(0.0, Util.linexp((double)i + d27 - 0.5, n12 - 1, 0.0, d, d2));
                                d25 = d26 - Math.max(0.0, Util.linexp((double)i + d27 - 0.5 - (d5 - 1.0), n12 - 1, 0.0, d, d2));
                            }
                            if (n == 1) {
                                d24 = d11;
                                d23 = 0.0;
                            } else {
                                d24 = Math.min(d11, Util.linexp((double)i + d27 + 0.5, n12 - 1, 0.0, d, d2));
                                d23 = Math.min(d11, Util.linexp((double)i + d27 + 0.5 + (d5 - 1.0), n12 - 1, 0.0, d, d2)) - d24;
                            }
                            int n43 = Math.max(1, (int)(6.0 * audioFileDescr.rate / d24 + 0.5));
                            int n44 = n43 + n43;
                            float[] fArray11 = Filter.createFullWindow(n44, 1);
                            n7 = n44 + n44 - 1;
                            for (n42 = 2; n42 < n7; n42 <<= 1) {
                            }
                            int n45 = n42 - n44 + 1;
                            int n46 = n42 - n45;
                            float[] fArray12 = new float[n42 + 2];
                            float[] fArray13 = new float[n42 + 2];
                            float[][] fArray14 = new float[n8][n46];
                            double d28 = d12 * d24;
                            double d29 = d12 * d23;
                            for (n26 = 1; n26 < n43; ++n26) {
                                d16 = Math.sin(d28 * (double)n26) / (double)n26;
                                d15 = d13 * d29 * (double)n26 * d29 * (double)n26;
                                fArray12[n43 + n26] = (float)(d16 *= Math.cos(d29 * (double)n26) / (1.0 - d15));
                                fArray12[n43 - n26] = (float)d16;
                            }
                            fArray12[n43] = (float)d28;
                            d28 = d12 * d26;
                            d29 = d12 * d25;
                            for (n26 = 1; n26 < n43; ++n26) {
                                d16 = Math.sin(d28 * (double)n26) / (double)n26;
                                d15 = d13 * d29 * (double)n26 * d29 * (double)n26;
                                int n47 = n43 + n26;
                                fArray12[n47] = fArray12[n47] - (float)(d16 *= Math.cos(d29 * (double)n26) / (1.0 - d15));
                                int n48 = n43 - n26;
                                fArray12[n48] = fArray12[n48] - (float)d16;
                            }
                            int n49 = n43;
                            fArray12[n49] = fArray12[n49] - (float)d28;
                            for (n26 = n44; n26 < n42; ++n26) {
                                fArray12[n26] = 0.0f;
                            }
                            Util.mult(fArray11, 0, fArray12, 0, n44);
                            Fourier.realTransform(fArray12, n42, 1);
                            long l12 = 0L;
                            int n50 = n43;
                            for (long j = 0L; this.threadRunning && j < l11; j += (long)Math.max(0, n41 - n50)) {
                                int n51 = (int)Math.min((long)n45, l11 - l12);
                                n41 = (int)Math.min((long)n45, l11 - j);
                                for (n26 = 0; this.threadRunning && n26 < n8; ++n26) {
                                    if (n51 > 0) {
                                        System.arraycopy(fArray4[n26], (int)l12, fArray13, 0, n51);
                                        for (n29 = n51; n29 < n42; ++n29) {
                                            fArray13[n29] = 0.0f;
                                        }
                                        Fourier.realTransform(fArray13, n42, 1);
                                        Fourier.complexMult(fArray13, 0, fArray12, 0, fArray13, 0, fArray12.length);
                                        Fourier.realTransform(fArray13, n42, -1);
                                    } else {
                                        Util.clear(fArray13);
                                    }
                                    Util.add(fArray14[n26], 0, fArray13, 0, n46);
                                    System.arraycopy(fArray13, n41, fArray14[n26], 0, n46);
                                    System.arraycopy(fArray13, n50, fArray4[n26], (int)j, Math.max(0, n41 - n50));
                                }
                                l12 += (long)n51;
                                if (n50 <= 0) continue;
                                n50 = Math.max(0, n50 - n41);
                            }
                            if (!this.threadRunning) break block64;
                        }
                        Param param2 = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr2, (long)n21), 2);
                        n7 = Math.min(n21, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr2, (double)Param.transform((Param)this.pr.para[10], (int)2, (Param)param2, null).value) + 0.5));
                        if (n7 != n2) {
                            n2 = n7;
                            fArray2 = Filter.createWindow(n2, 7);
                            Util.reverse(fArray2, 0, n2);
                        }
                        if ((n7 = Math.min(n21 - n2, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr2, (double)Param.transform((Param)this.pr.para[11], (int)2, (Param)param2, null).value) + 0.5))) != n3) {
                            n3 = n7;
                            fArray3 = Filter.createWindow(n3, 7);
                        }
                        Util.mult(fArray2, 0, fArray4, 0, n2);
                        Util.mult(fArray3, Math.max(0, n3 - n4), fArray4, Math.max(0, n4 - n3), Math.min(n3, n4));
                        float f7 = f * (float)Math.min(d8, Util.linexp(f3, 0.0, 1.0, d9, 1.0) / Math.sqrt(d18 / (double)(n28 * n17)));
                        Util.mult(fArray4, 0, n4, f7);
                        long l13 = Math.max(0L, (long)((double)n6 * d10 + (random.nextDouble() * 2.0 - 1.0) * d6 * d10 + 0.5));
                        if (audioFile3.getFrameNum() < l13) {
                            audioFile3.setFrameNum(l13);
                        }
                        audioFile3.seekFrame(l13);
                        n25 = (int)Math.min((long)n4, audioFile3.getFrameNum() - l13);
                        if (n25 > 0) {
                            audioFile3.readFrames(fArray5, 0, n25);
                            Util.add(fArray5, 0, fArray4, 0, n25);
                            audioFile3.seekFrame(l13);
                        }
                        audioFile3.writeFrames(fArray4, 0, n4);
                        this.setProgression((float)(l5 += (long)n13) / (float)l4);
                    }
                    if (this.threadRunning) {
                        continue;
                    }
                    break block64;
                }
                audioFile.close();
                audioFile = null;
                audioFile3.seekFrame(0L);
                for (long i = 0L; this.threadRunning && i < audioFile3.getFrameNum(); i += (long)n4) {
                    n4 = (int)Math.min((long)n13, audioFile3.getFrameNum() - i);
                    audioFile3.readFrames(fArray4, 0, n4);
                    f2 = Math.max(f2, Util.maxAbs(fArray4, 0, n4));
                }
                if (this.threadRunning) {
                    f = this.pr.intg[2] == 0 ? (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value : 1.0f;
                    this.normalizeAudioFile(audioFile3, audioFile2, fArray4, f, 1.0f);
                    this.deleteTempFile(audioFile3);
                    if (this.threadRunning) {
                        audioFile2.close();
                        audioFile2 = null;
                        this.handleClipping(f2 *= f);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        Component component = this.gui.getItemObj(516);
        if (component != null) {
            component.setEnabled(!this.pr.bool[0]);
        }
    }
}

