/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class LimiterDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_SYNC = 0;
    private static final int PR_BOOST = 0;
    private static final int PR_CEILING = 1;
    private static final int PR_ATTACK = 2;
    private static final int PR_RELEASE = 3;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_SYNC = "Sync";
    private static final String PRN_BOOST = "Boost";
    private static final String PRN_CEILING = "Ceiling";
    private static final String PRN_ATTACK = "Attack";
    private static final String PRN_RELEASE = "Release";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Sync"};
    private static final Param[] prPara = new Param[]{null, null, null, null};
    private static final String[] prParaName = new String[]{"Boost", "Ceiling", "Attack", "Release"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_SYNC = 0;
    private static final int GG_BOOST = 512;
    private static final int GG_CEILING = 513;
    private static final int GG_ATTACK = 514;
    private static final int GG_RELEASE = 515;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public LimiterDlg() {
        super("Limiter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            LimiterDlg.static_pr.text = prText;
            LimiterDlg.static_pr.textName = prTextName;
            LimiterDlg.static_pr.intg = prIntg;
            LimiterDlg.static_pr.intgName = prIntgName;
            LimiterDlg.static_pr.bool = prBool;
            LimiterDlg.static_pr.boolName = prBoolName;
            LimiterDlg.static_pr.para = prPara;
            LimiterDlg.static_pr.paraName = prParaName;
            LimiterDlg.static_pr.para[0] = new Param(3.0, 785);
            LimiterDlg.static_pr.para[1] = new Param(-0.2, 785);
            LimiterDlg.static_pr.para[2] = new Param(20.0, 2);
            LimiterDlg.static_pr.para[3] = new Param(200.0, 2);
            this.fillDefaultAudioDescr(LimiterDlg.static_pr.intg, 0, 1);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform Input", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("File Name:", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        this.gui.addLabel(new GroupLabel("Output", 1, 0));
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Lim$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("File Name:", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8]};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[7], Constants.spaces[4]};
        ParamSpace[] paramSpaceArray3 = new ParamSpace[]{new ParamSpace(-144.0, 0.0, 0.01, 785), Constants.spaces[5]};
        ParamField paramField = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Boost:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 512, null);
        gridBagConstraints.ipadx = 8;
        paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Attack [-60 dB]:", 4));
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 514, null);
        paramField = new ParamField(paramSpaceArray3);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Ceiling:", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        gridBagConstraints.ipadx = 8;
        paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Release [-60 dB]:", 4));
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 515, null);
        gridBagConstraints.ipady = 4;
        JCheckBox jCheckBox = new JCheckBox("Synchronize Channels");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void process() {
        AudioFile audioFile = null;
        AudioFile audioFile2 = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
            AudioFileDescr audioFileDescr = audioFile.getDescr();
            int n = audioFileDescr.channels;
            long l = audioFileDescr.length;
            PathField pathField = (PathField)this.gui.getItemObj(1025);
            if (pathField == null) {
                throw new IOException("Bug! Missing property!");
            }
            AudioFileDescr audioFileDescr2 = new AudioFileDescr(audioFileDescr);
            pathField.fillStream(audioFileDescr2);
            audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
            if (this.threadRunning) {
                int n2;
                double d = Math.max(1, (int)AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)(this.pr.para[2].value + 0.5)));
                double d2 = Math.max(1, (int)AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)(this.pr.para[3].value + 0.5)));
                double d3 = Math.pow(0.001, 1.0 / d);
                double d4 = Math.pow(0.001, 1.0 / d2);
                int n3 = (int)(d * 2.5);
                int n4 = (int)(d2 * 2.5);
                int n5 = n3 + n4;
                double[] dArray = new double[n5];
                dArray[n3] = 1.0;
                for (n2 = 1; n2 < n3; ++n2) {
                    dArray[n3 - n2] = Math.pow(d3, n2);
                }
                for (n2 = 1; n2 < n4; ++n2) {
                    dArray[n3 + n2] = Math.pow(d4, n2);
                }
                Param param = new Param(1.0, 1);
                double d5 = Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                double d6 = Param.transform((Param)this.pr.para[1], (int)1, (Param)param, null).value;
                int n6 = Math.max(n3, 8192);
                int n7 = n5 + n6;
                boolean bl = this.pr.bool[0];
                int n8 = bl ? 1 : n;
                double[][] dArray2 = new double[n8][n7];
                int n9 = n3 + n6;
                float[][] fArray = new float[n][n9];
                Util.fill(dArray2, 0, n7, d5);
                n2 = n3;
                long l2 = 0L;
                long l3 = 0L;
                while (l3 < l && this.threadRunning) {
                    Object object;
                    int n10;
                    int n11;
                    int n12 = (int)Math.min((long)n6, l - l2);
                    audioFile.readFrames(fArray, n3, n12);
                    int n13 = n11 + n12;
                    for (n11 = n3; n11 < n13; ++n11) {
                        for (n10 = 0; n10 < n8; ++n10) {
                            float[] fArray2;
                            double d7;
                            float f = 0.0f;
                            if (bl) {
                                object = fArray;
                                int n14 = ((float[][])object).length;
                                for (int i = 0; i < n14; ++i) {
                                    float[] fArray3 = object[i];
                                    f = Math.max(f, Math.abs(fArray3[n11]));
                                }
                            } else {
                                f = Math.abs(fArray[n10][n11]);
                            }
                            if (!((d7 = (double)f * (fArray2 = (object = (Object)dArray2[n10])[n11])) > d6)) continue;
                            double d8 = d6 / d7 - 1.0;
                            int n15 = n11 - n3;
                            for (int i = 0; i < n5; ++i) {
                                int n16 = n15++;
                                object[n16] = object[n16] * (dArray[i] * d8 + 1.0);
                            }
                        }
                    }
                    n11 = (int)Math.min((long)n6, l - l3) - n2;
                    n13 = n2 + n11;
                    for (n10 = 0; n10 < n; ++n10) {
                        double[] dArray3 = dArray2[n10 % n8];
                        object = fArray[n10];
                        for (int i = n2; i < n13; ++i) {
                            float f = (float)dArray3[i];
                            if (f == 1.0f) continue;
                            int n17 = i;
                            object[n17] = object[n17] * f;
                        }
                    }
                    audioFile2.writeFrames(fArray, n2, n11);
                    for (double[] dArray4 : dArray2) {
                        System.arraycopy(dArray4, n13, dArray4, 0, n7 - n13);
                    }
                    Util.fill(dArray2, n7 - n13, n13, d5);
                    for (double[] dArray5 : (double[][])fArray) {
                        System.arraycopy(dArray5, n13, dArray5, 0, n9 - n13);
                    }
                    n2 = 0;
                    this.setProgression((float)((double)((l2 += (long)n12) + (l3 += (long)n11)) / (double)(l + l)));
                }
                if (this.threadRunning) {
                    audioFile.close();
                    audioFile = null;
                    audioFile2.close();
                    audioFile2 = null;
                }
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
    }
}

