/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.EnvIcon;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.KriechChunk;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.SpectStream;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Envelope;
import de.sciss.fscape.util.Modulator;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Random;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class KriechstromDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_FLTCOLOR = 2;
    private static final int PR_GAINTYPE = 3;
    private static final int PR_LENUPDATE = 0;
    private static final int PR_MINCHUNKNUM = 0;
    private static final int PR_MAXCHUNKNUM = 1;
    private static final int PR_MINCHUNKLEN = 2;
    private static final int PR_MAXCHUNKLEN = 3;
    private static final int PR_MINCHUNKREP = 4;
    private static final int PR_MAXCHUNKREP = 5;
    private static final int PR_CROSSFADE = 6;
    private static final int PR_ENTRYPOINT = 7;
    private static final int PR_GAIN = 8;
    private static final int PR_FLTAMOUNT = 9;
    private static final int PR_OUTLENGTH = 10;
    private static final int PR_KRIECHENV = 0;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FLTCOLOR = "FltColor";
    private static final String PRN_FLTAMOUNT = "FltAmount";
    private static final String PRN_MINCHUNKNUM = "MinChunkNum";
    private static final String PRN_MAXCHUNKNUM = "MaxChunkNum";
    private static final String PRN_MINCHUNKLEN = "MinChunkLen";
    private static final String PRN_MAXCHUNKLEN = "MaxChunkLen";
    private static final String PRN_MINCHUNKREP = "MinChunkRep";
    private static final String PRN_MAXCHUNKREP = "MaxChunkRep";
    private static final String PRN_CROSSFADE = "CrossFade";
    private static final String PRN_ENTRYPOINT = "EntryPoint";
    private static final String PRN_KRIECHENV = "KriechEnv";
    private static final String PRN_LENUPDATE = "LenUpdate";
    private static final String PRN_OUTLENGTH = "OutLength";
    private static final String[] FLTCOLOR_NAMES = new String[]{"Dark", "Neutral", "Bright"};
    private static final int FLTCOLOR_DARK = 0;
    private static final int FLTCOLOR_NEUTRAL = 1;
    private static final int FLTCOLOR_BRIGHT = 2;
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 1, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "FltColor", "GainType"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"LenUpdate"};
    private static final String[] prParaName = new String[]{"MinChunkNum", "MaxChunkNum", "MinChunkLen", "MaxChunkLen", "MinChunkRep", "MaxChunkRep", "CrossFade", "EntryPoint", "Gain", "FltAmount", "OutLength"};
    private static final Param[] prPara = new Param[prParaName.length];
    private static final Envelope[] prEnvl = new Envelope[]{null};
    private static final String[] prEnvlName = new String[]{"KriechEnv"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_FLTCOLOR = 258;
    private static final int GG_GAINTYPE = 259;
    private static final int GG_LENUPDATE = 0;
    private static final int GG_MINCHUNKNUM = 512;
    private static final int GG_MAXCHUNKNUM = 513;
    private static final int GG_MINCHUNKLEN = 514;
    private static final int GG_MAXCHUNKLEN = 515;
    private static final int GG_MINCHUNKREP = 516;
    private static final int GG_MAXCHUNKREP = 517;
    private static final int GG_CROSSFADE = 518;
    private static final int GG_ENTRYPOINT = 519;
    private static final int GG_FLTAMOUNT = 521;
    private static final int GG_OUTLENGTH = 522;
    private static final int GG_GAIN = 520;
    private static final int GG_KRIECHENV = 1792;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public KriechstromDlg() {
        super("Kriechstrom");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            KriechstromDlg.static_pr.text = prText;
            KriechstromDlg.static_pr.textName = prTextName;
            KriechstromDlg.static_pr.intg = prIntg;
            KriechstromDlg.static_pr.intgName = prIntgName;
            KriechstromDlg.static_pr.bool = prBool;
            KriechstromDlg.static_pr.boolName = prBoolName;
            KriechstromDlg.static_pr.para = prPara;
            KriechstromDlg.static_pr.para[0] = new Param(1.0, 0);
            KriechstromDlg.static_pr.para[1] = new Param(10.0, 0);
            KriechstromDlg.static_pr.para[4] = new Param(1.0, 0);
            KriechstromDlg.static_pr.para[5] = new Param(5.0, 0);
            KriechstromDlg.static_pr.para[2] = new Param(10.0, 2);
            KriechstromDlg.static_pr.para[3] = new Param(1000.0, 2);
            KriechstromDlg.static_pr.para[6] = new Param(20.0, 18);
            KriechstromDlg.static_pr.para[7] = new Param(500.0, 2);
            KriechstromDlg.static_pr.para[9] = new Param(50.0, 17);
            KriechstromDlg.static_pr.para[10] = new Param(100.0, 18);
            KriechstromDlg.static_pr.paraName = prParaName;
            KriechstromDlg.static_pr.envl = prEnvl;
            KriechstromDlg.static_pr.envl[0] = Envelope.createBasicEnvelope(1);
            KriechstromDlg.static_pr.envlName = prEnvlName;
            this.fillDefaultAudioDescr(KriechstromDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(KriechstromDlg.static_pr.para, 8);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = KriechstromDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        KriechstromDlg.this.setInput(((PathField)pathEvent.getSource()).getPath().getPath());
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Frz$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 520, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 259, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Kriech Charakteristika", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], new ParamSpace(Constants.spaces[10])};
        ParamSpace[] paramSpaceArray2 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9]};
        ParamSpace paramSpace = new ParamSpace(1.0, 100000.0, 1.0, 0);
        ParamSpace[] paramSpaceArray3 = new ParamSpace[]{Constants.spaces[8], Constants.spaces[9], new ParamSpace(Constants.spaces[11])};
        paramSpaceArray3[2] = new ParamSpace(paramSpaceArray3[2].min, 50.0, paramSpaceArray3[2].inc, paramSpaceArray3[2].unit);
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Output length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 4;
        this.gui.addParamField(paramField, 522, null);
        EnvIcon envIcon = new EnvIcon(this.getComponent());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.gui.addGadget(envIcon, 1792);
        gridBagConstraints.weightx = 0.0;
        this.gui.addLabel(new JLabel());
        ParamField paramField2 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Max. entry offset", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 519, null);
        ParamField paramField3 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min/Max simult. chunks", 4));
        gridBagConstraints.weightx = 0.0;
        this.gui.addParamField(paramField3, 512, null);
        ParamField paramField4 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.0;
        this.gui.addLabel(new JLabel("...", 2));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 4;
        this.gui.addParamField(paramField4, 513, null);
        ParamField paramField5 = new ParamField(paramSpaceArray3);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Crossfades", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 518, null);
        ParamField paramField6 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min/Max chunks repeats", 4));
        gridBagConstraints.weightx = 0.0;
        this.gui.addParamField(paramField6, 516, null);
        ParamField paramField7 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.0;
        this.gui.addLabel(new JLabel("...", 2));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 4;
        this.gui.addParamField(paramField7, 517, null);
        ParamField paramField8 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Filter amount", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField8, 521, null);
        ParamField paramField9 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min. chunk length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 4;
        this.gui.addParamField(paramField9, 514, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < FLTCOLOR_NAMES.length; ++i) {
            jComboBox.addItem(FLTCOLOR_NAMES[i]);
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 3;
        this.gui.addLabel(new JLabel("Filter colour", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 258, null);
        ParamField paramField10 = new ParamField(paramSpaceArray2);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max. chunk length", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 4;
        this.gui.addParamField(paramField10, 515, null);
        JCheckBox jCheckBox = new JCheckBox("Instantaneous length update");
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addCheckbox(jCheckBox, 0, null);
        paramField5.setReference(paramField9);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block57: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            SpectStream spectStream = null;
            Random random = new Random(System.currentTimeMillis());
            float[][] fArray4 = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                float f3;
                double d;
                int n2;
                int n3;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr2 = audioFile2.getDescr();
                int n4 = audioFileDescr2.channels;
                long l = audioFileDescr2.length;
                if (l < 1L || n4 < 1) {
                    throw new EOFException("File is empty");
                }
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr2);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block57;
                Param param2 = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr2, (long)l), 2);
                Param param3 = Param.transform(this.pr.para[10], 2, param2, null);
                long l2 = (long)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)param3.value) + 0.5);
                spectStream = new SpectStream();
                spectStream.setChannels(n4);
                spectStream.setBands(0.0f, (float)audioFileDescr2.rate / 2.0f, 1, 1);
                spectStream.setRate((float)audioFileDescr2.rate, 1);
                spectStream.setEstimatedLength(l2);
                spectStream.getDescr();
                Modulator modulator = new Modulator(new Param(0.0, 2), param2, this.pr.envl[0], spectStream);
                int n5 = (int)(this.pr.para[0].value + 0.5);
                int n6 = (int)(this.pr.para[1].value + 0.5) - n5 + 1;
                if (n6 < 0) {
                    n6 = -n6;
                    n5 = (int)(this.pr.para[1].value + 0.5);
                }
                if ((n3 = (int)(this.pr.para[5].value + 0.5) - (n2 = (int)(this.pr.para[4].value + 0.5)) + 1) < 0) {
                    n3 = -n3;
                    n2 = (int)(this.pr.para[5].value + 0.5);
                }
                int n7 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[2], (int)2, null, null).value) + 0.5);
                int n8 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[3], (int)2, null, null).value) + 0.5);
                int n9 = n8 - n7 + 1;
                if (n9 < 0) {
                    n9 = -n9;
                    n7 = n8;
                }
                long l3 = Math.max(0L, l - (long)n7);
                float f4 = (float)Param.transform((Param)this.pr.para[9], (int)1, (Param)param, null).value;
                if (f4 > 0.0f) {
                    fArray4 = new float[512][3];
                    d = 1.0;
                    switch (this.pr.intg[2]) {
                        case 0: {
                            d = 2.0;
                            break;
                        }
                        case 1: {
                            d = 0.8;
                            break;
                        }
                        case 2: {
                            d = 0.4;
                        }
                    }
                    for (n8 = 0; n8 < 512; ++n8) {
                        double d2 = Math.exp(random.nextDouble() * d) * 20.0;
                        d2 = Math.pow(random.nextDouble(), d) * 2.06 + 0.24;
                        double d3 = 0.67;
                        double d4 = 1.0;
                        double d5 = Math.sin(d2) * this.sinh(0.34657359027997264 * d3 * d2 / Math.sin(d2));
                        double d6 = d5 * Math.sqrt(d4);
                        double d7 = 1.0;
                        fArray4[n8][0] = (float)((1.0 + d6) / d7);
                        fArray4[n8][1] = (float)(-Math.cos(d2) * 2.0 / d7);
                        fArray4[n8][2] = (float)((1.0 - d6) / d7);
                    }
                }
                long l4 = 0L;
                long l5 = l2;
                Vector<KriechChunk> vector = new Vector<KriechChunk>();
                fArray3 = new float[n4][8192];
                float[][] fArray5 = new float[n4][8192];
                Param param4 = new Param(0.0, 2);
                KriechChunk kriechChunk = new KriechChunk(n4);
                kriechChunk.len = 0;
                kriechChunk.outOff = 0L;
                kriechChunk.rep = 0;
                vector.addElement(kriechChunk);
                long l6 = 0L;
                float f5 = f3 = (float)((n6 >> 1) + n5);
                int n10 = 1;
                if (this.pr.intg[3] == 0) {
                    fileArray = new File[n4];
                    floatFileArray = new FloatFile[n4];
                    for (n = 0; n < n4; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n4; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l5 = (long)((float)l5 + (float)l2 / f3);
                } else {
                    f = (float)Param.transform((Param)this.pr.para[8], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block57;
                while (l6 < l2 && this.threadRunning) {
                    int n11;
                    int n12;
                    long l7;
                    long l8 = l2 - l6;
                    boolean bl = false;
                    int n13 = vector.size();
                    for (n8 = 0; n8 < n13; ++n8) {
                        kriechChunk = (KriechChunk)vector.elementAt(n8);
                        l7 = (long)kriechChunk.len - l6 + kriechChunk.outOff;
                        if (l7 > 0L) {
                            l8 = Math.min(l8, l7);
                            if ((l7 -= (long)kriechChunk.fadeOut) < 0L || kriechChunk.rep-- <= 1) continue;
                            if (l7 == 0L) {
                                kriechChunk = new KriechChunk(kriechChunk);
                                kriechChunk.outOff = l6;
                                if (this.pr.bool[0]) {
                                    kriechChunk.len = kriechChunk.nextLen;
                                    l8 = Math.min(l8, (long)(kriechChunk.len - (kriechChunk.rep > 1 ? kriechChunk.fadeOut : 0)));
                                    kriechChunk.nextLen = (int)Math.min(l - kriechChunk.inOff, (long)((int)(random.nextFloat() * (float)n9) + n7));
                                    param4.value = AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)kriechChunk.len);
                                    n12 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[6], (int)2, (Param)param4, null).value) + 0.5);
                                    kriechChunk.fadeIn = kriechChunk.fadeOut;
                                    kriechChunk.fadeOut = Math.min(Math.min(kriechChunk.nextLen >> 1, kriechChunk.len - kriechChunk.fadeIn), n12);
                                }
                                vector.addElement(kriechChunk);
                                continue;
                            }
                            l8 = Math.min(l8, l7);
                            continue;
                        }
                        vector.removeElementAt(n8);
                        --n8;
                        --n13;
                        bl = true;
                    }
                    Param param5 = modulator.calc();
                    spectStream.framesRead = l6;
                    if (bl) {
                        n8 = (int)(Math.min(1.0f, random.nextFloat() * ((float)n10 * f3) / f5) * (float)n6) + n5;
                        for (n11 = n8 - vector.size(); n11 > 0; --n11) {
                            kriechChunk = new KriechChunk(n4);
                            d = (random.nextDouble() * 2.0 - 1.0) * this.pr.para[7].value + param5.value;
                            kriechChunk.inOff = Math.min(l3, (long)Math.max(0, (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)d) + 0.5)));
                            kriechChunk.rep = (int)(random.nextFloat() * (float)n3) + n2;
                            kriechChunk.len = (int)Math.min(l - kriechChunk.inOff, (long)((int)(random.nextFloat() * (float)n9) + n7));
                            param4.value = AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)kriechChunk.len);
                            n13 = (int)(AudioFileDescr.millisToSamples((AudioFileDescr)audioFileDescr, (double)Param.transform((Param)this.pr.para[6], (int)2, (Param)param4, null).value) + 0.5);
                            kriechChunk.fadeIn = Math.min(kriechChunk.len >> 1, n13);
                            if (this.pr.bool[0]) {
                                kriechChunk.nextLen = (int)Math.min(l - kriechChunk.inOff, (long)((int)(random.nextFloat() * (float)n9) + n7));
                                kriechChunk.fadeOut = Math.min(Math.min(kriechChunk.nextLen >> 1, kriechChunk.len - kriechChunk.fadeIn), n13);
                            } else {
                                kriechChunk.fadeOut = Math.min(kriechChunk.len - kriechChunk.fadeIn, n13);
                            }
                            kriechChunk.outOff = l6;
                            kriechChunk.flt = random.nextFloat() < f4 ? (int)(random.nextFloat() * 512.0f) : -1;
                            vector.addElement(kriechChunk);
                            l8 = Math.min(l8, (long)(kriechChunk.len - (kriechChunk.rep > 1 ? kriechChunk.fadeOut : 0)));
                        }
                    }
                    while (l8 > 0L && this.threadRunning) {
                        float f6;
                        int n14 = (int)Math.min(8192L, l8);
                        for (n8 = 0; n8 < vector.size(); ++n8) {
                            float f7;
                            float f8;
                            kriechChunk = (KriechChunk)vector.elementAt(n8);
                            long l9 = l6 - kriechChunk.outOff;
                            audioFile2.seekFrame(kriechChunk.inOff + l9);
                            audioFile2.readFrames(fArray3, 0, n14);
                            if (kriechChunk.flt >= 0) {
                                fArray2 = fArray4[kriechChunk.flt];
                                for (n = 0; n < n4; ++n) {
                                    fArray = fArray3[n];
                                    f6 = kriechChunk.fltMem[n][0];
                                    float f9 = kriechChunk.fltMem[n][1];
                                    float f10 = kriechChunk.fltMem[n][2];
                                    float f11 = kriechChunk.fltMem[n][3];
                                    for (n11 = 0; n11 < n14; ++n11) {
                                        float f12 = fArray[n11];
                                        fArray[n11] = fArray2[0] * f12 + fArray2[1] * f6 + fArray2[2] * f9 - fArray2[1] * f10 - fArray2[2] * f11;
                                        f6 = f12;
                                        f11 = f10;
                                        f10 = fArray[n11];
                                    }
                                    kriechChunk.fltMem[n][0] = f6;
                                    kriechChunk.fltMem[n][1] = f9;
                                    kriechChunk.fltMem[n][2] = f10;
                                    kriechChunk.fltMem[n][3] = f11;
                                }
                            }
                            if ((l7 = (long)kriechChunk.fadeIn - l9) > 0L) {
                                n11 = (int)Math.min(l7, (long)n14);
                                f8 = (float)(l7 - (long)n11) / (float)kriechChunk.fadeIn;
                                f7 = 1.0f - (float)l9 / (float)kriechChunk.fadeIn;
                                f6 = (f7 - f8) / (float)(n11 - 1);
                                for (n12 = 0; n12 < n11; ++n12) {
                                    for (n = 0; n < n4; ++n) {
                                        float[] fArray6 = fArray3[n];
                                        int n15 = n12;
                                        fArray6[n15] = fArray6[n15] * (1.0f - f7 * f7);
                                    }
                                    f7 -= f6;
                                }
                            }
                            if ((l7 = (long)(kriechChunk.len - kriechChunk.fadeOut) - l9) < (long)n14) {
                                n11 = (int)Math.max(l7, 0L);
                                f7 = (float)((long)n11 - l7) / (float)kriechChunk.fadeOut;
                                f8 = (float)(l7 - (long)n14) / (float)kriechChunk.fadeOut;
                                f6 = (f8 + f7) / (float)(n14 - n11 - 1);
                                for (n12 = n11; n12 < n14; ++n12) {
                                    for (n = 0; n < n4; ++n) {
                                        float[] fArray7 = fArray3[n];
                                        int n16 = n12;
                                        fArray7[n16] = fArray7[n16] * (1.0f - f7 * f7);
                                    }
                                    f7 -= f6;
                                }
                            }
                            if (n8 == 0) {
                                for (n = 0; n < n4; ++n) {
                                    System.arraycopy(fArray3[n], 0, fArray5[n], 0, n14);
                                }
                                continue;
                            }
                            for (n = 0; n < n4; ++n) {
                                Util.add(fArray3[n], 0, fArray5[n], 0, n14);
                            }
                        }
                        if (floatFileArray != null) {
                            for (n = 0; n < n4; ++n) {
                                fArray = fArray5[n];
                                for (n8 = 0; n8 < n14; ++n8) {
                                    f6 = Math.abs(fArray[n8]);
                                    if (!(f6 > f2)) continue;
                                    f2 = f6;
                                }
                                floatFileArray[n].writeFloats(fArray, 0, n14);
                            }
                        } else {
                            for (n = 0; n < n4; ++n) {
                                fArray = fArray5[n];
                                for (n8 = 0; n8 < n14; ++n8) {
                                    f6 = Math.abs(fArray[n8]);
                                    int n17 = n8;
                                    fArray[n17] = fArray[n17] * f;
                                    if (!(f6 > f2)) continue;
                                    f2 = f6;
                                }
                            }
                            audioFile.writeFrames(fArray5, 0, n14);
                        }
                        l6 += (long)n14;
                        l8 -= (long)n14;
                        this.setProgression((float)(l4 += (long)n14) / (float)l5);
                    }
                    f5 += (float)vector.size();
                    ++n10;
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    if (this.pr.intg[3] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[8], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray5, f, 1.0f);
                        for (n = 0; n < n4; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        this.handleClipping(f2 *= f);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr2 = null;
                audioFileDescr = null;
                fArray3 = null;
                fArray = null;
                fArray2 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            Param param = new Param(AudioFileDescr.samplesToMillis((AudioFileDescr)audioFileDescr, (long)audioFileDescr.length), 2);
            ParamField paramField = (ParamField)this.gui.getItemObj(522);
            if (paramField != null) {
                paramField.setReference(param);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

