/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.gui.PathEvent;
import de.sciss.gui.PathListener;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class IchneumonDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_QUALITY = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_MINRSMP = 1;
    private static final int PR_MAXRSMP = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_QUALITY = "Quality";
    private static final String PRN_MINRSMP = "MinRsmp";
    private static final String PRN_MAXRSMP = "MaxRsmp";
    private static final int QUAL_MEDIUM = 0;
    private static final int QUAL_GOOD = 1;
    private static final int QUAL_VERYGOOD = 2;
    private static final String[] QUAL_NAMES = new String[]{"Medium", "Good", "Very good"};
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 1};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "Quality"};
    private static final Param[] prPara = new Param[]{null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "MinRsmp", "MaxRsmp"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_QUALITY = 259;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_GAIN = 512;
    private static final int GG_MINRSMP = 513;
    private static final int GG_MAXRSMP = 514;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public IchneumonDlg() {
        super("Ichneumon");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            IchneumonDlg.static_pr.text = prText;
            IchneumonDlg.static_pr.textName = prTextName;
            IchneumonDlg.static_pr.intg = prIntg;
            IchneumonDlg.static_pr.intgName = prIntgName;
            IchneumonDlg.static_pr.para = prPara;
            IchneumonDlg.static_pr.para[1] = new Param(1.0, 547);
            IchneumonDlg.static_pr.para[2] = new Param(24.0, 547);
            IchneumonDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(IchneumonDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(IchneumonDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        PathListener pathListener = new PathListener(){

            public void pathChanged(PathEvent pathEvent) {
                int n = IchneumonDlg.this.gui.getItemID((EventObject)pathEvent);
                switch (n) {
                    case 1024: {
                        IchneumonDlg.this.setInput(((PathField)pathEvent.getSource()).getPath().getPath());
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, pathListener);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Ich$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, pathListener);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Radio Massacre", 1, 0));
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[19], Constants.spaces[20]};
        ParamField paramField = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Min.rsmp", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < QUAL_NAMES.length; ++i) {
            jComboBox.addItem(QUAL_NAMES[i]);
        }
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_QUALITY, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox, 259, null);
        ParamField paramField2 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Max.rsmp", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 514, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        File file;
        GenericFile genericFile;
        AudioFile audioFile;
        AudioFile audioFile2;
        block54: {
            audioFile2 = null;
            audioFile = null;
            AudioFileDescr audioFileDescr = null;
            AudioFileDescr audioFileDescr2 = null;
            genericFile = null;
            file = null;
            floatFileArray = null;
            fileArray = null;
            float[][] fArray = null;
            float[][] fArray2 = null;
            float f = 1.0f;
            Param param = new Param(1.0, 1);
            float f2 = 0.0f;
            try {
                float f3;
                int n2;
                float f4;
                float[] fArray3;
                int n3;
                int n4;
                int n5;
                float f5;
                float f6;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr = audioFile2.getDescr();
                int n6 = audioFileDescr.channels;
                int n7 = (int)audioFileDescr.length;
                double d = audioFileDescr.rate;
                if (n7 * n6 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block54;
                int n8 = n6;
                Param param2 = new Param(d, 3);
                int n9 = 4096;
                switch (this.pr.intg[3]) {
                    case 0: {
                        f6 = 0.7f;
                        f5 = 6.5f;
                        n5 = 5;
                        break;
                    }
                    case 1: {
                        f6 = 0.8f;
                        f5 = 7.0f;
                        n5 = 9;
                        break;
                    }
                    case 2: {
                        f6 = 0.86f;
                        f5 = 7.5f;
                        n5 = 15;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(this.pr.intg[3]));
                    }
                }
                int n10 = (int)((float)(n9 * n5) / f6 + 0.5f);
                float[] fArray4 = new float[n10];
                float[] fArray5 = null;
                float f7 = Filter.createAntiAliasFilter(fArray4, fArray5, n10, n9, f6, f5);
                float[][] fArrayArray = new float[][]{fArray4, fArray5, new float[2]};
                fArrayArray[2][0] = n9;
                fArrayArray[2][1] = f7;
                int n11 = 32768 / n6;
                double d2 = 0.0;
                long l = 0L;
                long l2 = (long)n7 * 4L;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr2 = new AudioFileDescr(audioFileDescr);
                pathField.fillStream(audioFileDescr2);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr2);
                if (!this.threadRunning) break block54;
                double d3 = param2.value;
                float f8 = (float)(Param.transform((Param)this.pr.para[1], (int)3, (Param)param2, null).value / d);
                float f9 = (float)(Param.transform((Param)this.pr.para[2], (int)3, (Param)param2, null).value / d);
                d3 = Math.min(1.0, (double)Math.min(f8, f9));
                double d4 = (double)n9 * d3;
                int n12 = (int)((double)n10 / d4) + 1;
                int n13 = (n12 << 1) + n11;
                int n14 = (int)((double)n11 / d3) + 1;
                fArray = new float[n6][n13];
                fArray2 = new float[n8][n14];
                double[] dArray = new double[n14];
                int[] nArray = new int[4];
                file = IOUtil.createTempFile();
                genericFile = new FloatFile(file, 1);
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n8];
                    floatFileArray = new FloatFile[n8];
                    for (n = 0; n < n8; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n8; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n7;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                }
                if (!this.threadRunning) break block54;
                int n15 = 0;
                int n16 = 0;
                float f10 = 0.0f;
                float f11 = 0.0f;
                int n17 = 0;
                float f12 = 0.0f;
                int n18 = (int)audioFileDescr.rate / 50;
                int[] nArray2 = new int[n18 + 1];
                float[] fArray6 = new float[n18 + 1];
                for (n3 = 0; this.threadRunning && n3 < n7; n3 += n4) {
                    for (n = 0; n < n6; ++n) {
                        fArray[n][0] = fArray[n][n13 - 1];
                    }
                    n4 = Math.min(n7 - n3, n13 - 1);
                    audioFile2.readFrames(fArray, 1, n4);
                    this.setProgression((float)(l += (long)n4) / (float)l2);
                    if (this.threadRunning) {
                        fArray3 = fArray[0];
                        f4 = fArray3[0];
                        for (n2 = 1; n2 <= n4; ++n2) {
                            int n19;
                            f3 = f4;
                            f4 = fArray3[n2];
                            float f13 = f12;
                            f12 = f4 - f3;
                            if (f13 <= 0.0f && f12 > 0.0f) {
                                n16 = n3 + n2 - 2;
                                f11 = f3;
                                if (n15 < n17) {
                                    int n20 = n19 = Math.max(0, Math.min(n18, (int)((f10 - f11) * 2.0f * (float)(n16 - n15))));
                                    nArray2[n20] = nArray2[n20] + 1;
                                    nArray[0] = n15;
                                    nArray[1] = n17;
                                    nArray[2] = n16 + 1;
                                    nArray[3] = n19;
                                    ((FloatFile)genericFile).writeInts(nArray);
                                }
                            } else if (f13 > 0.0f && f12 <= 0.0f) {
                                n15 = n3 + n2 - 2;
                                f10 = f3;
                                if (n16 < n17) {
                                    int n21 = n19 = Math.max(0, Math.min(n18, (int)((f10 - f11) * 2.0f * (float)(n15 - n16))));
                                    nArray2[n21] = nArray2[n21] + 1;
                                    nArray[0] = n16;
                                    nArray[1] = n17;
                                    nArray[2] = n15 + 1;
                                    nArray[3] = n19;
                                    ((FloatFile)genericFile).writeInts(nArray);
                                }
                            }
                            if (!(f3 > 0.0f && f4 <= 0.0f) && (!(f3 <= 0.0f) || !(f4 > 0.0f))) continue;
                            n17 = n3 + n2 - 1;
                        }
                        continue;
                    }
                    break block54;
                }
                if (!this.threadRunning) break block54;
                int n22 = 0;
                for (n2 = 0; n2 < n18; ++n2) {
                    n22 += nArray2[n2];
                }
                int n23 = 0;
                for (n2 = 0; n2 <= n18; ++n2) {
                    f3 = (float)n23 / (float)n22;
                    fArray6[n2] = f3 * f9 + (1.0f - f3) * f8;
                    n23 += nArray2[n2];
                }
                nArray[0] = n7;
                nArray[1] = n7 + 1;
                nArray[2] = n7 + 2;
                nArray[3] = 0;
                ((FloatFile)genericFile).writeInts(nArray);
                int n24 = n12;
                boolean bl = false;
                n3 = 0;
                int n25 = 0;
                int n26 = -n12;
                audioFile2.seekFrame(0L);
                ((FloatFile)genericFile).seekFloat(0);
                ((FloatFile)genericFile).readInts(nArray);
                while (this.threadRunning && !bl) {
                    n4 = Math.min(n7 - n3, n13 - n24);
                    int n27 = n24 + n4;
                    audioFile2.readFrames(fArray, n24, n4);
                    n3 += n4;
                    this.setProgression((float)(l += (long)n4) / (float)l2);
                    if (this.threadRunning) {
                        int n28;
                        if (n27 < n13) {
                            for (n = 0; n < n6; ++n) {
                                fArray3 = fArray[n];
                                for (n2 = n27; n2 < n13; ++n2) {
                                    fArray3[n2] = 0.0f;
                                }
                            }
                            if ((n27 += n12) <= n13) {
                                bl = true;
                            } else {
                                n27 = n13;
                            }
                        }
                        double d5 = (double)n12 + d2;
                        double d6 = (double)n27 - (double)n12;
                        double d7 = d5;
                        double d8 = d7 + (double)n26;
                        for (n28 = 0; d7 < d6 && n28 < n14; ++n28) {
                            while ((double)nArray[2] < d8) {
                                ((FloatFile)genericFile).readInts(nArray);
                            }
                            if ((double)nArray[0] > d8) {
                                dArray[n28] = 1.0;
                            } else if ((double)nArray[1] > d8) {
                                f3 = fArray6[nArray[3]] - 1.0f;
                                f4 = ((float)d8 - (float)nArray[0]) / (float)(nArray[1] - nArray[0]);
                                dArray[n28] = f4 * f3 + 1.0f;
                            } else {
                                f3 = fArray6[nArray[3]] - 1.0f;
                                f4 = ((float)nArray[2] - (float)d8) / (float)(nArray[2] - nArray[1]);
                                dArray[n28] = f4 * f3 + 1.0f;
                            }
                            double d9 = 1.0 / dArray[n28];
                            d7 += d9;
                            d8 += d9;
                        }
                        for (n = 0; n < n8; ++n) {
                            fArray3 = fArray2[n];
                            this.resample(fArray[n % n6], d5, fArray3, 0, n28, dArray, fArrayArray);
                            for (n23 = 0; n23 < n28; ++n23) {
                                if (!(Math.abs(fArray3[n23]) > f2)) continue;
                                f2 = Math.abs(fArray3[n23]);
                            }
                        }
                        d5 = d7;
                        l += (long)n4;
                        if (floatFileArray != null) {
                            for (n = 0; n < n8; ++n) {
                                floatFileArray[n].writeFloats(fArray2[n], 0, n28);
                            }
                        } else {
                            for (n = 0; n < n8; ++n) {
                                Util.mult(fArray2[n], 0, n28, f);
                            }
                            audioFile.writeFrames(fArray2, 0, n28);
                        }
                        n25 += n28;
                        n2 = (int)(d5 - (double)n12);
                        n23 = n27 - n2;
                        d2 = d5 % 1.0;
                        n24 = n23;
                        n26 += n2;
                        for (n = 0; n < n6; ++n) {
                            System.arraycopy(fArray[n], n2, fArray[n], 0, n23);
                        }
                        this.setProgression((float)(l += (long)n4) / (float)l2);
                        continue;
                    }
                    break block54;
                }
                if (this.threadRunning) {
                    audioFile2.close();
                    audioFile2 = null;
                    audioFileDescr = null;
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray2, f, 1.0f);
                        for (n = 0; n < n8; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    audioFile.close();
                    audioFile = null;
                    genericFile.cleanUp();
                    genericFile = null;
                    file.delete();
                    this.handleClipping(f2 *= f);
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr = null;
                audioFileDescr2 = null;
                fArray = null;
                fArray2 = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (genericFile != null) {
            genericFile.cleanUp();
            file.delete();
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
            }
        }
    }

    protected void resample(float[] fArray, double d, float[] fArray2, int n, int n2, double[] dArray, float[][] fArray3) {
        double d2 = d;
        float[] fArray4 = fArray3[0];
        double d3 = fArray3[2][0];
        double d4 = fArray3[2][1];
        int n3 = fArray4.length;
        int n4 = fArray.length;
        int n5 = n;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            double d5;
            double d6;
            double d7 = dArray[n6];
            if (d7 < 1.0) {
                d6 = d3 * d7;
                d5 = d4;
            } else {
                d6 = d3;
                d5 = d4 / d7;
            }
            double d8 = d2 % 1.0;
            double d9 = 0.0;
            double d10 = d8 * d6 + 0.5;
            int n8 = (int)d10;
            for (n7 = (int)d2; n8 < n3 && n7 >= 0; --n7) {
                d9 += (double)fArray[n7] * (double)fArray4[n8];
                n8 = (int)(d10 += d6);
            }
            d10 = (1.0 - d8) * d6;
            n8 = (int)d10;
            for (n7 = (int)d2 + 1; n8 < n3 && n7 < n4; ++n7) {
                d9 += (double)fArray[n7] * (double)fArray4[n8];
                n8 = (int)(d10 += d6);
            }
            fArray2[n5++] = (float)(d9 * d5);
            ++n6;
            d2 += 1.0 / d7;
        }
    }

    protected void setInput(String string) {
        AudioFile audioFile = null;
        AudioFileDescr audioFileDescr = null;
        try {
            audioFile = AudioFile.openAsRead((File)new File(string));
            audioFileDescr = audioFile.getDescr();
            audioFile.close();
            Param param = new Param(audioFileDescr.rate, 3);
            ParamField paramField = (ParamField)this.gui.getItemObj(513);
            if (paramField != null) {
                paramField.setReference(param);
            }
            if ((paramField = (ParamField)this.gui.getItemObj(514)) != null) {
                paramField.setReference(param);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

