/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.FloatFile;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Fourier;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import de.sciss.io.IOUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ExciterDlg
extends ModulePanel {
    private static final int PR_INPUTFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_FILTERLEN = 3;
    private static final int PR_GAIN = 0;
    private static final int PR_LOFREQ = 1;
    private static final int PR_HIFREQ = 2;
    private static final int PR_DRYMIX = 3;
    private static final int PR_WETMIX = 4;
    private static final int PR_ROLLOFF = 5;
    private static final int PR_BANDSPEROCT = 6;
    private static final int FLT_LONG = 2;
    private static final String PRN_INPUTFILE = "InputFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_FILTERLEN = "FilterLen";
    private static final String PRN_LOFREQ = "LoFreq";
    private static final String PRN_HIFREQ = "HiFreq";
    private static final String PRN_DRYMIX = "DryMix";
    private static final String PRN_WETMIX = "WetMix";
    private static final String PRN_ROLLOFF = "RollOff";
    private static final String PRN_BANDSPEROCT = "BandsPerOct";
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InputFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 2};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "FilterLen"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "LoFreq", "HiFreq", "DryMix", "WetMix", "RollOff", "BandsPerOct"};
    private static final int GG_INPUTFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_FILTERLEN = 259;
    private static final int GG_GAIN = 512;
    private static final int GG_LOFREQ = 513;
    private static final int GG_HIFREQ = 514;
    private static final int GG_DRYMIX = 515;
    private static final int GG_WETMIX = 516;
    private static final int GG_ROLLOFF = 517;
    private static final int GG_BANDSPEROCT = 518;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public ExciterDlg() {
        super("Exciter");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            ExciterDlg.static_pr.text = prText;
            ExciterDlg.static_pr.textName = prTextName;
            ExciterDlg.static_pr.intg = prIntg;
            ExciterDlg.static_pr.intgName = prIntgName;
            ExciterDlg.static_pr.para = prPara;
            ExciterDlg.static_pr.para[1] = new Param(400.0, 3);
            ExciterDlg.static_pr.para[2] = new Param(9000.0, 3);
            ExciterDlg.static_pr.para[3] = new Param(100.0, 17);
            ExciterDlg.static_pr.para[4] = new Param(25.0, 17);
            ExciterDlg.static_pr.para[5] = new Param(12.0, 547);
            ExciterDlg.static_pr.para[6] = new Param(36.0, 0);
            ExciterDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(ExciterDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(ExciterDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Input file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(49, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Output file", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Exc$E");
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, null);
        this.gui.addLabel(new GroupLabel("Post processing", 1, 0));
        ParamField paramField = new ParamField(Constants.spaces[15]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Low CrossOver", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField, 513, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[15], Constants.spaces[18], Constants.spaces[19]};
        ParamField paramField2 = new ParamField(paramSpaceArray);
        paramField2.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel(PRN_ROLLOFF, 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 517, null);
        ParamField paramField3 = new ParamField(paramSpaceArray);
        paramField3.setReference(paramField);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("High CrossOver", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 514, null);
        ParamField paramField4 = new ParamField(new ParamSpace(1.0, 256.0, 1.0, 0));
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Bands per Oct.", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 518, null);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Short");
        jComboBox.addItem("Medium");
        jComboBox.addItem("Long");
        jComboBox.addItem("Very long");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Filter length", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addChoice(jComboBox, 259, null);
        ParamField paramField5 = new ParamField(Constants.spaces[5]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Dry mix", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 515, null);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel());
        ParamField paramField6 = new ParamField(Constants.spaces[5]);
        this.gui.addLabel(new JLabel("Wet mix", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField6, 516, null);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        int n;
        File[] fileArray;
        FloatFile[] floatFileArray;
        AudioFile audioFile;
        AudioFile audioFile2;
        block51: {
            float[] fArray;
            float[] fArray2;
            float[][] fArray3;
            float[] fArray4;
            float[] fArray5;
            float[][] fArray6;
            AudioFileDescr audioFileDescr;
            AudioFileDescr audioFileDescr2;
            audioFile2 = null;
            audioFile = null;
            floatFileArray = null;
            fileArray = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            try {
                int n2;
                float f3;
                double d;
                double d2;
                int n3;
                int n4;
                double d3;
                audioFile2 = AudioFile.openAsRead((File)new File(this.pr.text[0]));
                audioFileDescr2 = audioFile2.getDescr();
                int n5 = audioFileDescr2.channels;
                int n6 = (int)audioFileDescr2.length;
                if (n6 * n5 < 1) {
                    throw new EOFException("File is empty");
                }
                if (!this.threadRunning) break block51;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                audioFileDescr = new AudioFileDescr(audioFileDescr2);
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block51;
                double d4 = Param.transform((Param)this.pr.para[1], (int)3, null, null).value;
                double d5 = Param.transform((Param)this.pr.para[2], (int)3, (Param)this.pr.para[1], null).value;
                double d6 = Param.transform((Param)this.pr.para[5], (int)3, (Param)this.pr.para[1], null).value;
                if (d4 > d6) {
                    d3 = d4;
                    d4 = d6;
                    d6 = d3;
                }
                double d7 = Math.pow(2.0, 1.0 / this.pr.para[6].value);
                float f4 = (float)(this.pr.para[3].value / 100.0);
                float f5 = (float)(this.pr.para[4].value / 100.0);
                boolean bl = f4 > 0.0f;
                int n7 = (int)(Math.log(d5 / d4) / Math.log(d7));
                float[] fArray7 = new float[n7 + 1];
                float[] fArray8 = new float[n7 + 1];
                d3 = d4;
                double d8 = d3 * d7;
                for (n4 = 0; n4 <= n7; ++n4) {
                    fArray7[n4] = (float)d3;
                    fArray8[n4] = (float)(Math.sqrt(d8 * d3) - d3);
                    d3 = d8;
                    d8 = d3 * d7;
                }
                int n8 = 3 << this.pr.intg[3];
                int n9 = Math.max(1, (int)((double)n8 * audioFileDescr2.rate / (double)fArray7[0] + 0.5));
                double d9 = Math.PI * 2 / audioFileDescr2.rate;
                double d10 = 0.4052847345693511;
                int n10 = n9 + n9;
                float[] fArray9 = Filter.createFullWindow(n10, 1);
                int n11 = n10 + n10 - 1;
                for (n3 = 2; n3 < n11; n3 <<= 1) {
                }
                int n12 = n3 - n10 + 1;
                int n13 = n3 - n12;
                fArray6 = new float[n7][n3 + 2];
                fArray5 = new float[n3 + 2];
                fArray4 = new float[n3 + 2];
                fArray3 = new float[n5][n3 + 2];
                fArray2 = new float[n3 + 2];
                float[][] fArray10 = new float[n5][n12 + n10];
                float[][][] fArray11 = new float[n5][n7][n13];
                float[][] fArray12 = new float[n5][n13];
                int[] nArray = new int[n7];
                for (n4 = 0; n4 < n5; ++n4) {
                    Util.clear(fArray11[n4]);
                }
                Util.clear(fArray10);
                for (n4 = 0; n4 < n7; ++n4) {
                    fArray = fArray6[n4];
                    d2 = d9 * (double)fArray7[n4 + 1];
                    d = d9 * (double)fArray8[n4 + 1];
                    for (n11 = 1; n11 < n9; ++n11) {
                        d3 = Math.sin(d2 * (double)n11) / (double)n11;
                        d7 = d10 * d * (double)n11 * d * (double)n11;
                        fArray[n9 + n11] = (float)(d3 *= Math.cos(d * (double)n11) / (1.0 - d7));
                        fArray[n9 - n11] = (float)d3;
                    }
                    fArray[n9] = (float)d2;
                    d2 = d9 * (double)fArray7[n4];
                    d = d9 * (double)fArray8[n4];
                    for (n11 = 1; n11 < n9; ++n11) {
                        d3 = Math.sin(d2 * (double)n11) / (double)n11;
                        d7 = d10 * d * (double)n11 * d * (double)n11;
                        int n14 = n9 + n11;
                        fArray[n14] = fArray[n14] - (float)(d3 *= Math.cos(d * (double)n11) / (1.0 - d7));
                        int n15 = n9 - n11;
                        fArray[n15] = fArray[n15] - (float)d3;
                    }
                    int n16 = n9;
                    fArray[n16] = fArray[n16] - (float)d2;
                    for (n11 = n10; n11 < n3; ++n11) {
                        fArray[n11] = 0.0f;
                    }
                    Util.mult(fArray9, 0, fArray, 0, n10);
                    Fourier.realTransform(fArray, n3, 1);
                    d3 = 0.0;
                    n11 = 0;
                    while (n11 < fArray.length) {
                        float f6 = fArray[n11];
                        int n17 = n11++;
                        float f7 = fArray[n11];
                        int n18 = n11++;
                        d7 = Math.sqrt(f6 * fArray[n17] + f7 * fArray[n18]);
                        if (!(d7 > d3)) continue;
                        d3 = d7;
                    }
                    f3 = (float)(1.0 / Math.sqrt(d3));
                    Util.mult(fArray, 0, fArray.length, f3);
                    nArray[n4] = Math.min(n13, (int)(audioFileDescr2.rate / (double)fArray7[n4] * 1.5 + 0.5));
                }
                d2 = d9 * (audioFileDescr2.rate / 2.0);
                fArray2[n9] = (float)d2;
                d2 = d9 * d6;
                d = d9 * (d6 - d4);
                for (n11 = 1; n11 < n9; ++n11) {
                    d3 = Math.sin(d2 * (double)n11) / (double)n11;
                    d7 = d10 * d * (double)n11 * d * (double)n11;
                    int n19 = n9 + n11;
                    fArray2[n19] = fArray2[n19] - (float)(d3 *= Math.cos(d * (double)n11) / (1.0 - d7));
                    int n20 = n9 - n11;
                    fArray2[n20] = fArray2[n20] - (float)d3;
                }
                int n21 = n9;
                fArray2[n21] = fArray2[n21] - (float)d2;
                for (n11 = n10; n11 < n3; ++n11) {
                    fArray2[n11] = 0.0f;
                }
                Util.mult(fArray9, 0, fArray2, 0, n10);
                Fourier.realTransform(fArray2, n3, 1);
                d3 = 0.0;
                n11 = 0;
                while (n11 < fArray2.length) {
                    float f8 = fArray2[n11];
                    int n22 = n11++;
                    float f9 = fArray2[n11];
                    int n23 = n11++;
                    d7 = Math.sqrt(f8 * fArray2[n22] + f9 * fArray2[n23]);
                    if (!(d7 > d3)) continue;
                    d3 = d7;
                }
                f3 = (float)(0.25 / Math.sqrt(d3));
                Util.mult(fArray2, 0, fArray2.length, f3);
                long l = 0L;
                long l2 = (long)n6 * (long)(2 + n5 + n5);
                if (this.pr.intg[2] == 0) {
                    fileArray = new File[n5];
                    floatFileArray = new FloatFile[n5];
                    for (n = 0; n < n5; ++n) {
                        fileArray[n] = null;
                        floatFileArray[n] = null;
                    }
                    for (n = 0; n < n5; ++n) {
                        fileArray[n] = IOUtil.createTempFile();
                        floatFileArray[n] = new FloatFile(fileArray[n], 1);
                    }
                    l2 += (long)n6;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    f4 *= f;
                    f5 *= f;
                }
                if (!this.threadRunning) break block51;
                int n24 = 0;
                int n25 = n9;
                for (int i = 0; this.threadRunning && i < n6; i += Math.max(0, n2 - n25)) {
                    int n26;
                    int n27;
                    int n28 = Math.min(n12, n6 - n24);
                    for (n26 = 0; this.threadRunning && n26 < n28; n26 += n27) {
                        n27 = Math.min(8192, n28 - n26);
                        audioFile2.readFrames(fArray10, n26 + n10, n27);
                        n24 += n27;
                        this.setProgression((float)(l += (long)n27) / (float)l2);
                    }
                    if (this.threadRunning) {
                        n2 = Math.min(n12, n6 - i);
                        for (n = 0; this.threadRunning && n < n5; ++n) {
                            fArray = fArray3[n];
                            float[] fArray13 = fArray10[n];
                            Util.clear(fArray);
                            System.arraycopy(fArray13, n10, fArray5, 0, n28);
                            for (n4 = n28; n4 < n3; ++n4) {
                                fArray5[n4] = 0.0f;
                            }
                            Fourier.realTransform(fArray5, n3, 1);
                            for (int j = 0; this.threadRunning && j < n7; ++j) {
                                Fourier.complexMult(fArray5, 0, fArray6[j], 0, fArray4, 0, fArray5.length);
                                Fourier.realTransform(fArray4, n3, -1);
                                Util.add(fArray11[n][j], 0, fArray4, 0, n13);
                                System.arraycopy(fArray4, n12, fArray11[n][j], 0, n13);
                                int n29 = -1;
                                f3 = 0.0f;
                                n4 = 0;
                                int n30 = nArray[j];
                                while (n4 < n2) {
                                    if (n4 > n29) {
                                        f3 = 0.0f;
                                    }
                                    for (n11 = n29 + 1; n11 < n30; ++n11) {
                                        float f10 = Math.abs(fArray4[n11]);
                                        if (!(f10 >= f3)) continue;
                                        f3 = f10;
                                        n29 = n11;
                                    }
                                    if (f3 > 0.0f) {
                                        int n31 = n4;
                                        fArray[n31] = fArray[n31] + fArray4[n4] * fArray4[n4] / f3;
                                    }
                                    ++n4;
                                    ++n30;
                                }
                            }
                            Fourier.realTransform(fArray, n3, 1);
                            Fourier.complexMult(fArray, 0, fArray2, 0, fArray, 0, fArray2.length);
                            Fourier.realTransform(fArray, n3, -1);
                            Util.add(fArray12[n], 0, fArray, 0, n13);
                            System.arraycopy(fArray, n12, fArray12[n], 0, n13);
                            if (bl) {
                                for (n4 = 0; n4 < n2; ++n4) {
                                    fArray[n4] = fArray[n4] * f5 + fArray13[n4] * f4;
                                }
                                System.arraycopy(fArray13, n2, fArray13, 0, n10);
                            } else if (f5 != 1.0f) {
                                Util.mult(fArray, 0, n2, f5);
                            }
                            this.setProgression((float)(l += (long)(n2 + n2)) / (float)l2);
                        }
                        if (this.threadRunning) {
                            for (n26 = n25; this.threadRunning && n26 < n2; n26 += n27) {
                                n27 = Math.min(8192, n2 - n26);
                                if (floatFileArray != null) {
                                    for (n = 0; n < n5; ++n) {
                                        floatFileArray[n].writeFloats(fArray3[n], n26, n27);
                                    }
                                } else {
                                    audioFile.writeFrames(fArray3, n26, n27);
                                }
                                this.setProgression((float)(l += (long)n27) / (float)l2);
                            }
                            for (n = 0; n < n5; ++n) {
                                fArray = fArray3[n];
                                for (n26 = n25; n26 < n2; ++n26) {
                                    f3 = Math.abs(fArray[n26]);
                                    if (!(f3 > f2)) continue;
                                    f2 = f3;
                                }
                            }
                            if (n25 <= 0) continue;
                            n25 = Math.max(0, n25 - n2);
                            continue;
                        }
                    }
                    break block51;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[2] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        f3 = 1.0f;
                        this.normalizeAudioFile(floatFileArray, audioFile, fArray3, f, f3);
                        f2 *= f;
                        for (n = 0; n < n5; ++n) {
                            floatFileArray[n].cleanUp();
                            floatFileArray[n] = null;
                            fileArray[n].delete();
                            fileArray[n] = null;
                        }
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        audioFileDescr = null;
                        audioFile2.close();
                        audioFile2 = null;
                        audioFileDescr2 = null;
                        fArray5 = null;
                        fArray4 = null;
                        fArray3 = null;
                        fArray6 = null;
                        fArray2 = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                audioFileDescr2 = null;
                audioFileDescr = null;
                fArray5 = null;
                fArray4 = null;
                fArray3 = null;
                fArray6 = null;
                fArray2 = null;
                fArray = null;
                System.gc();
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
            audioFile2 = null;
        }
        if (audioFile != null) {
            audioFile.cleanUp();
            audioFile = null;
        }
        if (floatFileArray != null) {
            for (n = 0; n < floatFileArray.length; ++n) {
                if (floatFileArray[n] != null) {
                    floatFileArray[n].cleanUp();
                    floatFileArray[n] = null;
                }
                if (fileArray[n] == null) continue;
                fileArray[n].delete();
                fileArray[n] = null;
            }
        }
    }
}

