/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.EditEnvDlg;
import de.sciss.fscape.gui.ToolIcon;
import de.sciss.fscape.util.Curve;
import de.sciss.fscape.util.DoublePoint;
import de.sciss.fscape.util.Envelope;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

public class EnvIcon
extends ToolIcon {
    private Envelope env = null;
    private static final Color colrNormalL = new Color(0, 0, 48, 255);
    private static final Color colrGhostedL = new Color(0, 0, 0, 127);
    private static final Color colrNormalD = new Color(200, 200, 200, 255);
    private static final Color colrGhostedD = new Color(200, 200, 200, 127);
    private final boolean isDark = UIManager.getBoolean("dark-skin");

    public EnvIcon(final Component component) {
        super(10, null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!EnvIcon.this.isEnabled() || EnvIcon.this.env == null || !EnvIcon.this.contains(mouseEvent.getPoint())) {
                    return;
                }
                EditEnvDlg editEnvDlg = new EditEnvDlg(component, EnvIcon.this.env);
                editEnvDlg.setVisible(true);
                Envelope envelope = editEnvDlg.getEnvelope();
                if (envelope != null) {
                    EnvIcon.this.setEnv(envelope);
                }
                editEnvDlg.dispose();
            }
        });
    }

    public void setEnv(Envelope envelope) {
        this.env = envelope;
        this.repaint();
    }

    public Envelope getEnv() {
        return this.env;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.isEnabled() ? (this.isDark ? colrNormalD : colrNormalL) : (this.isDark ? colrGhostedD : colrGhostedD));
        this.drawPictogram(graphics2D);
        super.paintComponent(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.d.width + (this.d.width >> 1), this.d.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPictogram(Graphics graphics) {
        int[] nArray;
        int[] nArray2;
        if (this.env == null) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        Curve[] curveArray = new Curve[3];
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double d = 0.0;
        int n3 = 0;
        Envelope envelope = this.env;
        synchronized (envelope) {
            int n4;
            if (this.env.atkState) {
                curveArray[0] = this.env.atkCurve;
            }
            if (this.env.susState) {
                curveArray[1] = this.env.susCurve;
            }
            if (this.env.rlsState) {
                curveArray[2] = this.env.rlsCurve;
            }
            for (n4 = 0; n4 < 3; ++n4) {
                if (curveArray[n4] == null) continue;
                dArray[n4] = n4 == 1 ? 0.5 : 0.25;
                n3 += curveArray[n4].size();
                d += dArray[n4];
            }
            if (n3 == 0) {
                return;
            }
            dArray[0] = dArray[0] / d;
            dArray[1] = dArray[1] / d;
            dArray[2] = dArray[2] / d;
            nArray2 = new int[n3];
            nArray = new int[n3];
            int n5 = 2;
            int n6 = 0;
            for (n4 = 0; n4 < 3; ++n4) {
                if (curveArray[n4] == null) continue;
                double d2 = curveArray[n4].hSpace.max - curveArray[n4].hSpace.min;
                double d3 = curveArray[n4].vSpace.max - curveArray[n4].vSpace.min;
                int n7 = 0;
                while (n7 < curveArray[n4].size()) {
                    DoublePoint doublePoint = curveArray[n4].getPoint(n7);
                    nArray2[n6] = n5 + (int)((double)(n - 3) * dArray[n4] * (doublePoint.x - curveArray[n4].hSpace.min) / d2);
                    nArray[n6] = 1 + (int)((double)(n2 - 3) * (curveArray[n4].vSpace.max - doublePoint.y) / d3);
                    ++n7;
                    ++n6;
                }
                n5 += (int)(dArray[n4] * (double)(n - 1));
            }
        }
        graphics.drawPolyline(nArray2, nArray, n3);
    }
}

