/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.Dragable;
import de.sciss.fscape.gui.OpConnector;
import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.gui.OpPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;

public class DragContext
implements KeyListener {
    public static final int MOVE = 0;
    public static final int LINK = 1;
    private Component source;
    private Component target = null;
    private String srcName;
    private Container container;
    private int type;
    private Rectangle srcBounds;
    private Point initialLoc;
    private Point currentLoc;
    private Cursor dragCursor;
    private Cursor oldCursor;
    private int threshold;
    private boolean dragStarted = false;
    private boolean dragSuccessful = false;
    private int targetLastState;
    private Point srcPoint;
    private Point targetPoint;

    public DragContext(MouseEvent mouseEvent, int n) {
        this.source = mouseEvent.getComponent();
        this.srcName = this.source.toString();
        this.type = n;
        this.srcBounds = this.source.getBounds();
        this.currentLoc = this.initialLoc = new Point(this.srcBounds.x + mouseEvent.getX(), this.srcBounds.y + mouseEvent.getY());
        this.srcPoint = new Point(0, 0);
        this.targetPoint = new Point(0, 0);
        this.dragStarted = false;
        this.container = this.srcName.equals("OpPanel") ? (Container)this.source : this.source.getParent();
        this.dragCursor = new Cursor(this.srcName.equals("OpIcon") && n == 0 ? 13 : 1);
        this.threshold = 5;
    }

    public Component getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public Component getTarget() {
        return this.target;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public boolean hasDragStarted() {
        return this.dragStarted;
    }

    public boolean wasDragSuccessful() {
        return this.dragSuccessful;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        block16: {
            block18: {
                block17: {
                    if (mouseEvent.getComponent() != this.source) {
                        return;
                    }
                    if (this.dragStarted) {
                        this.paintScheme(false);
                    }
                    this.currentLoc = new Point(this.srcBounds.x + mouseEvent.getX(), this.srcBounds.y + mouseEvent.getY());
                    if (!this.dragStarted && (this.currentLoc.x - this.initialLoc.x) * (this.currentLoc.x - this.initialLoc.x) + (this.currentLoc.y - this.initialLoc.y) * (this.currentLoc.y - this.initialLoc.y) >= this.threshold * this.threshold) {
                        this.oldCursor = this.container.getCursor();
                        this.container.setCursor(this.dragCursor);
                        this.source.requestFocus();
                        this.source.addKeyListener(this);
                        this.dragStarted = true;
                        this.target = null;
                    }
                    if (!this.dragStarted) break block16;
                    if (!this.srcName.equals("OpIcon")) break block17;
                    switch (this.type) {
                        case 0: {
                            OpIcon opIcon = ((OpPanel)this.container).getOpIconAround(this.currentLoc.x, this.currentLoc.y, (OpIcon)this.source, 0, 0);
                            if (opIcon != this.target) {
                                if (this.target != null) {
                                    ((OpIcon)this.target).setSelected(this.targetLastState);
                                }
                                this.target = opIcon;
                                if (this.target != null) {
                                    this.targetLastState = ((OpIcon)this.target).isSelected();
                                    ((OpIcon)this.target).setSelected(1);
                                }
                            }
                            this.dragSuccessful = this.target == null;
                            break;
                        }
                        case 1: {
                            OpIcon opIcon = ((OpPanel)this.container).getOpIconAt(this.currentLoc.x, this.currentLoc.y);
                            if (opIcon == this.source) {
                                opIcon = null;
                            }
                            if (opIcon != this.target) {
                                if (this.target != null) {
                                    ((OpIcon)this.target).setSelected(this.targetLastState);
                                }
                                this.dragSuccessful = false;
                                this.target = opIcon;
                                if (this.target != null) {
                                    this.targetLastState = ((OpIcon)this.target).isSelected();
                                    OpConnector.calcArrow(this.source, this.target, this.srcPoint, this.targetPoint, 2, 2);
                                    if (!((OpIcon)this.target).getOperator().getSlots(17).isEmpty()) {
                                        ((OpIcon)this.target).setSelected(4);
                                        this.dragSuccessful = true;
                                        break;
                                    }
                                    ((OpIcon)this.target).setSelected(1);
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block18;
                }
                if (this.srcName.equals("OpConnector")) {
                    this.dragSuccessful = true;
                }
            }
            this.paintScheme(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragStarted) {
            if (this.target != null && this.target.toString().equals("OpIcon")) {
                ((OpIcon)this.target).setSelected(this.targetLastState);
            }
            this.paintScheme(false);
            this.container.setCursor(this.oldCursor);
            this.source.removeKeyListener(this);
            this.dragStarted = false;
        }
    }

    protected void paintScheme(boolean bl) {
        Graphics2D graphics2D = (Graphics2D)this.container.getGraphics();
        if (graphics2D == null) {
            return;
        }
        graphics2D.setXORMode(this.container.getBackground());
        graphics2D.setColor(this.container.getForeground());
        switch (this.type) {
            case 0: {
                ((Dragable)((Object)this.source)).paintScheme(graphics2D, this.currentLoc.x, this.currentLoc.y, bl);
                break;
            }
            case 1: {
                if (this.target == null) {
                    OpConnector.drawArrow(graphics2D, this.srcBounds.x + (this.srcBounds.width >> 1), this.srcBounds.y + (this.srcBounds.height >> 1), this.currentLoc.x, this.currentLoc.y, true);
                    break;
                }
                OpConnector.drawArrow(graphics2D, this.srcPoint.x, this.srcPoint.y, this.targetPoint.x, this.targetPoint.y, true);
                Graphics2D graphics2D2 = (Graphics2D)this.target.getGraphics();
                if (graphics2D2 == null) break;
                graphics2D2.setXORMode(this.container.getBackground());
                graphics2D2.setColor(this.container.getForeground());
                Point point = this.target.getLocation();
                OpConnector.drawArrow(graphics2D2, this.srcPoint.x - point.x, this.srcPoint.y - point.y, this.targetPoint.x - point.x, this.targetPoint.y - point.y, true);
                graphics2D2.dispose();
                break;
            }
        }
        graphics2D.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            MouseEvent mouseEvent = new MouseEvent(this.source, 502, System.currentTimeMillis(), 0, this.currentLoc.x, this.currentLoc.y, 0, false);
            this.dragSuccessful = false;
            this.mouseReleased(mouseEvent);
            this.source.dispatchEvent(mouseEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

