/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.OpIcon;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Curve;
import de.sciss.fscape.util.DoublePoint;
import de.sciss.fscape.util.ParamSpace;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class CurvePanel
extends JPanel {
    public static final String ACTION_POINTSELECTED = "PointSelect";
    public static final String ACTION_POINTDESELECTED = "PointDeselect";
    public static final String ACTION_POINTCHANGED = "PointMoved";
    public static final String ACTION_SPACECHANGED = "SpaceChange";
    protected CurvePoint currentCurvePoint;
    protected CurvePoint dummyPoint;
    protected Cursor lastCursor;
    protected CurvePoint dragSource = null;
    protected DoublePoint dragLeft;
    protected DoublePoint dragRight;
    protected boolean dragState = false;
    protected int dragType = -1;
    protected int dragLastX;
    protected int dragLastY;
    protected DoublePoint dragPoint;
    private static final int DRAG_MOVE = 0;
    private static final int DRAG_NONE = -1;
    protected static final int CP_WIDTH = 8;
    protected static final int CP_HEIGHT = 8;
    protected static final int CP_STATE_NORMAL = 0;
    protected static final int CP_STATE_SELECTED = 3;
    protected static final int CP_STATE_UNKNOWN = -1;
    protected Curve curve;
    protected Dimension dim;
    protected Button actionComponent;
    private final MouseInputAdapter mia;
    private final boolean isDark = UIManager.getBoolean("dark-skin");
    private static Paint pntGridLight = Color.lightGray;
    private static Paint pntGridDark = Color.darkGray;
    private static Paint pntGridLightD = new Color(192, 192, 192, 127);
    private static Paint pntGridDarkD = new Color(64, 64, 64, 127);
    private static Paint pntLineLight = Color.black;
    private static Paint pntLineDark = new Color(200, 200, 200);
    private static Paint pntLineLightD = new Color(0, 0, 0, 127);
    private static Paint pntLineDarkD = new Color(200, 200, 200, 127);

    public CurvePanel() {
        super(null);
        this.actionComponent = new Button();
        this.currentCurvePoint = this.dummyPoint = new CurvePoint();
        this.curve = new Curve(Constants.spaces[0], Constants.spaces[0]);
        this.setOpaque(true);
        this.dim = new Dimension(64, 64);
        this.setMinimumSize(this.dim);
        this.setPreferredSize(new Dimension(128, 128));
        this.setSize(this.dim);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CurvePanel.this.dim = CurvePanel.this.getSize();
                CurvePanel.this.recalcScreenPoints();
                CurvePanel.this.repaint();
            }
        });
        final CurvePanel curvePanel = this;
        this.mia = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (!CurvePanel.this.isEnabled()) {
                    return;
                }
                if (mouseEvent.getSource() == curvePanel) {
                    if (mouseEvent.getClickCount() == 2 && !mouseEvent.isAltDown()) {
                        DoublePoint doublePoint = CurvePanel.this.screenToParamSpace(mouseEvent.getX(), mouseEvent.getY());
                        CurvePoint curvePoint = new CurvePoint();
                        CurvePanel.this.addPoint(curvePoint, doublePoint.x, doublePoint.y);
                    }
                } else if (mouseEvent.isAltDown() && CurvePanel.this.curve.getPoint((n = CurvePanel.this.getComponentIndex((Component)mouseEvent.getSource())) - 1) != null && CurvePanel.this.curve.getPoint(n + 1) != null) {
                    CurvePanel.this.removePoint((CurvePoint)mouseEvent.getSource());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!CurvePanel.this.isEnabled()) {
                    return;
                }
                CurvePanel.this.currentCurvePoint.setSelected(0);
                if (mouseEvent.getSource() == curvePanel) {
                    if (CurvePanel.this.currentCurvePoint != CurvePanel.this.dummyPoint) {
                        CurvePanel.this.currentCurvePoint = CurvePanel.this.dummyPoint;
                        ActionEvent actionEvent = new ActionEvent(curvePanel, 1001, CurvePanel.ACTION_POINTDESELECTED);
                        CurvePanel.this.actionComponent.dispatchEvent(actionEvent);
                    }
                    if (mouseEvent.isControlDown()) {
                        // empty if block
                    }
                } else {
                    CurvePanel.this.currentCurvePoint = (CurvePoint)mouseEvent.getSource();
                    Point point = CurvePanel.this.currentCurvePoint.getLocation();
                    CurvePanel.this.currentCurvePoint.setSelected(3);
                    if (!mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
                        CurvePanel.this.dragLastX = mouseEvent.getX() + point.x;
                        CurvePanel.this.dragLastY = mouseEvent.getY() + point.y;
                        CurvePanel.this.dragPoint = CurvePanel.this.screenToParamSpace(point.x + 4, point.y + 4);
                        CurvePanel.this.dragType = 0;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!CurvePanel.this.isEnabled()) {
                    return;
                }
                if (CurvePanel.this.dragState) {
                    Graphics graphics = CurvePanel.this.getGraphics();
                    graphics.setXORMode(CurvePanel.this.getBackground());
                    graphics.setColor(Color.black);
                    graphics.drawRect(CurvePanel.this.dragLastX - 4, CurvePanel.this.dragLastY - 4, 7, 7);
                    CurvePanel.this.movePoint(CurvePanel.this.dragSource, CurvePanel.this.dragPoint.x, CurvePanel.this.dragPoint.y);
                    CurvePanel.this.dragState = false;
                    CurvePanel.this.setCursor(CurvePanel.this.lastCursor);
                    graphics.dispose();
                } else if (CurvePanel.this.currentCurvePoint != CurvePanel.this.dummyPoint && !mouseEvent.isAltDown()) {
                    ActionEvent actionEvent = new ActionEvent(curvePanel, 1001, CurvePanel.ACTION_POINTSELECTED);
                    CurvePanel.this.actionComponent.dispatchEvent(actionEvent);
                }
                CurvePanel.this.dragType = -1;
                CurvePanel.this.dragSource = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!CurvePanel.this.isEnabled() || CurvePanel.this.dragType == -1) {
                    return;
                }
                CurvePanel.this.dragSource = (CurvePoint)mouseEvent.getSource();
                Point point = CurvePanel.this.dragSource.getLocation();
                int n = mouseEvent.getX() + point.x;
                int n2 = mouseEvent.getY() + point.y;
                Graphics graphics = CurvePanel.this.getGraphics();
                graphics.setXORMode(CurvePanel.this.getBackground());
                graphics.setColor(Color.black);
                if (!CurvePanel.this.dragState) {
                    if ((n - CurvePanel.this.dragLastX) * (n - CurvePanel.this.dragLastX) + (n2 - CurvePanel.this.dragLastY) * (n2 - CurvePanel.this.dragLastY) <= 16) {
                        return;
                    }
                    Curve curve = CurvePanel.this.curve;
                    synchronized (curve) {
                        int n3 = CurvePanel.this.getComponentIndex(CurvePanel.this.dragSource);
                        CurvePanel.this.dragLeft = CurvePanel.this.curve.getPoint(n3 - 1);
                        CurvePanel.this.dragRight = CurvePanel.this.curve.getPoint(n3 + 1);
                    }
                    CurvePanel.this.lastCursor = CurvePanel.this.getCursor();
                    CurvePanel.this.setCursor(new Cursor(1));
                    CurvePanel.this.dragState = true;
                } else {
                    graphics.drawRect(CurvePanel.this.dragLastX - 4, CurvePanel.this.dragLastY - 4, 7, 7);
                }
                DoublePoint doublePoint = CurvePanel.this.screenToParamSpace(n, n2);
                double d = doublePoint.x;
                double d2 = doublePoint.y;
                if (CurvePanel.this.dragLeft != null && CurvePanel.this.dragRight != null) {
                    if (d <= CurvePanel.this.dragLeft.x) {
                        d = CurvePanel.this.dragLeft.x + CurvePanel.this.curve.hSpace.inc;
                    }
                    if (d >= CurvePanel.this.dragRight.x) {
                        d = CurvePanel.this.dragRight.x - CurvePanel.this.curve.hSpace.inc;
                    }
                } else {
                    d = CurvePanel.this.dragPoint.x;
                }
                point = CurvePanel.this.paramSpaceToScreen(d, d2);
                CurvePanel.this.dragLastX = point.x;
                CurvePanel.this.dragLastY = point.y;
                CurvePanel.this.dragPoint = new DoublePoint(d, d2);
                graphics.drawRect(CurvePanel.this.dragLastX - 4, CurvePanel.this.dragLastY - 4, 7, 7);
                graphics.dispose();
            }
        };
        this.addMouseListener(this.mia);
        this.addMouseMotionListener(this.mia);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (CurvePanel.this.currentCurvePoint != CurvePanel.this.dummyPoint) {
                    CurvePanel.this.currentCurvePoint.setSelected(0);
                    CurvePanel.this.currentCurvePoint = CurvePanel.this.dummyPoint;
                    ActionEvent actionEvent = new ActionEvent(curvePanel, 1001, CurvePanel.ACTION_POINTDESELECTED);
                    CurvePanel.this.actionComponent.dispatchEvent(actionEvent);
                }
            }
        });
        this.setCurve(this.curve);
        this.setFocusable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurve(Curve curve) {
        this.clear();
        Curve curve2 = this.curve;
        synchronized (curve2) {
            this.curve = (Curve)curve.clone();
            this.currentCurvePoint = this.dummyPoint;
            for (int i = curve.size(); i > 0; --i) {
                CurvePoint curvePoint = new CurvePoint();
                curvePoint.addMouseListener(this.mia);
                curvePoint.addMouseMotionListener(this.mia);
                this.add(curvePoint);
            }
        }
        this.recalcScreenPoints();
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_POINTDESELECTED);
        this.actionComponent.dispatchEvent(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Curve getCurve() {
        Curve curve = this.curve;
        synchronized (curve) {
            return (Curve)this.curve.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Curve curve = this.curve;
        synchronized (curve) {
            this.currentCurvePoint = this.dummyPoint;
            while (this.curve.size() > 0) {
                this.curve.removePoint(0);
                CurvePoint curvePoint = (CurvePoint)this.getComponent(0);
                this.remove(curvePoint);
                curvePoint.removeMouseListener(this.mia);
                curvePoint.removeMouseMotionListener(this.mia);
            }
        }
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_POINTDESELECTED);
        this.actionComponent.dispatchEvent(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescale(ParamSpace paramSpace, ParamSpace paramSpace2) {
        Curve curve = this.curve;
        synchronized (curve) {
            int n;
            DoublePoint doublePoint;
            int n2;
            if (paramSpace == null) {
                paramSpace = this.curve.hSpace;
            }
            if (paramSpace2 == null) {
                paramSpace2 = this.curve.vSpace;
            }
            double d = (paramSpace.max - paramSpace.min) / (this.curve.hSpace.max - this.curve.hSpace.min);
            double d2 = (paramSpace2.max - paramSpace2.min) / (this.curve.vSpace.max - this.curve.vSpace.min);
            Curve curve2 = new Curve(paramSpace, paramSpace2, this.curve.type);
            Vector<DoublePoint> vector = new Vector<DoublePoint>();
            for (n2 = this.curve.size() - 1; n2 >= 0; --n2) {
                doublePoint = this.curve.getPoint(n2);
                doublePoint = new DoublePoint((doublePoint.x - this.curve.hSpace.min) * d + paramSpace.min, (doublePoint.y - this.curve.vSpace.min) * d2 + paramSpace2.min);
                n = curve2.addPoint(doublePoint);
                if (n >= 0) continue;
                vector.addElement(doublePoint);
            }
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                int n3;
                DoublePoint doublePoint2;
                doublePoint = (DoublePoint)vector.elementAt(n2);
                double d3 = curve2.indexOf(doublePoint.x);
                if (!(d3 >= 0.0) || !(d3 <= (double)(this.curve.size() - 1)) || (doublePoint2 = curve2.getPoint(n3 = (int)Math.ceil(d3))) == null || (n = curve2.addPoint(doublePoint2.x - curve2.hSpace.inc, doublePoint.y)) >= 0) continue;
                this.remove(0);
            }
            this.curve = curve2;
        }
        this.recalcScreenPoints();
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_SPACECHANGED);
        this.actionComponent.dispatchEvent(actionEvent);
        if (this.currentCurvePoint != this.dummyPoint) {
            actionEvent = new ActionEvent(this, 1001, ACTION_POINTCHANGED);
            this.actionComponent.dispatchEvent(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamSpace getHSpace() {
        Curve curve = this.curve;
        synchronized (curve) {
            return this.curve.hSpace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamSpace getVSpace() {
        Curve curve = this.curve;
        synchronized (curve) {
            return this.curve.vSpace;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionComponent.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionComponent.removeActionListener(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoublePoint getPoint() {
        CurvePoint curvePoint = this.currentCurvePoint;
        int n = this.getComponentIndex(curvePoint);
        if (curvePoint == this.dummyPoint || n < 0) {
            return null;
        }
        Curve curve = this.curve;
        synchronized (curve) {
            DoublePoint doublePoint = this.curve.getPoint(n);
            return doublePoint;
        }
    }

    public boolean setPoint(DoublePoint doublePoint) {
        CurvePoint curvePoint = this.currentCurvePoint;
        if (curvePoint == this.dummyPoint) {
            return false;
        }
        this.movePoint(curvePoint, doublePoint.x, doublePoint.y);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurvePoint addPoint(CurvePoint curvePoint, double d, double d2) {
        curvePoint.addMouseListener(this.mia);
        curvePoint.addMouseMotionListener(this.mia);
        Point point = this.paramSpaceToScreen(d, d2);
        curvePoint.setLocation(point.x - 4, point.y - 4);
        Curve curve = this.curve;
        synchronized (curve) {
            int n = this.curve.addPoint(d, d2);
            if (n >= 0) {
                this.add((Component)curvePoint, n);
                this.repaint();
                this.currentCurvePoint.setSelected(0);
                this.currentCurvePoint = curvePoint;
                this.currentCurvePoint.setSelected(3);
                ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_POINTSELECTED);
                this.actionComponent.dispatchEvent(actionEvent);
                return curvePoint;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePoint(CurvePoint curvePoint) {
        int n = this.getComponentIndex(curvePoint);
        Curve curve = this.curve;
        synchronized (curve) {
            if (n >= 0) {
                this.remove(curvePoint);
                this.curve.removePoint(n);
                this.repaint();
            }
        }
        this.currentCurvePoint.setSelected(0);
        this.currentCurvePoint = this.dummyPoint;
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_POINTDESELECTED);
        this.actionComponent.dispatchEvent(actionEvent);
        curvePoint.removeMouseListener(this.mia);
        curvePoint.removeMouseMotionListener(this.mia);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePoint(CurvePoint curvePoint, double d, double d2) {
        int n = this.getComponentIndex(curvePoint);
        Curve curve = this.curve;
        synchronized (curve) {
            DoublePoint doublePoint = this.curve.getPoint(n);
            if (doublePoint == null) {
                return;
            }
            DoublePoint doublePoint2 = this.curve.getPoint(n - 1);
            DoublePoint doublePoint3 = this.curve.getPoint(n + 1);
            if (doublePoint2 != null && doublePoint3 != null) {
                if (d <= doublePoint2.x) {
                    d = doublePoint2.x + this.curve.hSpace.inc;
                }
                if (d >= doublePoint3.x) {
                    d = doublePoint3.x - this.curve.hSpace.inc;
                }
            } else {
                d = doublePoint.x;
            }
            Point point = this.paramSpaceToScreen(d, d2);
            curvePoint.setLocation(point.x - 4, point.y - 4);
            this.curve.removePoint(n);
            this.curve.addPoint(d, d2);
            this.repaint();
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_POINTCHANGED);
        this.actionComponent.dispatchEvent(actionEvent);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        block6: {
            int n;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n2 = 1 << (int)Math.max(0.0, Math.floor(Math.log((float)this.dim.width / 20.0f) / 0.6931471805599453));
            int n3 = 1 << (int)Math.max(0.0, Math.floor(Math.log((float)this.dim.height / 16.0f) / 0.6931471805599453));
            graphics2D.setPaint(this.isEnabled() ? (this.isDark ? pntGridDark : pntGridLight) : (this.isDark ? pntGridDarkD : pntGridLightD));
            for (n = 0; n <= n2; ++n) {
                graphics2D.drawLine((this.dim.width - 1) * n / n2, 0, (this.dim.width - 1) * n / n2, this.dim.height);
            }
            for (n = 0; n <= n3; ++n) {
                graphics2D.drawLine(0, (this.dim.height - 1) * n / n3, this.dim.width, (this.dim.height - 1) * n / n3);
            }
            int n4 = this.getComponentCount();
            if (n4 < 2) break block6;
            graphics2D.setPaint(this.isEnabled() ? (this.isDark ? pntLineDark : pntLineLight) : (this.isDark ? pntLineDarkD : pntLineLightD));
            Point point = this.getComponent(0).getLocation();
            if (this.curve.type == 0) {
                for (n = 1; n < n4; ++n) {
                    Point point2 = this.getComponent(n).getLocation();
                    graphics2D.drawLine(point.x + 4, point.y + 4, point2.x + 4, point2.y + 4);
                    point = point2;
                }
            } else {
                for (n = 1; n < n4; ++n) {
                    Point point3 = this.getComponent(n).getLocation();
                    graphics2D.drawLine(point.x + 4, point.y + 4, point3.x + 4, point.y + 4);
                    graphics2D.drawLine(point3.x + 4, point.y + 4, point3.x + 4, point3.y + 4);
                    point = point3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalcScreenPoints() {
        Curve curve = this.curve;
        synchronized (curve) {
            for (int i = this.curve.size() - 1; i >= 0; --i) {
                Component component = this.getComponent(i);
                DoublePoint doublePoint = this.curve.getPoint(i);
                Point point = this.paramSpaceToScreen(doublePoint.x, doublePoint.y);
                component.setLocation(point.x - 4, point.y - 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DoublePoint screenToParamSpace(int n, int n2) {
        Curve curve = this.curve;
        synchronized (curve) {
            double d = this.curve.hSpace.min + (this.curve.hSpace.max - this.curve.hSpace.min) * (double)n / (double)(this.dim.width - 1);
            double d2 = this.curve.vSpace.max - (this.curve.vSpace.max - this.curve.vSpace.min) * (double)n2 / (double)(this.dim.height - 1);
            return new DoublePoint(this.curve.hSpace.fitValue(d), this.curve.vSpace.fitValue(d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point paramSpaceToScreen(double d, double d2) {
        Curve curve = this.curve;
        synchronized (curve) {
            int n = (int)((double)(this.dim.width - 1) * (d - this.curve.hSpace.min) / (this.curve.hSpace.max - this.curve.hSpace.min));
            int n2 = (int)((double)(this.dim.height - 1) * (this.curve.vSpace.max - d2) / (this.curve.vSpace.max - this.curve.vSpace.min));
            return new Point(n, n2);
        }
    }

    protected int getComponentIndex(Component component) {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component2 = this.getComponent(i);
            if (component2 != component) continue;
            return i;
        }
        return -1;
    }

    public static class CurvePoint
    extends JPanel {
        private int state = -1;

        protected CurvePoint() {
            super(null);
            Dimension dimension = new Dimension(8, 8);
            this.setSelected(0);
            this.setSize(dimension);
            this.setLocation(0, 0);
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        protected int setSelected(int n) {
            int n2 = this.state;
            this.state = n;
            if (n2 != n) {
                if (n == 0) {
                    this.setForeground(SystemColor.control);
                    this.setBackground(SystemColor.control);
                } else {
                    this.setForeground(OpIcon.selectColor);
                    this.setBackground(OpIcon.selectColor);
                }
                this.repaint();
            }
            return n2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.draw3DRect(1, 1, 5, 5, true);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, 7, 7);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.requestFocus();
            }
            super.processMouseEvent(mouseEvent);
        }
    }
}

