/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.spect.Wavelet;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BlunderFingerDlg
extends ModulePanel {
    private static final int PR_INFITFILE = 0;
    private static final int PR_INPOPFILE = 1;
    private static final int PR_OUTPUTFILE = 2;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_GAINTYPE = 2;
    private static final int PR_CHROMOLEN = 3;
    private static final int PR_CHANFIT = 4;
    private static final int PR_DOMAIN = 5;
    private static final int PR_GAIN = 0;
    private static final int PR_CROSSPOINTS = 1;
    private static final int PR_POPULATION = 2;
    private static final int PR_ITERATIONS = 3;
    private static final int PR_MUTAPROB = 4;
    private static final int PR_MUTAAMOUNT = 5;
    private static final int PR_ELITISM = 0;
    private static final String PRN_INPUTFILE = "InFitFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_PATTERNFILE = "InPopFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_CROSSPOINTS = "CrossPoints";
    private static final String PRN_POPULATION = "Population";
    private static final String PRN_ITERATIONS = "Iterations";
    private static final String PRN_CHROMOLEN = "ChromoLen";
    private static final String PRN_CHANFIT = "ChanFit";
    private static final String PRN_DOMAIN = "Domain";
    private static final String PRN_MUTAPROB = "MutaProb";
    private static final String PRN_MUTAAMOUNT = "MutaAmount";
    private static final String PRN_ELITISM = "Elitism";
    private static final int CHANFIT_WORST = 0;
    private static final int CHANFIT_BEST = 1;
    private static final int CHANFIT_MEAN = 2;
    private static final int DOMAIN_TIME = 0;
    private static final int DOMAIN_WAVELET = 1;
    private static final String[] prText = new String[]{"", "", ""};
    private static final String[] prTextName = new String[]{"InFitFile", "InPopFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 4, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "GainType", "ChromoLen", "ChanFit", "Domain"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "CrossPoints", "Population", "Iterations", "MutaProb", "MutaAmount"};
    private static final boolean[] prBool = new boolean[]{true};
    private static final String[] prBoolName = new String[]{"Elitism"};
    private static final int GG_INFITFILE = 1024;
    private static final int GG_OUTPUTFILE = 1026;
    private static final int GG_INPOPFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_GAINTYPE = 258;
    private static final int GG_CHROMOLEN = 259;
    private static final int GG_CHANFIT = 260;
    private static final int GG_DOMAIN = 261;
    private static final int GG_GAIN = 512;
    private static final int GG_CROSSPOINTS = 513;
    private static final int GG_POPULATION = 514;
    private static final int GG_ITERATIONS = 515;
    private static final int GG_MUTAPROB = 516;
    private static final int GG_MUTAAMOUNT = 517;
    private static final int GG_ELITISM = 0;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_CHANNELS = "Inputs must share\nsame # of channels!";

    public BlunderFingerDlg() {
        super("BlunderFinger");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            BlunderFingerDlg.static_pr.text = prText;
            BlunderFingerDlg.static_pr.textName = prTextName;
            BlunderFingerDlg.static_pr.intg = prIntg;
            BlunderFingerDlg.static_pr.intgName = prIntgName;
            BlunderFingerDlg.static_pr.bool = prBool;
            BlunderFingerDlg.static_pr.boolName = prBoolName;
            BlunderFingerDlg.static_pr.para = prPara;
            BlunderFingerDlg.static_pr.para[1] = new Param(1.0, 0);
            BlunderFingerDlg.static_pr.para[2] = new Param(32.0, 0);
            BlunderFingerDlg.static_pr.para[3] = new Param(300.0, 0);
            BlunderFingerDlg.static_pr.para[4] = new Param(33.3, 48);
            BlunderFingerDlg.static_pr.para[5] = new Param(0.1, 17);
            BlunderFingerDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(BlunderFingerDlg.static_pr.intg, 0, 1);
            this.fillDefaultGain(BlunderFingerDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = BlunderFingerDlg.this.gui.getItemID(itemEvent);
                switch (n) {
                    case 259: {
                        ((BlunderFingerDlg)BlunderFingerDlg.this).pr.intg[n - 256] = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
                        BlunderFingerDlg.this.reflectPropertyChanges();
                    }
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(16, "Select input fit file");
        pathField.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Fit input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(16, "Select input population file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Population input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        PathField pathField3 = new PathField(49, "Select output file");
        pathField3.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField, pathField2};
        pathField3.deriveFrom(pathFieldArray, "$D0$B0Gen$B1$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Evolved output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField3, 1026, null);
        this.gui.registerGadget(pathField3.getTypeGadget(), 256);
        this.gui.registerGadget(pathField3.getResGadget(), 257);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 258, itemListener);
        this.gui.addLabel(new GroupLabel("Evolution settings", 1, 0));
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 2; i <= 16384; i <<= 1) {
            jComboBox.addItem(String.valueOf(i));
        }
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Chromosome length", 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox, 259, itemListener);
        ParamField paramField = new ParamField(new ParamSpace[]{new ParamSpace(1.0, 1000000.0, 1.0, 0)});
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Crossing points", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 513, null);
        ParamField paramField2 = new ParamField(new ParamSpace[]{new ParamSpace(1.0, 1000000.0, 1.0, 0)});
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_ITERATIONS, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField2, 515, null);
        ParamField paramField3 = new ParamField(Constants.spaces[2]);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Mutation probability", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField3, 516, null);
        ParamField paramField4 = new ParamField(new ParamSpace[]{new ParamSpace(2.0, 65536.0, 2.0, 0)});
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_POPULATION, 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField4, 514, null);
        ParamSpace[] paramSpaceArray = new ParamSpace[]{Constants.spaces[5], new ParamSpace(-144.0, 0.0, 0.01, 785)};
        ParamField paramField5 = new ParamField(paramSpaceArray);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Mutation amount", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField5, 517, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_ELITISM, 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addCheckbox(jCheckBox, 0, itemListener);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Worst");
        jComboBox2.addItem("Best");
        jComboBox2.addItem("Mean");
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Multichannel fitness", 4));
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice(jComboBox2, 260, itemListener);
        JComboBox<String> jComboBox3 = new JComboBox<String>();
        jComboBox3.addItem("Time");
        jComboBox3.addItem("Wavelet");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel(PRN_DOMAIN, 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox3, 261, itemListener);
        this.initGUI(this, 6, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile = null;
        AudioFile audioFile2 = null;
        AudioFile audioFile3 = null;
        Param param = new Param(1.0, 1);
        float f = 1.0f;
        float f2 = 0.0f;
        Random random = new Random();
        try {
            audioFile = AudioFile.openAsRead((File)new File(this.pr.text[0]));
            AudioFileDescr audioFileDescr = audioFile.getDescr();
            int n = audioFileDescr.channels;
            long l = (int)audioFileDescr.length;
            if (l < 1L || n < 1) {
                throw new EOFException("File is empty");
            }
            if (this.threadRunning) {
                audioFile3 = AudioFile.openAsRead((File)new File(this.pr.text[1]));
                AudioFileDescr audioFileDescr2 = audioFile3.getDescr();
                int n2 = audioFileDescr2.channels;
                long l2 = audioFileDescr2.length;
                if (l2 < 1L || n2 < 1) {
                    throw new EOFException("File is empty");
                }
                if (this.threadRunning) {
                    int n3;
                    if (n != n2) {
                        throw new IOException(ERR_CHANNELS);
                    }
                    PathField pathField = (PathField)this.gui.getItemObj(1026);
                    if (pathField == null) {
                        throw new IOException("Bug! Missing property!");
                    }
                    AudioFileDescr audioFileDescr3 = new AudioFileDescr(audioFileDescr);
                    pathField.fillStream(audioFileDescr3);
                    audioFileDescr3.channels = n3 = n;
                    audioFile2 = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr3);
                    if (this.threadRunning) {
                        AudioFile audioFile4;
                        int n4;
                        int n5 = 2 << this.pr.intg[3];
                        int n6 = n5 - 1;
                        float[][] fArray = new float[n][Math.max(8192, n5)];
                        float[] fArray2 = new float[n];
                        float[] fArray3 = new float[n];
                        float[][] fArray4 = new float[n][3];
                        int n7 = (int)this.pr.para[2].value;
                        int n8 = n7 - 1;
                        int n9 = n5 + n8;
                        float[][] fArray5 = new float[n][n9];
                        int n10 = 0;
                        float[][][] fArray6 = new float[n7][n][n5];
                        float[][][] fArray7 = new float[n7][n][n5];
                        double[] dArray = new double[n7];
                        double[] dArray2 = new double[n7];
                        float f3 = (float)(this.pr.para[4].value / 100.0);
                        int n11 = this.pr.intg[4];
                        boolean bl = this.pr.bool[0];
                        int n12 = (int)this.pr.para[3].value;
                        int n13 = (int)this.pr.para[1].value;
                        float f4 = (float)(Param.transform((Param)this.pr.para[5], (int)1, (Param)param, null).value * 2.0);
                        float[] fArray8 = new float[n7];
                        int n14 = (n7 + 1) * n7 / 2;
                        double d = 0.0;
                        for (n4 = 0; n4 < n7; ++n4) {
                            double d2 = (double)(n7 - n4) / (double)n14;
                            fArray8[n4] = (float)(d2 + d);
                            d += d2;
                        }
                        assert (Math.abs((double)fArray8[n7 - 1] - 1.0) < 1.0E-6) : fArray8[n7 - 1];
                        fArray8[n8] = 1.0f;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 - 2);
                        int[] nArray = new int[n13 + 1];
                        nArray[n13] = n5;
                        boolean bl2 = this.pr.intg[5] == 1;
                        float[][] fArray9 = bl2 ? Wavelet.getCoeffs(0) : (float[][])null;
                        if (this.pr.intg[2] == 1) {
                            f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                            audioFile4 = null;
                        } else {
                            audioFile4 = this.createTempFile(audioFileDescr3);
                        }
                        long l3 = (l << 2) + (audioFile4 == null ? 0L : l);
                        long l4 = 0L;
                        long l5 = 0L;
                        long l6 = 0L;
                        while (this.threadRunning && l6 < l) {
                            int n15;
                            float f5;
                            int n16;
                            float f6;
                            float[] fArray10;
                            int n17 = (int)Math.min((long)n5, l - l6);
                            audioFile.readFrames(fArray, 0, n17);
                            if (n17 < n5) {
                                Util.clear(fArray, n17, n5 - n17);
                            }
                            for (n4 = 0; n4 < n; ++n4) {
                                fArray10 = fArray[n4];
                                f6 = fArray2[n4];
                                n16 = 0;
                                while (n16 < n17) {
                                    f5 = fArray10[n16];
                                    int n18 = n16++;
                                    fArray10[n18] = fArray10[n18] - f6;
                                    f6 = f5;
                                }
                                fArray2[n4] = f6;
                            }
                            if (bl2) {
                                for (n4 = 0; n4 < n; ++n4) {
                                    Wavelet.fwdTransform(fArray[n4], n5, fArray9);
                                }
                            }
                            int n19 = (int)Math.min((long)(n9 - n10), l2 - l5);
                            Util.copy(fArray5, n5, fArray5, 0, n8);
                            audioFile3.readFrames(fArray5, n10, n19);
                            if (n19 + n10 < n9) {
                                Util.clear(fArray5, n19 + n10, n9 - (n19 + n10));
                            }
                            for (n4 = 0; n4 < n; ++n4) {
                                fArray10 = fArray5[n4];
                                f6 = fArray3[n4];
                                n16 = n10;
                                n15 = n16 + n19;
                                while (n16 < n15) {
                                    f5 = fArray10[n16];
                                    int n20 = n16++;
                                    fArray10[n20] = fArray10[n20] - f6;
                                    f6 = f5;
                                }
                                fArray3[n4] = f6;
                            }
                            for (n4 = 0; n4 < n7; ++n4) {
                                Util.copy(fArray5, n4, fArray6[n4], 0, n5);
                                if (bl2) {
                                    for (n16 = 0; n16 < n; ++n16) {
                                        Wavelet.fwdTransform(fArray6[n4][n16], n5, fArray9);
                                    }
                                }
                                dArray[n4] = BlunderFingerDlg.calcFitness(fArray6[n4], fArray, n11);
                            }
                            Util.sort(dArray, (Object[])fArray6, 0, n7);
                            for (n4 = 0; n4 < n12; ++n4) {
                                int n21 = 0;
                                if (bl) {
                                    n16 = 0;
                                    while (n16 < 2) {
                                        Util.copy(fArray6[n21], 0, fArray7[n21], 0, n5);
                                        dArray2[n21] = dArray[n21];
                                        ++n16;
                                        ++n21;
                                    }
                                }
                                while (n21 < n7) {
                                    int n22;
                                    int n23 = BlunderFingerDlg.wchoose(fArray8, random);
                                    int n24 = BlunderFingerDlg.wchoose(fArray8, random);
                                    if (n24 == n23) {
                                        n24 = n23 == n8 ? n23 - 1 : n23 + 1;
                                    }
                                    arrayList.clear();
                                    for (n16 = 1; n16 < n6; ++n16) {
                                        arrayList.add(new Integer(n16));
                                    }
                                    for (n16 = 0; n16 < n13; ++n16) {
                                        nArray[n16] = (Integer)arrayList.remove(random.nextInt(arrayList.size()));
                                    }
                                    Arrays.sort(nArray, 0, n13);
                                    n15 = 0;
                                    for (n16 = 0; n16 <= n13; ++n16) {
                                        Util.copy(fArray6[n23], n15, fArray7[n21], n15, nArray[n16] - n15);
                                        Util.copy(fArray6[n24], n15, fArray7[n21 + 1], n15, nArray[n16] - n15);
                                        n22 = n23;
                                        n23 = n24;
                                        n24 = n22;
                                        n15 = nArray[n16];
                                    }
                                    if (f3 > 0.0f) {
                                        for (n16 = 0; n16 < n; ++n16) {
                                            for (n15 = 0; n15 < 2; ++n15) {
                                                for (n22 = 0; n22 < n5; ++n22) {
                                                    if (!(random.nextFloat() < f3)) continue;
                                                    float f7 = (random.nextFloat() - 0.5f) * f4;
                                                    float[] fArray11 = fArray7[n21 + n15][n16];
                                                    int n25 = n22;
                                                    fArray11[n25] = fArray11[n25] + f7;
                                                }
                                            }
                                        }
                                    }
                                    for (n16 = 0; n16 < 2; ++n16) {
                                        dArray2[n21 + n16] = BlunderFingerDlg.calcFitness(fArray7[n21 + n16], fArray, n11);
                                    }
                                    n21 += 2;
                                }
                                float[][][] fArray12 = fArray6;
                                fArray6 = fArray7;
                                fArray7 = fArray12;
                                double[] dArray3 = dArray;
                                dArray = dArray2;
                                dArray2 = dArray3;
                                Util.sort(dArray, (Object[])fArray6, 0, n7);
                            }
                            float[][] fArray13 = fArray6[0];
                            if (bl2) {
                                for (n4 = 0; n4 < n; ++n4) {
                                    Wavelet.invTransform(fArray13[n4], n5, fArray9);
                                }
                            }
                            for (n4 = 0; n4 < n; ++n4) {
                                fArray10 = fArray13[n4];
                                f6 = fArray4[n4][0];
                                float f8 = fArray4[n4][1];
                                float f9 = fArray4[n4][2];
                                for (n16 = 0; n16 < n17; ++n16) {
                                    fArray10[n16] = (f6 += fArray10[n16]) - f8 + 0.99f * f9;
                                    f8 = f6;
                                    f9 = fArray10[n16];
                                }
                                fArray4[n4][0] = f6;
                                fArray4[n4][1] = f8;
                                fArray4[n4][2] = f9;
                            }
                            f2 = Math.max(f2, Util.maxAbs(fArray13, 0, n17));
                            if (this.pr.intg[2] == 1) {
                                Util.mult(fArray13, 0, n17, f);
                            }
                            if (audioFile4 != null) {
                                audioFile4.writeFrames(fArray13, 0, n17);
                            } else {
                                audioFile2.writeFrames(fArray13, 0, n17);
                            }
                            l6 += (long)n17;
                            l5 += (long)n19;
                            n10 = n8;
                            this.setProgression((float)(l4 += (long)(n17 << 2)) / (float)l3);
                        }
                        if (this.threadRunning) {
                            audioFile3.close();
                            audioFile3 = null;
                            audioFile.close();
                            audioFile = null;
                            if (this.pr.intg[2] == 0) {
                                f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                                this.normalizeAudioFile(audioFile4, audioFile2, fArray, f, 1.0f);
                                this.deleteTempFile(audioFile4);
                            }
                            if (this.threadRunning) {
                                audioFile2.close();
                                audioFile2 = null;
                                this.handleClipping(f2 *= f);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(new Exception("FScape ran out of memory"));
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
        if (audioFile2 != null) {
            audioFile2.cleanUp();
        }
        if (audioFile3 != null) {
            audioFile3.cleanUp();
        }
    }

    private static double calcFitness(float[][] fArray, float[][] fArray2, int n) {
        double d = 0.0;
        block5: for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            double d2 = 0.0;
            for (int j = 0; j < fArray3.length; ++j) {
                float f = fArray3[j] - fArray4[j];
                d2 += (double)(f * f);
            }
            if (i == 0) {
                d = d2;
                continue;
            }
            switch (n) {
                case 0: {
                    d = Math.max(d, d2);
                    continue block5;
                }
                case 1: {
                    d = Math.min(d, d2);
                    continue block5;
                }
                case 2: {
                    d += d2;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(n));
                }
            }
        }
        return d;
    }

    private static int wchoose(float[] fArray, Random random) {
        int n = Arrays.binarySearch(fArray, random.nextFloat());
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    protected void reflectPropertyChanges() {
        super.reflectPropertyChanges();
        JComboBox jComboBox = (JComboBox)this.gui.getItemObj(259);
        ParamField paramField = (ParamField)this.gui.getItemObj(513);
        if (jComboBox != null && paramField != null) {
            int n = (2 << jComboBox.getSelectedIndex()) - 1;
            paramField.setSpaces(new ParamSpace[]{new ParamSpace(1.0, n, 1.0, 0)});
            if (paramField.getParam().value > (double)n) {
                paramField.setParam(new Param(n, 0));
            }
        }
    }
}

