/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.Behavior;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class WindowFollowBehavior
extends ComponentAdapter
implements Behavior {
    protected final Window attachedWindow;
    protected final Window followedWindow;
    protected boolean enabled = true;
    protected Point lastLocation;

    public WindowFollowBehavior(Window attachedWindow, Window followedWindow) {
        this.attachedWindow = attachedWindow;
        this.followedWindow = followedWindow;
        this.updateLastLocation();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void updateLastLocation() {
        this.lastLocation = this.followedWindow.getLocation();
    }

    public Window getAttachedWindow() {
        return this.attachedWindow;
    }

    public Window getFollowedWindow() {
        return this.followedWindow;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateLastLocation();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.isEnabled() && this.attachedWindow != null && this.followedWindow != null) {
            Point nl = this.followedWindow.getLocation();
            Point fwl = this.attachedWindow.getLocation();
            this.attachedWindow.setLocation(fwl.x + nl.x - this.lastLocation.x, fwl.y + nl.y - this.lastLocation.y);
            this.lastLocation = nl;
        }
    }

    public static WindowFollowBehavior install(Window attachedWindow, Window followedWindow) {
        WindowFollowBehavior windowFollowBehavior = new WindowFollowBehavior(attachedWindow, followedWindow);
        followedWindow.addComponentListener(windowFollowBehavior);
        return windowFollowBehavior;
    }

    public static void uninstall(Window attachedWindow, Window followedWindow) {
        for (ComponentListener listener : followedWindow.getComponentListeners()) {
            if (!(listener instanceof WindowFollowBehavior) || ((WindowFollowBehavior)listener).getAttachedWindow() != attachedWindow) continue;
            followedWindow.removeComponentListener(listener);
        }
    }
}

