/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ConditionalVisibilityListener
implements FocusListener,
MouseListener {
    private Boolean focusedVisible;
    private Boolean mouseoverVisible;
    private Component component;
    private boolean focused = false;
    private boolean mouseover = false;

    public static void install(Component tracked, Component component, Boolean focusedVisible, Boolean mouseoverVisible) {
        ConditionalVisibilityListener cvl = new ConditionalVisibilityListener(component, focusedVisible, mouseoverVisible);
        if (focusedVisible != null) {
            tracked.addFocusListener(cvl);
        }
        if (mouseoverVisible != null) {
            tracked.addMouseListener(cvl);
        }
    }

    public ConditionalVisibilityListener(Component component) {
        this(component, null, null);
    }

    public ConditionalVisibilityListener(Component component, Boolean focusedVisible, Boolean mouseoverVisible) {
        this.setComponent(component);
        this.setFocusedVisible(focusedVisible);
        this.setMouseoverVisible(mouseoverVisible);
    }

    public Boolean getFocusedVisible() {
        return this.focusedVisible;
    }

    public void setFocusedVisible(Boolean focusedVisible) {
        this.focusedVisible = focusedVisible;
    }

    public Boolean getMouseoverVisible() {
        return this.mouseoverVisible;
    }

    public void setMouseoverVisible(Boolean mouseoverVisible) {
        this.mouseoverVisible = mouseoverVisible;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.focusedVisible != null) {
            this.focused = true;
            this.updateVisibility();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.focusedVisible != null) {
            this.focused = false;
            this.updateVisibility();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mouseoverVisible != null) {
            this.mouseover = true;
            this.updateVisibility();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseoverVisible != null) {
            this.mouseover = false;
            this.updateVisibility();
        }
    }

    public void updateVisibility() {
        this.component.setVisible(this.isVisible());
    }

    public boolean isVisible() {
        boolean f = this.focusedVisible == null || this.focusedVisible == this.focused;
        boolean m = this.mouseoverVisible == null || this.mouseoverVisible == this.mouseover;
        return f && m;
    }
}

