/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.swing.ScreenLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractScreenLayout<W extends Window, C>
implements ScreenLayout<W, C> {
    protected final List<W> windows = new ArrayList<W>();
    protected final Map<W, C> constraints = new WeakHashMap<W, C>();
    protected final Object lock = new Object();

    public void addWindow(W window) {
        this.addWindow(window, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWindow(W window, C constraints) {
        Object object = this.lock;
        synchronized (object) {
            this.windows.add(window);
            this.constraints.put(window, constraints);
            this.layoutScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWindow(W window) {
        Object object = this.lock;
        synchronized (object) {
            this.windows.remove(window);
            this.constraints.remove(window);
            this.layoutScreen();
        }
    }
}

