/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.font.DerivedFontAttributes;
import com.alee.utils.map.SoftHashMap;
import java.awt.Font;
import java.util.Map;

public final class FontUtils {
    private static final Map<DerivedFontAttributes, Font> derivedFontsCache = new SoftHashMap();
    public static final int MIN_LAYOUT_CHARCODE = 768;
    public static final int MAX_LAYOUT_CHARCODE = 8303;
    public static final int HI_SURROGATE_START = 55296;
    public static final int LO_SURROGATE_END = 57343;

    public static void clearDerivedFontsCache() {
        if (derivedFontsCache != null) {
            derivedFontsCache.clear();
        }
    }

    public static Font getCachedDerivedFont(Font font, int style, int size) {
        DerivedFontAttributes attribute = FontUtils.getFontAttribute(font, style, size);
        Font derivedFont = derivedFontsCache.get(attribute);
        if (derivedFont == null) {
            derivedFont = font.deriveFont(style, size);
            derivedFontsCache.put(attribute, derivedFont);
        }
        return derivedFont;
    }

    protected static DerivedFontAttributes getFontAttribute(Font font, int style, int size) {
        return new DerivedFontAttributes(font, style, size);
    }

    public static boolean isComplexLayout(char[] text, int start, int limit) {
        return FontUtils.isComplexText(text, start, limit);
    }

    public static boolean isComplexText(char[] chs, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (chs[i] < '\u0300' || !FontUtils.isNonSimpleChar(chs[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isNonSimpleChar(char ch) {
        return FontUtils.isComplexCharCode(ch) || ch >= '\ud800' && ch <= '\udfff';
    }

    static boolean isComplexCharCode(int code) {
        if (code < 768 || code > 8303) {
            return false;
        }
        if (code <= 879) {
            return true;
        }
        if (code < 1424) {
            return false;
        }
        if (code <= 1791) {
            return true;
        }
        if (code < 2304) {
            return false;
        }
        if (code <= 3711) {
            return true;
        }
        if (code < 6016) {
            return false;
        }
        if (code <= 6143) {
            return true;
        }
        if (code < 8204) {
            return false;
        }
        if (code <= 8205) {
            return true;
        }
        if (code >= 8234 && code <= 8238) {
            return true;
        }
        return code >= 8298 && code <= 8303;
    }
}

