/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.laf.grouping.GroupingLayout;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.Round;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.StretchInfo;
import com.alee.utils.MathUtils;
import com.alee.utils.ShapeUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.DataProvider;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

@XStreamAlias(value="WebShape")
public class WebShape<E extends JComponent, D extends WebDecoration<E, D>, I extends WebShape<E, D, I>>
extends AbstractShape<E, D, I> {
    @XStreamAsAttribute
    protected Round round;
    @XStreamAsAttribute
    protected String sides;
    @XStreamAsAttribute
    protected String lines;

    public Round getRound() {
        return this.round != null ? this.round : new Round();
    }

    protected GroupingLayout getGroupingLayout(E c) {
        LayoutManager layout;
        Container parent = ((Component)c).getParent();
        if (parent != null && (layout = parent.getLayout()) instanceof GroupingLayout) {
            return (GroupingLayout)layout;
        }
        return null;
    }

    protected String getSides(E c, D d) {
        if (((AbstractDecoration)d).isSection()) {
            return this.sides;
        }
        GroupingLayout layout = this.getGroupingLayout(c);
        return layout != null ? layout.getSides((Component)c) : this.sides;
    }

    public boolean isPaintTop(E c, D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(0) != '0';
    }

    public boolean isPaintLeft(E c, D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(2) != '0';
    }

    public boolean isPaintBottom(E c, D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(4) != '0';
    }

    public boolean isPaintRight(E c, D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.charAt(6) != '0';
    }

    public boolean isAnySide(E c, D d) {
        String sides = this.getSides(c, d);
        return sides == null || sides.contains("1");
    }

    protected String getLines(E c, D d) {
        if (((AbstractDecoration)d).isSection()) {
            return this.lines;
        }
        GroupingLayout layout = this.getGroupingLayout(c);
        return layout != null ? layout.getLines((Component)c) : this.lines;
    }

    public boolean isPaintTopLine(E c, D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintTop(c, d) && lines != null && lines.charAt(0) == '1';
    }

    public boolean isPaintLeftLine(E c, D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintLeft(c, d) && lines != null && lines.charAt(2) == '1';
    }

    public boolean isPaintBottomLine(E c, D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintBottom(c, d) && lines != null && lines.charAt(4) == '1';
    }

    public boolean isPaintRightLine(E c, D d) {
        String lines = this.getLines(c, d);
        return !this.isPaintRight(c, d) && lines != null && lines.charAt(6) == '1';
    }

    public boolean isAnyLine(E c, D d) {
        return this.isPaintTopLine(c, d) || this.isPaintLeftLine(c, d) || this.isPaintBottomLine(c, d) || this.isPaintRightLine(c, d);
    }

    @Override
    public Insets getBorderInsets(E c, D d) {
        int bottom;
        int left;
        int top;
        int borderWidth = (int)Math.round(Math.floor(((WebDecoration)d).getBorderWidth()));
        int shadowWidth = ((WebDecoration)d).getShadeWidth(ShadowType.outer);
        int spacing = shadowWidth + borderWidth;
        int n = this.isPaintTop(c, d) ? spacing : (top = this.isPaintTopLine(c, d) ? borderWidth : 0);
        int n2 = this.isPaintLeft(c, d) ? spacing : (left = this.isPaintLeftLine(c, d) ? borderWidth : 0);
        int n3 = this.isPaintBottom(c, d) ? spacing : (bottom = this.isPaintBottomLine(c, d) ? borderWidth : 0);
        int right = this.isPaintRight(c, d) ? spacing : (this.isPaintRightLine(c, d) ? borderWidth : 0);
        return new Insets(top, left, bottom, right);
    }

    @Override
    public boolean isVisible(ShapeType type, E c, D d) {
        switch (type) {
            case outerShade: {
                return this.isAnySide(c, d);
            }
            case border: {
                return this.isAnySide(c, d) || this.isAnyLine(c, d);
            }
        }
        return true;
    }

    @Override
    public Shape getShape(final ShapeType type, final Rectangle bounds, E c, D d) {
        final Round r = this.getRound();
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        final boolean top = this.isPaintTop(c, d);
        final boolean bottom = this.isPaintBottom(c, d);
        final boolean left = ltr ? this.isPaintLeft(c, d) : this.isPaintRight(c, d);
        final boolean right = ltr ? this.isPaintRight(c, d) : this.isPaintLeft(c, d);
        final int sw = ((WebDecoration)d).getShadeWidth(ShadowType.outer);
        return ShapeUtils.getShape(c, (String)("WebShape." + (Object)((Object)type)), (DataProvider)new DataProvider<Shape>(){

            public Shape provide() {
                int x = bounds.x;
                int y = bounds.y;
                int w = bounds.width;
                int h = bounds.height;
                if (type.isBorder()) {
                    boolean connect;
                    GeneralPath shape = new GeneralPath(0);
                    boolean moved = false;
                    if (top) {
                        shape.moveTo(x + (left ? sw + r.topLeft : 0), y + sw);
                        if (right) {
                            shape.lineTo(x + w - sw - r.topRight - 1, y + sw);
                            shape.quadTo(x + w - sw - 1, y + sw, x + w - sw - 1, y + sw + r.topRight);
                        } else {
                            shape.lineTo(x + w - 1, y + sw);
                        }
                        connect = true;
                    } else {
                        connect = false;
                    }
                    if (right) {
                        if (!connect) {
                            shape.moveTo(x + w - sw - 1, y + (top ? sw + r.topRight : 0));
                            moved = true;
                        }
                        if (bottom) {
                            shape.lineTo(x + w - sw - 1, y + h - sw - r.bottomRight - 1);
                            shape.quadTo(x + w - sw - 1, y + h - sw - 1, x + w - sw - r.bottomRight - 1, y + h - sw - 1);
                        } else {
                            shape.lineTo(x + w - sw - 1, y + h - 1);
                        }
                        connect = true;
                    } else {
                        connect = false;
                    }
                    if (bottom) {
                        if (!connect) {
                            shape.moveTo(x + w + (right ? -sw - r.bottomRight - 1 : -1), y + h - sw - 1);
                            moved = true;
                        }
                        if (left) {
                            shape.lineTo(x + sw + r.bottomLeft, y + h - sw - 1);
                            shape.quadTo(x + sw, y + h - sw - 1, x + sw, y + h - sw - r.bottomLeft - 1);
                        } else {
                            shape.lineTo(x, y + h - sw - 1);
                        }
                        connect = true;
                    } else {
                        connect = false;
                    }
                    if (left) {
                        if (!connect) {
                            shape.moveTo(x + sw, y + h + (bottom ? -sw - r.bottomLeft - 1 : -1));
                            moved = true;
                        }
                        if (top) {
                            shape.lineTo(x + sw, y + sw + r.topLeft);
                            shape.quadTo(x + sw, y + sw, x + sw + r.topLeft, y + sw);
                            if (!moved) {
                                shape.closePath();
                            }
                        } else {
                            shape.lineTo(x + sw, y);
                        }
                    }
                    return shape;
                }
                int shShear = type.isOuterShade() ? sw : 0;
                int bgShear = type.isBorder() ? -1 : 0;
                Point[] corners = new Point[4];
                int[] rounded = new int[4];
                corners[0] = WebShape.this.p(x + (left ? sw : -shShear), y + (top ? sw : -shShear));
                rounded[0] = left && top && r.topLeft > 0 ? r.topLeft + 1 : 0;
                corners[1] = WebShape.this.p(x + (right ? w - sw : w + shShear) + bgShear, y + (top ? sw : -shShear));
                rounded[1] = right && top && r.topRight > 0 ? r.topRight + 1 : 0;
                corners[2] = WebShape.this.p(x + (right ? w - sw : w + shShear) + bgShear, y + (bottom ? h - sw : h + shShear) + bgShear);
                rounded[2] = right && bottom && r.bottomRight > 0 ? r.bottomRight + 1 : 0;
                corners[3] = WebShape.this.p(x + (left ? sw : -shShear), y + (bottom ? h - sw : h + shShear) + bgShear);
                rounded[3] = left && bottom && r.bottomLeft > 0 ? r.bottomLeft + 1 : 0;
                return ShapeUtils.createRoundedShape((Point[])corners, (int[])rounded);
            }
        }, (Object[])new Object[]{bounds, sw, r, top, bottom, left, right});
    }

    @Override
    public Object[] getShapeSettings(Rectangle bounds, E c, D d) {
        Round r = this.getRound();
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        boolean top = this.isPaintTop(c, d);
        boolean bottom = this.isPaintBottom(c, d);
        boolean left = ltr ? this.isPaintLeft(c, d) : this.isPaintRight(c, d);
        boolean right = ltr ? this.isPaintRight(c, d) : this.isPaintLeft(c, d);
        return new Object[]{r, top, bottom, left, right};
    }

    @Override
    public StretchInfo getStretchInfo(Rectangle bounds, E c, D d) {
        Round r = this.getRound();
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        boolean top = this.isPaintTop(c, d);
        boolean bottom = this.isPaintBottom(c, d);
        boolean left = ltr ? this.isPaintLeft(c, d) : this.isPaintRight(c, d);
        boolean right = ltr ? this.isPaintRight(c, d) : this.isPaintLeft(c, d);
        int sw = ((WebDecoration)d).getShadeWidth(ShadowType.outer);
        int bw = (int)Math.ceil(((WebDecoration)d).getBorderWidth());
        int isw = ((WebDecoration)d).getShadeWidth(ShadowType.inner);
        int x0 = bounds.x + (left ? sw : 0) + MathUtils.max((int[])new int[]{bw, isw, r.topLeft, r.bottomLeft});
        int x1 = bounds.x + bounds.width - 1 - (right ? sw : 0) - MathUtils.max((int[])new int[]{isw, bw, r.topRight, r.bottomRight});
        Pair hor = x0 < x1 ? new Pair((Object)x0, (Object)x1) : null;
        int y0 = bounds.y + (top ? sw : 0) + MathUtils.max((int[])new int[]{isw, bw, r.topLeft, r.topRight});
        int y1 = bounds.y + bounds.height - 1 - (bottom ? sw : 0) - MathUtils.max((int[])new int[]{isw, bw, r.bottomLeft, r.bottomRight});
        Pair ver = y0 < y1 ? new Pair((Object)y0, (Object)y1) : null;
        return new StretchInfo((Pair<Integer, Integer>)hor, (Pair<Integer, Integer>)ver);
    }

    @Override
    public I merge(I shape) {
        super.merge(shape);
        if (((WebShape)shape).round != null) {
            this.round = ((WebShape)shape).round;
        }
        if (((WebShape)shape).sides != null) {
            this.sides = ((WebShape)shape).sides;
        }
        if (((WebShape)shape).lines != null) {
            this.lines = ((WebShape)shape).lines;
        }
        return (I)this;
    }
}

