/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shadow;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.shadow.IShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.utils.MergeUtils;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import javax.swing.JComponent;

public abstract class AbstractShadow<E extends JComponent, D extends IDecoration<E, D>, I extends AbstractShadow<E, D, I>>
implements IShadow<E, D, I> {
    @XStreamAsAttribute
    protected ShadowType type;
    @XStreamAsAttribute
    protected Float opacity;
    @XStreamAsAttribute
    protected Integer width;
    @XStreamAsAttribute
    protected Color color;

    public String getId() {
        return this.getType().toString();
    }

    @Override
    public ShadowType getType() {
        return this.type != null ? this.type : ShadowType.outer;
    }

    public float getOpacity() {
        return this.opacity != null ? this.opacity.floatValue() : 0.7f;
    }

    @Override
    public int getWidth() {
        return this.width != null ? this.width : 0;
    }

    public Color getColor() {
        return this.color != null ? this.color : Color.BLACK;
    }

    public I merge(I shadow) {
        if (((AbstractShadow)shadow).opacity != null) {
            this.opacity = ((AbstractShadow)shadow).opacity;
        }
        if (((AbstractShadow)shadow).width != null) {
            this.width = ((AbstractShadow)shadow).width;
        }
        if (((AbstractShadow)shadow).color != null) {
            this.color = ((AbstractShadow)shadow).color;
        }
        return (I)this;
    }

    public I clone() {
        return (I)((AbstractShadow)MergeUtils.cloneByFieldsSafely((Object)this, (Object[])new Object[0]));
    }
}

