/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="ColorBackground")
public class ColorBackground<E extends JComponent, D extends IDecoration<E, D>, I extends ColorBackground<E, D, I>>
extends AbstractBackground<E, D, I> {
    @XStreamAsAttribute
    protected Color color;

    public Color getColor() {
        return this.color != null ? this.color : Color.WHITE;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        float opacity = this.getOpacity();
        if (opacity > 0.0f) {
            Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.getColor());
            g2d.fill(shape);
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
            GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        }
    }

    @Override
    public I merge(I background) {
        super.merge(background);
        if (((ColorBackground)background).color != null) {
            this.color = ((ColorBackground)background).color;
        }
        return (I)this;
    }
}

