/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.painter.AbstractPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class ColorPainter<E extends JComponent, U extends ComponentUI>
extends AbstractPainter<E, U> {
    protected Color color;

    public ColorPainter() {
        this.color = null;
    }

    public ColorPainter(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    @Override
    public Boolean isOpaque() {
        Color color = this.getCurrentColor();
        return color != null && color.getAlpha() == 255;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        Color color = this.getCurrentColor();
        if (color != null) {
            Rectangle r = ((JComponent)c).getVisibleRect().intersection(bounds);
            if (r.width > 0 && r.height > 0) {
                g2d.setPaint(color);
                g2d.fillRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    protected Color getCurrentColor() {
        return this.color != null ? this.color : this.component.getBackground();
    }
}

