/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.date.WebDateField;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.log.Log;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;

public enum StyleableComponent implements IconSupport,
TitleSupport
{
    label(JLabel.class, "LabelUI", WebLookAndFeel.labelUI, StyleId.label),
    styledlabel(WebStyledLabel.class, "StyledLabelUI", WebLookAndFeel.styledLabelUI, StyleId.styledlabel),
    tooltip(JToolTip.class, "ToolTipUI", WebLookAndFeel.toolTipUI, StyleId.tooltip),
    button(JButton.class, "ButtonUI", WebLookAndFeel.buttonUI, StyleId.button),
    splitbutton(WebSplitButton.class, "SplitButtonUI", WebLookAndFeel.splitButtonUI, StyleId.splitbutton),
    togglebutton(JToggleButton.class, "ToggleButtonUI", WebLookAndFeel.toggleButtonUI, StyleId.togglebutton),
    checkbox(JCheckBox.class, "CheckBoxUI", WebLookAndFeel.checkBoxUI, StyleId.checkbox),
    tristatecheckbox(WebTristateCheckBox.class, "TristateCheckBoxUI", WebLookAndFeel.tristateCheckBoxUI, StyleId.tristatecheckbox),
    radiobutton(JRadioButton.class, "RadioButtonUI", WebLookAndFeel.radioButtonUI, StyleId.radiobutton),
    separator(JSeparator.class, "SeparatorUI", WebLookAndFeel.separatorUI, StyleId.separator),
    menubar(JMenuBar.class, "MenuBarUI", WebLookAndFeel.menuBarUI, StyleId.menubar),
    menu(JMenu.class, "MenuUI", WebLookAndFeel.menuUI, StyleId.menu),
    popupmenu(JPopupMenu.class, "PopupMenuUI", WebLookAndFeel.popupMenuUI, StyleId.popupmenu),
    menuitem(JMenuItem.class, "MenuItemUI", WebLookAndFeel.menuItemUI, StyleId.menuitem),
    checkboxmenuitem(JCheckBoxMenuItem.class, "CheckBoxMenuItemUI", WebLookAndFeel.checkBoxMenuItemUI, StyleId.checkboxmenuitem),
    radiobuttonmenuitem(JRadioButtonMenuItem.class, "RadioButtonMenuItemUI", WebLookAndFeel.radioButtonMenuItemUI, StyleId.radiobuttonmenuitem),
    popupmenuseparator(JPopupMenu.Separator.class, "PopupMenuSeparatorUI", WebLookAndFeel.popupMenuSeparatorUI, StyleId.popupmenuseparator),
    panel(JPanel.class, "PanelUI", WebLookAndFeel.panelUI, StyleId.panel),
    rootpane(JRootPane.class, "RootPaneUI", WebLookAndFeel.rootPaneUI, StyleId.rootpane),
    tabbedpane(JTabbedPane.class, "TabbedPaneUI", WebLookAndFeel.tabbedPaneUI, StyleId.tabbedpane),
    splitpane(JSplitPane.class, "SplitPaneUI", WebLookAndFeel.splitPaneUI, StyleId.splitpane),
    toolbar(JToolBar.class, "ToolBarUI", WebLookAndFeel.toolBarUI, StyleId.toolbar),
    toolbarseparator(JToolBar.Separator.class, "ToolBarSeparatorUI", WebLookAndFeel.toolBarSeparatorUI, StyleId.toolbarseparator),
    statusbar(WebStatusBar.class, "StatusBarUI", WebLookAndFeel.statusBarUI, StyleId.statusbar),
    scrollbar(JScrollBar.class, "ScrollBarUI", WebLookAndFeel.scrollBarUI, StyleId.scrollbar),
    scrollpane(JScrollPane.class, "ScrollPaneUI", WebLookAndFeel.scrollPaneUI, StyleId.scrollpane),
    viewport(JViewport.class, "ViewportUI", WebLookAndFeel.viewportUI, StyleId.viewport),
    textfield(JTextField.class, "TextFieldUI", WebLookAndFeel.textFieldUI, StyleId.textfield),
    passwordfield(JPasswordField.class, "PasswordFieldUI", WebLookAndFeel.passwordFieldUI, StyleId.passwordfield),
    formattedtextfield(JFormattedTextField.class, "FormattedTextFieldUI", WebLookAndFeel.formattedTextFieldUI, StyleId.formattedtextfield),
    textarea(JTextArea.class, "TextAreaUI", WebLookAndFeel.textAreaUI, StyleId.textarea),
    editorpane(JEditorPane.class, "EditorPaneUI", WebLookAndFeel.editorPaneUI, StyleId.editorpane),
    textpane(JTextPane.class, "TextPaneUI", WebLookAndFeel.textPaneUI, StyleId.textpane),
    tableheader(JTableHeader.class, "TableHeaderUI", WebLookAndFeel.tableHeaderUI, StyleId.tableheader),
    table(JTable.class, "TableUI", WebLookAndFeel.tableUI, StyleId.table),
    progressbar(JProgressBar.class, "ProgressBarUI", WebLookAndFeel.progressBarUI, StyleId.progressbar),
    slider(JSlider.class, "SliderUI", WebLookAndFeel.sliderUI, StyleId.slider),
    spinner(JSpinner.class, "SpinnerUI", WebLookAndFeel.spinnerUI, StyleId.spinner),
    combobox(JComboBox.class, "ComboBoxUI", WebLookAndFeel.comboBoxUI, StyleId.combobox),
    list(JList.class, "ListUI", WebLookAndFeel.listUI, StyleId.list),
    tree(JTree.class, "TreeUI", WebLookAndFeel.treeUI, StyleId.tree),
    colorchooser(JColorChooser.class, "ColorChooserUI", WebLookAndFeel.colorChooserUI, StyleId.colorchooser),
    filechooser(JFileChooser.class, "FileChooserUI", WebLookAndFeel.fileChooserUI, StyleId.filechooser),
    desktoppane(JDesktopPane.class, "DesktopPaneUI", WebLookAndFeel.desktopPaneUI, StyleId.desktoppane),
    desktopicon(JInternalFrame.JDesktopIcon.class, "DesktopIconUI", WebLookAndFeel.desktopIconUI, StyleId.desktopicon),
    internalframe(JInternalFrame.class, "InternalFrameUI", WebLookAndFeel.internalFrameUI, StyleId.internalframe),
    optionpane(JOptionPane.class, "OptionPaneUI", WebLookAndFeel.optionPaneUI, StyleId.optionpane),
    datefield(WebDateField.class, "DateFieldUI", WebLookAndFeel.dateFieldUI, StyleId.datefield);

    private static final Map<StyleableComponent, ImageIcon> componentIcons;
    private static final Map<String, StyleableComponent> componentByUIClassID;
    private static final Map<Class<? extends ComponentUI>, StyleableComponent> componentByUIClass;
    protected final Class<? extends JComponent> componentClass;
    protected final String uiClassID;
    protected final String defaultUIClass;
    protected final StyleId defaultStyleId;

    private StyleableComponent(Class<? extends JComponent> componentClass, String uiClassID, String defaultUIClass, StyleId styleId) {
        this.componentClass = componentClass;
        this.uiClassID = uiClassID;
        this.defaultUIClass = defaultUIClass;
        this.defaultStyleId = styleId;
    }

    public Class<? extends JComponent> getComponentClass() {
        return this.componentClass;
    }

    public String getUIClassID() {
        return this.uiClassID;
    }

    public String getDefaultUIClass() {
        return this.defaultUIClass;
    }

    public Class<? extends ComponentUI> getUIClass() {
        Class type = ReflectUtils.getClassSafely((String)UIManager.getString(this.getUIClassID()));
        Class defaultType = ReflectUtils.getClassSafely((String)this.getDefaultUIClass());
        return ReflectUtils.isAssignable((Class)defaultType, (Class)type) ? type : defaultType;
    }

    public StyleId getDefaultStyleId() {
        return this.defaultStyleId;
    }

    public ImageIcon getIcon() {
        if (componentIcons.containsKey((Object)this)) {
            return componentIcons.get((Object)this);
        }
        try {
            ImageIcon icon = new ImageIcon(StyleableComponent.class.getResource("icons/styleable/" + (Object)((Object)this) + ".png"));
            componentIcons.put(this, icon);
            return icon;
        }
        catch (Throwable e) {
            Log.get().error("Unable to find component icon: " + (Object)((Object)this), e);
            componentIcons.put(this, null);
            return null;
        }
    }

    public String getTitle() {
        return ReflectUtils.getClassName(this.getComponentClass());
    }

    public static boolean isSupported(Component component) {
        return component instanceof JComponent && StyleableComponent.isSupported(((JComponent)component).getUIClassID());
    }

    public static boolean isSupported(String uiClassID) {
        return StyleableComponent.getImpl(uiClassID) != null;
    }

    public static boolean isSupported(ComponentUI ui) {
        return StyleableComponent.isSupported(ui.getClass());
    }

    public static boolean isSupported(Class<? extends ComponentUI> uiClass) {
        return StyleableComponent.getImpl(uiClass) != null;
    }

    public static StyleableComponent get(JComponent component) {
        return StyleableComponent.get(component.getUIClassID());
    }

    public static StyleableComponent get(String uiClassID) {
        StyleableComponent type = StyleableComponent.getImpl(uiClassID);
        if (type == null) {
            throw new StyleException("Unsupported component UI class ID: " + uiClassID);
        }
        return type;
    }

    public static StyleableComponent get(ComponentUI ui) {
        return StyleableComponent.get(ui.getClass());
    }

    public static StyleableComponent get(Class<? extends ComponentUI> uiClass) {
        StyleableComponent type = StyleableComponent.getImpl(uiClass);
        if (type == null) {
            throw new StyleException("Unsupported component UI class: " + uiClass);
        }
        return type;
    }

    private static StyleableComponent getImpl(String uiClassID) {
        if (componentByUIClassID.size() == 0) {
            for (StyleableComponent supportedComponent : StyleableComponent.values()) {
                componentByUIClassID.put(supportedComponent.getUIClassID(), supportedComponent);
            }
        }
        return componentByUIClassID.get(uiClassID);
    }

    private static StyleableComponent getImpl(Class<? extends ComponentUI> uiClass) {
        StyleableComponent type = componentByUIClass.get(uiClass);
        if (type == null) {
            for (StyleableComponent supportedComponent : StyleableComponent.values()) {
                Class<? extends ComponentUI> typeClass = supportedComponent.getUIClass();
                if (!ReflectUtils.isAssignable(typeClass, uiClass)) continue;
                type = supportedComponent;
                componentByUIClass.put(uiClass, supportedComponent);
                break;
            }
        }
        return type;
    }

    public static List<StyleableComponent> list() {
        return CollectionUtils.asList((Object[])StyleableComponent.values());
    }

    static {
        componentIcons = new EnumMap<StyleableComponent, ImageIcon>(StyleableComponent.class);
        componentByUIClassID = new HashMap<String, StyleableComponent>(StyleableComponent.values().length);
        componentByUIClass = new HashMap<Class<? extends ComponentUI>, StyleableComponent>(StyleableComponent.values().length);
    }
}

