/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.painter.Painter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public final class StyleData
implements PropertyChangeListener {
    private final WeakReference<JComponent> component;
    private Skin skin;
    private boolean pinnedSkin;
    private StyleId styleId;
    private Map<String, Painter> painters;
    private List<WeakReference<JComponent>> children;
    private List<StyleListener> listeners;

    public StyleData(JComponent component) {
        this.component = new WeakReference<JComponent>(component);
        this.skin = null;
        this.pinnedSkin = false;
        this.styleId = null;
        this.painters = null;
        this.children = null;
        this.listeners = null;
        component.addPropertyChangeListener("styleId", this);
        component.addPropertyChangeListener("parent", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent component = this.getComponentImpl();
        Object styleId = component.getClientProperty("styleId");
        if (styleId != null) {
            if (styleId instanceof StyleId) {
                StyleManager.setStyleId(component, (StyleId)styleId);
            } else if (styleId instanceof String) {
                String id = (String)styleId;
                Object parent = component.getClientProperty("parent");
                if (parent != null) {
                    if (parent instanceof JComponent) {
                        StyleManager.setStyleId(component, StyleId.of(id, (JComponent)parent));
                    } else if (parent instanceof WeakReference) {
                        Object p = ((WeakReference)parent).get();
                        if (p != null && p instanceof JComponent) {
                            StyleManager.setStyleId(component, StyleId.of(id, (JComponent)p));
                        } else {
                            StyleManager.setStyleId(component, StyleId.of(id));
                        }
                    } else {
                        StyleManager.setStyleId(component, StyleId.of(id));
                    }
                } else {
                    StyleManager.setStyleId(component, StyleId.of(id));
                }
            }
        } else {
            StyleManager.restoreStyleId(component);
        }
    }

    public WeakReference<JComponent> getComponent() {
        return this.component;
    }

    private JComponent getComponentImpl() {
        JComponent component = (JComponent)this.component.get();
        if (component == null) {
            throw new StyleException("Component for style ID \"" + this.styleId.getCompleteId() + "\" has been destroyed");
        }
        return component;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public boolean isPinnedSkin() {
        return this.pinnedSkin;
    }

    public void setPinnedSkin(boolean pinnedSkin) {
        this.pinnedSkin = pinnedSkin;
    }

    public Skin applySkin(Skin skin, boolean applyToChildren) {
        JComponent component = this.getComponentImpl();
        boolean newSkin = skin != this.getSkin();
        Skin oldSkin = newSkin ? this.removeSkin() : this.getSkin();
        if (newSkin && skin != null) {
            skin.applySkin(component);
            this.skin = skin;
        }
        if (newSkin) {
            this.setPinnedSkin(false);
        }
        if (skin != null && applyToChildren) {
            this.applyChildrenSkin(skin);
        }
        if (newSkin) {
            this.fireSkinChanged(component, oldSkin, skin);
            this.fireSkinUpdated(component, this.getStyleId());
        }
        return oldSkin;
    }

    private void applyChildrenSkin(Skin skin) {
        if (this.children != null) {
            for (WeakReference<JComponent> reference : this.children) {
                JComponent child = (JComponent)reference.get();
                if (child == null) continue;
                StyleManager.setSkin(child, skin);
            }
        }
    }

    public void updateSkin() {
        JComponent component = this.getComponentImpl();
        this.getSkin().updateSkin(component);
        if (this.children != null) {
            for (WeakReference<JComponent> reference : this.children) {
                JComponent child = (JComponent)reference.get();
                if (child == null) continue;
                StyleManager.updateSkin(child);
            }
        }
        this.fireSkinUpdated(component, this.getStyleId());
    }

    public Skin removeSkin() {
        Skin oldSkin = this.skin;
        if (this.skin != null) {
            JComponent component = this.getComponentImpl();
            this.skin.removeSkin(component);
            this.skin = null;
        }
        return oldSkin;
    }

    public StyleId getStyleId() {
        return this.styleId;
    }

    public void setStyleId(StyleId styleId) {
        JComponent component = this.getComponentImpl();
        StyleId oldStyleId = this.styleId;
        this.styleId = styleId;
        this.updateSkin();
        this.fireStyleChanged(component, oldStyleId, styleId);
    }

    public Map<String, Painter> getPainters() {
        return this.painters;
    }

    public void setPainters(Map<String, Painter> painters) {
        this.painters = painters;
    }

    public List<WeakReference<JComponent>> getChildren() {
        return this.children;
    }

    public void addChild(JComponent child) {
        if (this.children == null) {
            this.children = new ArrayList<WeakReference<JComponent>>(1);
        }
        this.children.add(new WeakReference<JComponent>(child));
    }

    public void removeChild(JComponent child) {
        Iterator<WeakReference<JComponent>> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            WeakReference<JComponent> next = iterator.next();
            if (next.get() != child) continue;
            iterator.remove();
        }
    }

    public void addStyleListener(StyleListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<StyleListener>(1);
        }
        this.listeners.add(listener);
    }

    public void removeStyleListener(StyleListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireSkinChanged(JComponent component, Skin oldSkin, Skin newSkin) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.skinChanged(component, oldSkin, newSkin);
            }
        }
    }

    private void fireStyleChanged(JComponent component, StyleId oldStyleId, StyleId newStyleId) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.styleChanged(component, oldStyleId, newStyleId);
            }
        }
    }

    private void fireSkinUpdated(JComponent component, StyleId styleId) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.skinUpdated(component, styleId);
            }
        }
    }
}

