/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.managers.style.AbstractSkin;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.utils.XmlUtils;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CustomSkin
extends AbstractSkin {
    protected SkinInfo skinInfo;

    public CustomSkin(String location) {
        this.skinInfo = (SkinInfo)XmlUtils.fromXML((URL)this.getClass().getResource(location));
    }

    public CustomSkin(Class nearClass, String location) {
        this.skinInfo = (SkinInfo)XmlUtils.fromXML((URL)nearClass.getResource(location));
    }

    public CustomSkin(File location) {
        this.skinInfo = (SkinInfo)XmlUtils.fromXML((File)location);
    }

    public CustomSkin(SkinInfo skinInfo) {
        this.skinInfo = skinInfo;
    }

    public SkinInfo getSkinInfo() {
        return this.skinInfo;
    }

    @Override
    public String getId() {
        return this.skinInfo.getId();
    }

    @Override
    public Icon getIcon() {
        return this.skinInfo.getIcon();
    }

    @Override
    public String getTitle() {
        return this.skinInfo.getTitle();
    }

    @Override
    public String getDescription() {
        return this.skinInfo.getDescription();
    }

    @Override
    public String getAuthor() {
        return this.skinInfo.getAuthor();
    }

    @Override
    public List<String> getSupportedSystems() {
        return this.skinInfo.getSupportedSystemsList();
    }

    @Override
    public String getSkinClass() {
        return this.skinInfo.getSkinClass();
    }

    @Override
    public ComponentStyle getComponentStyle(JComponent component) {
        StyleableComponent type = StyleableComponent.get(component);
        return this.skinInfo.getStyle(component, type);
    }
}

