/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.effects;

import com.alee.extended.window.TestFrame;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class ShapeTransition {
    private static Shape shape = null;
    private static JComponent component;
    private static WebTimer timer;
    private static int counter;

    public static void main(String[] args) {
        WebLookAndFeel.install();
        final Arc2D.Double circle = new Arc2D.Double(0.0, 0.0, 800.0, 800.0, 0.0, 270.0, 2);
        final Line2D.Double line = new Line2D.Double(0.0, 0.0, 800.0, 0.0);
        component = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                GraphicsUtils.setupAntialias((Graphics2D)g2d);
                g2d.setPaint(Color.BLACK);
                g2d.draw(shape != null ? shape : circle);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(800, 800);
            }
        };
        MouseAdapter a = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (timer != null && timer.isRunning()) {
                    this.reset();
                } else {
                    this.addPoint(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (timer != null && timer.isRunning()) {
                    this.reset();
                } else {
                    this.addPoint(e);
                }
            }

            protected void reset() {
            }

            protected void addPoint(MouseEvent e) {
            }
        };
        component.addMouseListener(a);
        component.addMouseMotionListener(a);
        component.setFocusable(true);
        TestFrame.show(component);
        HotkeyManager.registerHotkey(Hotkey.SPACE, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                System.out.println("STARTED!");
                ShapeTransition.perform(circle, line, 5000L);
            }
        });
        component.requestFocusInWindow();
    }

    public static void perform(Shape startShape, Shape endShape, long time) {
        List<PointInfo> startInfo = ShapeTransition.gatherInfo(startShape.getPathIterator(null));
        List<PointInfo> endInfo = ShapeTransition.gatherInfo(endShape.getPathIterator(null));
        final List<PointInfo> srcPoints = ShapeTransition.calculateSrc(startInfo);
        final List<PointInfo> dstPoints = ShapeTransition.calculateDst(startInfo, endInfo);
        if (timer != null) {
            timer.stop();
        }
        timer = WebTimer.repeat((long)16L, (int)0, (boolean)true, (ActionListener)new ActionListener(){
            private float progress = 0.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.progress += (1.0f - this.progress) * 0.05f;
                GeneralPath gp = new GeneralPath(0);
                block7: for (int i = 0; i < srcPoints.size(); ++i) {
                    PointInfo src = (PointInfo)srcPoints.get(i);
                    PointInfo dst = (PointInfo)dstPoints.get(i);
                    switch (src.command) {
                        case 0: {
                            gp.moveTo(ShapeTransition.progress(src.points[0], dst.points[0], this.progress), ShapeTransition.progress(src.points[1], dst.points[1], this.progress));
                            continue block7;
                        }
                        case 1: {
                            gp.lineTo(ShapeTransition.progress(src.points[0], dst.points[0], this.progress), ShapeTransition.progress(src.points[1], dst.points[1], this.progress));
                            continue block7;
                        }
                        case 2: {
                            gp.quadTo(ShapeTransition.progress(src.points[0], dst.points[0], this.progress), ShapeTransition.progress(src.points[1], dst.points[1], this.progress), ShapeTransition.progress(src.points[2], dst.points[2], this.progress), ShapeTransition.progress(src.points[3], dst.points[3], this.progress));
                            continue block7;
                        }
                        case 3: {
                            gp.curveTo(ShapeTransition.progress(src.points[0], dst.points[0], this.progress), ShapeTransition.progress(src.points[1], dst.points[1], this.progress), ShapeTransition.progress(src.points[2], dst.points[2], this.progress), ShapeTransition.progress(src.points[3], dst.points[3], this.progress), ShapeTransition.progress(src.points[4], dst.points[4], this.progress), ShapeTransition.progress(src.points[5], dst.points[5], this.progress));
                            continue block7;
                        }
                        case 4: {
                            gp.closePath();
                        }
                    }
                }
                shape = gp;
                if (this.progress >= 1.0f) {
                    this.progress = 1.0f;
                    timer.stop();
                } else {
                    component.repaint();
                }
            }
        });
    }

    private static List<PointInfo> calculateSrc(List<PointInfo> startInfo) {
        return startInfo;
    }

    private static List<PointInfo> calculateDst(List<PointInfo> startInfo, List<PointInfo> endInfo) {
        ArrayList<PointInfo> dstInfo = new ArrayList<PointInfo>(startInfo.size());
        Point2D.Double p1 = new Point2D.Double(endInfo.get((int)0).points[0], endInfo.get((int)0).points[1]);
        Point2D.Double p2 = new Point2D.Double(endInfo.get((int)1).points[0], endInfo.get((int)1).points[1]);
        block7: for (int i = 0; i < startInfo.size(); ++i) {
            float x = (float)(p1.x + p2.x) * (float)i / (float)(startInfo.size() - 1);
            float y = (float)(p1.y + p2.y) * (float)i / (float)(startInfo.size() - 1);
            int command = startInfo.get((int)i).command;
            switch (command) {
                case 0: {
                    dstInfo.add(new PointInfo(command, new float[]{x, y}));
                    continue block7;
                }
                case 1: {
                    dstInfo.add(new PointInfo(command, new float[]{x, y}));
                    continue block7;
                }
                case 2: {
                    float[] pp = ((PointInfo)dstInfo.get((int)(i - 1))).points;
                    float px = pp[pp.length - 2];
                    float py = pp[pp.length - 1];
                    dstInfo.add(new PointInfo(command, new float[]{ShapeTransition.progress(px, x, 0.5f), ShapeTransition.progress(py, y, 0.5f), x, y}));
                    continue block7;
                }
                case 3: {
                    float[] pp = ((PointInfo)dstInfo.get((int)(i - 1))).points;
                    float px = pp[pp.length - 2];
                    float py = pp[pp.length - 1];
                    dstInfo.add(new PointInfo(command, new float[]{ShapeTransition.progress(px, x, 0.33f), ShapeTransition.progress(py, y, 0.33f), ShapeTransition.progress(px, x, 0.66f), ShapeTransition.progress(py, y, 0.66f), x, y}));
                    continue block7;
                }
                case 4: {
                    dstInfo.add(new PointInfo(command, null));
                }
            }
        }
        return dstInfo;
    }

    protected static List<PointInfo> gatherInfo(PathIterator iterator) {
        ArrayList<PointInfo> info = new ArrayList<PointInfo>();
        while (!iterator.isDone()) {
            float[] points = new float[6];
            int type = iterator.currentSegment(points);
            System.out.println(Arrays.toString(points));
            switch (type) {
                case 0: {
                    System.out.println("SEG_MOVETO");
                    break;
                }
                case 1: {
                    System.out.println("SEG_LINETO");
                    break;
                }
                case 2: {
                    System.out.println("SEG_QUADTO");
                    break;
                }
                case 3: {
                    System.out.println("SEG_CUBICTO");
                    break;
                }
                case 4: {
                    System.out.println("SEG_CLOSE");
                }
            }
            info.add(new PointInfo(type, points));
            iterator.next();
        }
        return info;
    }

    private static float progress(float x1, float x2, float progress) {
        return (1.0f - progress) * x1 + progress * x2;
    }

    static {
        counter = 0;
    }

    public static class PointInfo {
        public final int command;
        public final float[] points;

        public PointInfo(int command, float[] points) {
            this.command = command;
            this.points = points;
        }
    }
}

