/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.viewport;

import com.alee.laf.viewport.AdaptiveViewportPainter;
import com.alee.laf.viewport.IViewportPainter;
import com.alee.laf.viewport.ViewportPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.swing.DataRunnable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;

public class WebViewportUI
extends BasicViewportUI
implements Styleable,
ShapeProvider {
    @DefaultPainter(value=ViewportPainter.class)
    protected IViewportPainter painter;
    protected JViewport viewport = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebViewportUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.viewport = (JViewport)c;
        StyleManager.installSkin(this.viewport);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.viewport);
        this.viewport = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.viewport);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.viewport, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.viewport, this.painter);
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.viewport, new DataRunnable<IViewportPainter>(){

            public void run(IViewportPainter newPainter) {
                WebViewportUI.this.painter = newPainter;
            }
        }, this.painter, painter, IViewportPainter.class, AdaptiveViewportPainter.class);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }
}

