/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.ColorSupport;
import com.alee.api.IconSupport;
import com.alee.api.TitleSupport;
import com.alee.extended.label.WebStyledLabel;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeUI;
import com.alee.managers.style.StyleId;
import com.alee.utils.ImageUtils;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class WebTreeCellRenderer
extends WebStyledLabel
implements TreeCellRenderer {
    public static final String ID_PREFIX = "WTCR";
    protected String id;
    protected ImageIcon rootIcon = WebTreeUI.ROOT_ICON;
    protected ImageIcon openIcon = WebTreeUI.OPEN_ICON;
    protected ImageIcon closedIcon = WebTreeUI.CLOSED_ICON;
    protected ImageIcon leafIcon = WebTreeUI.LEAF_ICON;

    public WebTreeCellRenderer() {
        this.setId();
        this.setName("Tree.cellRenderer");
    }

    private void setId() {
        this.id = TextUtils.generateId((String)ID_PREFIX);
    }

    @Override
    public WebStyledLabel getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        boolean enabled = tree.isEnabled();
        this.setStyleId(StyleId.treeCellRenderer.at(tree));
        this.setEnabled(enabled);
        this.setFont(tree.getFont());
        this.setComponentOrientation(tree.getComponentOrientation());
        if (value instanceof ColorSupport) {
            Color color = ((ColorSupport)value).getColor();
            this.setForeground(color != null ? color : tree.getForeground());
        } else {
            this.setForeground(tree.getForeground());
        }
        if (value instanceof IconSupport) {
            icon = ((IconSupport)value).getIcon();
            if (enabled) {
                this.setIcon(icon);
            } else {
                String id = value instanceof UniqueNode ? ((UniqueNode)value).getId() : "" + value.hashCode();
                this.setIcon(ImageUtils.getDisabledCopy((String)this.getIconTypeKey(id), (Icon)icon));
            }
        } else {
            Icon icon2 = leaf ? this.leafIcon : (tree.getModel().getRoot() == value ? this.rootIcon : (icon = expanded ? this.openIcon : this.closedIcon));
            if (enabled) {
                this.setIcon(icon);
            } else {
                String type = leaf ? "leaf" : (tree.getModel().getRoot() == value ? "root" : (expanded ? "open" : "closed"));
                this.setIcon(ImageUtils.getDisabledCopy((String)this.getIconTypeKey(type), (ImageIcon)icon));
            }
        }
        if (value instanceof TitleSupport) {
            this.setText(((TitleSupport)value).getTitle());
        } else {
            this.setText(tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus));
        }
        return this;
    }

    private String getIconTypeKey(String type) {
        return "WebTreeCellRenderer." + this.id + "." + type;
    }

    public Icon getRootIcon() {
        return this.rootIcon;
    }

    public void setRootIcon(Icon rootIcon) {
        this.rootIcon = rootIcon != null ? ImageUtils.getImageIcon((Icon)rootIcon) : null;
        ImageUtils.clearDisabledCopyCache((String)this.getIconTypeKey("root"));
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setOpenIcon(Icon openIcon) {
        this.openIcon = openIcon != null ? ImageUtils.getImageIcon((Icon)openIcon) : null;
        ImageUtils.clearDisabledCopyCache((String)this.getIconTypeKey("open"));
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setClosedIcon(Icon closedIcon) {
        this.closedIcon = closedIcon != null ? ImageUtils.getImageIcon((Icon)closedIcon) : null;
        ImageUtils.clearDisabledCopyCache((String)this.getIconTypeKey("closed"));
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon leafIcon) {
        this.leafIcon = leafIcon != null ? ImageUtils.getImageIcon((Icon)leafIcon) : null;
        ImageUtils.clearDisabledCopyCache((String)this.getIconTypeKey("leaf"));
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String pn, Object oldValue, Object newValue) {
        if (pn.equals("text") || (pn.equals("font") || pn.equals("foreground")) && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(pn, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

