/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.jdk.Predicate;
import com.alee.laf.tree.TreeNodeEventRunnable;
import com.alee.laf.tree.WebTree;
import com.alee.utils.SwingUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeEventUtils {
    public static <E extends DefaultMutableTreeNode> MouseAdapter onNodeDoubleClick(WebTree<E> tree, TreeNodeEventRunnable<E> runnable) {
        return TreeEventUtils.onNodeDoubleClick(tree, null, runnable);
    }

    public static <E extends DefaultMutableTreeNode> MouseAdapter onNodeDoubleClick(final WebTree<E> tree, final Predicate<E> condition, final TreeNodeEventRunnable<E> runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int mouseoverRow;
                if (SwingUtils.isLeftMouseButton(e) && e.getClickCount() == 2 && (mouseoverRow = tree.getHoverRow()) != -1) {
                    Object node = tree.getNodeForRow(mouseoverRow);
                    if (condition == null || condition.test(node)) {
                        runnable.run(node);
                    }
                }
            }
        };
        tree.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }
}

